/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.javasupport;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyInteger;
import org.jruby.RubyModule;
import org.jruby.RubyProc;
import org.jruby.RubyString;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.common.IRubyWarnings;
import org.jruby.exceptions.RaiseException;
import org.jruby.internal.runtime.methods.DynamicMethod;
import org.jruby.javasupport.Java;
import org.jruby.javasupport.JavaArray;
import org.jruby.javasupport.JavaCallable;
import org.jruby.javasupport.JavaConstructor;
import org.jruby.javasupport.JavaField;
import org.jruby.javasupport.JavaMethod;
import org.jruby.javasupport.JavaObject;
import org.jruby.javasupport.JavaSupport;
import org.jruby.javasupport.JavaUtil;
import org.jruby.javasupport.util.RuntimeHelpers;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Block;
import org.jruby.runtime.CallType;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.callback.Callback;
import org.jruby.util.ByteList;
import org.jruby.util.IdUtil;
import org.jruby.util.collections.IntHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@JRubyClass(name={"Java::JavaClass"}, parent="Java::JavaObject")
public class JavaClass
extends JavaObject {
    private static final Class<?>[] EMPTY_CLASS_ARRAY = new Class[0];
    private static final Method[] EMPTY_METHOD_ARRAY = new Method[0];
    private static final Field[] EMPTY_FIELD_ARRAY = new Field[0];
    private static final Map<String, AssignedName> RESERVED_NAMES = new HashMap<String, AssignedName>();
    private static final Map<String, AssignedName> STATIC_RESERVED_NAMES;
    private static final Map<String, AssignedName> INSTANCE_RESERVED_NAMES;
    private final RubyModule JAVA_UTILITIES = this.getRuntime().getJavaSupport().getJavaUtilitiesModule();
    private Map<String, AssignedName> staticAssignedNames;
    private Map<String, AssignedName> instanceAssignedNames;
    private Map<String, NamedCallback> staticCallbacks;
    private Map<String, NamedCallback> instanceCallbacks;
    private List<ConstantField> constantFields;
    private volatile RubyArray constructors;
    private volatile ArrayList<IRubyObject> proxyExtenders;
    private volatile RubyModule proxyModule;
    private volatile RubyClass proxyClass;
    private RubyModule unfinishedProxyModule;
    private RubyClass unfinishedProxyClass;
    private final ReentrantLock proxyLock = new ReentrantLock();
    private static final Pattern JAVA_PROPERTY_CHOPPER;
    private static final Pattern CAMEL_CASE_SPLITTER;
    private static final Callback __jsend_method;

    public RubyModule getProxyModule() {
        RubyModule rubyModule = this.proxyModule;
        if (rubyModule != null) {
            return rubyModule;
        }
        if (this.proxyLock.isHeldByCurrentThread()) {
            return this.unfinishedProxyModule;
        }
        return null;
    }

    public RubyClass getProxyClass() {
        RubyClass rubyClass = this.proxyClass;
        if (rubyClass != null) {
            return rubyClass;
        }
        if (this.proxyLock.isHeldByCurrentThread()) {
            return this.unfinishedProxyClass;
        }
        return null;
    }

    public void lockProxy() {
        this.proxyLock.lock();
    }

    public void unlockProxy() {
        this.proxyLock.unlock();
    }

    protected Map<String, AssignedName> getStaticAssignedNames() {
        return this.staticAssignedNames;
    }

    protected Map<String, AssignedName> getInstanceAssignedNames() {
        return this.instanceAssignedNames;
    }

    private JavaClass(Ruby ruby, Class<?> clazz) {
        super(ruby, ruby.getJavaSupport().getJavaClassClass(), clazz);
        if (clazz.isInterface()) {
            this.initializeInterface(clazz);
        } else if (!clazz.isArray() && !clazz.isPrimitive()) {
            this.initializeClass(clazz);
        }
    }

    @Override
    public boolean equals(Object object) {
        return object instanceof JavaClass && this.getValue() == ((JavaClass)object).getValue();
    }

    private void initializeInterface(Class<?> clazz) {
        HashMap<String, AssignedName> hashMap = new HashMap<String, AssignedName>(STATIC_RESERVED_NAMES);
        ArrayList<ConstantField> arrayList = new ArrayList<ConstantField>();
        Field[] fieldArray = EMPTY_FIELD_ARRAY;
        try {
            fieldArray = clazz.getDeclaredFields();
        }
        catch (SecurityException securityException) {
            try {
                fieldArray = clazz.getFields();
            }
            catch (SecurityException securityException2) {
                // empty catch block
            }
        }
        int n = fieldArray.length;
        while (--n >= 0) {
            Field field = fieldArray[n];
            if (clazz != field.getDeclaringClass() || !ConstantField.isConstant(field)) continue;
            arrayList.add(new ConstantField(field));
        }
        this.staticAssignedNames = hashMap;
        this.constantFields = arrayList;
    }

    private void initializeClass(Class<?> clazz) {
        Object object;
        AssignedName assignedName;
        Object object2;
        AnnotatedElement annotatedElement;
        Cloneable cloneable;
        HashMap<Object, Object> hashMap;
        HashMap<Object, Object> hashMap2;
        Class<?> clazz2 = clazz.getSuperclass();
        if (clazz2 == null) {
            hashMap2 = new HashMap<String, AssignedName>();
            hashMap = new HashMap<String, AssignedName>();
        } else {
            cloneable = JavaClass.get(this.getRuntime(), clazz2);
            hashMap2 = new HashMap<String, AssignedName>(((JavaClass)cloneable).getStaticAssignedNames());
            hashMap = new HashMap<String, AssignedName>(((JavaClass)cloneable).getInstanceAssignedNames());
        }
        hashMap2.putAll(STATIC_RESERVED_NAMES);
        hashMap.putAll(INSTANCE_RESERVED_NAMES);
        cloneable = new HashMap();
        HashMap<String, NamedCallback> hashMap3 = new HashMap<String, NamedCallback>();
        ArrayList<ConstantField> arrayList = new ArrayList<ConstantField>();
        Field[] fieldArray = EMPTY_FIELD_ARRAY;
        try {
            fieldArray = clazz.getFields();
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        int n = fieldArray.length;
        while (--n >= 0) {
            annotatedElement = fieldArray[n];
            if (clazz != ((Field)annotatedElement).getDeclaringClass()) continue;
            if (ConstantField.isConstant((Field)annotatedElement)) {
                arrayList.add(new ConstantField((Field)annotatedElement));
                continue;
            }
            object2 = ((Field)annotatedElement).getName();
            int n2 = ((Field)annotatedElement).getModifiers();
            if (Modifier.isStatic(n2)) {
                assignedName = (AssignedName)hashMap2.get(object2);
                if (assignedName != null && assignedName.type < 2) continue;
                hashMap2.put(object2, new AssignedName((String)object2, 2));
                cloneable.put(object2, new StaticFieldGetter((String)object2, (Field)annotatedElement));
                if (Modifier.isFinal(n2)) continue;
                object = (String)object2 + '=';
                cloneable.put(object, new StaticFieldSetter((String)object, (Field)annotatedElement));
                continue;
            }
            assignedName = (AssignedName)hashMap.get(object2);
            if (assignedName != null && assignedName.type < 2) continue;
            hashMap.put(object2, new AssignedName((String)object2, 2));
            hashMap3.put((String)object2, new InstanceFieldGetter((String)object2, (Field)annotatedElement));
            if (Modifier.isFinal(n2)) continue;
            object = (String)object2 + '=';
            hashMap3.put((String)object, new InstanceFieldSetter((String)object, (Field)annotatedElement));
        }
        Method[] methodArray = EMPTY_METHOD_ARRAY;
        for (annotatedElement = clazz; annotatedElement != null; annotatedElement = ((Class)annotatedElement).getSuperclass()) {
            try {
                methodArray = clazz.getMethods();
                break;
            }
            catch (SecurityException securityException) {
                continue;
            }
        }
        int n3 = methodArray.length;
        while (--n3 >= 0) {
            object2 = methodArray[n3];
            String string = ((Method)object2).getName();
            if (Modifier.isStatic(((Method)object2).getModifiers())) {
                assignedName = (AssignedName)hashMap2.get(string);
                if (assignedName == null) {
                    hashMap2.put(string, new AssignedName(string, 1));
                } else {
                    if (assignedName.type < 1) continue;
                    if (assignedName.type != 1) {
                        cloneable.remove(string);
                        cloneable.remove(string + '=');
                        hashMap2.put(string, new AssignedName(string, 1));
                    }
                }
                object = (StaticMethodInvoker)cloneable.get(string);
                if (object == null) {
                    object = new StaticMethodInvoker(string);
                    cloneable.put(string, object);
                }
                ((MethodCallback)object).addMethod((Method)object2, clazz);
                continue;
            }
            assignedName = (AssignedName)hashMap.get(string);
            if (assignedName == null) {
                hashMap.put(string, new AssignedName(string, 1));
            } else {
                if (assignedName.type < 1) continue;
                if (assignedName.type != 1) {
                    hashMap3.remove(string);
                    hashMap3.remove(string + '=');
                    hashMap.put(string, new AssignedName(string, 1));
                }
            }
            object = (InstanceMethodInvoker)hashMap3.get(string);
            if (object == null) {
                object = new InstanceMethodInvoker(string);
                hashMap3.put(string, (NamedCallback)object);
            }
            ((MethodCallback)object).addMethod((Method)object2, clazz);
        }
        this.staticAssignedNames = hashMap2;
        this.instanceAssignedNames = hashMap;
        this.staticCallbacks = cloneable;
        this.instanceCallbacks = hashMap3;
        this.constantFields = arrayList;
    }

    /*
     * WARNING - void declaration
     */
    public void setupProxy(RubyClass rubyClass) {
        void var4_12;
        assert (this.proxyLock.isHeldByCurrentThread());
        rubyClass.defineFastMethod("__jsend!", __jsend_method);
        Class clazz = this.javaClass();
        if (clazz.isInterface()) {
            this.setupInterfaceProxy(rubyClass);
            return;
        }
        assert (this.proxyClass == null);
        this.unfinishedProxyClass = rubyClass;
        if (clazz.isArray() || clazz.isPrimitive()) {
            this.proxyClass = rubyClass;
            this.proxyModule = rubyClass;
            return;
        }
        for (ConstantField object : this.constantFields) {
            object.install(rubyClass);
        }
        for (NamedCallback n : this.staticCallbacks.values()) {
            if (n.type == 2 && n.hasLocalMethod()) {
                JavaClass.assignAliases((MethodCallback)n, this.staticAssignedNames);
            }
            n.install(rubyClass);
        }
        for (NamedCallback namedCallback : this.instanceCallbacks.values()) {
            if (namedCallback.type == 4 && namedCallback.hasLocalMethod()) {
                JavaClass.assignAliases((MethodCallback)namedCallback, this.instanceAssignedNames);
            }
            namedCallback.install(rubyClass);
        }
        Iterator<Object> iterator = EMPTY_CLASS_ARRAY;
        try {
            iterator = clazz.getClasses();
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        int n = ((Iterator<Object>)iterator).length;
        while (--var4_12 >= 0) {
            Iterator<Object> iterator2;
            String string;
            if (clazz != ((Class)((Object)iterator[var4_12])).getDeclaringClass() || (string = JavaClass.getSimpleName(iterator2 = iterator[var4_12])).length() == 0 || !IdUtil.isConstant(string) || rubyClass.getConstantAt(string) != null) continue;
            rubyClass.setConstant(string, Java.get_proxy_class(this.JAVA_UTILITIES, JavaClass.get(this.getRuntime(), iterator2)));
        }
        this.proxyClass = rubyClass;
        this.proxyModule = rubyClass;
        this.applyProxyExtenders();
    }

    private static void assignAliases(MethodCallback methodCallback, Map<String, AssignedName> map) {
        String string = methodCallback.name;
        String string2 = JavaClass.getRubyCasedName(string);
        JavaClass.addUnassignedAlias(string2, map, methodCallback);
        String string3 = JavaClass.getJavaPropertyName(string);
        String string4 = null;
        for (Method method : methodCallback.methods) {
            Class<?>[] classArray = method.getParameterTypes();
            Class<?> clazz = method.getReturnType();
            int n = classArray.length;
            if (string3 != null) {
                if (string2.startsWith("get_")) {
                    string4 = string2.substring(4);
                    if (n == 0 || n == 1 && classArray[0] == Integer.TYPE) {
                        JavaClass.addUnassignedAlias(string3, map, methodCallback);
                        JavaClass.addUnassignedAlias(string4, map, methodCallback);
                    }
                } else if (string2.startsWith("set_")) {
                    string4 = string2.substring(4);
                    if (n == 1 && clazz == Void.TYPE) {
                        JavaClass.addUnassignedAlias(string3 + '=', map, methodCallback);
                        JavaClass.addUnassignedAlias(string4 + '=', map, methodCallback);
                    }
                } else if (string2.startsWith("is_")) {
                    string4 = string2.substring(3);
                    if (clazz == Boolean.TYPE) {
                        JavaClass.addUnassignedAlias(string3, map, methodCallback);
                        JavaClass.addUnassignedAlias(string4, map, methodCallback);
                    }
                }
            }
            if (clazz != Boolean.TYPE) continue;
            JavaClass.addUnassignedAlias(string2 + '?', map, methodCallback);
            if (string4 == null) continue;
            JavaClass.addUnassignedAlias(string4 + '?', map, methodCallback);
        }
    }

    private static void addUnassignedAlias(String string, Map<String, AssignedName> map, MethodCallback methodCallback) {
        if (string != null) {
            AssignedName assignedName = map.get(string);
            if (assignedName == null) {
                methodCallback.addAlias(string);
                map.put(string, new AssignedName(string, 5));
            } else if (assignedName.type == 5) {
                methodCallback.addAlias(string);
            } else if (assignedName.type > 5) {
                methodCallback.addAlias(string);
                map.put(string, new AssignedName(string, 5));
            }
        }
    }

    public static String getJavaPropertyName(String string) {
        Matcher matcher = JAVA_PROPERTY_CHOPPER.matcher(string);
        if (!matcher.find()) {
            return null;
        }
        String string2 = matcher.group(2).toLowerCase() + matcher.group(3);
        return string2;
    }

    public static String getRubyCasedName(String string) {
        Matcher matcher = CAMEL_CASE_SPLITTER.matcher(string);
        return matcher.replaceAll("$1_$2").toLowerCase();
    }

    private void setupInterfaceProxy(RubyClass rubyClass) {
        assert (this.javaClass().isInterface());
        assert (this.proxyLock.isHeldByCurrentThread());
        assert (this.proxyClass == null);
        this.proxyClass = rubyClass;
    }

    public void setupInterfaceModule(RubyModule rubyModule) {
        assert (this.javaClass().isInterface());
        assert (this.proxyLock.isHeldByCurrentThread());
        assert (this.proxyModule == null);
        this.unfinishedProxyModule = rubyModule;
        Class clazz = this.javaClass();
        for (ConstantField constantField : this.constantFields) {
            constantField.install(rubyModule);
        }
        Class<?>[] classArray = EMPTY_CLASS_ARRAY;
        try {
            classArray = clazz.getClasses();
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        int n = classArray.length;
        while (--n >= 0) {
            Class<?> clazz2;
            String string;
            if (clazz != classArray[n].getDeclaringClass() || (string = JavaClass.getSimpleName(clazz2 = classArray[n])).length() == 0 || !IdUtil.isConstant(string) || rubyModule.getConstantAt(string) != null) continue;
            rubyModule.const_set(this.getRuntime().newString(string), Java.get_proxy_class(this.JAVA_UTILITIES, JavaClass.get(this.getRuntime(), clazz2)));
        }
        this.proxyModule = rubyModule;
        this.applyProxyExtenders();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addProxyExtender(IRubyObject iRubyObject) {
        this.lockProxy();
        try {
            if (!iRubyObject.respondsTo("extend_proxy")) {
                throw this.getRuntime().newTypeError("proxy extender must have an extend_proxy method");
            }
            if (this.proxyModule == null) {
                if (this.proxyExtenders == null) {
                    this.proxyExtenders = new ArrayList();
                }
                this.proxyExtenders.add(iRubyObject);
            } else {
                this.getRuntime().getWarnings().warn(IRubyWarnings.ID.PROXY_EXTENDED_LATE, " proxy extender added after proxy class created for " + this, new Object[0]);
                this.extendProxy(iRubyObject);
            }
        }
        finally {
            this.unlockProxy();
        }
    }

    private void applyProxyExtenders() {
        ArrayList<IRubyObject> arrayList = this.proxyExtenders;
        if (arrayList != null) {
            for (IRubyObject iRubyObject : arrayList) {
                this.extendProxy(iRubyObject);
            }
            this.proxyExtenders = null;
        }
    }

    private void extendProxy(IRubyObject iRubyObject) {
        iRubyObject.callMethod(this.getRuntime().getCurrentContext(), "extend_proxy", this.proxyModule);
    }

    @JRubyMethod(required=1)
    public IRubyObject extend_proxy(IRubyObject iRubyObject) {
        this.addProxyExtender(iRubyObject);
        return this.getRuntime().getNil();
    }

    public static JavaClass get(Ruby ruby, Class<?> clazz) {
        JavaClass javaClass = ruby.getJavaSupport().getJavaClassFromCache(clazz);
        if (javaClass == null) {
            javaClass = JavaClass.createJavaClass(ruby, clazz);
        }
        return javaClass;
    }

    public static RubyArray getRubyArray(Ruby ruby, Class<?>[] classArray) {
        IRubyObject[] iRubyObjectArray = new IRubyObject[classArray.length];
        int n = classArray.length;
        while (--n >= 0) {
            iRubyObjectArray[n] = JavaClass.get(ruby, classArray[n]);
        }
        return ruby.newArrayNoCopy(iRubyObjectArray);
    }

    private static synchronized JavaClass createJavaClass(Ruby ruby, Class<?> clazz) {
        JavaClass javaClass = ruby.getJavaSupport().getJavaClassFromCache(clazz);
        if (javaClass == null) {
            javaClass = new JavaClass(ruby, clazz);
            ruby.getJavaSupport().putJavaClassIntoCache(javaClass);
        }
        return javaClass;
    }

    public static RubyClass createJavaClassClass(Ruby ruby, RubyModule rubyModule) {
        RubyClass rubyClass = rubyModule.defineClassUnder("JavaClass", rubyModule.fastGetClass("JavaObject"), ObjectAllocator.NOT_ALLOCATABLE_ALLOCATOR);
        rubyClass.includeModule(ruby.fastGetModule("Comparable"));
        rubyClass.defineAnnotatedMethods(JavaClass.class);
        rubyClass.getMetaClass().undefineMethod("new");
        rubyClass.getMetaClass().undefineMethod("allocate");
        return rubyClass;
    }

    public static synchronized JavaClass forNameVerbose(Ruby ruby, String string) {
        Class clazz = ruby.getJavaSupport().loadJavaClassVerbose(string);
        return JavaClass.get(ruby, clazz);
    }

    public static synchronized JavaClass forNameQuiet(Ruby ruby, String string) {
        Class clazz = ruby.getJavaSupport().loadJavaClassQuiet(string);
        return JavaClass.get(ruby, clazz);
    }

    @JRubyMethod(name={"for_name"}, required=1, meta=true)
    public static JavaClass for_name(IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        return JavaClass.forNameVerbose(iRubyObject.getRuntime(), iRubyObject2.asJavaString());
    }

    @JRubyMethod
    public RubyModule ruby_class() {
        return Java.getProxyClass(this.getRuntime(), this);
    }

    @JRubyMethod(name={"public?"})
    public RubyBoolean public_p() {
        return this.getRuntime().newBoolean(Modifier.isPublic(this.javaClass().getModifiers()));
    }

    @JRubyMethod(name={"protected?"})
    public RubyBoolean protected_p() {
        return this.getRuntime().newBoolean(Modifier.isProtected(this.javaClass().getModifiers()));
    }

    @JRubyMethod(name={"private?"})
    public RubyBoolean private_p() {
        return this.getRuntime().newBoolean(Modifier.isPrivate(this.javaClass().getModifiers()));
    }

    public Class javaClass() {
        return (Class)this.getValue();
    }

    @JRubyMethod(name={"final?"})
    public RubyBoolean final_p() {
        return this.getRuntime().newBoolean(Modifier.isFinal(this.javaClass().getModifiers()));
    }

    @JRubyMethod(name={"interface?"})
    public RubyBoolean interface_p() {
        return this.getRuntime().newBoolean(this.javaClass().isInterface());
    }

    @JRubyMethod(name={"array?"})
    public RubyBoolean array_p() {
        return this.getRuntime().newBoolean(this.javaClass().isArray());
    }

    @JRubyMethod(name={"enum?"})
    public RubyBoolean enum_p() {
        return this.getRuntime().newBoolean(this.javaClass().isEnum());
    }

    @JRubyMethod(name={"annotation?"})
    public RubyBoolean annotation_p() {
        return this.getRuntime().newBoolean(this.javaClass().isAnnotation());
    }

    @JRubyMethod(name={"anonymous_class?"})
    public RubyBoolean anonymous_class_p() {
        return this.getRuntime().newBoolean(this.javaClass().isAnonymousClass());
    }

    @JRubyMethod(name={"local_class?"})
    public RubyBoolean local_class_p() {
        return this.getRuntime().newBoolean(this.javaClass().isLocalClass());
    }

    @JRubyMethod(name={"member_class?"})
    public RubyBoolean member_class_p() {
        return this.getRuntime().newBoolean(this.javaClass().isMemberClass());
    }

    @JRubyMethod(name={"synthetic?"})
    public IRubyObject synthetic_p() {
        return this.getRuntime().newBoolean(this.javaClass().isSynthetic());
    }

    @JRubyMethod(name={"name", "to_s"})
    public RubyString name() {
        return this.getRuntime().newString(this.javaClass().getName());
    }

    @JRubyMethod
    public IRubyObject canonical_name() {
        String string = this.javaClass().getCanonicalName();
        if (string != null) {
            return this.getRuntime().newString(string);
        }
        return this.getRuntime().getNil();
    }

    @JRubyMethod(name={"package"})
    public IRubyObject get_package() {
        return Java.getInstance(this.getRuntime(), this.javaClass().getPackage());
    }

    @JRubyMethod
    public IRubyObject class_loader() {
        return Java.getInstance(this.getRuntime(), this.javaClass().getClassLoader());
    }

    @JRubyMethod
    public IRubyObject protection_domain() {
        return Java.getInstance(this.getRuntime(), this.javaClass().getProtectionDomain());
    }

    @JRubyMethod(required=1)
    public IRubyObject resource(IRubyObject iRubyObject) {
        return Java.getInstance(this.getRuntime(), this.javaClass().getResource(iRubyObject.asJavaString()));
    }

    @JRubyMethod(required=1)
    public IRubyObject resource_as_stream(IRubyObject iRubyObject) {
        return Java.getInstance(this.getRuntime(), this.javaClass().getResourceAsStream(iRubyObject.asJavaString()));
    }

    @JRubyMethod(required=1)
    public IRubyObject resource_as_string(IRubyObject iRubyObject) {
        InputStream inputStream = this.javaClass().getResourceAsStream(iRubyObject.asJavaString());
        if (inputStream == null) {
            return this.getRuntime().getNil();
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            int n;
            byte[] byArray = new byte[4096];
            while ((n = inputStream.read(byArray)) >= 0) {
                byteArrayOutputStream.write(byArray, 0, n);
            }
        }
        catch (IOException iOException) {
            throw this.getRuntime().newIOErrorFromException(iOException);
        }
        return this.getRuntime().newString(new ByteList(byteArrayOutputStream.toByteArray(), false));
    }

    @JRubyMethod(required=1)
    public IRubyObject annotation(IRubyObject iRubyObject) {
        if (!(iRubyObject instanceof JavaClass)) {
            throw this.getRuntime().newTypeError(iRubyObject, this.getRuntime().getJavaSupport().getJavaClassClass());
        }
        return Java.getInstance(this.getRuntime(), this.javaClass().getAnnotation(((JavaClass)iRubyObject).javaClass()));
    }

    @JRubyMethod
    public IRubyObject annotations() {
        return Java.getInstance(this.getRuntime(), this.javaClass().getAnnotations());
    }

    @JRubyMethod(name={"annotations?"})
    public RubyBoolean annotations_p() {
        return this.getRuntime().newBoolean(this.javaClass().getAnnotations().length > 0);
    }

    @JRubyMethod
    public IRubyObject declared_annotations() {
        return Java.getInstance(this.getRuntime(), this.javaClass().getDeclaredAnnotations());
    }

    @JRubyMethod(name={"declared_annotations?"})
    public RubyBoolean declared_annotations_p() {
        return this.getRuntime().newBoolean(this.javaClass().getDeclaredAnnotations().length > 0);
    }

    @JRubyMethod(name={"annotation_present?"}, required=1)
    public IRubyObject annotation_present_p(IRubyObject iRubyObject) {
        if (!(iRubyObject instanceof JavaClass)) {
            throw this.getRuntime().newTypeError(iRubyObject, this.getRuntime().getJavaSupport().getJavaClassClass());
        }
        return this.getRuntime().newBoolean(this.javaClass().isAnnotationPresent(((JavaClass)iRubyObject).javaClass()));
    }

    @JRubyMethod
    public IRubyObject modifiers() {
        return this.getRuntime().newFixnum(this.javaClass().getModifiers());
    }

    @JRubyMethod
    public IRubyObject declaring_class() {
        Class<?> clazz = this.javaClass().getDeclaringClass();
        if (clazz != null) {
            return JavaClass.get(this.getRuntime(), clazz);
        }
        return this.getRuntime().getNil();
    }

    @JRubyMethod
    public IRubyObject enclosing_class() {
        return Java.getInstance(this.getRuntime(), this.javaClass().getEnclosingClass());
    }

    @JRubyMethod
    public IRubyObject enclosing_constructor() {
        Constructor<?> constructor = this.javaClass().getEnclosingConstructor();
        if (constructor != null) {
            return new JavaConstructor(this.getRuntime(), constructor);
        }
        return this.getRuntime().getNil();
    }

    @JRubyMethod
    public IRubyObject enclosing_method() {
        Method method = this.javaClass().getEnclosingMethod();
        if (method != null) {
            return new JavaMethod(this.getRuntime(), method);
        }
        return this.getRuntime().getNil();
    }

    @JRubyMethod
    public IRubyObject enum_constants() {
        return Java.getInstance(this.getRuntime(), this.javaClass().getEnumConstants());
    }

    @JRubyMethod
    public IRubyObject generic_interfaces() {
        return Java.getInstance(this.getRuntime(), this.javaClass().getGenericInterfaces());
    }

    @JRubyMethod
    public IRubyObject generic_superclass() {
        return Java.getInstance(this.getRuntime(), this.javaClass().getGenericSuperclass());
    }

    @JRubyMethod
    public IRubyObject type_parameters() {
        return Java.getInstance(this.getRuntime(), this.javaClass().getTypeParameters());
    }

    @JRubyMethod
    public IRubyObject signers() {
        return Java.getInstance(this.getRuntime(), this.javaClass().getSigners());
    }

    private static String getSimpleName(Class<?> clazz) {
        if (clazz.isArray()) {
            return JavaClass.getSimpleName(clazz.getComponentType()) + "[]";
        }
        String string = clazz.getName();
        int n = string.length();
        int n2 = string.lastIndexOf(36);
        if (n2 != -1) {
            while (++n2 < n && Character.isDigit(string.charAt(n2))) {
            }
            return string.substring(n2);
        }
        return string.substring(string.lastIndexOf(46) + 1);
    }

    @JRubyMethod
    public RubyString simple_name() {
        return this.getRuntime().newString(JavaClass.getSimpleName(this.javaClass()));
    }

    @JRubyMethod
    public IRubyObject superclass() {
        Class clazz = this.javaClass().getSuperclass();
        if (clazz == null) {
            return this.getRuntime().getNil();
        }
        return JavaClass.get(this.getRuntime(), clazz);
    }

    @JRubyMethod(name={"<=>"}, required=1)
    public RubyFixnum op_cmp(IRubyObject iRubyObject) {
        if (!(iRubyObject instanceof JavaClass)) {
            throw this.getRuntime().newTypeError("<=> requires JavaClass (" + iRubyObject.getType() + " given)");
        }
        JavaClass javaClass = (JavaClass)iRubyObject;
        if (this.javaClass() == javaClass.javaClass()) {
            return this.getRuntime().newFixnum(0);
        }
        if (javaClass.javaClass().isAssignableFrom(this.javaClass())) {
            return this.getRuntime().newFixnum(-1);
        }
        return this.getRuntime().newFixnum(1);
    }

    @JRubyMethod
    public RubyArray java_instance_methods() {
        return this.java_methods(this.javaClass().getMethods(), false);
    }

    @JRubyMethod
    public RubyArray declared_instance_methods() {
        return this.java_methods(this.javaClass().getDeclaredMethods(), false);
    }

    private RubyArray java_methods(Method[] methodArray, boolean bl) {
        RubyArray rubyArray = this.getRuntime().newArray(methodArray.length);
        for (int i = 0; i < methodArray.length; ++i) {
            Method method = methodArray[i];
            if (bl != Modifier.isStatic(method.getModifiers())) continue;
            rubyArray.append(JavaMethod.create(this.getRuntime(), method));
        }
        return rubyArray;
    }

    @JRubyMethod
    public RubyArray java_class_methods() {
        return this.java_methods(this.javaClass().getMethods(), true);
    }

    @JRubyMethod
    public RubyArray declared_class_methods() {
        return this.java_methods(this.javaClass().getDeclaredMethods(), true);
    }

    @JRubyMethod(required=1, rest=true)
    public JavaMethod java_method(IRubyObject[] iRubyObjectArray) throws ClassNotFoundException {
        String string = iRubyObjectArray[0].asJavaString();
        Class<?>[] classArray = this.buildArgumentTypes(iRubyObjectArray);
        return JavaMethod.create(this.getRuntime(), this.javaClass(), string, classArray);
    }

    @JRubyMethod(required=1, rest=true)
    public JavaMethod declared_method(IRubyObject[] iRubyObjectArray) throws ClassNotFoundException {
        String string = iRubyObjectArray[0].asJavaString();
        Class<?>[] classArray = this.buildArgumentTypes(iRubyObjectArray);
        return JavaMethod.createDeclared(this.getRuntime(), this.javaClass(), string, classArray);
    }

    @JRubyMethod(required=1, rest=true)
    public JavaCallable declared_method_smart(IRubyObject[] iRubyObjectArray) throws ClassNotFoundException {
        String string = iRubyObjectArray[0].asJavaString();
        Class<?>[] classArray = this.buildArgumentTypes(iRubyObjectArray);
        JavaCallable javaCallable = JavaClass.getMatchingCallable(this.getRuntime(), this.javaClass(), string, classArray);
        if (javaCallable != null) {
            return javaCallable;
        }
        throw this.getRuntime().newNameError("undefined method '" + string + "' for class '" + this.javaClass().getName() + "'", string);
    }

    public static JavaCallable getMatchingCallable(Ruby ruby, Class<?> clazz, String string, Class<?>[] classArray) {
        if ("<init>".equals(string)) {
            return JavaConstructor.getMatchingConstructor(ruby, clazz, classArray);
        }
        return JavaMethod.getMatchingDeclaredMethod(ruby, clazz, string, classArray);
    }

    private Class<?>[] buildArgumentTypes(IRubyObject[] iRubyObjectArray) throws ClassNotFoundException {
        if (iRubyObjectArray.length < 1) {
            throw this.getRuntime().newArgumentError(iRubyObjectArray.length, 1);
        }
        Class[] classArray = new Class[iRubyObjectArray.length - 1];
        for (int i = 1; i < iRubyObjectArray.length; ++i) {
            JavaClass javaClass = iRubyObjectArray[i] instanceof JavaClass ? (JavaClass)iRubyObjectArray[i] : (iRubyObjectArray[i].respondsTo("java_class") ? (JavaClass)iRubyObjectArray[i].callMethod(this.getRuntime().getCurrentContext(), "java_class") : JavaClass.for_name(this, iRubyObjectArray[i]));
            classArray[i - 1] = javaClass.javaClass();
        }
        return classArray;
    }

    @JRubyMethod
    public RubyArray constructors() {
        RubyArray rubyArray = this.constructors;
        if (rubyArray != null) {
            return rubyArray;
        }
        this.constructors = this.buildConstructors(this.javaClass().getConstructors());
        return this.constructors;
    }

    @JRubyMethod
    public RubyArray classes() {
        return JavaClass.getRubyArray(this.getRuntime(), this.javaClass().getClasses());
    }

    @JRubyMethod
    public RubyArray declared_classes() {
        Ruby ruby = this.getRuntime();
        RubyArray rubyArray = ruby.newArray();
        Class clazz = this.javaClass();
        try {
            Class<?>[] classArray = clazz.getDeclaredClasses();
            for (int i = 0; i < classArray.length; ++i) {
                if (!Modifier.isPublic(classArray[i].getModifiers())) continue;
                rubyArray.append(JavaClass.get(ruby, classArray[i]));
            }
        }
        catch (SecurityException securityException) {
            try {
                Class<?>[] classArray = clazz.getClasses();
                for (int i = 0; i < classArray.length; ++i) {
                    if (clazz != classArray[i].getDeclaringClass()) continue;
                    rubyArray.append(JavaClass.get(ruby, classArray[i]));
                }
            }
            catch (SecurityException securityException2) {
                // empty catch block
            }
        }
        return rubyArray;
    }

    @JRubyMethod
    public RubyArray declared_constructors() {
        return this.buildConstructors(this.javaClass().getDeclaredConstructors());
    }

    private RubyArray buildConstructors(Constructor<?>[] constructorArray) {
        RubyArray rubyArray = this.getRuntime().newArray(constructorArray.length);
        for (int i = 0; i < constructorArray.length; ++i) {
            rubyArray.append(new JavaConstructor(this.getRuntime(), constructorArray[i]));
        }
        return rubyArray;
    }

    @JRubyMethod(rest=true)
    public JavaConstructor constructor(IRubyObject[] iRubyObjectArray) {
        try {
            Class<?>[] classArray = this.buildClassArgs(iRubyObjectArray);
            Constructor constructor = this.javaClass().getConstructor(classArray);
            return new JavaConstructor(this.getRuntime(), constructor);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw this.getRuntime().newNameError("no matching java constructor", null);
        }
    }

    @JRubyMethod(rest=true)
    public JavaConstructor declared_constructor(IRubyObject[] iRubyObjectArray) {
        try {
            Class<?>[] classArray = this.buildClassArgs(iRubyObjectArray);
            Constructor constructor = this.javaClass().getDeclaredConstructor(classArray);
            return new JavaConstructor(this.getRuntime(), constructor);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw this.getRuntime().newNameError("no matching java constructor", null);
        }
    }

    private Class<?>[] buildClassArgs(IRubyObject[] iRubyObjectArray) {
        JavaSupport javaSupport = this.getRuntime().getJavaSupport();
        Class[] classArray = new Class[iRubyObjectArray.length];
        int n = iRubyObjectArray.length;
        while (--n >= 0) {
            String string = iRubyObjectArray[n].asJavaString();
            classArray[n] = javaSupport.loadJavaClassVerbose(string);
        }
        return classArray;
    }

    @JRubyMethod
    public JavaClass array_class() {
        return JavaClass.get(this.getRuntime(), Array.newInstance(this.javaClass(), 0).getClass());
    }

    @JRubyMethod(required=1)
    public JavaObject new_array(IRubyObject iRubyObject) {
        if (iRubyObject instanceof RubyInteger) {
            int n = (int)((RubyInteger)iRubyObject).getLongValue();
            return new JavaArray(this.getRuntime(), Array.newInstance(this.javaClass(), n));
        }
        if (iRubyObject instanceof RubyArray) {
            List list = ((RubyArray)iRubyObject).getList();
            int n = list.size();
            if (n == 0) {
                throw this.getRuntime().newArgumentError("empty dimensions specifier for java array");
            }
            int[] nArray = new int[n];
            int n2 = n;
            while (--n2 >= 0) {
                IRubyObject iRubyObject2 = (IRubyObject)list.get(n2);
                if (!(iRubyObject2 instanceof RubyInteger)) {
                    throw this.getRuntime().newTypeError(iRubyObject2, this.getRuntime().getInteger());
                }
                nArray[n2] = (int)((RubyInteger)iRubyObject2).getLongValue();
            }
            return new JavaArray(this.getRuntime(), Array.newInstance(this.javaClass(), nArray));
        }
        throw this.getRuntime().newArgumentError("invalid length or dimensions specifier for java array - must be Integer or Array of Integer");
    }

    @JRubyMethod
    public RubyArray fields() {
        return this.buildFieldResults(this.javaClass().getFields());
    }

    @JRubyMethod
    public RubyArray declared_fields() {
        return this.buildFieldResults(this.javaClass().getDeclaredFields());
    }

    private RubyArray buildFieldResults(Field[] fieldArray) {
        RubyArray rubyArray = this.getRuntime().newArray(fieldArray.length);
        for (int i = 0; i < fieldArray.length; ++i) {
            rubyArray.append(new JavaField(this.getRuntime(), fieldArray[i]));
        }
        return rubyArray;
    }

    @JRubyMethod(required=1)
    public JavaField field(IRubyObject iRubyObject) {
        String string = iRubyObject.asJavaString();
        try {
            Field field = this.javaClass().getField(string);
            return new JavaField(this.getRuntime(), field);
        }
        catch (NoSuchFieldException noSuchFieldException) {
            throw this.undefinedFieldError(string);
        }
    }

    @JRubyMethod(required=1)
    public JavaField declared_field(IRubyObject iRubyObject) {
        String string = iRubyObject.asJavaString();
        try {
            Field field = this.javaClass().getDeclaredField(string);
            return new JavaField(this.getRuntime(), field);
        }
        catch (NoSuchFieldException noSuchFieldException) {
            throw this.undefinedFieldError(string);
        }
    }

    private RaiseException undefinedFieldError(String string) {
        return this.getRuntime().newNameError("undefined field '" + string + "' for class '" + this.javaClass().getName() + "'", string);
    }

    @JRubyMethod
    public RubyArray interfaces() {
        return JavaClass.getRubyArray(this.getRuntime(), this.javaClass().getInterfaces());
    }

    @JRubyMethod(name={"primitive?"})
    public RubyBoolean primitive_p() {
        return this.getRuntime().newBoolean(this.isPrimitive());
    }

    @JRubyMethod(name={"assignable_from?"}, required=1)
    public RubyBoolean assignable_from_p(IRubyObject iRubyObject) {
        if (!(iRubyObject instanceof JavaClass)) {
            throw this.getRuntime().newTypeError("assignable_from requires JavaClass (" + iRubyObject.getType() + " given)");
        }
        Class clazz = ((JavaClass)iRubyObject).javaClass();
        return JavaClass.assignable(this.javaClass(), clazz) ? this.getRuntime().getTrue() : this.getRuntime().getFalse();
    }

    static boolean assignable(Class<?> clazz, Class<?> clazz2) {
        if (!clazz.isPrimitive() && clazz2 == Void.TYPE || clazz.isAssignableFrom(clazz2)) {
            return true;
        }
        clazz2 = JavaUtil.primitiveToWrapper(clazz2);
        if ((clazz = JavaUtil.primitiveToWrapper(clazz)).isAssignableFrom(clazz2)) {
            return true;
        }
        if (Number.class.isAssignableFrom(clazz)) {
            if (Number.class.isAssignableFrom(clazz2)) {
                return true;
            }
            if (clazz2.equals(Character.class)) {
                return true;
            }
        }
        return clazz.equals(Character.class) && Number.class.isAssignableFrom(clazz2);
    }

    private boolean isPrimitive() {
        return this.javaClass().isPrimitive();
    }

    @JRubyMethod
    public JavaClass component_type() {
        if (!this.javaClass().isArray()) {
            throw this.getRuntime().newTypeError("not a java array-class");
        }
        return JavaClass.get(this.getRuntime(), this.javaClass().getComponentType());
    }

    static {
        RESERVED_NAMES.put("__id__", new AssignedName("__id__", 0));
        RESERVED_NAMES.put("__send__", new AssignedName("__send__", 0));
        RESERVED_NAMES.put("class", new AssignedName("class", 0));
        RESERVED_NAMES.put("initialize", new AssignedName("initialize", 0));
        RESERVED_NAMES.put("object_id", new AssignedName("object_id", 0));
        RESERVED_NAMES.put("private", new AssignedName("private", 0));
        RESERVED_NAMES.put("protected", new AssignedName("protected", 0));
        RESERVED_NAMES.put("public", new AssignedName("public", 0));
        RESERVED_NAMES.put("id", new AssignedName("id", 4));
        STATIC_RESERVED_NAMES = new HashMap<String, AssignedName>(RESERVED_NAMES);
        STATIC_RESERVED_NAMES.put("new", new AssignedName("new", 0));
        INSTANCE_RESERVED_NAMES = new HashMap<String, AssignedName>(RESERVED_NAMES);
        JAVA_PROPERTY_CHOPPER = Pattern.compile("(get|set|is)([A-Z0-9])(.*)");
        CAMEL_CASE_SPLITTER = Pattern.compile("([a-z][0-9]*)([A-Z])");
        __jsend_method = new Callback(){

            public IRubyObject execute(IRubyObject iRubyObject, IRubyObject[] iRubyObjectArray, Block block) {
                String string = iRubyObjectArray[0].asJavaString();
                DynamicMethod dynamicMethod = iRubyObject.getMetaClass().searchMethod(string);
                int n = dynamicMethod.getArity().getValue();
                IRubyObject[] iRubyObjectArray2 = new IRubyObject[iRubyObjectArray.length - 1];
                System.arraycopy(iRubyObjectArray, 1, iRubyObjectArray2, 0, iRubyObjectArray2.length);
                if (n < 0 || n == iRubyObjectArray2.length) {
                    return RuntimeHelpers.invoke(iRubyObject.getRuntime().getCurrentContext(), iRubyObject, string, iRubyObjectArray2, CallType.FUNCTIONAL, block);
                }
                RubyClass rubyClass = iRubyObject.getMetaClass().getSuperClass();
                return RuntimeHelpers.invokeAs(iRubyObject.getRuntime().getCurrentContext(), rubyClass, iRubyObject, string, iRubyObjectArray2, CallType.SUPER, block);
            }

            public Arity getArity() {
                return Arity.optional();
            }
        };
    }

    private static class ConstantField {
        static final int CONSTANT = 25;
        final Field field;

        ConstantField(Field field) {
            this.field = field;
        }

        void install(RubyModule rubyModule) {
            if (rubyModule.fastGetConstantAt(this.field.getName()) == null) {
                JavaField javaField = new JavaField(rubyModule.getRuntime(), this.field);
                rubyModule.const_set(javaField.name(), Java.java_to_ruby(rubyModule, javaField.static_value(), Block.NULL_BLOCK));
            }
        }

        static boolean isConstant(Field field) {
            return (field.getModifiers() & 0x19) == 25 && Character.isUpperCase(field.getName().charAt(0));
        }
    }

    private class InstanceMethodInvoker
    extends MethodCallback {
        InstanceMethodInvoker() {
        }

        InstanceMethodInvoker(String string) {
            super(string, 4);
        }

        void install(RubyClass rubyClass) {
            if (this.hasLocalMethod()) {
                rubyClass.defineFastMethod(this.name, this, this.visibility);
                if (this.aliases != null && this.isPublic()) {
                    rubyClass.defineAliases(this.aliases, this.name);
                    this.aliases = null;
                }
            }
        }

        public IRubyObject execute(IRubyObject iRubyObject, IRubyObject[] iRubyObjectArray, Block block) {
            IRubyObject[] iRubyObjectArray2;
            this.createJavaMethods(iRubyObject.getRuntime());
            int n = iRubyObjectArray.length;
            boolean bl = block.isGiven();
            if (bl) {
                ++n;
                iRubyObjectArray2 = new IRubyObject[iRubyObjectArray.length + 1];
                System.arraycopy(iRubyObjectArray, 0, iRubyObjectArray2, 0, iRubyObjectArray.length);
                iRubyObjectArray2[iRubyObjectArray.length] = RubyProc.newProc(iRubyObject.getRuntime(), block, Block.Type.LAMBDA);
                iRubyObjectArray = iRubyObjectArray2;
            }
            iRubyObjectArray2 = new IRubyObject[n + 1];
            iRubyObjectArray2[0] = iRubyObject.getInstanceVariables().fastGetInstanceVariable("@java_object");
            int n2 = n;
            if (bl) {
                iRubyObjectArray2[n] = iRubyObjectArray[n - 1];
                --n2;
            }
            while (--n2 >= 0) {
                iRubyObjectArray2[n2 + 1] = Java.ruby_to_java(iRubyObject, iRubyObjectArray[n2], Block.NULL_BLOCK);
            }
            JavaMethod javaMethod = this.javaMethod;
            if (javaMethod == null) {
                RubyArray rubyArray = (RubyArray)this.javaMethods.get(n);
                if (rubyArray == null) {
                    this.raiseNoMatchingMethodError(iRubyObject, iRubyObjectArray2, 1);
                }
                javaMethod = (JavaMethod)Java.matching_method_internal(JavaClass.this.JAVA_UTILITIES, rubyArray, iRubyObjectArray2, 1, n);
            }
            return Java.java_to_ruby(iRubyObject, javaMethod.invoke(iRubyObjectArray2), Block.NULL_BLOCK);
        }

        public Arity getArity() {
            return Arity.OPTIONAL;
        }
    }

    private class StaticMethodInvoker
    extends MethodCallback {
        StaticMethodInvoker() {
        }

        StaticMethodInvoker(String string) {
            super(string, 2);
        }

        void install(RubyClass rubyClass) {
            if (this.hasLocalMethod()) {
                RubyClass rubyClass2 = rubyClass.getSingletonClass();
                rubyClass2.defineFastMethod(this.name, this, this.visibility);
                if (this.aliases != null && this.isPublic()) {
                    rubyClass2.defineAliases(this.aliases, this.name);
                    this.aliases = null;
                }
            }
        }

        public IRubyObject execute(IRubyObject iRubyObject, IRubyObject[] iRubyObjectArray, Block block) {
            this.createJavaMethods(iRubyObject.getRuntime());
            int n = iRubyObjectArray.length;
            IRubyObject[] iRubyObjectArray2 = new IRubyObject[n];
            int n2 = n;
            while (--n2 >= 0) {
                iRubyObjectArray2[n2] = Java.ruby_to_java(iRubyObject, iRubyObjectArray[n2], Block.NULL_BLOCK);
            }
            JavaMethod javaMethod = this.javaMethod;
            if (javaMethod == null) {
                RubyArray rubyArray = (RubyArray)this.javaMethods.get(n);
                if (rubyArray == null) {
                    this.raiseNoMatchingMethodError(iRubyObject, iRubyObjectArray2, 0);
                }
                javaMethod = (JavaMethod)Java.matching_method_internal(JavaClass.this.JAVA_UTILITIES, rubyArray, iRubyObjectArray2, 0, n);
            }
            return Java.java_to_ruby(iRubyObject, javaMethod.invoke_static(iRubyObjectArray2), Block.NULL_BLOCK);
        }

        public Arity getArity() {
            return Arity.OPTIONAL;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static abstract class MethodCallback
    extends NamedCallback {
        private boolean haveLocalMethod;
        private List<Method> methods;
        protected List<String> aliases;
        protected JavaMethod javaMethod;
        protected IntHashMap javaMethods;
        protected volatile boolean initialized;

        MethodCallback() {
        }

        MethodCallback(String string, int n) {
            super(string, n);
        }

        void addMethod(Method method, Class<?> clazz) {
            if (this.methods == null) {
                this.methods = new ArrayList<Method>();
            }
            this.methods.add(method);
            this.haveLocalMethod |= clazz == method.getDeclaringClass();
        }

        void addAlias(String string) {
            if (this.aliases == null) {
                this.aliases = new ArrayList<String>();
            }
            if (!this.aliases.contains(string)) {
                this.aliases.add(string);
            }
        }

        @Override
        boolean hasLocalMethod() {
            return this.haveLocalMethod;
        }

        synchronized void createJavaMethods(Ruby ruby) {
            if (!this.initialized) {
                if (this.methods != null) {
                    if (this.methods.size() == 1) {
                        this.javaMethod = JavaMethod.create(ruby, this.methods.get(0));
                    } else {
                        this.javaMethods = new IntHashMap();
                        for (Method method : this.methods) {
                            int n = method.getParameterTypes().length;
                            RubyArray rubyArray = (RubyArray)this.javaMethods.get(n);
                            if (rubyArray == null) {
                                rubyArray = RubyArray.newArrayLight(ruby);
                                this.javaMethods.put(n, rubyArray);
                            }
                            rubyArray.append(JavaMethod.create(ruby, method));
                        }
                    }
                    this.methods = null;
                }
                this.initialized = true;
            }
        }

        void raiseNoMatchingMethodError(IRubyObject iRubyObject, IRubyObject[] iRubyObjectArray, int n) {
            int n2 = iRubyObjectArray.length;
            ArrayList<Object> arrayList = new ArrayList<Object>(n2 - n);
            for (int i = n; i < n2; ++i) {
                arrayList.add(((JavaClass)((JavaObject)iRubyObjectArray[i]).java_class()).getValue());
            }
            throw iRubyObject.getRuntime().newNameError("no " + this.name + " with arguments matching " + arrayList + " on object " + iRubyObject.callMethod(iRubyObject.getRuntime().getCurrentContext(), "inspect"), null);
        }
    }

    private class InstanceFieldSetter
    extends FieldCallback {
        InstanceFieldSetter() {
        }

        InstanceFieldSetter(String string, Field field) {
            super(string, 3, field);
        }

        void install(RubyClass rubyClass) {
            rubyClass.defineFastMethod(this.name, this, this.visibility);
        }

        public IRubyObject execute(IRubyObject iRubyObject, IRubyObject[] iRubyObjectArray, Block block) {
            if (this.javaField == null) {
                this.javaField = new JavaField(JavaClass.this.getRuntime(), this.field);
            }
            return Java.java_to_ruby(iRubyObject, this.javaField.set_value(iRubyObject.getInstanceVariables().fastGetInstanceVariable("@java_object"), Java.ruby_to_java(iRubyObject, iRubyObjectArray[0], Block.NULL_BLOCK)), Block.NULL_BLOCK);
        }

        public Arity getArity() {
            return Arity.ONE_ARGUMENT;
        }
    }

    private class InstanceFieldGetter
    extends FieldCallback {
        InstanceFieldGetter() {
        }

        InstanceFieldGetter(String string, Field field) {
            super(string, 3, field);
        }

        void install(RubyClass rubyClass) {
            rubyClass.defineFastMethod(this.name, this, this.visibility);
        }

        public IRubyObject execute(IRubyObject iRubyObject, IRubyObject[] iRubyObjectArray, Block block) {
            if (this.javaField == null) {
                this.javaField = new JavaField(JavaClass.this.getRuntime(), this.field);
            }
            return Java.java_to_ruby(iRubyObject, this.javaField.value(iRubyObject.getInstanceVariables().fastGetInstanceVariable("@java_object")), Block.NULL_BLOCK);
        }

        public Arity getArity() {
            return Arity.NO_ARGUMENTS;
        }
    }

    private class StaticFieldSetter
    extends FieldCallback {
        StaticFieldSetter() {
        }

        StaticFieldSetter(String string, Field field) {
            super(string, 1, field);
        }

        void install(RubyClass rubyClass) {
            rubyClass.getSingletonClass().defineFastMethod(this.name, this, this.visibility);
        }

        public IRubyObject execute(IRubyObject iRubyObject, IRubyObject[] iRubyObjectArray, Block block) {
            if (this.javaField == null) {
                this.javaField = new JavaField(JavaClass.this.getRuntime(), this.field);
            }
            return Java.java_to_ruby(iRubyObject, this.javaField.set_static_value(Java.ruby_to_java(iRubyObject, iRubyObjectArray[0], Block.NULL_BLOCK)), Block.NULL_BLOCK);
        }

        public Arity getArity() {
            return Arity.ONE_ARGUMENT;
        }
    }

    private class StaticFieldGetter
    extends FieldCallback {
        StaticFieldGetter() {
        }

        StaticFieldGetter(String string, Field field) {
            super(string, 1, field);
        }

        void install(RubyClass rubyClass) {
            rubyClass.getSingletonClass().defineFastMethod(this.name, this, this.visibility);
        }

        public IRubyObject execute(IRubyObject iRubyObject, IRubyObject[] iRubyObjectArray, Block block) {
            if (this.javaField == null) {
                this.javaField = new JavaField(JavaClass.this.getRuntime(), this.field);
            }
            return Java.java_to_ruby(iRubyObject, this.javaField.static_value(), Block.NULL_BLOCK);
        }

        public Arity getArity() {
            return Arity.NO_ARGUMENTS;
        }
    }

    private static abstract class FieldCallback
    extends NamedCallback {
        Field field;
        JavaField javaField;

        FieldCallback() {
        }

        FieldCallback(String string, int n, Field field) {
            super(string, n);
            this.field = field;
        }
    }

    private static abstract class NamedCallback
    implements Callback {
        static final int STATIC_FIELD = 1;
        static final int STATIC_METHOD = 2;
        static final int INSTANCE_FIELD = 3;
        static final int INSTANCE_METHOD = 4;
        String name;
        int type;
        Visibility visibility = Visibility.PUBLIC;
        boolean isProtected;

        NamedCallback() {
        }

        NamedCallback(String string, int n) {
            this.name = string;
            this.type = n;
        }

        abstract void install(RubyClass var1);

        boolean hasLocalMethod() {
            return true;
        }

        boolean isPublic() {
            return this.visibility == Visibility.PUBLIC;
        }

        boolean isProtected() {
            return this.visibility == Visibility.PROTECTED;
        }
    }

    private static class AssignedName {
        static final int RESERVED = 0;
        static final int METHOD = 1;
        static final int FIELD = 2;
        static final int PROTECTED_METHOD = 3;
        static final int WEAKLY_RESERVED = 4;
        static final int ALIAS = 5;
        static final int PROTECTED_FIELD = 6;
        String name;
        int type;

        AssignedName() {
        }

        AssignedName(String string, int n) {
            this.name = string;
            this.type = n;
        }
    }
}

