/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.internal.runtime.methods;

import org.jruby.Ruby;
import org.jruby.RubyModule;
import org.jruby.internal.runtime.methods.CallConfiguration;
import org.jruby.internal.runtime.methods.DynamicMethod;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Block;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.callback.Callback;

public class SimpleCallbackMethod
extends DynamicMethod {
    private Callback callback;

    public SimpleCallbackMethod(RubyModule rubyModule, Callback callback, Visibility visibility) {
        super(rubyModule, visibility, CallConfiguration.NO_FRAME_NO_SCOPE);
        this.callback = callback;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IRubyObject call(ThreadContext threadContext, IRubyObject iRubyObject, RubyModule rubyModule, String string, IRubyObject[] iRubyObjectArray, Block block) {
        assert (iRubyObjectArray != null);
        Ruby ruby = threadContext.getRuntime();
        if (ruby.hasEventHooks()) {
            ruby.callEventHooks(threadContext, 5, threadContext.getFile(), threadContext.getLine(), string, this.getImplementationClass());
            try {
                IRubyObject iRubyObject2 = this.callback.execute(iRubyObject, iRubyObjectArray, block);
                return iRubyObject2;
            }
            finally {
                ruby.callEventHooks(threadContext, 6, threadContext.getFile(), threadContext.getLine(), string, this.getImplementationClass());
            }
        }
        return this.callback.execute(iRubyObject, iRubyObjectArray, block);
    }

    public Callback getCallback() {
        return this.callback;
    }

    public Arity getArity() {
        return this.getCallback().getArity();
    }

    public DynamicMethod dup() {
        return new SimpleCallbackMethod(this.getImplementationClass(), this.callback, this.getVisibility());
    }
}

