/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.internal.runtime.methods;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.jruby.Ruby;
import org.jruby.RubyModule;
import org.jruby.exceptions.JumpException;
import org.jruby.exceptions.RaiseException;
import org.jruby.internal.runtime.methods.CallConfiguration;
import org.jruby.internal.runtime.methods.CompiledMethod;
import org.jruby.parser.StaticScope;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Block;
import org.jruby.runtime.Frame;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;

public class ReflectedCompiledMethod
extends CompiledMethod {
    private final Method method;

    public ReflectedCompiledMethod(RubyModule rubyModule, Arity arity, Visibility visibility, StaticScope staticScope, Object object, Method method, CallConfiguration callConfiguration) {
        super(rubyModule, arity, visibility, staticScope, object, callConfiguration);
        this.method = method;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IRubyObject call(ThreadContext threadContext, IRubyObject iRubyObject, RubyModule rubyModule, String string, IRubyObject[] iRubyObjectArray, Block block) {
        this.callConfig.pre(threadContext, iRubyObject, this.getImplementationClass(), string, block, this.staticScope, this);
        Ruby ruby = threadContext.getRuntime();
        try {
            boolean bl = ruby.hasEventHooks();
            try {
                if (bl) {
                    ruby.callEventHooks(threadContext, 3, threadContext.getFile(), threadContext.getLine(), string, this.getImplementationClass());
                }
                IRubyObject iRubyObject2 = (IRubyObject)this.method.invoke(this.$scriptObject, threadContext, iRubyObject, iRubyObjectArray, block);
                if (bl) {
                    Frame frame = threadContext.getPreviousFrame();
                    ruby.callEventHooks(threadContext, 4, frame.getFile(), frame.getLine(), string, this.getImplementationClass());
                }
                return iRubyObject2;
            }
            catch (Throwable throwable) {
                try {
                    if (bl) {
                        Frame frame = threadContext.getPreviousFrame();
                        ruby.callEventHooks(threadContext, 4, frame.getFile(), frame.getLine(), string, this.getImplementationClass());
                    }
                    throw throwable;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw RaiseException.createNativeRaiseException(ruby, illegalArgumentException);
                }
                catch (IllegalAccessException illegalAccessException) {
                    throw RaiseException.createNativeRaiseException(ruby, illegalAccessException);
                }
                catch (InvocationTargetException invocationTargetException) {
                    Throwable throwable2 = invocationTargetException.getCause();
                    if (throwable2 instanceof JumpException.ReturnJump) {
                        IRubyObject iRubyObject3 = this.handleReturn(threadContext, (JumpException.ReturnJump)throwable2);
                        return iRubyObject3;
                    }
                    if (throwable2 instanceof JumpException.RedoJump) {
                        IRubyObject iRubyObject4 = this.handleRedo(ruby);
                        return iRubyObject4;
                    }
                    if (throwable2 instanceof RuntimeException) {
                        throw (RuntimeException)throwable2;
                    }
                    if (throwable2 instanceof Error) {
                        throw (Error)throwable2;
                    }
                    throw RaiseException.createNativeRaiseException(ruby, throwable2);
                }
            }
        }
        finally {
            this.callConfig.post(threadContext);
        }
    }
}

