/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext;

import java.io.IOException;
import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyObject;
import org.jruby.RubyProc;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.javasupport.util.RuntimeHelpers;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Block;
import org.jruby.runtime.BlockCallback;
import org.jruby.runtime.CallBlock;
import org.jruby.runtime.MethodIndex;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.load.Library;

@JRubyClass(name={"Generator"}, include={"Enumerable"})
public class Generator {
    public static void createGenerator(Ruby ruby) throws IOException {
        RubyClass rubyClass = ruby.defineClass("Generator", ruby.getObject(), ruby.getObject().getAllocator());
        rubyClass.includeModule(ruby.getEnumerable());
        rubyClass.defineAnnotatedMethods(Generator.class);
    }

    @JRubyMethod(name={"new"}, rest=true, frame=true, meta=true)
    public static IRubyObject new_instance(IRubyObject iRubyObject, IRubyObject[] iRubyObjectArray, Block block) {
        RubyObject rubyObject = new RubyObject(iRubyObject.getRuntime(), (RubyClass)iRubyObject);
        rubyObject.dataWrapStruct(new GeneratorData(rubyObject));
        rubyObject.callMethod(iRubyObject.getRuntime().getCurrentContext(), "initialize", iRubyObjectArray, block);
        return rubyObject;
    }

    @JRubyMethod(optional=1, frame=true, visibility=Visibility.PRIVATE)
    public static IRubyObject initialize(IRubyObject iRubyObject, IRubyObject[] iRubyObjectArray, Block block) {
        GeneratorData generatorData = (GeneratorData)iRubyObject.dataGetStruct();
        iRubyObject.getInstanceVariables().setInstanceVariable("@queue", iRubyObject.getRuntime().newArray());
        iRubyObject.getInstanceVariables().setInstanceVariable("@index", iRubyObject.getRuntime().newFixnum(0));
        if (Arity.checkArgumentCount(iRubyObject.getRuntime(), iRubyObjectArray, 0, 1) == 1) {
            generatorData.setEnum(iRubyObjectArray[0]);
        } else {
            generatorData.setProc(iRubyObject.getRuntime().newProc(Block.Type.PROC, block));
        }
        return iRubyObject;
    }

    @JRubyMethod(frame=true)
    public static IRubyObject yield(IRubyObject iRubyObject, IRubyObject iRubyObject2, Block block) {
        iRubyObject.getInstanceVariables().getInstanceVariable("@queue").callMethod(iRubyObject.getRuntime().getCurrentContext(), "<<", iRubyObject2);
        GeneratorData generatorData = (GeneratorData)iRubyObject.dataGetStruct();
        generatorData.doWait();
        return iRubyObject;
    }

    @JRubyMethod(name={"end?"})
    public static IRubyObject end_p(IRubyObject iRubyObject) {
        GeneratorData generatorData = (GeneratorData)iRubyObject.dataGetStruct();
        boolean bl = iRubyObject.getInstanceVariables().getInstanceVariable("@queue").callMethod(iRubyObject.getRuntime().getCurrentContext(), MethodIndex.EMPTY_P, "empty?").isTrue();
        return generatorData.isEnd() && bl ? iRubyObject.getRuntime().getTrue() : iRubyObject.getRuntime().getFalse();
    }

    @JRubyMethod(name={"next?"})
    public static IRubyObject next_p(IRubyObject iRubyObject) {
        return RuntimeHelpers.negate(RuntimeHelpers.invoke(iRubyObject.getRuntime().getCurrentContext(), iRubyObject, "end?"), iRubyObject.getRuntime());
    }

    @JRubyMethod(name={"index", "pos"})
    public static IRubyObject index(IRubyObject iRubyObject) {
        return iRubyObject.getInstanceVariables().getInstanceVariable("@index");
    }

    @JRubyMethod(frame=true)
    public static IRubyObject next(IRubyObject iRubyObject, Block block) {
        GeneratorData generatorData = (GeneratorData)iRubyObject.dataGetStruct();
        if (RuntimeHelpers.invoke(iRubyObject.getRuntime().getCurrentContext(), iRubyObject, "end?").isTrue()) {
            throw iRubyObject.getRuntime().newEOFError("no more elements available");
        }
        generatorData.generate();
        iRubyObject.getInstanceVariables().setInstanceVariable("@index", iRubyObject.getInstanceVariables().getInstanceVariable("@index").callMethod(iRubyObject.getRuntime().getCurrentContext(), MethodIndex.OP_PLUS, "+", iRubyObject.getRuntime().newFixnum(1)));
        return iRubyObject.getInstanceVariables().getInstanceVariable("@queue").callMethod(iRubyObject.getRuntime().getCurrentContext(), "shift");
    }

    @JRubyMethod(frame=true)
    public static IRubyObject current(IRubyObject iRubyObject, Block block) {
        if (iRubyObject.getInstanceVariables().getInstanceVariable("@queue").callMethod(iRubyObject.getRuntime().getCurrentContext(), MethodIndex.EMPTY_P, "empty?").isTrue()) {
            throw iRubyObject.getRuntime().newEOFError("no more elements available");
        }
        return iRubyObject.getInstanceVariables().getInstanceVariable("@queue").callMethod(iRubyObject.getRuntime().getCurrentContext(), "first");
    }

    @JRubyMethod(frame=true)
    public static IRubyObject rewind(IRubyObject iRubyObject, Block block) {
        if (iRubyObject.getInstanceVariables().getInstanceVariable("@index").callMethod(iRubyObject.getRuntime().getCurrentContext(), "nonzero?").isTrue()) {
            GeneratorData generatorData = (GeneratorData)iRubyObject.dataGetStruct();
            iRubyObject.getInstanceVariables().setInstanceVariable("@queue", iRubyObject.getRuntime().newArray());
            iRubyObject.getInstanceVariables().setInstanceVariable("@index", iRubyObject.getRuntime().newFixnum(0));
            generatorData.start();
        }
        return iRubyObject;
    }

    @JRubyMethod(frame=true)
    public static IRubyObject each(IRubyObject iRubyObject, Block block) {
        Generator.rewind(iRubyObject, Block.NULL_BLOCK);
        ThreadContext threadContext = iRubyObject.getRuntime().getCurrentContext();
        while (Generator.next_p(iRubyObject).isTrue()) {
            block.yield(threadContext, Generator.next(iRubyObject, Block.NULL_BLOCK));
        }
        return iRubyObject;
    }

    static class GeneratorData
    implements Runnable {
        private IRubyObject gen;
        private Object mutex = new Object();
        private IRubyObject enm;
        private RubyProc proc;
        private Thread t;
        private volatile boolean end;
        private IterBlockCallback ibc;
        private boolean available = false;

        public GeneratorData(IRubyObject iRubyObject) {
            this.gen = iRubyObject;
        }

        public void setEnum(IRubyObject iRubyObject) {
            this.proc = null;
            this.enm = iRubyObject;
            this.start();
        }

        public void setProc(RubyProc rubyProc) {
            this.proc = rubyProc;
            this.enm = null;
            this.start();
        }

        public void start() {
            if (this.t != null) {
                this.t.interrupt();
                try {
                    this.t.join();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            this.end = false;
            this.ibc = new IterBlockCallback();
            this.t = new Thread(this);
            this.t.setDaemon(true);
            this.t.start();
            this.generate();
        }

        public boolean isEnd() {
            return this.end;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void doWait() {
            this.available = true;
            if (this.proc != null) {
                boolean bl = true;
                Object object = this.mutex;
                synchronized (object) {
                    this.mutex.notifyAll();
                    while (bl) {
                        try {
                            this.mutex.wait();
                            bl = false;
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void generate() {
            if (this.proc == null) {
                boolean bl = true;
                Object object = this.mutex;
                synchronized (object) {
                    while (!this.ibc.haveValue() && !this.end) {
                        this.mutex.notifyAll();
                        bl = true;
                        while (bl) {
                            try {
                                this.mutex.wait();
                                bl = false;
                            }
                            catch (InterruptedException interruptedException) {}
                        }
                    }
                    if (this.ibc.haveValue() && this.proc == null) {
                        this.gen.callMethod(this.gen.getRuntime().getCurrentContext(), "yield", this.ibc.pop());
                    }
                }
            }
            Object object = this.mutex;
            synchronized (object) {
                while (!this.available && !this.end) {
                    boolean bl = true;
                    this.mutex.notifyAll();
                    while (bl) {
                        try {
                            this.mutex.wait(20L);
                            bl = false;
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                }
                this.available = false;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            ThreadContext threadContext = this.gen.getRuntime().getCurrentContext();
            if (this.enm != null) {
                this.enm.callMethod(threadContext, "each", IRubyObject.NULL_ARRAY, CallBlock.newCallClosure(this.enm, this.enm.getMetaClass().getRealClass(), Arity.noArguments(), this.ibc, threadContext));
            } else {
                this.proc.call(threadContext, new IRubyObject[]{this.gen});
            }
            this.end = true;
            Object object = this.mutex;
            synchronized (object) {
                this.mutex.notifyAll();
            }
        }

        private class IterBlockCallback
        implements BlockCallback {
            private IRubyObject obj;
            private boolean shouldSkip = false;

            private IterBlockCallback() {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public IRubyObject call(ThreadContext threadContext, IRubyObject[] iRubyObjectArray, Block block) {
                if (this.shouldSkip) {
                    return GeneratorData.this.gen.getRuntime().getNil();
                }
                boolean bl = true;
                Object object = GeneratorData.this.mutex;
                synchronized (object) {
                    GeneratorData.this.mutex.notifyAll();
                    while (bl) {
                        try {
                            GeneratorData.this.mutex.wait();
                            bl = false;
                        }
                        catch (InterruptedException interruptedException) {
                            this.shouldSkip = true;
                            return GeneratorData.this.gen.getRuntime().getNil();
                        }
                    }
                    this.obj = iRubyObjectArray.length > 1 ? GeneratorData.this.gen.getRuntime().newArrayNoCopy(iRubyObjectArray) : iRubyObjectArray[0];
                    GeneratorData.this.mutex.notifyAll();
                    return GeneratorData.this.gen.getRuntime().getNil();
                }
            }

            public boolean haveValue() {
                return this.obj != null;
            }

            public IRubyObject pop() {
                IRubyObject iRubyObject = this.obj;
                this.obj = null;
                return iRubyObject;
            }
        }
    }

    public static class Service
    implements Library {
        public void load(Ruby ruby, boolean bl) throws IOException {
            Generator.createGenerator(ruby);
        }
    }
}

