/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.demo;

import java.awt.Color;
import java.awt.EventQueue;
import java.awt.Point;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.LinkedList;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComboBox;
import javax.swing.plaf.basic.BasicComboPopup;
import javax.swing.text.AbstractDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DocumentFilter;
import javax.swing.text.JTextComponent;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import org.jruby.Ruby;
import org.jruby.RubyIO;
import org.jruby.RubyModule;
import org.jruby.RubyString;
import org.jruby.ext.Readline;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Block;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.callback.Callback;
import org.jruby.util.Join;

public class TextAreaReadline
implements KeyListener {
    private static final String EMPTY_LINE = "";
    private JTextComponent area;
    private int startPos;
    private String currentLine;
    public volatile MutableAttributeSet promptStyle;
    public volatile MutableAttributeSet inputStyle;
    public volatile MutableAttributeSet outputStyle;
    public volatile MutableAttributeSet resultStyle;
    private JComboBox completeCombo;
    private BasicComboPopup completePopup;
    private int start;
    private int end;
    private final InputStream inputStream = new Input();
    private final OutputStream outputStream = new Output();
    private static final Join.Spec INPUT_SPEC = new Join.Spec(){
        {
            this.addReaction(new Join.FastReaction((Enum)Channel.SHUTDOWN, new Enum[]{Channel.BUFFER}){

                public void react(Join join, Object[] objectArray) {
                    join.send(Channel.FINISHED, null);
                }
            });
            this.addReaction(new Join.FastReaction((Enum)Channel.SHUTDOWN, new Enum[]{Channel.EMPTY}){

                public void react(Join join, Object[] objectArray) {
                    join.send(Channel.FINISHED, null);
                }
            });
            this.addReaction(new Join.FastReaction((Enum)Channel.SHUTDOWN, new Enum[]{Channel.FINISHED}){

                public void react(Join join, Object[] objectArray) {
                    join.send(Channel.FINISHED, null);
                }
            });
            this.addReaction(new Join.FastReaction((Enum)Channel.FINISHED, new Enum[]{Channel.LINE}){

                public void react(Join join, Object[] objectArray) {
                    join.send(Channel.FINISHED, null);
                }
            });
            this.addReaction(new Join.SyncReaction((Enum)Channel.AVAILABLE, new Enum[]{Channel.BUFFER}){

                public Object react(Join join, Object[] objectArray) {
                    InputBuffer inputBuffer = (InputBuffer)objectArray[1];
                    join.send(Channel.BUFFER, (Object)inputBuffer);
                    return inputBuffer.bytes.length - inputBuffer.offset;
                }
            });
            this.addReaction(new Join.SyncReaction((Enum)Channel.AVAILABLE, new Enum[]{Channel.EMPTY}){

                public Object react(Join join, Object[] objectArray) {
                    join.send(Channel.EMPTY, null);
                    return 0;
                }
            });
            this.addReaction(new Join.SyncReaction((Enum)Channel.AVAILABLE, new Enum[]{Channel.FINISHED}){

                public Object react(Join join, Object[] objectArray) {
                    join.send(Channel.FINISHED, null);
                    return 0;
                }
            });
            this.addReaction(new Join.SyncReaction((Enum)Channel.READ, new Enum[]{Channel.BUFFER}){

                public Object react(Join join, Object[] objectArray) {
                    return ((ReadRequest)objectArray[0]).perform(join, (InputBuffer)objectArray[1]);
                }
            });
            this.addReaction(new Join.SyncReaction((Enum)Channel.READ, new Enum[]{Channel.EMPTY, Channel.LINE}){

                public Object react(Join join, Object[] objectArray) {
                    ReadRequest readRequest = (ReadRequest)objectArray[0];
                    String string = (String)objectArray[2];
                    if (string.length() != 0) {
                        byte[] byArray;
                        try {
                            byArray = string.getBytes("UTF-8");
                        }
                        catch (UnsupportedEncodingException unsupportedEncodingException) {
                            byArray = string.getBytes();
                        }
                        return readRequest.perform(join, new InputBuffer(byArray));
                    }
                    return -1;
                }
            });
            this.addReaction(new Join.SyncReaction((Enum)Channel.READ, new Enum[]{Channel.FINISHED}){

                public Object react(Join join, Object[] objectArray) {
                    join.send(Channel.FINISHED, null);
                    return -1;
                }
            });
            this.addReaction(new Join.SyncReaction((Enum)Channel.GET_LINE, new Enum[]{Channel.LINE}){

                public Object react(Join join, Object[] objectArray) {
                    return objectArray[1];
                }
            });
            this.addReaction(new Join.SyncReaction((Enum)Channel.GET_LINE, new Enum[]{Channel.FINISHED}){

                public Object react(Join join, Object[] objectArray) {
                    join.send(Channel.FINISHED, null);
                    return TextAreaReadline.EMPTY_LINE;
                }
            });
        }
    };
    private final Join inputJoin = INPUT_SPEC.createJoin();
    private Ruby runtime;

    public TextAreaReadline(JTextComponent jTextComponent) {
        this(jTextComponent, null);
    }

    public TextAreaReadline(JTextComponent jTextComponent, String string) {
        this.area = jTextComponent;
        this.inputJoin.send(Channel.EMPTY, null);
        jTextComponent.addKeyListener(this);
        if (jTextComponent.getDocument() instanceof AbstractDocument) {
            ((AbstractDocument)jTextComponent.getDocument()).setDocumentFilter(new DocumentFilter(){

                public void insertString(DocumentFilter.FilterBypass filterBypass, int n, String string, AttributeSet attributeSet) throws BadLocationException {
                    if (n >= TextAreaReadline.this.startPos) {
                        super.insertString(filterBypass, n, string, attributeSet);
                    }
                }

                public void remove(DocumentFilter.FilterBypass filterBypass, int n, int n2) throws BadLocationException {
                    if (n >= TextAreaReadline.this.startPos) {
                        super.remove(filterBypass, n, n2);
                    }
                }

                public void replace(DocumentFilter.FilterBypass filterBypass, int n, int n2, String string, AttributeSet attributeSet) throws BadLocationException {
                    if (n >= TextAreaReadline.this.startPos) {
                        super.replace(filterBypass, n, n2, string, attributeSet);
                    }
                }
            });
        }
        this.promptStyle = new SimpleAttributeSet();
        StyleConstants.setForeground(this.promptStyle, new Color(164, 0, 0));
        this.inputStyle = new SimpleAttributeSet();
        StyleConstants.setForeground(this.inputStyle, new Color(32, 74, 135));
        this.outputStyle = new SimpleAttributeSet();
        StyleConstants.setForeground(this.outputStyle, Color.darkGray);
        this.resultStyle = new SimpleAttributeSet();
        StyleConstants.setItalic(this.resultStyle, true);
        StyleConstants.setForeground(this.resultStyle, new Color(32, 74, 135));
        this.completeCombo = new JComboBox();
        this.completeCombo.setRenderer(new DefaultListCellRenderer());
        this.completePopup = new BasicComboPopup(this.completeCombo);
        if (string != null) {
            SimpleAttributeSet simpleAttributeSet = new SimpleAttributeSet();
            StyleConstants.setBackground(simpleAttributeSet, jTextComponent.getForeground());
            StyleConstants.setForeground(simpleAttributeSet, jTextComponent.getBackground());
            this.append(string, simpleAttributeSet);
        }
        this.startPos = jTextComponent.getDocument().getLength();
    }

    public InputStream getInputStream() {
        return this.inputStream;
    }

    public OutputStream getOutputStream() {
        return this.outputStream;
    }

    public void hookIntoRuntime(final Ruby ruby) {
        this.runtime = ruby;
        ruby.getLoadService().require("readline");
        RubyModule rubyModule = ruby.fastGetModule("Readline");
        rubyModule.defineModuleFunction("readline", new Callback(){

            public IRubyObject execute(IRubyObject iRubyObject, IRubyObject[] iRubyObjectArray, Block block) {
                String string = TextAreaReadline.this.readLine(iRubyObjectArray[0].toString());
                if (string != null) {
                    return RubyString.newUnicodeString(ruby, string);
                }
                return ruby.getNil();
            }

            public Arity getArity() {
                return Arity.twoArguments();
            }
        });
    }

    public void hookIntoRuntimeWithStreams(Ruby ruby) {
        this.hookIntoRuntime(ruby);
        RubyIO rubyIO = new RubyIO(ruby, this.getInputStream());
        ruby.getGlobalVariables().set("$stdin", rubyIO);
        RubyIO rubyIO2 = new RubyIO(ruby, this.getOutputStream());
        ruby.getGlobalVariables().set("$stdout", rubyIO2);
        ruby.getGlobalVariables().set("$stderr", rubyIO2);
    }

    protected void completeAction(KeyEvent keyEvent) {
        if (Readline.getCompletor(Readline.getHolder(this.runtime)) == null) {
            return;
        }
        keyEvent.consume();
        if (this.completePopup.isVisible()) {
            return;
        }
        LinkedList linkedList = new LinkedList();
        String string = null;
        try {
            string = this.area.getText(this.startPos, this.area.getCaretPosition() - this.startPos);
        }
        catch (BadLocationException badLocationException) {
            return;
        }
        int n = this.area.getCaretPosition() - this.startPos;
        int n2 = Readline.getCompletor(Readline.getHolder(this.runtime)).complete(string, n, linkedList);
        if (linkedList.isEmpty()) {
            return;
        }
        if (linkedList.size() == 1) {
            this.replaceText(this.startPos + n2, this.area.getCaretPosition(), (String)linkedList.get(0));
            return;
        }
        this.start = this.startPos + n2;
        this.end = this.area.getCaretPosition();
        Point point = this.area.getCaret().getMagicCaretPosition();
        int n3 = string.substring(n2).lastIndexOf(46) + 1;
        this.start += n3;
        if (linkedList.size() < 10) {
            this.completePopup.getList().setVisibleRowCount(linkedList.size());
        } else {
            this.completePopup.getList().setVisibleRowCount(10);
        }
        this.completeCombo.removeAllItems();
        for (String string2 : linkedList) {
            if (n3 != 0) {
                string2 = string2.substring(n3);
            }
            this.completeCombo.addItem(string2);
        }
        this.completePopup.show(this.area, point.x, point.y + this.area.getFontMetrics(this.area.getFont()).getHeight());
    }

    protected void backAction(KeyEvent keyEvent) {
        if (this.area.getCaretPosition() <= this.startPos) {
            keyEvent.consume();
        }
    }

    protected void upAction(KeyEvent keyEvent) {
        keyEvent.consume();
        if (this.completePopup.isVisible()) {
            int n = this.completeCombo.getSelectedIndex() - 1;
            if (n < 0) {
                return;
            }
            this.completeCombo.setSelectedIndex(n);
            return;
        }
        if (!Readline.getHistory(Readline.getHolder(this.runtime)).next()) {
            this.currentLine = this.getLine();
        } else {
            Readline.getHistory(Readline.getHolder(this.runtime)).previous();
        }
        if (!Readline.getHistory(Readline.getHolder(this.runtime)).previous()) {
            return;
        }
        String string = Readline.getHistory(Readline.getHolder(this.runtime)).current().trim();
        this.replaceText(this.startPos, this.area.getDocument().getLength(), string);
    }

    protected void downAction(KeyEvent keyEvent) {
        String string;
        keyEvent.consume();
        if (this.completePopup.isVisible()) {
            int n = this.completeCombo.getSelectedIndex() + 1;
            if (n == this.completeCombo.getItemCount()) {
                return;
            }
            this.completeCombo.setSelectedIndex(n);
            return;
        }
        if (!Readline.getHistory(Readline.getHolder(this.runtime)).next()) {
            return;
        }
        if (!Readline.getHistory(Readline.getHolder(this.runtime)).next()) {
            string = this.currentLine;
        } else {
            Readline.getHistory(Readline.getHolder(this.runtime)).previous();
            string = Readline.getHistory(Readline.getHolder(this.runtime)).current().trim();
        }
        this.replaceText(this.startPos, this.area.getDocument().getLength(), string);
    }

    protected void replaceText(int n, int n2, String string) {
        try {
            this.area.getDocument().remove(n, n2 - n);
            this.area.getDocument().insertString(n, string, this.inputStyle);
        }
        catch (BadLocationException badLocationException) {
            badLocationException.printStackTrace();
        }
    }

    protected String getLine() {
        try {
            return this.area.getText(this.startPos, this.area.getDocument().getLength() - this.startPos);
        }
        catch (BadLocationException badLocationException) {
            badLocationException.printStackTrace();
            return null;
        }
    }

    protected void enterAction(KeyEvent keyEvent) {
        keyEvent.consume();
        if (this.completePopup.isVisible()) {
            if (this.completeCombo.getSelectedItem() != null) {
                this.replaceText(this.start, this.end, (String)this.completeCombo.getSelectedItem());
            }
            this.completePopup.setVisible(false);
            return;
        }
        this.append("\n", null);
        String string = this.getLine();
        this.startPos = this.area.getDocument().getLength();
        this.inputJoin.send(Channel.LINE, (Object)string);
    }

    public String readLine(final String string) {
        if (EventQueue.isDispatchThread()) {
            throw this.runtime.newThreadError("Cannot call readline from event dispatch thread");
        }
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                TextAreaReadline.this.append(string.trim(), TextAreaReadline.this.promptStyle);
                TextAreaReadline.this.append(" ", TextAreaReadline.this.inputStyle);
                TextAreaReadline.this.area.setCaretPosition(TextAreaReadline.this.area.getDocument().getLength());
                TextAreaReadline.this.startPos = TextAreaReadline.this.area.getDocument().getLength();
                Readline.getHistory(Readline.getHolder(TextAreaReadline.this.runtime)).moveToEnd();
            }
        });
        String string2 = (String)this.inputJoin.call(Channel.GET_LINE, null);
        if (string2.length() > 0) {
            return string2.trim();
        }
        return null;
    }

    public void keyPressed(KeyEvent keyEvent) {
        int n = keyEvent.getKeyCode();
        switch (n) {
            case 9: {
                this.completeAction(keyEvent);
                break;
            }
            case 8: 
            case 37: {
                this.backAction(keyEvent);
                break;
            }
            case 38: {
                this.upAction(keyEvent);
                break;
            }
            case 40: {
                this.downAction(keyEvent);
                break;
            }
            case 10: {
                this.enterAction(keyEvent);
                break;
            }
            case 36: {
                keyEvent.consume();
                this.area.setCaretPosition(this.startPos);
                break;
            }
            case 68: {
                if ((keyEvent.getModifiersEx() & 0x80) == 0) break;
                keyEvent.consume();
                this.inputJoin.send(Channel.LINE, (Object)EMPTY_LINE);
            }
        }
        if (this.completePopup.isVisible() && n != 9 && n != 38 && n != 40) {
            this.completePopup.setVisible(false);
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void shutdown() {
        this.inputJoin.send(Channel.SHUTDOWN, null);
    }

    protected void append(String string, AttributeSet attributeSet) {
        try {
            this.area.getDocument().insertString(this.area.getDocument().getLength(), string, attributeSet);
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    private void writeLineUnsafe(String string) {
        if (string.startsWith("=>")) {
            this.append(string, this.resultStyle);
        } else {
            this.append(string, this.outputStyle);
        }
        this.startPos = this.area.getDocument().getLength();
    }

    private void writeLine(final String string) {
        if (EventQueue.isDispatchThread()) {
            this.writeLineUnsafe(string);
        } else {
            EventQueue.invokeLater(new Runnable(){

                public void run() {
                    TextAreaReadline.this.writeLineUnsafe(string);
                }
            });
        }
    }

    private class Output
    extends OutputStream {
        private Output() {
        }

        public void write(int n) throws IOException {
            TextAreaReadline.this.writeLine(TextAreaReadline.EMPTY_LINE + n);
        }

        public void write(byte[] byArray, int n, int n2) {
            try {
                TextAreaReadline.this.writeLine(new String(byArray, n, n2, "UTF-8"));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                TextAreaReadline.this.writeLine(new String(byArray, n, n2));
            }
        }

        public void write(byte[] byArray) {
            try {
                TextAreaReadline.this.writeLine(new String(byArray, "UTF-8"));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                TextAreaReadline.this.writeLine(new String(byArray));
            }
        }
    }

    private class Input
    extends InputStream {
        private volatile boolean closed = false;

        private Input() {
        }

        public int available() throws IOException {
            if (this.closed) {
                throw new IOException("Stream is closed");
            }
            return (Integer)TextAreaReadline.this.inputJoin.call(Channel.AVAILABLE, null);
        }

        public int read() throws IOException {
            byte[] byArray = new byte[1];
            if (this.read(byArray, 0, 1) == 1) {
                return byArray[0];
            }
            return -1;
        }

        public int read(byte[] byArray, int n, int n2) throws IOException {
            if (this.closed) {
                throw new IOException("Stream is closed");
            }
            if (EventQueue.isDispatchThread()) {
                throw new IOException("Cannot call read from event dispatch thread");
            }
            if (byArray == null) {
                throw new NullPointerException();
            }
            if (n < 0 || n2 < 0 || n + n2 > byArray.length) {
                throw new IndexOutOfBoundsException();
            }
            if (n2 == 0) {
                return 0;
            }
            ReadRequest readRequest = new ReadRequest(byArray, n, n2);
            return (Integer)TextAreaReadline.this.inputJoin.call(Channel.READ, (Object)readRequest);
        }

        public void close() {
            this.closed = true;
            TextAreaReadline.this.inputJoin.send(Channel.SHUTDOWN, null);
        }
    }

    private static class ReadRequest {
        public final byte[] b;
        public final int off;
        public final int len;

        public ReadRequest(byte[] byArray, int n, int n2) {
            this.b = byArray;
            this.off = n;
            this.len = n2;
        }

        public int perform(Join join, InputBuffer inputBuffer) {
            int n = this.len;
            int n2 = inputBuffer.bytes.length - inputBuffer.offset;
            if (n > n2) {
                n = n2;
            }
            if (n == n2) {
                join.send(Channel.EMPTY, null);
            } else {
                inputBuffer.offset += n;
                join.send(Channel.BUFFER, (Object)inputBuffer);
            }
            System.arraycopy(inputBuffer.bytes, inputBuffer.offset, this.b, this.off, n);
            return n;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Channel {
        AVAILABLE,
        READ,
        BUFFER,
        EMPTY,
        LINE,
        GET_LINE,
        SHUTDOWN,
        FINISHED;

    }

    private static class InputBuffer {
        public final byte[] bytes;
        public int offset = 0;

        public InputBuffer(byte[] byArray) {
            this.bytes = byArray;
        }
    }
}

