/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.compiler;

import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import org.jruby.Ruby;
import org.jruby.RubyInstanceConfig;
import org.jruby.ast.ArgsNode;
import org.jruby.ast.Node;
import org.jruby.ast.executable.Script;
import org.jruby.ast.util.SexpMaker;
import org.jruby.compiler.ASTCompiler;
import org.jruby.compiler.ASTInspector;
import org.jruby.compiler.CompilerCallback;
import org.jruby.compiler.JITCompilerMBean;
import org.jruby.compiler.MethodCompiler;
import org.jruby.compiler.NotCompilableException;
import org.jruby.compiler.impl.StandardASMCompiler;
import org.jruby.internal.runtime.methods.CallConfiguration;
import org.jruby.internal.runtime.methods.DefaultMethod;
import org.jruby.parser.StaticScope;
import org.jruby.runtime.ThreadContext;
import org.jruby.util.ClassCache;
import org.jruby.util.CodegenUtils;
import org.jruby.util.JavaNameMangler;

public class JITCompiler
implements JITCompilerMBean {
    public static final boolean USE_CACHE = true;
    private Ruby ruby;
    private AtomicLong compiledCount = new AtomicLong(0L);
    private AtomicLong successCount = new AtomicLong(0L);
    private AtomicLong failCount = new AtomicLong(0L);
    private AtomicLong abandonCount = new AtomicLong(0L);
    private AtomicLong compileTime = new AtomicLong(0L);
    private AtomicLong averageCompileTime = new AtomicLong(0L);
    private AtomicLong codeSize = new AtomicLong(0L);
    private AtomicLong averageCodeSize = new AtomicLong(0L);
    private AtomicLong largestCodeSize = new AtomicLong(0L);

    public JITCompiler(Ruby ruby) {
        this.ruby = ruby;
        ruby.getBeanManager().register(this);
    }

    public void runJIT(DefaultMethod defaultMethod, ThreadContext threadContext, String string) {
        Set<Script> set = this.ruby.getJittedMethods();
        RubyInstanceConfig rubyInstanceConfig = this.ruby.getInstanceConfig();
        ClassCache classCache = rubyInstanceConfig.getClassCache();
        if (defaultMethod.getCallCount() < 0) {
            return;
        }
        try {
            defaultMethod.setCallCount(defaultMethod.getCallCount() + 1);
            if (defaultMethod.getCallCount() >= rubyInstanceConfig.getJitThreshold()) {
                int n;
                if (classCache.isFull()) {
                    this.abandonCount.incrementAndGet();
                    defaultMethod.setCallCount(-1);
                    return;
                }
                String string2 = defaultMethod.getImplementationClass().getName();
                if (rubyInstanceConfig.getExcludedMethods().size() > 0 && (rubyInstanceConfig.getExcludedMethods().contains(string2) || rubyInstanceConfig.getExcludedMethods().contains(string2 + "#" + string) || rubyInstanceConfig.getExcludedMethods().contains(string))) {
                    defaultMethod.setCallCount(-1);
                    return;
                }
                JITClassGenerator jITClassGenerator = new JITClassGenerator(string, defaultMethod, threadContext);
                String string3 = SexpMaker.create(string, defaultMethod.getArgsNode(), defaultMethod.getBodyNode());
                Class clazz = rubyInstanceConfig.getClassCache().cacheClassByKey(string3, jITClassGenerator);
                if (clazz == null) {
                    this.failCount.incrementAndGet();
                    defaultMethod.setCallCount(-1);
                    return;
                }
                this.successCount.incrementAndGet();
                Script script = (Script)clazz.newInstance();
                set.add(script);
                if (rubyInstanceConfig.getJitLogEvery() > 0 && (n = set.size()) % rubyInstanceConfig.getJitLogEvery() == 0) {
                    JITCompiler.log(defaultMethod, string, "live compiled methods: " + n, new String[0]);
                }
                if (rubyInstanceConfig.isJitLogging()) {
                    JITCompiler.log(defaultMethod, string, "done jitting", new String[0]);
                }
                defaultMethod.setJITCallConfig(jITClassGenerator.callConfig());
                defaultMethod.setJITCompiledScript(script);
                defaultMethod.setCallCount(-1);
            }
        }
        catch (Throwable throwable) {
            if (rubyInstanceConfig.isJitLoggingVerbose()) {
                JITCompiler.log(defaultMethod, string, "could not compile", throwable.getMessage());
            }
            this.failCount.incrementAndGet();
            defaultMethod.setCallCount(-1);
        }
    }

    private static String calculateFilename(ArgsNode argsNode, Node node) {
        if (node != null) {
            return node.getPosition().getFile();
        }
        if (argsNode != null) {
            return argsNode.getPosition().getFile();
        }
        return "__eval__";
    }

    static void log(DefaultMethod defaultMethod, String string, String string2, String ... stringArray) {
        String string3 = defaultMethod.getImplementationClass().getBaseName();
        if (string3 == null) {
            string3 = "<anon class>";
        }
        System.err.print(string2 + ":" + string3 + "." + string);
        if (stringArray.length > 0) {
            System.err.print(" because of: \"");
            for (int i = 0; i < stringArray.length; ++i) {
                System.err.print(stringArray[i]);
            }
            System.err.print('\"');
        }
        System.err.println("");
    }

    public long getSuccessCount() {
        return this.successCount.get();
    }

    public long getCompileCount() {
        return this.compiledCount.get();
    }

    public long getFailCount() {
        return this.failCount.get();
    }

    public long getCompileTime() {
        return this.compileTime.get() / 1000L;
    }

    public long getAbandonCount() {
        return this.abandonCount.get();
    }

    public long getCodeSize() {
        return this.codeSize.get();
    }

    public long getAverageCodeSize() {
        return this.averageCodeSize.get();
    }

    public long getAverageCompileTime() {
        return this.averageCompileTime.get() / 1000L;
    }

    public long getLargestCodeSize() {
        return this.largestCodeSize.get();
    }

    public class JITClassGenerator
    implements ClassCache.ClassGenerator {
        private StandardASMCompiler asmCompiler;
        private DefaultMethod method;
        private StaticScope staticScope;
        private Node bodyNode;
        private ArgsNode argsNode;
        private CallConfiguration jitCallConfig;
        private byte[] bytecode;
        private String name;

        public JITClassGenerator(String string, DefaultMethod defaultMethod, ThreadContext threadContext) {
            this.method = defaultMethod;
            String string2 = "ruby/jit/" + JavaNameMangler.mangleFilenameForClasspath(defaultMethod.getPosition().getFile());
            String string3 = string2 + "/" + JavaNameMangler.mangleStringForCleanJavaIdentifier(string);
            this.bodyNode = defaultMethod.getBodyNode();
            this.argsNode = defaultMethod.getArgsNode();
            String string4 = JITCompiler.calculateFilename(this.argsNode, this.bodyNode);
            this.staticScope = defaultMethod.getStaticScope();
            this.asmCompiler = new StandardASMCompiler(string3 + defaultMethod.hashCode() + "_" + threadContext.hashCode(), string4);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void compile() {
            MethodCompiler methodCompiler;
            if (this.bytecode != null) {
                return;
            }
            long l = System.nanoTime();
            this.asmCompiler.startScript(this.staticScope);
            final ASTCompiler aSTCompiler = new ASTCompiler();
            CompilerCallback compilerCallback = new CompilerCallback(){

                public void call(MethodCompiler methodCompiler) {
                    aSTCompiler.compileArgs(JITClassGenerator.this.argsNode, methodCompiler);
                }
            };
            ASTInspector aSTInspector = new ASTInspector();
            aSTInspector.inspect(this.argsNode);
            aSTInspector.inspect(this.bodyNode);
            if (this.bodyNode != null) {
                methodCompiler = this.asmCompiler.startMethod("__file__", compilerCallback, this.staticScope, aSTInspector);
                aSTCompiler.compile(this.bodyNode, methodCompiler);
            } else if (this.argsNode != null && (this.argsNode.getRequiredArgsCount() > 0 || this.argsNode.getOptionalArgsCount() > 0)) {
                methodCompiler = this.asmCompiler.startMethod("__file__", compilerCallback, this.staticScope, aSTInspector);
                methodCompiler.loadNil();
            } else {
                methodCompiler = this.asmCompiler.startMethod("__file__", null, this.staticScope, aSTInspector);
                methodCompiler.loadNil();
                this.jitCallConfig = CallConfiguration.NO_FRAME_NO_SCOPE;
            }
            methodCompiler.endMethod();
            this.asmCompiler.endScript(false, false);
            if (this.jitCallConfig == null) {
                this.jitCallConfig = aSTInspector.hasClosure() || aSTInspector.hasScopeAwareMethods() ? CallConfiguration.FRAME_AND_SCOPE : CallConfiguration.FRAME_ONLY;
            }
            this.bytecode = this.asmCompiler.getClassByteArray();
            this.name = CodegenUtils.c(this.asmCompiler.getClassname());
            if (this.bytecode.length > JITCompiler.this.ruby.getInstanceConfig().getJitMaxSize()) {
                this.bytecode = null;
                throw new NotCompilableException("JITed method size exceeds configured max of " + JITCompiler.this.ruby.getInstanceConfig().getJitMaxSize());
            }
            JITCompiler.this.compiledCount.incrementAndGet();
            JITCompiler.this.compileTime.addAndGet(System.nanoTime() - l);
            JITCompiler.this.codeSize.addAndGet(this.bytecode.length);
            JITCompiler.this.averageCompileTime.set(JITCompiler.this.compileTime.get() / JITCompiler.this.compiledCount.get());
            JITCompiler.this.averageCodeSize.set(JITCompiler.this.codeSize.get() / JITCompiler.this.compiledCount.get());
            AtomicLong atomicLong = JITCompiler.this.largestCodeSize;
            synchronized (atomicLong) {
                if (JITCompiler.this.largestCodeSize.get() < (long)this.bytecode.length) {
                    JITCompiler.this.largestCodeSize.set(this.bytecode.length);
                }
            }
        }

        public byte[] bytecode() {
            this.compile();
            return this.bytecode;
        }

        public String name() {
            this.compile();
            return this.name;
        }

        public CallConfiguration callConfig() {
            this.compile();
            return this.jitCallConfig;
        }
    }
}

