/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.common;

import org.jruby.Ruby;
import org.jruby.common.IRubyWarnings;
import org.jruby.lexer.yacc.ISourcePosition;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

public class RubyWarnings
implements IRubyWarnings {
    private Ruby runtime;

    public RubyWarnings(Ruby ruby) {
        this.runtime = ruby;
    }

    public void warn(IRubyWarnings.ID iD, ISourcePosition iSourcePosition, String string, Object ... objectArray) {
        this.warn(iD, iSourcePosition.getFile(), iSourcePosition.getEndLine(), string, objectArray);
    }

    public void warn(IRubyWarnings.ID iD, String string, int n, String string2, Object ... objectArray) {
        if (this.runtime.getVerbose().isNil()) {
            return;
        }
        StringBuilder stringBuilder = new StringBuilder(100);
        stringBuilder.append(string).append(':').append(n + 1).append(' ');
        stringBuilder.append("warning: ").append(string2).append('\n');
        IRubyObject iRubyObject = this.runtime.getGlobalVariables().get("$stderr");
        iRubyObject.callMethod(this.runtime.getCurrentContext(), "write", this.runtime.newString(stringBuilder.toString()));
    }

    public boolean isVerbose() {
        return this.runtime.getVerbose().isTrue();
    }

    public void warn(IRubyWarnings.ID iD, String string, Object ... objectArray) {
        ThreadContext threadContext = this.runtime.getCurrentContext();
        this.warn(iD, threadContext.getFile(), threadContext.getLine(), string, objectArray);
    }

    public void warning(IRubyWarnings.ID iD, String string, Object ... objectArray) {
        ThreadContext threadContext = this.runtime.getCurrentContext();
        this.warning(iD, threadContext.getFile(), threadContext.getLine(), string, objectArray);
    }

    public void warning(IRubyWarnings.ID iD, ISourcePosition iSourcePosition, String string, Object ... objectArray) {
        this.warning(iD, iSourcePosition.getFile(), iSourcePosition.getEndLine(), string, objectArray);
    }

    public void warning(IRubyWarnings.ID iD, String string, int n, String string2, Object ... objectArray) {
        if (this.isVerbose()) {
            this.warn(iD, string, n, string2, objectArray);
        }
    }
}

