/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ast;

import java.util.List;
import org.jruby.Ruby;
import org.jruby.ast.Node;
import org.jruby.ast.NodeType;
import org.jruby.ast.visitor.NodeVisitor;
import org.jruby.evaluator.Instruction;
import org.jruby.lexer.yacc.ISourcePosition;
import org.jruby.runtime.Block;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WhenNode
extends Node {
    private final Node expressionNodes;
    private final Node bodyNode;
    private final Node nextCase;

    public WhenNode(ISourcePosition iSourcePosition, Node node, Node node2, Node node3) {
        super(iSourcePosition, NodeType.WHENNODE);
        this.expressionNodes = node;
        this.bodyNode = node2;
        this.nextCase = node3;
    }

    @Override
    public Instruction accept(NodeVisitor nodeVisitor) {
        return nodeVisitor.visitWhenNode(this);
    }

    public Node getBodyNode() {
        return this.bodyNode;
    }

    public Node getNextCase() {
        return this.nextCase;
    }

    public Node getExpressionNodes() {
        return this.expressionNodes;
    }

    @Override
    public List<Node> childNodes() {
        return Node.createList(this.expressionNodes, this.bodyNode, this.nextCase);
    }

    @Override
    public IRubyObject interpret(Ruby ruby, ThreadContext threadContext, IRubyObject iRubyObject, Block block) {
        if (this.bodyNode == null) {
            return ruby.getNil();
        }
        return this.bodyNode.interpret(ruby, threadContext, iRubyObject, block);
    }
}

