/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ast;

import java.util.List;
import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubySymbol;
import org.jruby.ast.Node;
import org.jruby.ast.NodeType;
import org.jruby.ast.visitor.NodeVisitor;
import org.jruby.evaluator.ASTInterpreter;
import org.jruby.evaluator.Instruction;
import org.jruby.lexer.yacc.ISourcePosition;
import org.jruby.parser.StaticScope;
import org.jruby.runtime.Block;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SClassNode
extends Node {
    private final Node receiverNode;
    private final StaticScope scope;
    private final Node bodyNode;

    public SClassNode(ISourcePosition iSourcePosition, Node node, StaticScope staticScope, Node node2) {
        super(iSourcePosition, NodeType.SCLASSNODE);
        assert (staticScope != null) : "scope is not null";
        assert (node != null) : "receiverNode is not null";
        this.receiverNode = node;
        this.scope = staticScope;
        this.bodyNode = node2;
    }

    @Override
    public Instruction accept(NodeVisitor nodeVisitor) {
        return nodeVisitor.visitSClassNode(this);
    }

    public Node getBodyNode() {
        return this.bodyNode;
    }

    public StaticScope getScope() {
        return this.scope;
    }

    public Node getReceiverNode() {
        return this.receiverNode;
    }

    @Override
    public List<Node> childNodes() {
        return Node.createList(this.receiverNode, this.bodyNode);
    }

    @Override
    public IRubyObject interpret(Ruby ruby, ThreadContext threadContext, IRubyObject iRubyObject, Block block) {
        IRubyObject iRubyObject2 = this.receiverNode.interpret(ruby, threadContext, iRubyObject, block);
        if (iRubyObject2 instanceof RubyFixnum || iRubyObject2 instanceof RubySymbol) {
            throw ruby.newTypeError("no virtual class for " + iRubyObject2.getMetaClass().getBaseName());
        }
        if (ruby.getSafeLevel() >= 4 && !iRubyObject2.isTaint()) {
            throw ruby.newSecurityError("Insecure: can't extend object.");
        }
        RubyClass rubyClass = iRubyObject2.getSingletonClass();
        this.scope.setModule(rubyClass);
        return ASTInterpreter.evalClassDefinitionBody(ruby, threadContext, this.scope, this.bodyNode, rubyClass, iRubyObject, block);
    }
}

