/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ast;

import java.util.List;
import org.jruby.Ruby;
import org.jruby.RubyException;
import org.jruby.ast.Node;
import org.jruby.ast.NodeType;
import org.jruby.ast.RescueBodyNode;
import org.jruby.ast.visitor.NodeVisitor;
import org.jruby.common.IRubyWarnings;
import org.jruby.evaluator.ASTInterpreter;
import org.jruby.evaluator.Instruction;
import org.jruby.exceptions.JumpException;
import org.jruby.exceptions.RaiseException;
import org.jruby.javasupport.util.RuntimeHelpers;
import org.jruby.lexer.yacc.ISourcePosition;
import org.jruby.runtime.Block;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RescueNode
extends Node {
    private final Node bodyNode;
    private final RescueBodyNode rescueNode;
    private final Node elseNode;

    public RescueNode(ISourcePosition iSourcePosition, Node node, RescueBodyNode rescueBodyNode, Node node2) {
        super(iSourcePosition, NodeType.RESCUENODE);
        this.bodyNode = node;
        this.rescueNode = rescueBodyNode;
        this.elseNode = node2;
    }

    @Override
    public Instruction accept(NodeVisitor nodeVisitor) {
        return nodeVisitor.visitRescueNode(this);
    }

    public Node getBodyNode() {
        return this.bodyNode;
    }

    public Node getElseNode() {
        return this.elseNode;
    }

    public RescueBodyNode getRescueNode() {
        return this.rescueNode;
    }

    @Override
    public List<Node> childNodes() {
        return Node.createList(this.rescueNode, this.bodyNode, this.elseNode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IRubyObject interpret(Ruby ruby, ThreadContext threadContext, IRubyObject iRubyObject, Block block) {
        while (true) {
            IRubyObject iRubyObject2 = ruby.getGlobalVariables().get("$!");
            boolean bl = false;
            try {
                IRubyObject iRubyObject3 = this.executeBody(ruby, threadContext, iRubyObject, block);
                return iRubyObject3;
            }
            catch (RaiseException raiseException) {
                try {
                    IRubyObject iRubyObject4 = this.handleException(ruby, threadContext, iRubyObject, block, raiseException);
                    return iRubyObject4;
                }
                catch (JumpException.RetryJump retryJump) {
                    continue;
                }
                catch (RaiseException raiseException2) {
                    bl = true;
                    throw raiseException2;
                }
            }
            finally {
                if (bl) continue;
                ruby.getGlobalVariables().set("$!", iRubyObject2);
                continue;
            }
            break;
        }
    }

    private IRubyObject handleException(Ruby ruby, ThreadContext threadContext, IRubyObject iRubyObject, Block block, RaiseException raiseException) {
        RubyException rubyException = raiseException.getException();
        ruby.getGlobalVariables().set("$!", rubyException);
        for (RescueBodyNode rescueBodyNode = this.rescueNode; rescueBodyNode != null; rescueBodyNode = rescueBodyNode.getOptRescueNode()) {
            IRubyObject[] iRubyObjectArray = this.getExceptions(rescueBodyNode, ruby, threadContext, iRubyObject, block);
            if (!RuntimeHelpers.isExceptionHandled(rubyException, iRubyObjectArray, ruby, threadContext, iRubyObject).isTrue()) continue;
            return rescueBodyNode.interpret(ruby, threadContext, iRubyObject, block);
        }
        throw raiseException;
    }

    private IRubyObject executeBody(Ruby ruby, ThreadContext threadContext, IRubyObject iRubyObject, Block block) {
        if (this.bodyNode == null) {
            return ruby.getNil();
        }
        IRubyObject iRubyObject2 = this.bodyNode.interpret(ruby, threadContext, iRubyObject, block);
        if (this.elseNode != null) {
            if (this.rescueNode == null) {
                ruby.getWarnings().warn(IRubyWarnings.ID.ELSE_WITHOUT_RESCUE, this.elseNode.getPosition(), "else without rescue is useless", new Object[0]);
            }
            iRubyObject2 = this.elseNode.interpret(ruby, threadContext, iRubyObject, block);
        }
        return iRubyObject2;
    }

    private IRubyObject[] getExceptions(RescueBodyNode rescueBodyNode, Ruby ruby, ThreadContext threadContext, IRubyObject iRubyObject, Block block) {
        Node node = rescueBodyNode.getExceptionNodes();
        IRubyObject[] iRubyObjectArray = node == null ? new IRubyObject[]{ruby.getStandardError()} : ASTInterpreter.setupArgs(ruby, threadContext, node, iRubyObject, block);
        return iRubyObjectArray;
    }
}

