/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ast;

import java.util.List;
import org.jruby.Ruby;
import org.jruby.ast.Node;
import org.jruby.ast.NodeType;
import org.jruby.ast.visitor.NodeVisitor;
import org.jruby.evaluator.ASTInterpreter;
import org.jruby.evaluator.Instruction;
import org.jruby.lexer.yacc.ISourcePosition;
import org.jruby.runtime.Block;
import org.jruby.runtime.CallSite;
import org.jruby.runtime.MethodIndex;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OpAsgnNode
extends Node {
    private final Node receiverNode;
    private final Node valueNode;
    public final CallSite variableCallAdapter;
    public final CallSite operatorCallAdapter;
    public final CallSite variableAsgnCallAdapter;

    public OpAsgnNode(ISourcePosition iSourcePosition, Node node, Node node2, String string, String string2) {
        super(iSourcePosition, NodeType.OPASGNNODE);
        assert (node != null) : "receiverNode is not null";
        assert (node2 != null) : "valueNode is not null";
        this.receiverNode = node;
        this.valueNode = node2;
        this.variableCallAdapter = MethodIndex.getCallSite(string);
        this.operatorCallAdapter = MethodIndex.getCallSite(string2);
        this.variableAsgnCallAdapter = MethodIndex.getCallSite((string + "=").intern());
    }

    @Override
    public Instruction accept(NodeVisitor nodeVisitor) {
        return nodeVisitor.visitOpAsgnNode(this);
    }

    public String getOperatorName() {
        return this.operatorCallAdapter.methodName;
    }

    public Node getReceiverNode() {
        return this.receiverNode;
    }

    public Node getValueNode() {
        return this.valueNode;
    }

    public String getVariableName() {
        return this.variableCallAdapter.methodName;
    }

    public String getVariableNameAsgn() {
        return this.variableAsgnCallAdapter.methodName;
    }

    @Override
    public List<Node> childNodes() {
        return Node.createList(this.receiverNode, this.valueNode);
    }

    @Override
    public IRubyObject interpret(Ruby ruby, ThreadContext threadContext, IRubyObject iRubyObject, Block block) {
        IRubyObject iRubyObject2 = this.receiverNode.interpret(ruby, threadContext, iRubyObject, block);
        IRubyObject iRubyObject3 = this.variableCallAdapter.call(threadContext, iRubyObject2);
        if (this.getOperatorName() == "||") {
            if (iRubyObject3.isTrue()) {
                return ASTInterpreter.pollAndReturn(threadContext, iRubyObject3);
            }
            iRubyObject3 = this.valueNode.interpret(ruby, threadContext, iRubyObject, block);
        } else if (this.getOperatorName() == "&&") {
            if (!iRubyObject3.isTrue()) {
                return ASTInterpreter.pollAndReturn(threadContext, iRubyObject3);
            }
            iRubyObject3 = this.valueNode.interpret(ruby, threadContext, iRubyObject, block);
        } else {
            iRubyObject3 = this.operatorCallAdapter.call(threadContext, iRubyObject3, this.valueNode.interpret(ruby, threadContext, iRubyObject, block));
        }
        this.variableAsgnCallAdapter.call(threadContext, iRubyObject2, iRubyObject3);
        return ASTInterpreter.pollAndReturn(threadContext, iRubyObject3);
    }
}

