/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ast;

import java.util.List;
import org.jruby.Ruby;
import org.jruby.ast.BinaryOperatorNode;
import org.jruby.ast.Node;
import org.jruby.ast.NodeType;
import org.jruby.ast.visitor.NodeVisitor;
import org.jruby.evaluator.ASTInterpreter;
import org.jruby.evaluator.Instruction;
import org.jruby.lexer.yacc.ISourcePosition;
import org.jruby.runtime.Block;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OpAsgnAndNode
extends Node
implements BinaryOperatorNode {
    private final Node firstNode;
    private final Node secondNode;

    public OpAsgnAndNode(ISourcePosition iSourcePosition, Node node, Node node2) {
        super(iSourcePosition, NodeType.OPASGNANDNODE);
        assert (node != null) : "headNode is not null";
        assert (node2 != null) : "valueNode is not null";
        this.firstNode = node;
        this.secondNode = node2;
    }

    @Override
    public Instruction accept(NodeVisitor nodeVisitor) {
        return nodeVisitor.visitOpAsgnAndNode(this);
    }

    @Override
    public Node getFirstNode() {
        return this.firstNode;
    }

    @Override
    public Node getSecondNode() {
        return this.secondNode;
    }

    @Override
    public List<Node> childNodes() {
        return Node.createList(this.firstNode, this.secondNode);
    }

    @Override
    public IRubyObject interpret(Ruby ruby, ThreadContext threadContext, IRubyObject iRubyObject, Block block) {
        IRubyObject iRubyObject2 = this.firstNode.interpret(ruby, threadContext, iRubyObject, block);
        if (!iRubyObject2.isTrue()) {
            return ASTInterpreter.pollAndReturn(threadContext, iRubyObject2);
        }
        return this.secondNode.interpret(ruby, threadContext, iRubyObject, block);
    }
}

