/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ast;

import java.util.List;
import org.jruby.Ruby;
import org.jruby.RubyRegexp;
import org.jruby.ast.Node;
import org.jruby.ast.NodeType;
import org.jruby.ast.visitor.NodeVisitor;
import org.jruby.evaluator.Instruction;
import org.jruby.lexer.yacc.ISourcePosition;
import org.jruby.runtime.Block;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Match2Node
extends Node {
    private final Node receiverNode;
    private final Node valueNode;

    public Match2Node(ISourcePosition iSourcePosition, Node node, Node node2) {
        super(iSourcePosition, NodeType.MATCH2NODE);
        assert (node != null) : "receiverNode is not null";
        assert (node2 != null) : "valueNode is not null";
        this.receiverNode = node;
        this.valueNode = node2;
    }

    @Override
    public Instruction accept(NodeVisitor nodeVisitor) {
        return nodeVisitor.visitMatch2Node(this);
    }

    public Node getReceiverNode() {
        return this.receiverNode;
    }

    public Node getValueNode() {
        return this.valueNode;
    }

    @Override
    public List<Node> childNodes() {
        return Node.createList(this.receiverNode, this.valueNode);
    }

    @Override
    public IRubyObject interpret(Ruby ruby, ThreadContext threadContext, IRubyObject iRubyObject, Block block) {
        IRubyObject iRubyObject2 = this.receiverNode.interpret(ruby, threadContext, iRubyObject, block);
        IRubyObject iRubyObject3 = this.valueNode.interpret(ruby, threadContext, iRubyObject, block);
        return ((RubyRegexp)iRubyObject2).op_match(threadContext, iRubyObject3);
    }

    @Override
    public String definition(Ruby ruby, ThreadContext threadContext, IRubyObject iRubyObject, Block block) {
        return "method";
    }
}

