/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ast;

import java.util.List;
import org.jruby.Ruby;
import org.jruby.ast.ArrayNode;
import org.jruby.ast.BlockAcceptingNode;
import org.jruby.ast.IArgumentNode;
import org.jruby.ast.IterNode;
import org.jruby.ast.Node;
import org.jruby.ast.NodeType;
import org.jruby.ast.types.INameNode;
import org.jruby.ast.visitor.NodeVisitor;
import org.jruby.evaluator.ASTInterpreter;
import org.jruby.evaluator.Instruction;
import org.jruby.javasupport.util.RuntimeHelpers;
import org.jruby.lexer.yacc.ISourcePosition;
import org.jruby.runtime.Block;
import org.jruby.runtime.CallSite;
import org.jruby.runtime.InterpretedBlock;
import org.jruby.runtime.MethodIndex;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FCallNode
extends Node
implements INameNode,
IArgumentNode,
BlockAcceptingNode {
    private Node argsNode;
    private Node iterNode;
    public CallSite callAdapter;

    public FCallNode(ISourcePosition iSourcePosition, String string, Node node) {
        this(iSourcePosition, string, node, null);
    }

    public FCallNode(ISourcePosition iSourcePosition, String string, Node node, Node node2) {
        super(iSourcePosition, NodeType.FCALLNODE);
        this.setArgsNode(node);
        this.iterNode = node2;
        this.callAdapter = MethodIndex.getFunctionalCallSite(string);
    }

    @Override
    public Instruction accept(NodeVisitor nodeVisitor) {
        return nodeVisitor.visitFCallNode(this);
    }

    @Override
    public Node getIterNode() {
        return this.iterNode;
    }

    @Override
    public Node setIterNode(Node node) {
        this.iterNode = node;
        this.callAdapter = MethodIndex.getFunctionalCallSite(this.callAdapter.methodName);
        return this;
    }

    @Override
    public Node getArgsNode() {
        return this.argsNode;
    }

    @Override
    public Node setArgsNode(Node node) {
        this.argsNode = node;
        if (node instanceof ArrayNode) {
            ((ArrayNode)node).setLightweight(true);
        }
        return node;
    }

    @Override
    public String getName() {
        return this.callAdapter.methodName;
    }

    @Override
    public List<Node> childNodes() {
        return FCallNode.createList(this.argsNode, this.iterNode);
    }

    @Override
    public String toString() {
        return "FCallNode: " + this.getName();
    }

    @Override
    public IRubyObject interpret(Ruby ruby, ThreadContext threadContext, IRubyObject iRubyObject, Block block) {
        IRubyObject[] iRubyObjectArray = ASTInterpreter.setupArgs(ruby, threadContext, this.argsNode, iRubyObject, block);
        Block block2 = ASTInterpreter.getBlock(ruby, threadContext, iRubyObject, block, this.iterNode);
        if (!block2.isGiven()) {
            return this.callAdapter.call(threadContext, iRubyObject, iRubyObjectArray);
        }
        return this.iterNode instanceof IterNode ? this.callAdapter.callIter(threadContext, iRubyObject, iRubyObjectArray, block2) : this.callAdapter.call(threadContext, iRubyObject, iRubyObjectArray, block2);
    }

    public Block getBlock(ThreadContext threadContext, IRubyObject iRubyObject) {
        IterNode iterNode = (IterNode)this.iterNode;
        iterNode.getScope().determineModule();
        return InterpretedBlock.newInterpretedClosure(threadContext, iterNode.getBlockBody(), iRubyObject);
    }

    public Block getBlock(Ruby ruby, ThreadContext threadContext, IRubyObject iRubyObject, Block block) {
        return RuntimeHelpers.getBlockFromBlockPassBody(ruby, this.iterNode.interpret(ruby, threadContext, iRubyObject, block), block);
    }

    @Override
    public String definition(Ruby ruby, ThreadContext threadContext, IRubyObject iRubyObject, Block block) {
        if (iRubyObject.getMetaClass().isMethodBound(this.getName(), false)) {
            return ASTInterpreter.getArgumentDefinition(ruby, threadContext, this.getArgsNode(), "method", iRubyObject, block);
        }
        return null;
    }
}

