/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ast;

import java.util.List;
import org.jruby.Ruby;
import org.jruby.ast.AssignableNode;
import org.jruby.ast.Node;
import org.jruby.ast.NodeType;
import org.jruby.ast.types.INameNode;
import org.jruby.ast.visitor.NodeVisitor;
import org.jruby.evaluator.Instruction;
import org.jruby.lexer.yacc.ISourcePosition;
import org.jruby.runtime.Block;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DAsgnNode
extends AssignableNode
implements INameNode {
    private String name;
    private int location;

    public DAsgnNode(ISourcePosition iSourcePosition, String string, int n, Node node) {
        super(iSourcePosition, NodeType.DASGNNODE, node);
        this.name = string;
        this.location = n;
    }

    @Override
    public Instruction accept(NodeVisitor nodeVisitor) {
        return nodeVisitor.visitDAsgnNode(this);
    }

    @Override
    public String getName() {
        return this.name;
    }

    public int getDepth() {
        return this.location >> 16;
    }

    public int getIndex() {
        return this.location & 0xFFFF;
    }

    @Override
    public List<Node> childNodes() {
        return DAsgnNode.createList(this.getValueNode());
    }

    public void setName(String string) {
        this.name = string;
    }

    @Override
    public IRubyObject interpret(Ruby ruby, ThreadContext threadContext, IRubyObject iRubyObject, Block block) {
        return threadContext.getCurrentScope().setValue(this.getIndex(), this.getValueNode().interpret(ruby, threadContext, iRubyObject, block), this.getDepth());
    }

    @Override
    public IRubyObject assign(Ruby ruby, ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2, Block block, boolean bl) {
        threadContext.getCurrentScope().setValue(this.getIndex(), iRubyObject2, this.getDepth());
        return ruby.getNil();
    }
}

