/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ast;

import java.util.List;
import org.jruby.Ruby;
import org.jruby.ast.AssignableNode;
import org.jruby.ast.Colon2Node;
import org.jruby.ast.Node;
import org.jruby.ast.NodeType;
import org.jruby.ast.types.INameNode;
import org.jruby.ast.visitor.NodeVisitor;
import org.jruby.evaluator.Instruction;
import org.jruby.lexer.yacc.ISourcePosition;
import org.jruby.runtime.Block;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConstDeclNode
extends AssignableNode
implements INameNode {
    private final String name;
    private final INameNode constNode;

    public ConstDeclNode(ISourcePosition iSourcePosition, String string, INameNode iNameNode, Node node) {
        super(iSourcePosition, NodeType.CONSTDECLNODE, node);
        this.name = string;
        this.constNode = iNameNode;
    }

    @Override
    public Instruction accept(NodeVisitor nodeVisitor) {
        return nodeVisitor.visitConstDeclNode(this);
    }

    @Override
    public String getName() {
        return this.name == null ? this.constNode.getName() : this.name;
    }

    public Node getConstNode() {
        return (Node)((Object)this.constNode);
    }

    @Override
    public List<Node> childNodes() {
        return ConstDeclNode.createList(this.getValueNode());
    }

    @Override
    public IRubyObject interpret(Ruby ruby, ThreadContext threadContext, IRubyObject iRubyObject, Block block) {
        IRubyObject iRubyObject2 = this.getValueNode().interpret(ruby, threadContext, iRubyObject, block);
        if (this.constNode == null) {
            return threadContext.setConstantInCurrent(this.name, iRubyObject2);
        }
        if (((Node)((Object)this.constNode)).nodeId == NodeType.COLON2NODE) {
            Node node = ((Colon2Node)this.constNode).getLeftNode();
            assert (node != null) : "leftNode is not null";
            IRubyObject iRubyObject3 = node.interpret(ruby, threadContext, iRubyObject, block);
            return threadContext.setConstantInModule(this.constNode.getName(), iRubyObject3, iRubyObject2);
        }
        return threadContext.setConstantInObject(this.constNode.getName(), iRubyObject2);
    }

    @Override
    public IRubyObject assign(Ruby ruby, ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2, Block block, boolean bl) {
        IRubyObject iRubyObject3;
        if (this.constNode == null) {
            iRubyObject3 = threadContext.getCurrentScope().getStaticScope().getModule();
            if (iRubyObject3 == null) {
                throw ruby.newTypeError("no class/module to define constant");
            }
        } else {
            Node node;
            iRubyObject3 = this.constNode instanceof Colon2Node ? ((node = ((Colon2Node)this.constNode).getLeftNode()) == null ? ruby.getNil() : node.interpret(ruby, threadContext, iRubyObject, block)) : ruby.getObject();
        }
        iRubyObject3.fastSetConstant(this.getName(), iRubyObject2);
        return ruby.getNil();
    }
}

