/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ast;

import java.util.List;
import org.jruby.Ruby;
import org.jruby.RubyModule;
import org.jruby.ast.Colon3Node;
import org.jruby.ast.Node;
import org.jruby.ast.NodeType;
import org.jruby.ast.types.INameNode;
import org.jruby.ast.visitor.NodeVisitor;
import org.jruby.evaluator.Instruction;
import org.jruby.exceptions.JumpException;
import org.jruby.javasupport.util.RuntimeHelpers;
import org.jruby.lexer.yacc.ISourcePosition;
import org.jruby.runtime.Block;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.IdUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Colon2Node
extends Colon3Node
implements INameNode {
    private final Node leftNode;

    public Colon2Node(ISourcePosition iSourcePosition, Node node, String string) {
        super(iSourcePosition, NodeType.COLON2NODE, string);
        this.leftNode = node;
    }

    @Override
    public Instruction accept(NodeVisitor nodeVisitor) {
        return nodeVisitor.visitColon2Node(this);
    }

    public Node getLeftNode() {
        return this.leftNode;
    }

    @Override
    public List<Node> childNodes() {
        return Node.createList(this.leftNode);
    }

    @Override
    public String toString() {
        String string = "Colon2Node [";
        if (this.leftNode != null) {
            string = string + this.leftNode;
        }
        string = string + this.getName();
        return string + "]";
    }

    @Override
    public RubyModule getEnclosingModule(Ruby ruby, ThreadContext threadContext, IRubyObject iRubyObject, Block block) {
        if (this.leftNode != null) {
            IRubyObject iRubyObject2 = this.leftNode.interpret(ruby, threadContext, iRubyObject, block);
            return RuntimeHelpers.prepareClassNamespace(threadContext, iRubyObject2);
        }
        return threadContext.getCurrentScope().getStaticScope().getModule();
    }

    @Override
    public IRubyObject interpret(Ruby ruby, ThreadContext threadContext, IRubyObject iRubyObject, Block block) {
        if (this.leftNode == null) {
            return ruby.getObject().fastGetConstantFrom(this.name);
        }
        IRubyObject iRubyObject2 = this.leftNode.interpret(ruby, threadContext, iRubyObject, block);
        if (IdUtil.isConstant(this.name)) {
            if (iRubyObject2 instanceof RubyModule) {
                return ((RubyModule)iRubyObject2).fastGetConstantFrom(this.name);
            }
            throw ruby.newTypeError(iRubyObject2 + " is not a class/module");
        }
        return iRubyObject2.callMethod(threadContext, this.name, IRubyObject.NULL_ARRAY, block);
    }

    @Override
    public String definition(Ruby ruby, ThreadContext threadContext, IRubyObject iRubyObject, Block block) {
        try {
            IRubyObject iRubyObject2 = this.leftNode.interpret(ruby, threadContext, iRubyObject, block);
            if (iRubyObject2 instanceof RubyModule && ((RubyModule)iRubyObject2).fastGetConstantAt(this.name) != null) {
                return "constant";
            }
            if (iRubyObject2.getMetaClass().isMethodBound(this.name, true)) {
                return "method";
            }
        }
        catch (JumpException jumpException) {
            // empty catch block
        }
        return null;
    }
}

