/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ast;

import java.util.List;
import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyModule;
import org.jruby.ast.Colon3Node;
import org.jruby.ast.IScopingNode;
import org.jruby.ast.Node;
import org.jruby.ast.NodeType;
import org.jruby.ast.visitor.NodeVisitor;
import org.jruby.evaluator.ASTInterpreter;
import org.jruby.evaluator.Instruction;
import org.jruby.lexer.yacc.ISourcePosition;
import org.jruby.parser.StaticScope;
import org.jruby.runtime.Block;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassNode
extends Node
implements IScopingNode {
    private final Colon3Node cpath;
    private final StaticScope scope;
    private final Node bodyNode;
    private final Node superNode;

    public ClassNode(ISourcePosition iSourcePosition, Colon3Node colon3Node, StaticScope staticScope, Node node, Node node2) {
        super(iSourcePosition, NodeType.CLASSNODE);
        assert (colon3Node != null) : "cpath is not null";
        assert (staticScope != null) : "scope is not null";
        assert (node != null) : "bodyNode is not null";
        this.cpath = colon3Node;
        this.scope = staticScope;
        this.bodyNode = node;
        this.superNode = node2;
    }

    @Override
    public Instruction accept(NodeVisitor nodeVisitor) {
        return nodeVisitor.visitClassNode(this);
    }

    public Node getBodyNode() {
        return this.bodyNode;
    }

    public StaticScope getScope() {
        return this.scope;
    }

    @Override
    public Colon3Node getCPath() {
        return this.cpath;
    }

    public Node getSuperNode() {
        return this.superNode;
    }

    @Override
    public List<Node> childNodes() {
        return Node.createList(this.cpath, this.bodyNode, this.superNode);
    }

    @Override
    public String toString() {
        return "ClassNode [" + this.cpath + "]";
    }

    @Override
    public IRubyObject interpret(Ruby ruby, ThreadContext threadContext, IRubyObject iRubyObject, Block block) {
        IRubyObject iRubyObject2;
        RubyModule rubyModule = this.cpath.getEnclosingModule(ruby, threadContext, iRubyObject, block);
        if (rubyModule == null) {
            throw ruby.newTypeError("no outer class/module");
        }
        IRubyObject iRubyObject3 = null;
        if (this.superNode != null) {
            iRubyObject2 = this.superNode.interpret(ruby, threadContext, iRubyObject, block);
            RubyClass.checkInheritable(iRubyObject2);
            iRubyObject3 = iRubyObject2;
        }
        iRubyObject2 = rubyModule.defineOrGetClassUnder(this.cpath.getName(), (RubyClass)iRubyObject3);
        this.scope.setModule((RubyModule)iRubyObject2);
        return ASTInterpreter.evalClassDefinitionBody(ruby, threadContext, this.scope, this.bodyNode, iRubyObject2, iRubyObject, block);
    }
}

