/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ast;

import java.util.List;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.ast.ArrayNode;
import org.jruby.ast.Node;
import org.jruby.ast.NodeType;
import org.jruby.ast.WhenNode;
import org.jruby.ast.visitor.NodeVisitor;
import org.jruby.evaluator.ASTInterpreter;
import org.jruby.evaluator.Instruction;
import org.jruby.javasupport.util.RuntimeHelpers;
import org.jruby.lexer.yacc.ISourcePosition;
import org.jruby.runtime.Block;
import org.jruby.runtime.MethodIndex;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CaseNode
extends Node {
    private final Node caseNode;
    private final Node caseBody;

    public CaseNode(ISourcePosition iSourcePosition, Node node, Node node2) {
        super(iSourcePosition, NodeType.CASENODE);
        assert (node2 != null) : "caseBody is not null";
        this.caseNode = node;
        this.caseBody = node2;
    }

    @Override
    public Instruction accept(NodeVisitor nodeVisitor) {
        return nodeVisitor.visitCaseNode(this);
    }

    public Node getCaseNode() {
        return this.caseNode;
    }

    public Node getFirstWhenNode() {
        return this.caseBody;
    }

    @Override
    public List<Node> childNodes() {
        return Node.createList(this.caseNode, this.caseBody);
    }

    @Override
    public IRubyObject interpret(Ruby ruby, ThreadContext threadContext, IRubyObject iRubyObject, Block block) {
        IRubyObject iRubyObject2 = null;
        if (this.caseNode != null) {
            iRubyObject2 = this.caseNode.interpret(ruby, threadContext, iRubyObject, block);
        }
        threadContext.pollThreadEvents();
        IRubyObject iRubyObject3 = ruby.getNil();
        Node node = this.caseBody;
        while (node != null) {
            if (!(node instanceof WhenNode)) {
                return node.interpret(ruby, threadContext, iRubyObject, block);
            }
            WhenNode whenNode = (WhenNode)node;
            if (whenNode.getExpressionNodes() instanceof ArrayNode) {
                ArrayNode arrayNode = (ArrayNode)whenNode.getExpressionNodes();
                threadContext.setFile(arrayNode.getPosition().getFile());
                for (int i = 0; i < arrayNode.size(); ++i) {
                    Node node2 = arrayNode.get(i);
                    threadContext.setLine(node2.getPosition().getStartLine());
                    if (ruby.hasEventHooks()) {
                        ASTInterpreter.callTraceFunction(ruby, threadContext, 0);
                    }
                    if (node2 instanceof WhenNode) {
                        IRubyObject iRubyObject4 = ((WhenNode)node2).getExpressionNodes().interpret(ruby, threadContext, iRubyObject, block);
                        RubyArray rubyArray = RuntimeHelpers.splatValue(iRubyObject4);
                        int n = rubyArray.getLength();
                        for (int j = 0; j < n; ++j) {
                            IRubyObject iRubyObject5 = rubyArray.eltInternal(j);
                            if ((iRubyObject2 == null || !iRubyObject5.callMethod(threadContext, MethodIndex.OP_EQQ, "===", iRubyObject2).isTrue()) && (iRubyObject2 != null || !iRubyObject5.isTrue())) continue;
                            return node.interpret(ruby, threadContext, iRubyObject, block);
                        }
                        continue;
                    }
                    iRubyObject3 = node2.interpret(ruby, threadContext, iRubyObject, block);
                    if ((iRubyObject2 == null || !iRubyObject3.callMethod(threadContext, MethodIndex.OP_EQQ, "===", iRubyObject2).isTrue()) && (iRubyObject2 != null || !iRubyObject3.isTrue())) continue;
                    return whenNode.interpret(ruby, threadContext, iRubyObject, block);
                }
            } else {
                iRubyObject3 = whenNode.getExpressionNodes().interpret(ruby, threadContext, iRubyObject, block);
                if (iRubyObject2 != null && iRubyObject3.callMethod(threadContext, MethodIndex.OP_EQQ, "===", iRubyObject2).isTrue() || iRubyObject2 == null && iRubyObject3.isTrue()) {
                    return node.interpret(ruby, threadContext, iRubyObject, block);
                }
            }
            threadContext.pollThreadEvents();
            node = whenNode.getNextCase();
        }
        return ruby.getNil();
    }
}

