/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ast;

import org.jruby.Ruby;
import org.jruby.ast.ListNode;
import org.jruby.ast.Node;
import org.jruby.ast.NodeType;
import org.jruby.ast.types.ILiteralNode;
import org.jruby.ast.visitor.NodeVisitor;
import org.jruby.evaluator.Instruction;
import org.jruby.lexer.yacc.ISourcePosition;
import org.jruby.runtime.Block;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

public class ArrayNode
extends ListNode
implements ILiteralNode {
    private boolean lightweight = false;

    public ArrayNode(ISourcePosition iSourcePosition, Node node) {
        super(iSourcePosition, NodeType.ARRAYNODE, node);
        assert (node != null) : "ArrayNode.first == null";
    }

    public ArrayNode(ISourcePosition iSourcePosition) {
        super(iSourcePosition, NodeType.ARRAYNODE);
    }

    public Instruction accept(NodeVisitor nodeVisitor) {
        return nodeVisitor.visitArrayNode(this);
    }

    public void setLightweight(boolean bl) {
        this.lightweight = bl;
    }

    public boolean isLightweight() {
        return this.lightweight;
    }

    public IRubyObject interpret(Ruby ruby, ThreadContext threadContext, IRubyObject iRubyObject, Block block) {
        int n = this.size();
        IRubyObject[] iRubyObjectArray = new IRubyObject[n];
        for (int i = 0; i < n; ++i) {
            iRubyObjectArray[i] = this.get(i).interpret(ruby, threadContext, iRubyObject, block);
        }
        if (this.lightweight) {
            return ruby.newArrayNoCopyLight(iRubyObjectArray);
        }
        return ruby.newArrayNoCopy(iRubyObjectArray);
    }
}

