/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import java.lang.ref.SoftReference;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.IllegalFieldValueException;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyComparable;
import org.jruby.RubyFixnum;
import org.jruby.RubyFloat;
import org.jruby.RubyHash;
import org.jruby.RubyInteger;
import org.jruby.RubyNumeric;
import org.jruby.RubyObject;
import org.jruby.RubyString;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.runtime.Block;
import org.jruby.runtime.MethodIndex;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ByteList;
import org.jruby.util.RubyDateFormat;

@JRubyClass(name={"Time"}, include={"Comparable"})
public class RubyTime
extends RubyObject {
    public static final String UTC = "UTC";
    private DateTime dt;
    private long usec;
    private static final DateTimeFormatter ONE_DAY_CTIME_FORMATTER = DateTimeFormat.forPattern((String)"EEE MMM  d HH:mm:ss yyyy").withLocale(Locale.ENGLISH);
    private static final DateTimeFormatter TWO_DAY_CTIME_FORMATTER = DateTimeFormat.forPattern((String)"EEE MMM dd HH:mm:ss yyyy").withLocale(Locale.ENGLISH);
    private static final DateTimeFormatter TO_S_FORMATTER = DateTimeFormat.forPattern((String)"EEE MMM dd HH:mm:ss Z yyyy").withLocale(Locale.ENGLISH);
    private static final DateTimeFormatter TO_S_UTC_FORMATTER = DateTimeFormat.forPattern((String)"EEE MMM dd HH:mm:ss 'UTC' yyyy").withLocale(Locale.ENGLISH);
    private static final Pattern TZ_PATTERN = Pattern.compile("(\\D+?)([\\+-]?)(\\d+)(:\\d+)?(:\\d+)?");
    private static final ByteList TZ_STRING = ByteList.create((CharSequence)"TZ");
    private static SoftReference<Map<String, DateTimeZone>> LOCAL_ZONES_CACHE = new SoftReference(new HashMap());
    private static final long BASE_TIME_MILLIS = System.currentTimeMillis();
    private static final long BASE_TIME_NANOS = System.nanoTime();
    private static ObjectAllocator TIME_ALLOCATOR = new ObjectAllocator(){

        public IRubyObject allocate(Ruby ruby, RubyClass rubyClass) {
            long l = (System.nanoTime() - BASE_TIME_NANOS) / 1000L;
            long l2 = BASE_TIME_MILLIS + l / 1000L;
            long l3 = l % 1000L;
            DateTimeZone dateTimeZone = RubyTime.getLocalTimeZone(ruby);
            DateTime dateTime = new DateTime(l2, dateTimeZone);
            RubyTime rubyTime = new RubyTime(ruby, rubyClass, dateTime);
            rubyTime.setUSec(l3);
            return rubyTime;
        }
    };
    private static final String[] MONTHS = new String[]{"jan", "feb", "mar", "apr", "may", "jun", "jul", "aug", "sep", "oct", "nov", "dec"};
    private static final Map<String, Integer> MONTHS_MAP = new HashMap<String, Integer>();
    private static final int[] time_min;
    private static final int[] time_max;
    private static final int ARG_SIZE = 7;

    public static DateTimeZone getLocalTimeZone(Ruby ruby) {
        String string;
        Object object;
        RubyString rubyString = ruby.newString(TZ_STRING);
        RubyHash rubyHash = (RubyHash)ruby.getObject().fastGetConstant("ENV");
        IRubyObject iRubyObject = rubyHash.op_aref(ruby.getCurrentContext(), rubyString);
        if (iRubyObject == null || !(iRubyObject instanceof RubyString)) {
            return DateTimeZone.getDefault();
        }
        String string2 = iRubyObject.toString();
        Map<String, DateTimeZone> map = LOCAL_ZONES_CACHE.get();
        if (map != null) {
            object = map.get(string2);
            if (object != null) {
                return object;
            }
        } else {
            map = new HashMap<String, DateTimeZone>();
            LOCAL_ZONES_CACHE = new SoftReference<Map<String, DateTimeZone>>(map);
        }
        object = string2;
        Matcher matcher = TZ_PATTERN.matcher(string2);
        if (matcher.matches()) {
            string = matcher.group(2);
            String string3 = matcher.group(3);
            String string4 = matcher.group(4);
            if (("00".equals(string3) || "0".equals(string3)) && (string4 == null || ":00".equals(string4) || ":0".equals(string4))) {
                string2 = "Etc/GMT";
            } else {
                string = "-".equals(string) ? "+" : "-";
                string2 = "GMT" + string + string3;
                if (string4 != null) {
                    string2 = string2 + string4;
                }
            }
        }
        if ("GMT".equalsIgnoreCase(string2) || UTC.equalsIgnoreCase(string2)) {
            string2 = "Etc/" + string2;
        }
        string = DateTimeZone.forTimeZone((TimeZone)TimeZone.getTimeZone(string2));
        map.put((String)object, (DateTimeZone)string);
        return string;
    }

    public RubyTime(Ruby ruby, RubyClass rubyClass) {
        super(ruby, rubyClass);
    }

    public RubyTime(Ruby ruby, RubyClass rubyClass, DateTime dateTime) {
        super(ruby, rubyClass);
        this.dt = dateTime;
    }

    public static RubyClass createTimeClass(Ruby ruby) {
        RubyClass rubyClass = ruby.defineClass("Time", ruby.getObject(), TIME_ALLOCATOR);
        rubyClass.index = 19;
        ruby.setTime(rubyClass);
        rubyClass.includeModule(ruby.getComparable());
        rubyClass.defineAnnotatedMethods(RubyTime.class);
        return rubyClass;
    }

    public void setUSec(long l) {
        this.usec = l;
    }

    public long getUSec() {
        return this.usec;
    }

    public void updateCal(DateTime dateTime) {
        this.dt = dateTime;
    }

    protected long getTimeInMillis() {
        return this.dt.getMillis();
    }

    public static RubyTime newTime(Ruby ruby, long l) {
        return RubyTime.newTime(ruby, new DateTime(l));
    }

    public static RubyTime newTime(Ruby ruby, DateTime dateTime) {
        return new RubyTime(ruby, ruby.getTime(), dateTime);
    }

    public static RubyTime newTime(Ruby ruby, DateTime dateTime, long l) {
        RubyTime rubyTime = new RubyTime(ruby, ruby.getTime(), dateTime);
        rubyTime.setUSec(l);
        return rubyTime;
    }

    @JRubyMethod(name={"initialize_copy"}, required=1)
    public IRubyObject initialize_copy(IRubyObject iRubyObject) {
        if (!(iRubyObject instanceof RubyTime)) {
            throw this.getRuntime().newTypeError("Expecting an instance of class Time");
        }
        RubyTime rubyTime = (RubyTime)iRubyObject;
        this.dt = rubyTime.dt;
        this.usec = rubyTime.usec;
        return this;
    }

    @JRubyMethod(name={"succ"})
    public RubyTime succ() {
        return RubyTime.newTime(this.getRuntime(), this.dt.plusSeconds(1));
    }

    @JRubyMethod(name={"gmtime", "utc"})
    public RubyTime gmtime() {
        this.dt = this.dt.withZone(DateTimeZone.UTC);
        return this;
    }

    @JRubyMethod(name={"localtime"})
    public RubyTime localtime() {
        this.dt = this.dt.withZone(RubyTime.getLocalTimeZone(this.getRuntime()));
        return this;
    }

    @JRubyMethod(name={"gmt?", "utc?", "gmtime?"})
    public RubyBoolean gmt() {
        return this.getRuntime().newBoolean(this.dt.getZone().getID().equals(UTC));
    }

    @JRubyMethod(name={"getgm", "getutc"})
    public RubyTime getgm() {
        return RubyTime.newTime(this.getRuntime(), this.dt.withZone(DateTimeZone.UTC), this.getUSec());
    }

    @JRubyMethod(name={"getlocal"})
    public RubyTime getlocal() {
        return RubyTime.newTime(this.getRuntime(), this.dt.withZone(RubyTime.getLocalTimeZone(this.getRuntime())), this.getUSec());
    }

    @JRubyMethod(name={"strftime"}, required=1)
    public RubyString strftime(IRubyObject iRubyObject) {
        RubyDateFormat rubyDateFormat = new RubyDateFormat("-", Locale.US);
        rubyDateFormat.applyPattern(iRubyObject.toString());
        rubyDateFormat.setDateTime(this.dt);
        String string = rubyDateFormat.format(null);
        return this.getRuntime().newString(string);
    }

    @JRubyMethod(name={">="}, required=1)
    public IRubyObject op_ge(ThreadContext threadContext, IRubyObject iRubyObject) {
        if (iRubyObject instanceof RubyTime) {
            return this.getRuntime().newBoolean(this.cmp((RubyTime)iRubyObject) >= 0);
        }
        return RubyComparable.op_ge(threadContext, this, iRubyObject);
    }

    @JRubyMethod(name={">"}, required=1)
    public IRubyObject op_gt(ThreadContext threadContext, IRubyObject iRubyObject) {
        if (iRubyObject instanceof RubyTime) {
            return this.getRuntime().newBoolean(this.cmp((RubyTime)iRubyObject) > 0);
        }
        return RubyComparable.op_gt(threadContext, this, iRubyObject);
    }

    @JRubyMethod(name={"<="}, required=1)
    public IRubyObject op_le(ThreadContext threadContext, IRubyObject iRubyObject) {
        if (iRubyObject instanceof RubyTime) {
            return this.getRuntime().newBoolean(this.cmp((RubyTime)iRubyObject) <= 0);
        }
        return RubyComparable.op_le(threadContext, this, iRubyObject);
    }

    @JRubyMethod(name={"<"}, required=1)
    public IRubyObject op_lt(ThreadContext threadContext, IRubyObject iRubyObject) {
        if (iRubyObject instanceof RubyTime) {
            return this.getRuntime().newBoolean(this.cmp((RubyTime)iRubyObject) < 0);
        }
        return RubyComparable.op_lt(threadContext, this, iRubyObject);
    }

    private int cmp(RubyTime rubyTime) {
        long l = this.getTimeInMillis();
        long l2 = rubyTime.getTimeInMillis();
        long l3 = rubyTime.usec;
        if (l > l2 || l == l2 && this.usec > l3) {
            return 1;
        }
        if (l < l2 || l == l2 && this.usec < l3) {
            return -1;
        }
        return 0;
    }

    @JRubyMethod(name={"+"}, required=1)
    public IRubyObject op_plus(IRubyObject iRubyObject) {
        long l = this.getTimeInMillis();
        if (iRubyObject instanceof RubyTime) {
            throw this.getRuntime().newTypeError("time + time ?");
        }
        long l2 = (long)(RubyNumeric.num2dbl(iRubyObject) * 1000000.0);
        int n = (int)(l2 % 1000L);
        RubyTime rubyTime = new RubyTime(this.getRuntime(), this.getMetaClass());
        rubyTime.dt = new DateTime(l += (l2 /= 1000L)).withZone(this.dt.getZone());
        rubyTime.setUSec(n);
        return rubyTime;
    }

    @JRubyMethod(name={"-"}, required=1)
    public IRubyObject op_minus(IRubyObject iRubyObject) {
        long l = this.getTimeInMillis();
        if (iRubyObject instanceof RubyTime) {
            return RubyFloat.newFloat(this.getRuntime(), (double)(l -= ((RubyTime)iRubyObject).getTimeInMillis()) * 0.001);
        }
        long l2 = (long)(RubyNumeric.num2dbl(iRubyObject) * 1000000.0);
        int n = (int)(l2 % 1000L);
        RubyTime rubyTime = new RubyTime(this.getRuntime(), this.getMetaClass());
        rubyTime.dt = new DateTime(l -= (l2 /= 1000L)).withZone(this.dt.getZone());
        rubyTime.setUSec(n);
        return rubyTime;
    }

    @JRubyMethod(name={"==="}, required=1)
    public IRubyObject op_eqq(ThreadContext threadContext, IRubyObject iRubyObject) {
        return RubyNumeric.fix2int(this.callMethod(threadContext, MethodIndex.OP_SPACESHIP, "<=>", iRubyObject)) == 0 ? this.getRuntime().getTrue() : this.getRuntime().getFalse();
    }

    @JRubyMethod(name={"<=>"}, required=1)
    public IRubyObject op_cmp(IRubyObject iRubyObject) {
        if (iRubyObject.isNil()) {
            return iRubyObject;
        }
        if (iRubyObject instanceof RubyTime) {
            return this.getRuntime().newFixnum(this.cmp((RubyTime)iRubyObject));
        }
        return this.getRuntime().getNil();
    }

    @JRubyMethod(name={"eql?"}, required=1)
    public IRubyObject eql_p(IRubyObject iRubyObject) {
        if (iRubyObject instanceof RubyTime) {
            RubyTime rubyTime = (RubyTime)iRubyObject;
            return this.usec == rubyTime.usec && this.getTimeInMillis() == rubyTime.getTimeInMillis() ? this.getRuntime().getTrue() : this.getRuntime().getFalse();
        }
        return this.getRuntime().getFalse();
    }

    @JRubyMethod(name={"asctime", "ctime"})
    public RubyString asctime() {
        DateTimeFormatter dateTimeFormatter = this.dt.getDayOfMonth() < 10 ? ONE_DAY_CTIME_FORMATTER : TWO_DAY_CTIME_FORMATTER;
        String string = dateTimeFormatter.print((ReadableInstant)this.dt);
        return this.getRuntime().newString(string);
    }

    @JRubyMethod(name={"to_s", "inspect"})
    public IRubyObject to_s() {
        DateTimeFormatter dateTimeFormatter = this.dt.getZone() == DateTimeZone.UTC ? TO_S_UTC_FORMATTER : TO_S_FORMATTER;
        String string = dateTimeFormatter.print((ReadableInstant)this.dt);
        return this.getRuntime().newString(string);
    }

    @JRubyMethod(name={"to_a"})
    public RubyArray to_a() {
        return this.getRuntime().newArrayNoCopy(new IRubyObject[]{this.sec(), this.min(), this.hour(), this.mday(), this.month(), this.year(), this.wday(), this.yday(), this.isdst(), this.zone()});
    }

    @JRubyMethod(name={"to_f"})
    public RubyFloat to_f() {
        long l = this.getTimeInMillis();
        l = l * 1000L + this.usec;
        return RubyFloat.newFloat(this.getRuntime(), (double)l / 1000000.0);
    }

    @JRubyMethod(name={"to_i", "tv_sec"})
    public RubyInteger to_i() {
        return this.getRuntime().newFixnum(this.getTimeInMillis() / 1000L);
    }

    @JRubyMethod(name={"usec", "tv_usec"})
    public RubyInteger usec() {
        return this.getRuntime().newFixnum((long)(this.dt.getMillisOfSecond() * 1000) + this.getUSec());
    }

    public void setMicroseconds(long l) {
        long l2 = this.getTimeInMillis() % 1000L;
        long l3 = this.getTimeInMillis() - l2;
        this.dt = this.dt.withMillis(l3 += l / 1000L);
        this.usec = l % 1000L;
    }

    public long microseconds() {
        return this.getTimeInMillis() % 1000L * 1000L + this.usec;
    }

    @JRubyMethod(name={"sec"})
    public RubyInteger sec() {
        return this.getRuntime().newFixnum(this.dt.getSecondOfMinute());
    }

    @JRubyMethod(name={"min"})
    public RubyInteger min() {
        return this.getRuntime().newFixnum(this.dt.getMinuteOfHour());
    }

    @JRubyMethod(name={"hour"})
    public RubyInteger hour() {
        return this.getRuntime().newFixnum(this.dt.getHourOfDay());
    }

    @JRubyMethod(name={"mday", "day"})
    public RubyInteger mday() {
        return this.getRuntime().newFixnum(this.dt.getDayOfMonth());
    }

    @JRubyMethod(name={"month", "mon"})
    public RubyInteger month() {
        return this.getRuntime().newFixnum(this.dt.getMonthOfYear());
    }

    @JRubyMethod(name={"year"})
    public RubyInteger year() {
        return this.getRuntime().newFixnum(this.dt.getYear());
    }

    @JRubyMethod(name={"wday"})
    public RubyInteger wday() {
        return this.getRuntime().newFixnum(this.dt.getDayOfWeek() % 7);
    }

    @JRubyMethod(name={"yday"})
    public RubyInteger yday() {
        return this.getRuntime().newFixnum(this.dt.getDayOfYear());
    }

    @JRubyMethod(name={"gmt_offset", "gmtoff", "utc_offset"})
    public RubyInteger gmt_offset() {
        int n = this.dt.getZone().getOffsetFromLocal(this.dt.getMillis());
        return this.getRuntime().newFixnum(n / 1000);
    }

    @JRubyMethod(name={"isdst", "dst?"})
    public RubyBoolean isdst() {
        return this.getRuntime().newBoolean(!this.dt.getZone().isStandardOffset(this.dt.getMillis()));
    }

    @JRubyMethod(name={"zone"})
    public RubyString zone() {
        String string = this.dt.getZone().getShortName(this.dt.getMillis());
        if (string.equals("+00:00")) {
            string = "GMT";
        }
        return this.getRuntime().newString(string);
    }

    public void setDateTime(DateTime dateTime) {
        this.dt = dateTime;
    }

    public DateTime getDateTime() {
        return this.dt;
    }

    public Date getJavaDate() {
        return this.dt.toDate();
    }

    @JRubyMethod(name={"hash"})
    public RubyFixnum hash() {
        return this.getRuntime().newFixnum((int)((this.dt.getMillis() / 1000L ^ this.microseconds()) << 1) >> 1);
    }

    @JRubyMethod(name={"_dump"}, optional=1, frame=true)
    public RubyString dump(IRubyObject[] iRubyObjectArray, Block block) {
        RubyString rubyString = (RubyString)this.mdump(new IRubyObject[]{this});
        rubyString.syncVariables(this.getVariableList());
        return rubyString;
    }

    public RubyObject mdump(IRubyObject[] iRubyObjectArray) {
        int n;
        RubyTime rubyTime = (RubyTime)iRubyObjectArray[0];
        DateTime dateTime = rubyTime.dt.withZone(DateTimeZone.UTC);
        byte[] byArray = new byte[8];
        int n2 = Integer.MIN_VALUE | dateTime.getYear() - 1900 << 14 | dateTime.getMonthOfYear() - 1 << 10 | dateTime.getDayOfMonth() << 5 | dateTime.getHourOfDay();
        int n3 = dateTime.getMinuteOfHour() << 26 | dateTime.getSecondOfMinute() << 20 | dateTime.getMillisOfSecond() * 1000 + (int)this.usec;
        for (n = 0; n < 4; ++n) {
            byArray[n] = (byte)(n2 & 0xFF);
            n2 >>>= 8;
        }
        for (n = 4; n < 8; ++n) {
            byArray[n] = (byte)(n3 & 0xFF);
            n3 >>>= 8;
        }
        return RubyString.newString(rubyTime.getRuntime(), new ByteList(byArray, false));
    }

    @JRubyMethod(name={"initialize"}, frame=true, visibility=Visibility.PRIVATE)
    public IRubyObject initialize(Block block) {
        return this;
    }

    public static IRubyObject s_new(IRubyObject iRubyObject, IRubyObject[] iRubyObjectArray, Block block) {
        Ruby ruby = iRubyObject.getRuntime();
        RubyTime rubyTime = new RubyTime(ruby, (RubyClass)iRubyObject, new DateTime(RubyTime.getLocalTimeZone(ruby)));
        rubyTime.callInit(iRubyObjectArray, block);
        return rubyTime;
    }

    @Deprecated
    public static IRubyObject newInstance(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject[] iRubyObjectArray, Block block) {
        return RubyTime.newInstance(threadContext, iRubyObject);
    }

    @JRubyMethod(name={"now"}, backtrace=true, meta=true)
    public static IRubyObject newInstance(ThreadContext threadContext, IRubyObject iRubyObject) {
        IRubyObject iRubyObject2 = ((RubyClass)iRubyObject).allocate();
        iRubyObject2.callMethod(threadContext, "initialize");
        return iRubyObject2;
    }

    @JRubyMethod(name={"at"}, meta=true)
    public static IRubyObject at(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        RubyTime rubyTime;
        Ruby ruby = threadContext.getRuntime();
        if (iRubyObject2 instanceof RubyTime) {
            RubyTime rubyTime2 = (RubyTime)iRubyObject2;
            rubyTime = new RubyTime(ruby, (RubyClass)iRubyObject, rubyTime2.dt);
            rubyTime.setUSec(rubyTime2.getUSec());
        } else {
            rubyTime = new RubyTime(ruby, (RubyClass)iRubyObject, new DateTime(0L, RubyTime.getLocalTimeZone(ruby)));
            long l = RubyNumeric.num2long(iRubyObject2);
            long l2 = 0L;
            long l3 = 0L;
            if (iRubyObject2 instanceof RubyFloat) {
                double d = ((RubyFloat)iRubyObject2).getDoubleValue();
                long l4 = (long)((d - (double)l) * 1000000.0);
                l2 = l4 / 1000L;
                l3 = l4 % 1000L;
            }
            rubyTime.setUSec(l3);
            rubyTime.dt = rubyTime.dt.withMillis(l * 1000L + l2);
        }
        rubyTime.callMethod(threadContext, "initialize");
        return rubyTime;
    }

    @JRubyMethod(name={"at"}, meta=true)
    public static IRubyObject at(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2, IRubyObject iRubyObject3) {
        Ruby ruby = threadContext.getRuntime();
        RubyTime rubyTime = new RubyTime(ruby, (RubyClass)iRubyObject, new DateTime(0L, RubyTime.getLocalTimeZone(ruby)));
        long l = RubyNumeric.num2long(iRubyObject2);
        long l2 = 0L;
        long l3 = 0L;
        long l4 = RubyNumeric.num2long(iRubyObject3);
        l2 = l4 / 1000L;
        l3 = l4 % 1000L;
        rubyTime.setUSec(l3);
        rubyTime.dt = rubyTime.dt.withMillis(l * 1000L + l2);
        rubyTime.callMethod(threadContext, "initialize");
        return rubyTime;
    }

    @JRubyMethod(name={"local", "mktime"}, required=1, optional=9, meta=true)
    public static RubyTime new_local(IRubyObject iRubyObject, IRubyObject[] iRubyObjectArray) {
        return RubyTime.createTime(iRubyObject, iRubyObjectArray, false);
    }

    @JRubyMethod(name={"utc", "gm"}, required=1, optional=9, meta=true)
    public static RubyTime new_utc(IRubyObject iRubyObject, IRubyObject[] iRubyObjectArray) {
        return RubyTime.createTime(iRubyObject, iRubyObjectArray, true);
    }

    @JRubyMethod(name={"_load"}, required=1, frame=true, meta=true)
    public static RubyTime load(IRubyObject iRubyObject, IRubyObject iRubyObject2, Block block) {
        return RubyTime.s_mload(iRubyObject, (RubyTime)((RubyClass)iRubyObject).allocate(), iRubyObject2);
    }

    protected static RubyTime s_mload(IRubyObject iRubyObject, RubyTime rubyTime, IRubyObject iRubyObject2) {
        int n;
        Ruby ruby = iRubyObject.getRuntime();
        DateTime dateTime = new DateTime(DateTimeZone.UTC);
        byte[] byArray = null;
        byArray = iRubyObject2.convertToString().getBytes();
        if (byArray.length != 8) {
            throw ruby.newTypeError("marshaled time format differ");
        }
        int n2 = 0;
        int n3 = 0;
        for (n = 0; n < 4; ++n) {
            n2 |= (byArray[n] & 0xFF) << 8 * n;
        }
        for (n = 4; n < 8; ++n) {
            n3 |= (byArray[n] & 0xFF) << 8 * (n - 4);
        }
        if ((n2 & Integer.MIN_VALUE) == 0) {
            dateTime = dateTime.withMillis((long)n2 * 1000L + (long)n3);
        } else {
            dateTime = dateTime.withYear(((n2 &= Integer.MAX_VALUE) >>> 14 & 0xFFFF) + 1900);
            dateTime = dateTime.withMonthOfYear((n2 >>> 10 & 0xF) + 1);
            dateTime = dateTime.withDayOfMonth(n2 >>> 5 & 0x1F);
            dateTime = dateTime.withHourOfDay(n2 & 0x1F);
            dateTime = dateTime.withMinuteOfHour(n3 >>> 26 & 0x3F);
            dateTime = dateTime.withSecondOfMinute(n3 >>> 20 & 0x3F);
            dateTime = dateTime.withMillisOfSecond((n3 & 0xFFFFF) / 1000);
            dateTime = dateTime.withZone(RubyTime.getLocalTimeZone(ruby));
            rubyTime.setUSec((n3 & 0xFFFFF) % 1000);
        }
        rubyTime.setDateTime(dateTime);
        return rubyTime;
    }

    /*
     * WARNING - void declaration
     */
    private static RubyTime createTime(IRubyObject iRubyObject, IRubyObject[] iRubyObjectArray, boolean bl) {
        Integer n;
        Object object;
        int n2;
        Ruby ruby = iRubyObject.getRuntime();
        int n3 = 7;
        if (iRubyObjectArray.length == 10) {
            iRubyObjectArray = new IRubyObject[]{iRubyObjectArray[5], iRubyObjectArray[4], iRubyObjectArray[3], iRubyObjectArray[2], iRubyObjectArray[1], iRubyObjectArray[0], ruby.getNil()};
        } else {
            n3 = iRubyObjectArray.length;
            if (n3 < 7) {
                IRubyObject[] iRubyObjectArray2 = new IRubyObject[7];
                System.arraycopy(iRubyObjectArray, 0, iRubyObjectArray2, 0, iRubyObjectArray.length);
                for (n2 = n3; n2 < 7; ++n2) {
                    iRubyObjectArray2[n2] = ruby.getNil();
                }
                iRubyObjectArray = iRubyObjectArray2;
                n3 = 7;
            }
        }
        if (iRubyObjectArray[0] instanceof RubyString) {
            iRubyObjectArray[0] = RubyNumeric.str2inum(ruby, (RubyString)iRubyObjectArray[0], 10, false);
        }
        int n4 = (int)RubyNumeric.num2long(iRubyObjectArray[0]);
        n2 = 1;
        if (n3 > 1) {
            if (!iRubyObjectArray[1].isNil()) {
                object = iRubyObjectArray[1].checkStringType();
                if (!object.isNil()) {
                    String string = object.toString().toLowerCase();
                    n = MONTHS_MAP.get(string);
                    if (n != null) {
                        n2 = n;
                    } else {
                        try {
                            n2 = Integer.parseInt(string);
                        }
                        catch (NumberFormatException numberFormatException) {
                            throw ruby.newArgumentError("Argument out of range.");
                        }
                    }
                } else {
                    n2 = (int)RubyNumeric.num2long(iRubyObjectArray[1]);
                }
            }
            if (1 > n2 || n2 > 12) {
                throw ruby.newArgumentError("Argument out of range: for month: " + n2);
            }
        }
        object = new int[]{1, 0, 0, 0, 0, 0};
        int n5 = 0;
        while (((Object)object).length >= n5 + 2) {
            if (!iRubyObjectArray[n5 + 2].isNil()) {
                long l;
                if (!(iRubyObjectArray[n5 + 2] instanceof RubyNumeric)) {
                    iRubyObjectArray[n5 + 2] = iRubyObjectArray[n5 + 2].callMethod(ruby.getCurrentContext(), "to_i");
                }
                if ((long)time_min[n5] > (l = RubyNumeric.num2long(iRubyObjectArray[n5 + 2])) || l > (long)time_max[n5]) {
                    throw ruby.newArgumentError("argument out of range.");
                }
                object[n5] = (int)l;
            }
            ++n5;
        }
        if (0 <= n4 && n4 < 39) {
            n4 += 2000;
        } else if (69 <= n4 && n4 < 139) {
            n4 += 1900;
        }
        DateTimeZone dateTimeZone = bl ? DateTimeZone.UTC : RubyTime.getLocalTimeZone(ruby);
        try {
            n = new DateTime(n4, 1, 1, 0, 0, 0, 0, dateTimeZone);
            n = n.plusMonths(n2 - 1).plusDays((int)(object[0] - true)).plusHours((int)object[1]).plusMinutes((int)object[2]).plusSeconds((int)object[3]);
        }
        catch (IllegalFieldValueException illegalFieldValueException) {
            throw ruby.newArgumentError("time out of range");
        }
        RubyTime rubyTime = new RubyTime(ruby, (RubyClass)iRubyObject, (DateTime)n);
        if (iRubyObjectArray.length != 8 && !iRubyObjectArray[6].isNil()) {
            void var11_18;
            void var12_20;
            reference var11_17 = object[4] % 1000;
            reference var12_19 = object[4] / 1000;
            if (object[4] < 0) {
                --var12_20;
                var11_18 += 1000;
            }
            rubyTime.dt = n.withMillis(n.getMillis() + (long)var12_20);
            rubyTime.setUSec((long)var11_18);
        }
        rubyTime.callInit(IRubyObject.NULL_ARRAY, Block.NULL_BLOCK);
        return rubyTime;
    }

    static {
        for (int i = 0; i < MONTHS.length; ++i) {
            MONTHS_MAP.put(MONTHS[i], i + 1);
        }
        time_min = new int[]{1, 0, 0, 0, Integer.MIN_VALUE};
        time_max = new int[]{31, 23, 59, 60, Integer.MAX_VALUE};
    }
}

