/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import java.io.IOException;
import java.nio.channels.Channel;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.locks.ReentrantLock;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyException;
import org.jruby.RubyFixnum;
import org.jruby.RubyIO;
import org.jruby.RubyInstanceConfig;
import org.jruby.RubyModule;
import org.jruby.RubyNumeric;
import org.jruby.RubyObject;
import org.jruby.RubyString;
import org.jruby.RubySymbol;
import org.jruby.RubySystemExit;
import org.jruby.RubyThreadGroup;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.common.IRubyWarnings;
import org.jruby.exceptions.RaiseException;
import org.jruby.exceptions.ThreadKill;
import org.jruby.internal.runtime.FutureThread;
import org.jruby.internal.runtime.NativeThread;
import org.jruby.internal.runtime.RubyNativeThread;
import org.jruby.internal.runtime.RubyRunnable;
import org.jruby.internal.runtime.ThreadLike;
import org.jruby.internal.runtime.ThreadService;
import org.jruby.runtime.Block;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ObjectMarshal;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;

@JRubyClass(name={"Thread"})
public class RubyThread
extends RubyObject {
    private ThreadLike threadImpl;
    private RubyFixnum priority;
    private final Map<IRubyObject, IRubyObject> threadLocalVariables = new HashMap<IRubyObject, IRubyObject>();
    private boolean abortOnException;
    private IRubyObject finalResult;
    private RaiseException exitingException;
    private IRubyObject receivedException;
    private RubyThreadGroup threadGroup;
    private final ThreadService threadService;
    private volatile boolean isStopped = false;
    private volatile boolean isDead = false;
    public Object stopLock = new Object();
    private volatile boolean killed = false;
    public Object killLock = new Object();
    public final ReentrantLock lock = new ReentrantLock();
    private static final boolean DEBUG = false;
    private Selector currentSelector;

    protected RubyThread(Ruby ruby, RubyClass rubyClass) {
        super(ruby, rubyClass);
        this.threadService = ruby.getThreadService();
        this.finalResult = ruby.getNil();
    }

    public void dispose() {
        this.threadGroup.remove(this);
    }

    public static RubyClass createThreadClass(Ruby ruby) {
        RubyClass rubyClass = ruby.defineClass("Thread", ruby.getObject(), ObjectAllocator.NOT_ALLOCATABLE_ALLOCATOR);
        ruby.setThread(rubyClass);
        rubyClass.defineAnnotatedMethods(RubyThread.class);
        RubyThread rubyThread = new RubyThread(ruby, rubyClass);
        rubyThread.threadImpl = new NativeThread(rubyThread, Thread.currentThread());
        ruby.getThreadService().setMainThread(rubyThread);
        ruby.getDefaultThreadGroup().addDirectly(rubyThread);
        rubyClass.setMarshal(ObjectMarshal.NOT_MARSHALABLE_MARSHAL);
        return rubyClass;
    }

    @JRubyMethod(name={"new", "fork"}, rest=true, frame=true, meta=true)
    public static IRubyObject newInstance(IRubyObject iRubyObject, IRubyObject[] iRubyObjectArray, Block block) {
        return RubyThread.startThread(iRubyObject, iRubyObjectArray, true, block);
    }

    @JRubyMethod(name={"start"}, rest=true, frame=true, meta=true)
    public static RubyThread start(IRubyObject iRubyObject, IRubyObject[] iRubyObjectArray, Block block) {
        return RubyThread.startThread(iRubyObject, iRubyObjectArray, false, block);
    }

    public static RubyThread adopt(IRubyObject iRubyObject, Thread thread) {
        return RubyThread.adoptThread(iRubyObject, thread, Block.NULL_BLOCK);
    }

    private static RubyThread adoptThread(IRubyObject iRubyObject, Thread thread, Block block) {
        Ruby ruby = iRubyObject.getRuntime();
        RubyThread rubyThread = new RubyThread(ruby, (RubyClass)iRubyObject);
        rubyThread.threadImpl = new NativeThread(rubyThread, thread);
        ThreadContext threadContext = ruby.getThreadService().registerNewThread(rubyThread);
        threadContext.preAdoptThread();
        ruby.getDefaultThreadGroup().addDirectly(rubyThread);
        return rubyThread;
    }

    @JRubyMethod(name={"initialize"}, rest=true, frame=true, visibility=Visibility.PRIVATE)
    public IRubyObject initialize(IRubyObject[] iRubyObjectArray, Block block) {
        Ruby ruby = this.getRuntime();
        if (!block.isGiven()) {
            throw ruby.newThreadError("must be called with a block");
        }
        this.threadImpl = RubyInstanceConfig.POOLING_ENABLED ? new FutureThread(this, new RubyRunnable(this, iRubyObjectArray, block)) : new NativeThread(this, new RubyNativeThread(this, iRubyObjectArray, block));
        ruby.getDefaultThreadGroup().addDirectly(this);
        this.threadImpl.start();
        Thread.yield();
        return this;
    }

    private static RubyThread startThread(IRubyObject iRubyObject, IRubyObject[] iRubyObjectArray, boolean bl, Block block) {
        RubyThread rubyThread = new RubyThread(iRubyObject.getRuntime(), (RubyClass)iRubyObject);
        if (bl) {
            rubyThread.callInit(iRubyObjectArray, block);
        } else {
            rubyThread.initialize(iRubyObjectArray, block);
        }
        return rubyThread;
    }

    private void ensureNotCurrent() {
        if (this == this.getRuntime().getCurrentContext().getThread()) {
            throw new RuntimeException("internal thread method called from another thread");
        }
    }

    public synchronized void cleanTerminate(IRubyObject iRubyObject) {
        this.finalResult = iRubyObject;
        this.isStopped = true;
        this.isDead = true;
    }

    public void pollThreadEvents() {
        this.pollThreadEvents(this.getRuntime().getCurrentContext());
    }

    public void pollThreadEvents(ThreadContext threadContext) {
        this.threadService.waitForCritical();
        if (this.killed) {
            this.throwThreadKill();
        }
        if (this.receivedException != null) {
            this.receivedAnException(threadContext);
        }
    }

    private void throwThreadKill() {
        throw new ThreadKill();
    }

    @JRubyMethod(name={"abort_on_exception"}, meta=true)
    public static RubyBoolean abort_on_exception_x(IRubyObject iRubyObject) {
        Ruby ruby = iRubyObject.getRuntime();
        return ruby.isGlobalAbortOnExceptionEnabled() ? ruby.getTrue() : ruby.getFalse();
    }

    @JRubyMethod(name={"abort_on_exception="}, required=1, meta=true)
    public static IRubyObject abort_on_exception_set_x(IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        iRubyObject.getRuntime().setGlobalAbortOnExceptionEnabled(iRubyObject2.isTrue());
        return iRubyObject2;
    }

    @JRubyMethod(name={"current"}, meta=true)
    public static RubyThread current(IRubyObject iRubyObject) {
        return iRubyObject.getRuntime().getCurrentContext().getThread();
    }

    @JRubyMethod(name={"main"}, meta=true)
    public static RubyThread main(IRubyObject iRubyObject) {
        return iRubyObject.getRuntime().getThreadService().getMainThread();
    }

    @JRubyMethod(name={"pass"}, meta=true)
    public static IRubyObject pass(IRubyObject iRubyObject) {
        Ruby ruby = iRubyObject.getRuntime();
        ThreadService threadService = ruby.getThreadService();
        boolean bl = threadService.getCritical();
        threadService.setCritical(false);
        Thread.yield();
        threadService.setCritical(bl);
        return iRubyObject.getRuntime().getNil();
    }

    @JRubyMethod(name={"list"}, meta=true)
    public static RubyArray list(IRubyObject iRubyObject) {
        IRubyObject[] iRubyObjectArray = iRubyObject.getRuntime().getThreadService().getActiveRubyThreads();
        return iRubyObject.getRuntime().newArrayNoCopy(iRubyObjectArray);
    }

    private IRubyObject getSymbolKey(IRubyObject iRubyObject) {
        if (iRubyObject instanceof RubySymbol) {
            return iRubyObject;
        }
        if (iRubyObject instanceof RubyString) {
            return this.getRuntime().newSymbol(iRubyObject.asJavaString());
        }
        if (iRubyObject instanceof RubyFixnum) {
            this.getRuntime().getWarnings().warn(IRubyWarnings.ID.FIXNUMS_NOT_SYMBOLS, "Do not use Fixnums as Symbols", new Object[0]);
            throw this.getRuntime().newArgumentError(iRubyObject + " is not a symbol");
        }
        throw this.getRuntime().newTypeError(iRubyObject + " is not a symbol");
    }

    @JRubyMethod(name={"[]"}, required=1)
    public IRubyObject op_aref(IRubyObject iRubyObject) {
        IRubyObject iRubyObject2 = this.threadLocalVariables.get(this.getSymbolKey(iRubyObject));
        if (iRubyObject2 != null) {
            return iRubyObject2;
        }
        return this.getRuntime().getNil();
    }

    @JRubyMethod(name={"[]="}, required=2)
    public IRubyObject op_aset(IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        iRubyObject = this.getSymbolKey(iRubyObject);
        this.threadLocalVariables.put(iRubyObject, iRubyObject2);
        return iRubyObject2;
    }

    @JRubyMethod(name={"abort_on_exception"})
    public RubyBoolean abort_on_exception() {
        return this.abortOnException ? this.getRuntime().getTrue() : this.getRuntime().getFalse();
    }

    @JRubyMethod(name={"abort_on_exception="}, required=1)
    public IRubyObject abort_on_exception_set(IRubyObject iRubyObject) {
        this.abortOnException = iRubyObject.isTrue();
        return iRubyObject;
    }

    @JRubyMethod(name={"alive?"})
    public RubyBoolean alive_p() {
        return !this.isDead && this.threadImpl.isAlive() ? this.getRuntime().getTrue() : this.getRuntime().getFalse();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JRubyMethod(name={"join"}, optional=1, backtrace=true)
    public IRubyObject join(IRubyObject[] iRubyObjectArray) {
        block16: {
            long l = Long.MAX_VALUE;
            if (iRubyObjectArray.length > 0) {
                if (iRubyObjectArray.length > 1) {
                    throw this.getRuntime().newArgumentError(iRubyObjectArray.length, 1);
                }
                l = (long)(1000.0 * iRubyObjectArray[0].convertToFloat().getValue());
                if (l <= 0L) {
                    if (this.threadImpl.isAlive()) {
                        return this.getRuntime().getNil();
                    }
                    return this;
                }
            }
            if (this.isCurrent()) {
                throw this.getRuntime().newThreadError("thread tried to join itself");
            }
            try {
                Object object;
                if (this.threadService.getCritical()) {
                    object = this.stopLock;
                    synchronized (object) {
                        this.stopLock.notify();
                    }
                }
                object = this.getRuntime().getCurrentContext().getThread();
                long l2 = Math.min(l, 200L);
                long l3 = System.currentTimeMillis();
                do {
                    ((RubyThread)object).pollThreadEvents();
                    this.threadImpl.join(l2);
                } while (this.threadImpl.isAlive() && System.currentTimeMillis() - l3 <= l);
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
                assert (false) : interruptedException;
            }
            catch (ExecutionException executionException) {
                executionException.printStackTrace();
                if ($assertionsDisabled) break block16;
                throw new AssertionError((Object)executionException);
            }
        }
        if (this.exitingException != null) {
            throw this.exitingException;
        }
        if (this.threadImpl.isAlive()) {
            return this.getRuntime().getNil();
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JRubyMethod(name={"value"})
    public IRubyObject value() {
        this.join(new IRubyObject[0]);
        RubyThread rubyThread = this;
        synchronized (rubyThread) {
            return this.finalResult;
        }
    }

    @JRubyMethod(name={"group"})
    public IRubyObject group() {
        if (this.threadGroup == null) {
            return this.getRuntime().getNil();
        }
        return this.threadGroup;
    }

    void setThreadGroup(RubyThreadGroup rubyThreadGroup) {
        this.threadGroup = rubyThreadGroup;
    }

    @JRubyMethod(name={"inspect"})
    public IRubyObject inspect() {
        StringBuilder stringBuilder = new StringBuilder();
        String string = this.getMetaClass().getRealClass().getName();
        stringBuilder.append("#<").append(string).append(":0x");
        stringBuilder.append(Integer.toHexString(System.identityHashCode(this)));
        if (this.threadImpl.isAlive()) {
            if (this.isStopped) {
                stringBuilder.append(this.getRuntime().newString(" sleep"));
            } else if (this.killed) {
                stringBuilder.append(this.getRuntime().newString(" aborting"));
            } else {
                stringBuilder.append(this.getRuntime().newString(" run"));
            }
        } else {
            stringBuilder.append(" dead");
        }
        stringBuilder.append(">");
        return this.getRuntime().newString(stringBuilder.toString());
    }

    @JRubyMethod(name={"key?"}, required=1)
    public RubyBoolean key_p(IRubyObject iRubyObject) {
        iRubyObject = this.getSymbolKey(iRubyObject);
        return this.getRuntime().newBoolean(this.threadLocalVariables.containsKey(iRubyObject));
    }

    @JRubyMethod(name={"keys"})
    public RubyArray keys() {
        IRubyObject[] iRubyObjectArray = new IRubyObject[this.threadLocalVariables.size()];
        return RubyArray.newArrayNoCopy(this.getRuntime(), this.threadLocalVariables.keySet().toArray(iRubyObjectArray));
    }

    @JRubyMethod(name={"critical="}, required=1, meta=true)
    public static IRubyObject critical_set(IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        iRubyObject.getRuntime().getThreadService().setCritical(iRubyObject2.isTrue());
        return iRubyObject2;
    }

    @JRubyMethod(name={"critical"}, meta=true)
    public static IRubyObject critical(IRubyObject iRubyObject) {
        return iRubyObject.getRuntime().newBoolean(iRubyObject.getRuntime().getThreadService().getCritical());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JRubyMethod(name={"stop"}, meta=true)
    public static IRubyObject stop(IRubyObject iRubyObject) {
        Object object;
        RubyThread rubyThread = iRubyObject.getRuntime().getThreadService().getCurrentContext().getThread();
        Object object2 = object = rubyThread.stopLock;
        synchronized (object2) {
            rubyThread.pollThreadEvents();
            try {
                rubyThread.isStopped = true;
                iRubyObject.getRuntime().getThreadService().setCritical(false);
                object.wait();
            }
            catch (InterruptedException interruptedException) {
                rubyThread.pollThreadEvents();
            }
            rubyThread.isStopped = false;
        }
        return iRubyObject.getRuntime().getNil();
    }

    @JRubyMethod(name={"kill"}, required=1, frame=true, meta=true)
    public static IRubyObject kill(IRubyObject iRubyObject, IRubyObject iRubyObject2, Block block) {
        if (!(iRubyObject2 instanceof RubyThread)) {
            throw iRubyObject.getRuntime().newTypeError(iRubyObject2, iRubyObject.getRuntime().getThread());
        }
        return ((RubyThread)iRubyObject2).kill();
    }

    @JRubyMethod(name={"exit"}, frame=true, meta=true)
    public static IRubyObject s_exit(IRubyObject iRubyObject, Block block) {
        RubyThread rubyThread = iRubyObject.getRuntime().getThreadService().getCurrentContext().getThread();
        rubyThread.killed = true;
        iRubyObject.getRuntime().getThreadService().setCritical(false);
        throw new ThreadKill();
    }

    @JRubyMethod(name={"stop?"})
    public RubyBoolean stop_p() {
        return this.getRuntime().newBoolean(this.isStopped);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JRubyMethod(name={"wakeup"})
    public RubyThread wakeup() {
        Object object = this.stopLock;
        synchronized (object) {
            this.stopLock.notifyAll();
        }
        return this;
    }

    @JRubyMethod(name={"priority"})
    public RubyFixnum priority() {
        return this.priority;
    }

    @JRubyMethod(name={"priority="}, required=1)
    public IRubyObject priority_set(IRubyObject iRubyObject) {
        int n = RubyNumeric.fix2int(iRubyObject);
        if (n < 1) {
            n = 1;
        } else if (n > 10) {
            n = 10;
        }
        this.priority = RubyFixnum.newFixnum(this.getRuntime(), n);
        if (this.threadImpl.isAlive()) {
            this.threadImpl.setPriority(n);
        }
        return this.priority;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JRubyMethod(name={"raise"}, optional=2, frame=true)
    public IRubyObject raise(IRubyObject[] iRubyObjectArray, Block block) {
        this.ensureNotCurrent();
        Ruby ruby = this.getRuntime();
        RubyThread rubyThread = this.getRuntime().getCurrentContext().getThread();
        try {
            while (!rubyThread.lock.tryLock() || !this.lock.tryLock()) {
                if (!rubyThread.lock.isHeldByCurrentThread()) continue;
                rubyThread.lock.unlock();
            }
            rubyThread.pollThreadEvents();
            this.receivedException = this.prepareRaiseException(ruby, iRubyObjectArray, block);
            Object object = this.stopLock;
            synchronized (object) {
                this.stopLock.notify();
            }
            this.interrupt();
        }
        finally {
            if (rubyThread.lock.isHeldByCurrentThread()) {
                rubyThread.lock.unlock();
            }
            if (this.lock.isHeldByCurrentThread()) {
                this.lock.unlock();
            }
        }
        return this;
    }

    private IRubyObject prepareRaiseException(Ruby ruby, IRubyObject[] iRubyObjectArray, Block block) {
        IRubyObject iRubyObject;
        if (iRubyObjectArray.length == 0) {
            IRubyObject iRubyObject2 = ruby.getGlobalVariables().get("$!");
            if (iRubyObject2.isNil()) {
                return new RaiseException(ruby, ruby.getRuntimeError(), "", false).getException();
            }
            return iRubyObject2;
        }
        ThreadContext threadContext = this.getRuntime().getCurrentContext();
        if (iRubyObjectArray.length == 1) {
            if (iRubyObjectArray[0] instanceof RubyString) {
                return ruby.getRuntimeError().newInstance(threadContext, iRubyObjectArray, block);
            }
            if (!iRubyObjectArray[0].respondsTo("exception")) {
                return ruby.newTypeError("exception class/object expected").getException();
            }
            iRubyObject = iRubyObjectArray[0].callMethod(threadContext, "exception");
        } else {
            if (!iRubyObjectArray[0].respondsTo("exception")) {
                return ruby.newTypeError("exception class/object expected").getException();
            }
            iRubyObject = iRubyObjectArray[0].callMethod(threadContext, "exception", iRubyObjectArray[1]);
        }
        if (!ruby.getException().isInstance(iRubyObject)) {
            return ruby.newTypeError("exception object expected").getException();
        }
        if (iRubyObjectArray.length == 3) {
            ((RubyException)iRubyObject).set_backtrace(iRubyObjectArray[2]);
        }
        return iRubyObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JRubyMethod(name={"run"})
    public IRubyObject run() {
        Object object = this.stopLock;
        synchronized (object) {
            if (this.isStopped) {
                this.isStopped = false;
                this.stopLock.notifyAll();
            }
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sleep(long l) throws InterruptedException {
        assert (this == this.getRuntime().getCurrentContext().getThread());
        Object object = this.stopLock;
        synchronized (object) {
            this.pollThreadEvents();
            try {
                this.isStopped = true;
                this.stopLock.wait(l);
            }
            finally {
                this.isStopped = false;
                this.pollThreadEvents();
            }
        }
    }

    @JRubyMethod(name={"status"})
    public IRubyObject status() {
        if (this.threadImpl.isAlive()) {
            if (this.isStopped || this.currentSelector != null && this.currentSelector.isOpen()) {
                return this.getRuntime().newString("sleep");
            }
            if (this.killed) {
                return this.getRuntime().newString("aborting");
            }
            return this.getRuntime().newString("run");
        }
        if (this.exitingException != null) {
            return this.getRuntime().getNil();
        }
        return this.getRuntime().getFalse();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JRubyMethod(name={"kill", "exit", "terminate"})
    public IRubyObject kill() {
        RubyThread rubyThread = this.getRuntime().getCurrentContext().getThread();
        if (rubyThread == this) {
            this.throwThreadKill();
        }
        try {
            while (!rubyThread.lock.tryLock() || !this.lock.tryLock()) {
                if (!rubyThread.lock.isHeldByCurrentThread()) continue;
                rubyThread.lock.unlock();
            }
            rubyThread.pollThreadEvents();
            this.killed = true;
            Object object = this.stopLock;
            synchronized (object) {
                this.stopLock.notify();
            }
            this.interrupt();
        }
        finally {
            if (rubyThread.lock.isHeldByCurrentThread()) {
                rubyThread.lock.unlock();
            }
            if (this.lock.isHeldByCurrentThread()) {
                this.lock.unlock();
            }
        }
        try {
            this.threadImpl.join();
        }
        catch (InterruptedException interruptedException) {
            rubyThread.pollThreadEvents();
        }
        catch (ExecutionException executionException) {
            rubyThread.pollThreadEvents();
        }
        return this;
    }

    @JRubyMethod(name={"kill!", "exit!", "terminate!"})
    public IRubyObject kill_bang() {
        throw this.getRuntime().newNotImplementedError("Thread#kill!, exit!, and terminate! are not safe and not supported");
    }

    @JRubyMethod(name={"safe_level"})
    public IRubyObject safe_level() {
        throw this.getRuntime().newNotImplementedError("Thread-specific SAFE levels are not supported");
    }

    private boolean isCurrent() {
        return this.threadImpl.isCurrent();
    }

    public void exceptionRaised(RaiseException raiseException) {
        assert (this.isCurrent());
        RubyException rubyException = raiseException.getException();
        Ruby ruby = rubyException.getRuntime();
        if (ruby.getSystemExit().isInstance(rubyException)) {
            this.threadService.getMainThread().raise(new IRubyObject[]{rubyException}, Block.NULL_BLOCK);
        } else {
            if (this.abortOnException(ruby)) {
                ruby.printError(rubyException);
                RubySystemExit rubySystemExit = RubySystemExit.newInstance(ruby, 1);
                rubySystemExit.message = rubyException.message;
                rubySystemExit.set_backtrace(rubyException.backtrace());
                this.threadService.getMainThread().raise(new IRubyObject[]{rubySystemExit}, Block.NULL_BLOCK);
                return;
            }
            if (ruby.getDebug().isTrue()) {
                ruby.printError(raiseException.getException());
            }
        }
        this.exitingException = raiseException;
    }

    private boolean abortOnException(Ruby ruby) {
        return ruby.isGlobalAbortOnExceptionEnabled() || this.abortOnException;
    }

    public static RubyThread mainThread(IRubyObject iRubyObject) {
        return iRubyObject.getRuntime().getThreadService().getMainThread();
    }

    public boolean selectForAccept(RubyIO rubyIO) {
        Channel channel = rubyIO.getChannel();
        if (channel instanceof SelectableChannel) {
            SelectableChannel selectableChannel = (SelectableChannel)channel;
            try {
                Set<SelectionKey> set;
                rubyIO.addBlockingThread(this);
                this.currentSelector = selectableChannel.provider().openSelector();
                SelectionKey selectionKey = selectableChannel.register(this.currentSelector, 16);
                int n = this.currentSelector.select();
                this.pollThreadEvents();
                if (n == 1 && (set = this.currentSelector.selectedKeys()).iterator().next() == selectionKey) {
                    boolean bl = true;
                    return bl;
                }
                boolean bl = false;
                return bl;
            }
            catch (IOException iOException) {
                throw rubyIO.getRuntime().newRuntimeError("Error with selector: " + iOException);
            }
            finally {
                if (this.currentSelector != null) {
                    try {
                        this.currentSelector.close();
                    }
                    catch (IOException iOException) {
                        throw rubyIO.getRuntime().newRuntimeError("Could not close selector");
                    }
                }
                this.currentSelector = null;
                rubyIO.removeBlockingThread(this);
            }
        }
        return true;
    }

    public void interrupt() {
        if (this.currentSelector != null) {
            this.currentSelector.wakeup();
        }
    }

    public void beforeBlockingCall() {
        this.isStopped = true;
    }

    public void afterBlockingCall() {
        this.isStopped = false;
    }

    private void receivedAnException(ThreadContext threadContext) {
        IRubyObject iRubyObject = this.receivedException;
        this.receivedException = null;
        RubyModule rubyModule = this.getRuntime().getKernel();
        rubyModule.callMethod(threadContext, "raise", iRubyObject);
    }
}

