/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyFloat;
import org.jruby.RubyKernel;
import org.jruby.RubyModule;
import org.jruby.RubyNumeric;
import org.jruby.anno.JRubyMethod;
import org.jruby.anno.JRubyModule;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;

@JRubyModule(name={"Math"})
public class RubyMath {
    private static final double[] ASINH_COEF = new double[]{-0.12820039911738187, -0.05881176118995177, 0.004727465432212481, -4.938363162653618E-4, 5.850620705855741E-5, -7.466998328931368E-6, 1.00116935835582E-6, -1.3903543858708333E-7, 1.9823169483172795E-8, -2.8847468417848845E-9, 4.2672965467159937E-10, -6.397608465436636E-11, 9.699168608906471E-12, -1.4844276972043772E-12, 2.290373793902745E-13, -3.5588395132732646E-14, 5.563969408005679E-15, -8.746250959962468E-16, 1.381524884452669E-16, -2.1916688282900364E-17, 3.490465852482756E-18};
    private static final double[] ATANH_COEF = new double[]{0.0943951023931955, 0.04919843705578616, 0.002102593522455433, 1.0735544497761166E-4, 5.978267249293031E-6, 3.505062030889135E-7, 2.1263743437653402E-8, 1.3216945357155272E-9, 8.36587550117807E-11, 5.370503749311002E-12, 3.4866594701571077E-13, 2.284549509603433E-14, 1.508407105944793E-15, 1.0024188168041091E-16, 6.69867473816507E-18, 4.497954546494931E-19};
    private static final double[] ERFC_COEF = new double[]{-0.049046121234691806, -0.14226120510371365, 0.010035582187599796, -5.768764699767485E-4, 2.741993125219606E-5, -1.1043175507344507E-6, 3.8488755420345036E-8, -1.1808582533875466E-9, 3.2334215826050907E-11, -7.991015947004549E-13, 1.7990725113961456E-14, -3.718635487818693E-16, 7.103599003714253E-18, -1.2612455119155226E-19};
    private static final double[] ERFC2_COEF = new double[]{-0.0696013466023095, -0.04110133936262089, 0.003914495866689627, -4.906395650548979E-4, 7.157479001377036E-5, -1.1530716341312328E-5, 1.9946705902019974E-6, -3.642666471599223E-7, 6.944372610005012E-8, -1.371220902104366E-8, 2.7883896610071373E-9, -5.814164724331161E-10, 1.2389204917527532E-10, -2.6906391453067435E-11, 5.942614350847911E-12, -1.3323867357581197E-12, 3.0280468061771323E-13, -6.966648814941033E-14, 1.620854541053923E-14, -3.809934465250492E-15, 9.040487815978831E-16, -2.1640061950896072E-16, 5.222102233995855E-17, -1.2697296023645554E-17, 3.1091455042761977E-18, -7.663762920320386E-19, 1.9008192513627452E-19};
    private static final double[] ERFCC_COEF = new double[]{0.07151793102029248, -0.026532434337606717, 0.0017111539779208558, -1.6375166345851787E-4, 1.9871293500552038E-5, -2.843712412766555E-6, 4.6061613089631305E-7, -8.227753025879209E-8, 1.5921418727709012E-8, -3.295071362252843E-9, 7.223439760400556E-10, -1.6648558133987297E-10, 4.010392588237665E-11, -1.004816214425731E-11, 2.608275913300334E-12, -6.991110560404025E-13, 1.9294923332617072E-13, -5.470131188754331E-14, 1.5896633097626975E-14, -4.726893980197555E-15, 1.4358733767849847E-15, -4.449510561817358E-16, 1.4048108847682335E-16, -4.5138183877642106E-17, 1.474521541045133E-17, -4.8926214069457765E-18, 1.6476121414106467E-18, -5.626817176329408E-19, 1.9474433822320786E-19};

    public static RubyModule createMathModule(Ruby ruby) {
        RubyModule rubyModule = ruby.defineModule("Math");
        ruby.setMath(rubyModule);
        rubyModule.defineConstant("E", RubyFloat.newFloat(ruby, Math.E));
        rubyModule.defineConstant("PI", RubyFloat.newFloat(ruby, Math.PI));
        rubyModule.defineAnnotatedMethods(RubyMath.class);
        return rubyModule;
    }

    private static void domainCheck(IRubyObject iRubyObject, double d, String string) {
        if (Double.isNaN(d)) {
            throw iRubyObject.getRuntime().newErrnoEDOMError(string);
        }
    }

    private static double chebylevSerie(double d, double[] dArray) {
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 2.0 * d;
        for (int i = dArray.length - 1; i >= 0; --i) {
            d4 = d2;
            d2 = d3;
            d3 = d5 * d2 - d4 + dArray[i];
        }
        return 0.5 * (d3 - d4);
    }

    private static double sign(double d, double d2) {
        double d3 = d < 0.0 ? -d : d;
        return d2 < 0.0 ? -d3 : d3;
    }

    @JRubyMethod(name={"atan2"}, required=2, module=true, visibility=Visibility.PRIVATE)
    public static RubyFloat atan2(IRubyObject iRubyObject, IRubyObject iRubyObject2, IRubyObject iRubyObject3) {
        double d = ((RubyFloat)RubyKernel.new_float(iRubyObject, iRubyObject2)).getDoubleValue();
        double d2 = ((RubyFloat)RubyKernel.new_float(iRubyObject, iRubyObject3)).getDoubleValue();
        return RubyFloat.newFloat(iRubyObject.getRuntime(), Math.atan2(d, d2));
    }

    @JRubyMethod(name={"cos"}, required=1, module=true, visibility=Visibility.PRIVATE)
    public static RubyFloat cos(IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        double d = ((RubyFloat)RubyKernel.new_float(iRubyObject, iRubyObject2)).getDoubleValue();
        return RubyFloat.newFloat(iRubyObject.getRuntime(), Math.cos(d));
    }

    @JRubyMethod(name={"sin"}, required=1, module=true, visibility=Visibility.PRIVATE)
    public static RubyFloat sin(IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        double d = ((RubyFloat)RubyKernel.new_float(iRubyObject, iRubyObject2)).getDoubleValue();
        return RubyFloat.newFloat(iRubyObject.getRuntime(), Math.sin(d));
    }

    @JRubyMethod(name={"tan"}, required=1, module=true, visibility=Visibility.PRIVATE)
    public static RubyFloat tan(IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        double d = ((RubyFloat)RubyKernel.new_float(iRubyObject, iRubyObject2)).getDoubleValue();
        return RubyFloat.newFloat(iRubyObject.getRuntime(), Math.tan(d));
    }

    @JRubyMethod(name={"asin"}, required=1, module=true, visibility=Visibility.PRIVATE)
    public static RubyFloat asin(IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        double d = ((RubyFloat)RubyKernel.new_float(iRubyObject, iRubyObject2)).getDoubleValue();
        double d2 = Math.asin(d);
        RubyMath.domainCheck(iRubyObject, d2, "asin");
        return RubyFloat.newFloat(iRubyObject.getRuntime(), d2);
    }

    @JRubyMethod(name={"acos"}, required=1, module=true, visibility=Visibility.PRIVATE)
    public static RubyFloat acos(IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        double d = ((RubyFloat)RubyKernel.new_float(iRubyObject, iRubyObject2)).getDoubleValue();
        double d2 = Math.acos(d);
        RubyMath.domainCheck(iRubyObject, d2, "acos");
        return RubyFloat.newFloat(iRubyObject.getRuntime(), d2);
    }

    @JRubyMethod(name={"atan"}, required=1, module=true, visibility=Visibility.PRIVATE)
    public static RubyFloat atan(IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        double d = ((RubyFloat)RubyKernel.new_float(iRubyObject, iRubyObject2)).getDoubleValue();
        return RubyFloat.newFloat(iRubyObject.getRuntime(), Math.atan(d));
    }

    @JRubyMethod(name={"cosh"}, required=1, module=true, visibility=Visibility.PRIVATE)
    public static RubyFloat cosh(IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        double d = ((RubyFloat)RubyKernel.new_float(iRubyObject, iRubyObject2)).getDoubleValue();
        return RubyFloat.newFloat(iRubyObject.getRuntime(), (Math.exp(d) + Math.exp(-d)) / 2.0);
    }

    @JRubyMethod(name={"sinh"}, required=1, module=true, visibility=Visibility.PRIVATE)
    public static RubyFloat sinh(IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        double d = ((RubyFloat)RubyKernel.new_float(iRubyObject, iRubyObject2)).getDoubleValue();
        return RubyFloat.newFloat(iRubyObject.getRuntime(), (Math.exp(d) - Math.exp(-d)) / 2.0);
    }

    @JRubyMethod(name={"tanh"}, required=1, module=true, visibility=Visibility.PRIVATE)
    public static RubyFloat tanh(IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        double d = ((RubyFloat)RubyKernel.new_float(iRubyObject, iRubyObject2)).getDoubleValue();
        return RubyFloat.newFloat(iRubyObject.getRuntime(), Math.tanh(d));
    }

    @JRubyMethod(name={"acosh"}, required=1, module=true, visibility=Visibility.PRIVATE)
    public static RubyFloat acosh(IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        double d = ((RubyFloat)RubyKernel.new_float(iRubyObject, iRubyObject2)).getDoubleValue();
        double d2 = Double.isNaN(d) || d < 1.0 ? Double.NaN : (d < 9.490626562E7 ? Math.log(d + Math.sqrt(d * d - 1.0)) : 0.6931471805599453 + Math.log(d));
        RubyMath.domainCheck(iRubyObject, d2, "acosh");
        return RubyFloat.newFloat(iRubyObject.getRuntime(), d2);
    }

    @JRubyMethod(name={"asinh"}, required=1, module=true, visibility=Visibility.PRIVATE)
    public static RubyFloat asinh(IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        double d;
        double d2 = ((RubyFloat)RubyKernel.new_float(iRubyObject, iRubyObject2)).getDoubleValue();
        double d3 = Math.abs(d2);
        if (Double.isNaN(d2)) {
            d = Double.NaN;
        } else if (d3 <= 1.05367E-8) {
            d = d2;
        } else if (d3 <= 1.0) {
            d = d2 * (1.0 + RubyMath.chebylevSerie(2.0 * d2 * d2 - 1.0, ASINH_COEF));
        } else if (d3 < 9.490626562E7) {
            d = Math.log(d2 + Math.sqrt(d2 * d2 + 1.0));
        } else {
            d = 0.6931471805599453 + Math.log(d3);
            if (d2 < 0.0) {
                d *= -1.0;
            }
        }
        return RubyFloat.newFloat(iRubyObject.getRuntime(), d);
    }

    @JRubyMethod(name={"atanh"}, required=1, module=true, visibility=Visibility.PRIVATE)
    public static RubyFloat atanh(IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        double d = ((RubyFloat)RubyKernel.new_float(iRubyObject, iRubyObject2)).getDoubleValue();
        double d2 = Math.abs(d);
        double d3 = Double.isNaN(d) ? Double.NaN : (d2 < 1.82501E-8 ? d : (d2 <= 0.5 ? d * (1.0 + RubyMath.chebylevSerie(8.0 * d * d - 1.0, ATANH_COEF)) : (d2 < 1.0 ? 0.5 * Math.log((1.0 + d) / (1.0 - d)) : (d2 == 1.0 ? d * Double.POSITIVE_INFINITY : Double.NaN))));
        RubyMath.domainCheck(iRubyObject, d3, "atanh");
        return RubyFloat.newFloat(iRubyObject.getRuntime(), d3);
    }

    @JRubyMethod(name={"exp"}, required=1, module=true, visibility=Visibility.PRIVATE)
    public static RubyFloat exp(IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        double d = ((RubyFloat)RubyKernel.new_float(iRubyObject, iRubyObject2)).getDoubleValue();
        return RubyFloat.newFloat(iRubyObject.getRuntime(), Math.exp(d));
    }

    @JRubyMethod(name={"log"}, required=1, module=true, visibility=Visibility.PRIVATE)
    public static RubyFloat log(IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        double d = ((RubyFloat)RubyKernel.new_float(iRubyObject, iRubyObject2)).getDoubleValue();
        double d2 = Math.log(d);
        RubyMath.domainCheck(iRubyObject, d2, "log");
        return RubyFloat.newFloat(iRubyObject.getRuntime(), d2);
    }

    @JRubyMethod(name={"log10"}, required=1, module=true, visibility=Visibility.PRIVATE)
    public static RubyFloat log10(IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        double d = ((RubyFloat)RubyKernel.new_float(iRubyObject, iRubyObject2)).getDoubleValue();
        double d2 = Math.log(d) / Math.log(10.0);
        RubyMath.domainCheck(iRubyObject, d2, "log10");
        return RubyFloat.newFloat(iRubyObject.getRuntime(), d2);
    }

    @JRubyMethod(name={"sqrt"}, required=1, module=true, visibility=Visibility.PRIVATE)
    public static RubyFloat sqrt(IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        double d = ((RubyFloat)RubyKernel.new_float(iRubyObject, iRubyObject2)).getDoubleValue();
        double d2 = d < 0.0 ? Double.NaN : Math.sqrt(d);
        RubyMath.domainCheck(iRubyObject, d2, "sqrt");
        return RubyFloat.newFloat(iRubyObject.getRuntime(), d2);
    }

    @JRubyMethod(name={"hypot"}, required=2, module=true, visibility=Visibility.PRIVATE)
    public static RubyFloat hypot(IRubyObject iRubyObject, IRubyObject iRubyObject2, IRubyObject iRubyObject3) {
        double d;
        double d2 = ((RubyFloat)RubyKernel.new_float(iRubyObject, iRubyObject2)).getDoubleValue();
        double d3 = ((RubyFloat)RubyKernel.new_float(iRubyObject, iRubyObject3)).getDoubleValue();
        if (Math.abs(d2) > Math.abs(d3)) {
            d = d3 / d2;
            d = Math.abs(d2) * Math.sqrt(1.0 + d * d);
        } else if (d3 != 0.0) {
            d = d2 / d3;
            d = Math.abs(d3) * Math.sqrt(1.0 + d * d);
        } else {
            d = 0.0;
        }
        return RubyFloat.newFloat(iRubyObject.getRuntime(), d);
    }

    @JRubyMethod(name={"frexp"}, required=1, module=true, visibility=Visibility.PRIVATE)
    public static RubyArray frexp(IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        double d = ((RubyFloat)RubyKernel.new_float(iRubyObject, iRubyObject2)).getDoubleValue();
        int n = 1;
        long l = 0L;
        if (d != 0.0) {
            if (d < 0.0) {
                d = -d;
                n = -1;
            }
            while (d < 0.5) {
                d *= 2.0;
                --l;
            }
            while (d >= 1.0) {
                d *= 0.5;
                ++l;
            }
        }
        return RubyArray.newArray(iRubyObject.getRuntime(), RubyFloat.newFloat(iRubyObject.getRuntime(), (double)n * d), RubyNumeric.int2fix(iRubyObject.getRuntime(), l));
    }

    @JRubyMethod(name={"ldexp"}, required=2, module=true, visibility=Visibility.PRIVATE)
    public static RubyFloat ldexp(IRubyObject iRubyObject, IRubyObject iRubyObject2, IRubyObject iRubyObject3) {
        double d = ((RubyFloat)RubyKernel.new_float(iRubyObject, iRubyObject2)).getDoubleValue();
        return RubyFloat.newFloat(iRubyObject.getRuntime(), d * Math.pow(2.0, RubyNumeric.num2int(iRubyObject3)));
    }

    @JRubyMethod(name={"erf"}, required=1, module=true, visibility=Visibility.PRIVATE)
    public static RubyFloat erf(IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        double d = ((RubyFloat)RubyKernel.new_float(iRubyObject, iRubyObject2)).getDoubleValue();
        double d2 = Math.abs(d);
        double d3 = d2 <= 1.49012E-8 ? 2.0 * d / 1.772453850905516 : (d2 <= 1.0 ? d * (1.0 + RubyMath.chebylevSerie(2.0 * d * d - 1.0, ERFC_COEF)) : (d2 < 6.013687357 ? RubyMath.sign(1.0 - RubyMath.erfc(iRubyObject, RubyFloat.newFloat(iRubyObject.getRuntime(), d2)).getDoubleValue(), d) : RubyMath.sign(1.0, d)));
        return RubyFloat.newFloat(iRubyObject.getRuntime(), d3);
    }

    @JRubyMethod(name={"erfc"}, required=1, module=true, visibility=Visibility.PRIVATE)
    public static RubyFloat erfc(IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        double d;
        double d2 = ((RubyFloat)RubyKernel.new_float(iRubyObject, iRubyObject2)).getDoubleValue();
        double d3 = Math.abs(d2);
        if (d2 <= -6.013687357) {
            d = 2.0;
        } else if (d3 < 1.49012E-8) {
            d = 1.0 - 2.0 * d2 / 1.772453850905516;
        } else {
            double d4 = d3 * d3;
            if (d3 < 1.0) {
                d = 1.0 - d2 * (1.0 + RubyMath.chebylevSerie(2.0 * d4 - 1.0, ERFC_COEF));
            } else if (d3 <= 4.0) {
                d = Math.exp(-d4) / d3 * (0.5 + RubyMath.chebylevSerie((8.0 / d4 - 5.0) / 3.0, ERFC2_COEF));
                if (d2 < 0.0) {
                    d = 2.0 - d;
                }
                if (d2 < 0.0) {
                    d = 2.0 - d;
                }
                if (d2 < 0.0) {
                    d = 2.0 - d;
                }
            } else {
                d = Math.exp(-d4) / d3 * (0.5 + RubyMath.chebylevSerie(8.0 / d4 - 1.0, ERFCC_COEF));
                if (d2 < 0.0) {
                    d = 2.0 - d;
                }
            }
        }
        return RubyFloat.newFloat(iRubyObject.getRuntime(), d);
    }
}

