/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyClass;
import org.jruby.RubyFile;
import org.jruby.RubyFixnum;
import org.jruby.RubyHash;
import org.jruby.RubyInteger;
import org.jruby.RubyNumeric;
import org.jruby.RubyObject;
import org.jruby.RubyString;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.ext.posix.util.Platform;
import org.jruby.javasupport.JavaUtil;
import org.jruby.runtime.Block;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ByteList;
import org.jruby.util.Dir;
import org.jruby.util.JRubyFile;
import org.jruby.util.NormalizedFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@JRubyClass(name={"Dir"}, include={"Enumerable"})
public class RubyDir
extends RubyObject {
    private RubyString path;
    protected JRubyFile dir;
    private String[] snapshot;
    private int pos;
    private boolean isOpen = true;
    private static final ObjectAllocator DIR_ALLOCATOR = new ObjectAllocator(){

        public IRubyObject allocate(Ruby ruby, RubyClass rubyClass) {
            return new RubyDir(ruby, rubyClass);
        }
    };

    public RubyDir(Ruby ruby, RubyClass rubyClass) {
        super(ruby, rubyClass);
    }

    public static RubyClass createDirClass(Ruby ruby) {
        RubyClass rubyClass = ruby.defineClass("Dir", ruby.getObject(), DIR_ALLOCATOR);
        ruby.setDir(rubyClass);
        rubyClass.includeModule(ruby.getEnumerable());
        rubyClass.defineAnnotatedMethods(RubyDir.class);
        return rubyClass;
    }

    private final void checkDir() {
        if (!this.isTaint() && this.getRuntime().getSafeLevel() >= 4) {
            throw this.getRuntime().newSecurityError("Insecure: operation on untainted Dir");
        }
        this.testFrozen("");
        if (!this.isOpen) {
            throw this.getRuntime().newIOError("closed directory");
        }
    }

    @JRubyMethod(name={"initialize"}, required=1, frame=true)
    public IRubyObject initialize(IRubyObject iRubyObject, Block block) {
        RubyString rubyString = iRubyObject.convertToString();
        this.getRuntime().checkSafeString(rubyString);
        String string = RubyFile.adjustRootPathOnWindows(this.getRuntime(), rubyString.toString(), null);
        RubyDir.checkDirIsTwoSlashesOnWindows(this.getRuntime(), string);
        this.dir = JRubyFile.create(this.getRuntime().getCurrentDirectory(), string);
        if (!this.dir.isDirectory()) {
            this.dir = null;
            throw this.getRuntime().newErrnoENOENTError(rubyString.toString() + " is not a directory");
        }
        this.path = rubyString;
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(".");
        arrayList.add("..");
        arrayList.addAll(RubyDir.getContents(this.dir));
        this.snapshot = arrayList.toArray(new String[arrayList.size()]);
        this.pos = 0;
        return this;
    }

    private static List<ByteList> dirGlobs(String string, IRubyObject[] iRubyObjectArray, int n) {
        ArrayList<ByteList> arrayList = new ArrayList<ByteList>();
        for (int i = 0; i < iRubyObjectArray.length; ++i) {
            ByteList byteList = iRubyObjectArray[i].convertToString().getByteList();
            arrayList.addAll(Dir.push_glob(string, byteList, n));
        }
        return arrayList;
    }

    private static IRubyObject asRubyStringList(Ruby ruby, List<ByteList> list) {
        ArrayList<RubyString> arrayList = new ArrayList<RubyString>();
        for (ByteList byteList : list) {
            arrayList.add(RubyString.newString(ruby, byteList));
        }
        IRubyObject[] iRubyObjectArray = new IRubyObject[arrayList.size()];
        arrayList.toArray(iRubyObjectArray);
        return ruby.newArrayNoCopy(iRubyObjectArray);
    }

    private static String getCWD(Ruby ruby) {
        try {
            return new NormalizedFile(ruby.getCurrentDirectory()).getCanonicalPath();
        }
        catch (Exception exception) {
            return ruby.getCurrentDirectory();
        }
    }

    @JRubyMethod(name={"[]"}, required=1, rest=true, meta=true)
    public static IRubyObject aref(IRubyObject iRubyObject, IRubyObject[] iRubyObjectArray) {
        List<ByteList> list;
        if (iRubyObjectArray.length == 1) {
            ByteList byteList = iRubyObjectArray[0].convertToString().getByteList();
            list = Dir.push_glob(RubyDir.getCWD(iRubyObject.getRuntime()), byteList, 0);
        } else {
            list = RubyDir.dirGlobs(RubyDir.getCWD(iRubyObject.getRuntime()), iRubyObjectArray, 0);
        }
        return RubyDir.asRubyStringList(iRubyObject.getRuntime(), list);
    }

    @JRubyMethod(name={"glob"}, required=1, optional=1, frame=true, meta=true)
    public static IRubyObject glob(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject[] iRubyObjectArray, Block block) {
        List<ByteList> list;
        Ruby ruby = iRubyObject.getRuntime();
        int n = iRubyObjectArray.length == 2 ? RubyNumeric.num2int(iRubyObjectArray[1]) : 0;
        IRubyObject iRubyObject2 = iRubyObjectArray[0].checkArrayType();
        if (iRubyObject2.isNil()) {
            ByteList byteList = iRubyObjectArray[0].convertToString().getByteList();
            list = Dir.push_glob(iRubyObject.getRuntime().getCurrentDirectory(), byteList, n);
        } else {
            list = RubyDir.dirGlobs(RubyDir.getCWD(ruby), ((RubyArray)iRubyObject2).toJavaArray(), n);
        }
        if (block.isGiven()) {
            for (int i = 0; i < list.size(); ++i) {
                block.yield(threadContext, RubyString.newString(ruby, list.get(i)));
            }
            return iRubyObject.getRuntime().getNil();
        }
        return RubyDir.asRubyStringList(iRubyObject.getRuntime(), list);
    }

    @JRubyMethod(name={"entries"})
    public RubyArray entries() {
        return this.getRuntime().newArrayNoCopy(JavaUtil.convertJavaArrayToRuby(this.getRuntime(), this.snapshot));
    }

    @JRubyMethod(name={"entries"}, required=1, meta=true)
    public static RubyArray entries(IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        Ruby ruby = iRubyObject.getRuntime();
        String string = RubyFile.adjustRootPathOnWindows(ruby, iRubyObject2.convertToString().toString(), null);
        RubyDir.checkDirIsTwoSlashesOnWindows(ruby, string);
        JRubyFile jRubyFile = JRubyFile.create(iRubyObject.getRuntime().getCurrentDirectory(), string);
        if (!jRubyFile.isDirectory()) {
            throw iRubyObject.getRuntime().newErrnoENOENTError("No such directory");
        }
        List<String> list = RubyDir.getContents(jRubyFile);
        list.add(0, ".");
        list.add(1, "..");
        Object[] objectArray = list.toArray();
        return iRubyObject.getRuntime().newArrayNoCopy(JavaUtil.convertJavaArrayToRuby(iRubyObject.getRuntime(), objectArray));
    }

    private static void checkDirIsTwoSlashesOnWindows(Ruby ruby, String string) {
        if (Platform.IS_WINDOWS && ("//".equals(string) || "\\\\".equals(string))) {
            throw ruby.newErrnoEINVALError("Invalid argument - " + string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JRubyMethod(name={"chdir"}, optional=1, frame=true, meta=true)
    public static IRubyObject chdir(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject[] iRubyObjectArray, Block block) {
        RubyString rubyString = iRubyObjectArray.length == 1 ? iRubyObjectArray[0].convertToString() : RubyDir.getHomeDirectoryPath(threadContext);
        String string = RubyFile.adjustRootPathOnWindows(iRubyObject.getRuntime(), rubyString.toString(), null);
        RubyDir.checkDirIsTwoSlashesOnWindows(iRubyObject.getRuntime(), string);
        JRubyFile jRubyFile = RubyDir.getDir(iRubyObject.getRuntime(), string, true);
        String string2 = null;
        String string3 = iRubyObject.getRuntime().getCurrentDirectory();
        try {
            string2 = jRubyFile.getCanonicalPath();
        }
        catch (IOException iOException) {
            string2 = jRubyFile.getAbsolutePath();
        }
        IRubyObject iRubyObject2 = null;
        if (block.isGiven()) {
            iRubyObject.getRuntime().setCurrentDirectory(string2);
            try {
                iRubyObject2 = block.yield(threadContext, rubyString);
            }
            finally {
                jRubyFile = RubyDir.getDir(iRubyObject.getRuntime(), string3, true);
                iRubyObject.getRuntime().setCurrentDirectory(string3);
            }
        } else {
            iRubyObject.getRuntime().setCurrentDirectory(string2);
            iRubyObject2 = iRubyObject.getRuntime().newFixnum(0);
        }
        return iRubyObject2;
    }

    @JRubyMethod(name={"chroot"}, required=1, meta=true)
    public static IRubyObject chroot(IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        throw iRubyObject.getRuntime().newNotImplementedError("chroot not implemented: chroot is non-portable and is not supported.");
    }

    @JRubyMethod(name={"rmdir", "unlink", "delete"}, required=1, meta=true)
    public static IRubyObject rmdir(IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        JRubyFile jRubyFile = RubyDir.getDir(iRubyObject.getRuntime(), iRubyObject2.convertToString().toString(), true);
        if (!jRubyFile.delete()) {
            throw iRubyObject.getRuntime().newSystemCallError("No such directory");
        }
        return iRubyObject.getRuntime().newFixnum(0);
    }

    @JRubyMethod(name={"foreach"}, required=1, frame=true, meta=true)
    public static IRubyObject foreach(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2, Block block) {
        RubyString rubyString = iRubyObject2.convertToString();
        iRubyObject.getRuntime().checkSafeString(rubyString);
        RubyClass rubyClass = iRubyObject.getRuntime().getDir();
        RubyDir rubyDir = (RubyDir)rubyClass.newInstance(threadContext, new IRubyObject[]{rubyString}, block);
        rubyDir.each(threadContext, block);
        return iRubyObject.getRuntime().getNil();
    }

    @JRubyMethod(name={"getwd", "pwd"}, meta=true)
    public static RubyString getwd(IRubyObject iRubyObject) {
        Ruby ruby = iRubyObject.getRuntime();
        return RubyString.newUnicodeString(ruby, ruby.getCurrentDirectory());
    }

    @JRubyMethod(name={"mkdir"}, required=1, optional=1, meta=true)
    public static IRubyObject mkdir(IRubyObject iRubyObject, IRubyObject[] iRubyObjectArray) {
        int n;
        Ruby ruby = iRubyObject.getRuntime();
        ruby.checkSafeString(iRubyObjectArray[0]);
        String string = iRubyObjectArray[0].toString();
        File file = RubyDir.getDir(ruby, string, false);
        if (File.separatorChar == '\\') {
            file = new File(file.getPath());
        }
        int n2 = n = iRubyObjectArray.length == 2 ? (int)iRubyObjectArray[1].convertToInteger().getLongValue() : 511;
        if (ruby.getPosix().mkdir(file.getAbsolutePath(), n) < 0) {
            throw iRubyObject.getRuntime().newSystemCallError("mkdir failed");
        }
        return RubyFixnum.zero(iRubyObject.getRuntime());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JRubyMethod(name={"open"}, required=1, frame=true, meta=true)
    public static IRubyObject open(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2, Block block) {
        RubyDir rubyDir = (RubyDir)iRubyObject.getRuntime().getDir().newInstance(threadContext, new IRubyObject[]{iRubyObject2}, Block.NULL_BLOCK);
        if (!block.isGiven()) {
            return rubyDir;
        }
        try {
            IRubyObject iRubyObject3 = block.yield(threadContext, rubyDir);
            return iRubyObject3;
        }
        finally {
            rubyDir.close();
        }
    }

    @JRubyMethod(name={"close"})
    public IRubyObject close() {
        this.checkDir();
        this.isOpen = false;
        return this.getRuntime().getNil();
    }

    @JRubyMethod(name={"each"}, frame=true)
    public IRubyObject each(ThreadContext threadContext, Block block) {
        this.checkDir();
        String[] stringArray = this.snapshot;
        for (int i = 0; i < stringArray.length; ++i) {
            block.yield(threadContext, this.getRuntime().newString(stringArray[i]));
        }
        return this;
    }

    @JRubyMethod(name={"tell", "pos"})
    public RubyInteger tell() {
        this.checkDir();
        return this.getRuntime().newFixnum(this.pos);
    }

    @JRubyMethod(name={"seek"}, required=1)
    public IRubyObject seek(IRubyObject iRubyObject) {
        this.checkDir();
        this.set_pos(iRubyObject);
        return this;
    }

    @JRubyMethod(name={"pos="}, required=1)
    public IRubyObject set_pos(IRubyObject iRubyObject) {
        this.pos = RubyNumeric.fix2int(iRubyObject);
        return iRubyObject;
    }

    @JRubyMethod(name={"path"})
    public IRubyObject path(ThreadContext threadContext) {
        this.checkDir();
        return this.path.strDup(threadContext.getRuntime());
    }

    @JRubyMethod(name={"read"})
    public IRubyObject read() {
        this.checkDir();
        if (this.pos >= this.snapshot.length) {
            return this.getRuntime().getNil();
        }
        RubyString rubyString = this.getRuntime().newString(this.snapshot[this.pos]);
        ++this.pos;
        return rubyString;
    }

    @JRubyMethod(name={"rewind"})
    public IRubyObject rewind() {
        if (!this.isTaint() && this.getRuntime().getSafeLevel() >= 4) {
            throw this.getRuntime().newSecurityError("Insecure: can't close");
        }
        this.checkDir();
        this.pos = 0;
        return this;
    }

    protected static JRubyFile getDir(Ruby ruby, String string, boolean bl) {
        JRubyFile jRubyFile = JRubyFile.create(ruby.getCurrentDirectory(), string);
        if (bl && !jRubyFile.exists()) {
            throw ruby.newErrnoENOENTError("No such file or directory - " + string);
        }
        boolean bl2 = jRubyFile.isDirectory();
        if (bl && !bl2) {
            throw ruby.newErrnoENOTDIRError(string + " is not a directory");
        }
        if (!bl && bl2) {
            throw ruby.newErrnoEEXISTError("File exists - " + string);
        }
        return jRubyFile;
    }

    protected static List<String> getContents(File file) {
        String[] stringArray = file.list();
        ArrayList<String> arrayList = new ArrayList<String>();
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                arrayList.add(stringArray[i]);
            }
        }
        return arrayList;
    }

    protected static List<RubyString> getContents(File file, Ruby ruby) {
        ArrayList<RubyString> arrayList = new ArrayList<RubyString>();
        String[] stringArray = file.list();
        for (int i = 0; i < stringArray.length; ++i) {
            arrayList.add(ruby.newString(stringArray[i]));
        }
        return arrayList;
    }

    public static IRubyObject getHomeDirectoryPath(ThreadContext threadContext, String string) {
        int n;
        String[] stringArray;
        String string2 = null;
        try {
            stringArray = new FileInputStream("/etc/passwd");
            n = stringArray.available();
            byte[] byArray = new byte[n];
            stringArray.read(byArray);
            stringArray.close();
            string2 = new String(byArray);
        }
        catch (IOException iOException) {
            return threadContext.getRuntime().getNil();
        }
        stringArray = string2.split("\n");
        n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            String[] stringArray2 = stringArray[i].split(":");
            if (!stringArray2[0].equals(string)) continue;
            return threadContext.getRuntime().newString(stringArray2[5]);
        }
        throw threadContext.getRuntime().newArgumentError("user " + string + " doesn't exist");
    }

    public static RubyString getHomeDirectoryPath(ThreadContext threadContext) {
        Ruby ruby = threadContext.getRuntime();
        RubyHash rubyHash = (RubyHash)ruby.getObject().fastGetConstant("ENV_JAVA");
        RubyHash rubyHash2 = (RubyHash)ruby.getObject().fastGetConstant("ENV");
        IRubyObject iRubyObject = rubyHash2.op_aref(threadContext, ruby.newString("HOME"));
        if (iRubyObject == null || iRubyObject.isNil()) {
            iRubyObject = rubyHash.op_aref(threadContext, ruby.newString("user.home"));
        }
        if (iRubyObject == null || iRubyObject.isNil()) {
            iRubyObject = rubyHash2.op_aref(threadContext, ruby.newString("LOGDIR"));
        }
        if (iRubyObject == null || iRubyObject.isNil()) {
            throw ruby.newArgumentError("user.home/LOGDIR not set");
        }
        return (RubyString)iRubyObject;
    }
}

