/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jersey.spi.spring.container.servlet;

import com.sun.jersey.api.core.ResourceConfig;
import com.sun.jersey.api.spring.Autowire;
import com.sun.jersey.spi.container.WebApplication;
import com.sun.jersey.spi.container.servlet.ServletContainer;
import com.sun.jersey.spi.inject.Inject;
import com.sun.jersey.spi.service.ComponentContext;
import com.sun.jersey.spi.service.ComponentProvider;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import javax.servlet.ServletContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.aop.framework.Advised;
import org.springframework.aop.support.AopUtils;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpringServlet
extends ServletContainer {
    private static final long serialVersionUID = 5686655395749077671L;
    private static final Log LOG = LogFactory.getLog(SpringServlet.class);

    protected void initiate(ResourceConfig rc, WebApplication wa) {
        try {
            WebApplicationContext springContext = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)this.getServletContext());
            wa.initiate(rc, (ComponentProvider)new SpringComponentProvider((ConfigurableApplicationContext)springContext));
        }
        catch (RuntimeException e) {
            LOG.error((Object)"Got exception while trying to initialize", (Throwable)e);
            throw e;
        }
    }

    private static String getBeanName(ComponentContext cc, Class<?> c, ApplicationContext springContext) {
        String[] names;
        Inject inject;
        boolean annotatedWithInject = false;
        if (cc != null && (inject = SpringServlet.getAnnotation(cc.getAnnotations(), Inject.class)) != null) {
            annotatedWithInject = true;
            if (inject.value() != null && !inject.value().equals("")) {
                return inject.value();
            }
        }
        if ((names = springContext.getBeanNamesForType(c)).length == 0) {
            return null;
        }
        if (names.length == 1) {
            return names[0];
        }
        StringBuilder sb = new StringBuilder();
        sb.append("There are multiple beans configured in spring for the type ").append(c.getName()).append(".");
        if (annotatedWithInject) {
            sb.append("\nYou should specify the name of the preferred bean at @Inject: Inject(\"yourBean\").");
        } else {
            sb.append("\nAnnotation information was not available, the reason might be because you're not using @Inject. You should use @Inject and specifiy the bean name via Inject(\"yourBean\").");
        }
        sb.append("\nAvailable bean names: ").append(SpringServlet.toCSV(names));
        throw new RuntimeException(sb.toString());
    }

    private static <T extends Annotation> T getAnnotation(Annotation[] annotations, Class<T> clazz) {
        if (annotations != null) {
            for (Annotation annotation : annotations) {
                if (!annotation.annotationType().equals(clazz)) continue;
                return (T)((Annotation)clazz.cast(annotation));
            }
        }
        return null;
    }

    static <T> String toCSV(T[] items) {
        if (items == null) {
            return null;
        }
        return SpringServlet.toCSV(Arrays.asList(items));
    }

    static <I> String toCSV(Collection<I> items) {
        return SpringServlet.toCSV(items, ", ", null);
    }

    static <I> String toCSV(Collection<I> items, String separator, String delimiter) {
        if (items == null) {
            return null;
        }
        if (items.isEmpty()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        Iterator<I> iter = items.iterator();
        while (iter.hasNext()) {
            if (delimiter != null) {
                sb.append(delimiter);
            }
            I item = iter.next();
            sb.append(item);
            if (delimiter != null) {
                sb.append(delimiter);
            }
            if (!iter.hasNext()) continue;
            sb.append(separator);
        }
        return sb.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SpringComponentProvider
    implements ComponentProvider {
        private ConfigurableApplicationContext springContext;

        public <T> T getInjectableInstance(T instance) {
            if (AopUtils.isAopProxy(instance)) {
                Advised aopResource = (Advised)instance;
                try {
                    Object result = aopResource.getTargetSource().getTarget();
                    return (T)result;
                }
                catch (Exception e) {
                    LOG.fatal((Object)"Could not get target object from proxy.", (Throwable)e);
                    throw new RuntimeException("Could not get target object from proxy.", e);
                }
            }
            return instance;
        }

        public SpringComponentProvider(ConfigurableApplicationContext springContext) {
            this.springContext = springContext;
        }

        public <T> T getInstance(ComponentProvider.Scope scope, Class<T> clazz) throws InstantiationException, IllegalAccessException {
            return this.getInstance(null, scope, clazz);
        }

        public <T> T getInstance(ComponentProvider.Scope scope, Constructor<T> constructor, Object[] parameters) throws InstantiationException, IllegalArgumentException, IllegalAccessException, InvocationTargetException {
            return this.getInstance(null, scope, constructor.getDeclaringClass());
        }

        public <T> T getInstance(ComponentContext cc, ComponentProvider.Scope scope, Class<T> clazz) throws InstantiationException, IllegalAccessException {
            Autowire autowire = clazz.getAnnotation(Autowire.class);
            if (autowire != null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Creating resource class " + clazz.getSimpleName() + " annotated with @" + Autowire.class.getSimpleName() + " as spring bean."));
                }
                Object result = this.springContext.getBeanFactory().createBean(clazz, autowire.mode().getSpringCode(), autowire.dependencyCheck());
                return clazz.cast(result);
            }
            String beanName = SpringServlet.getBeanName(cc, clazz, (ApplicationContext)this.springContext);
            if (beanName == null) {
                return null;
            }
            if (scope == ComponentProvider.Scope.Undefined || scope == ComponentProvider.Scope.Singleton && this.springContext.isSingleton(beanName) || scope == ComponentProvider.Scope.PerRequest && this.springContext.isPrototype(beanName)) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Retrieving bean '" + beanName + "' for resource class " + clazz.getSimpleName() + " from spring."));
                }
                Object result = this.springContext.getBean(beanName, clazz);
                return clazz.cast(result);
            }
            return null;
        }

        public void inject(Object instance) {
        }
    }
}

