/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visualweb.palette.codeclips;

import java.util.ArrayList;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.modules.visualweb.palette.codeclips.CodeClipUtilities;
import org.openide.text.ActiveEditorDrop;
import org.openide.util.NbBundle;
import org.openide.util.lookup.InstanceContent;

class ActiveEditorDropCodeClipProvider
implements InstanceContent.Convertor {
    private static ActiveEditorDropCodeClipProvider instance = new ActiveEditorDropCodeClipProvider();

    private ActiveEditorDropCodeClipProvider() {
    }

    static ActiveEditorDropCodeClipProvider getInstance() {
        return instance;
    }

    public Class type(Object object) {
        if (object instanceof ArrayList) {
            return ActiveEditorDrop.class;
        }
        return null;
    }

    public String id(Object object) {
        return (String)((ArrayList)object).get(1);
    }

    public String displayName(Object object) {
        return this.id(object);
    }

    public Object convert(Object object) {
        ArrayList arrayList = (ArrayList)object;
        String string = (String)arrayList.get(0);
        String string2 = (String)arrayList.get(1);
        String string3 = (String)arrayList.get(2);
        ActiveEditorDrop activeEditorDrop = this.getActiveEditorDrop(string, string3, string2);
        return activeEditorDrop;
    }

    private ActiveEditorDrop getActiveEditorDrop(String string, String string2, String string3) {
        String string4;
        if (string != null) {
            ResourceBundle resourceBundle = NbBundle.getBundle((String)string);
            try {
                string4 = resourceBundle.getString(string2);
            }
            catch (MissingResourceException missingResourceException) {
                string4 = string2;
            }
            string3 = CodeClipUtilities.fillFromBundle(string3, string);
        } else {
            string4 = string2;
        }
        ActiveEditorDropCodeClip activeEditorDropCodeClip = new ActiveEditorDropCodeClip(string4, string3);
        return activeEditorDropCodeClip;
    }

    private static class ActiveEditorDropCodeClip
    implements ActiveEditorDrop {
        String body;
        String title;

        public ActiveEditorDropCodeClip(String string, String string2) {
            this.body = string2;
            this.title = string;
        }

        public boolean handleTransfer(JTextComponent jTextComponent) {
            if (jTextComponent == null) {
                return false;
            }
            String string = CodeClipUtilities.parseClipForParams(this.title, this.body);
            try {
                Document document = jTextComponent.getDocument();
                Caret caret = jTextComponent.getCaret();
                int n = Math.min(caret.getDot(), caret.getMark());
                int n2 = Math.max(caret.getDot(), caret.getMark());
                document.remove(n, n2 - n);
                int n3 = caret.getDot();
                document.insertString(n3, string, null);
            }
            catch (BadLocationException badLocationException) {
                return false;
            }
            return true;
        }
    }
}

