/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.tasklist.projectint;

import java.awt.Image;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collection;
import java.util.Iterator;
import javax.swing.SwingUtilities;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.modules.tasklist.projectint.MainProjectIterator;
import org.netbeans.modules.tasklist.projectint.Utils;
import org.netbeans.spi.project.SubprojectProvider;
import org.netbeans.spi.tasklist.TaskScanningScope;
import org.openide.filesystems.FileObject;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.openide.util.lookup.AbstractLookup;
import org.openide.util.lookup.InstanceContent;
import org.openide.windows.TopComponent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MainProjectScanningScope
extends TaskScanningScope
implements PropertyChangeListener,
Runnable {
    private TaskScanningScope.Callback callback;
    private InstanceContent lookupContent = new InstanceContent();
    private Lookup lookup;
    private Project currentProject;
    private Collection<FileObject> editedFiles;

    private MainProjectScanningScope(String string, String string2, Image image) {
        super(string, string2, image);
    }

    public static MainProjectScanningScope create() {
        return new MainProjectScanningScope(NbBundle.getBundle(MainProjectScanningScope.class).getString("LBL_MainProjectScope"), NbBundle.getBundle(MainProjectScanningScope.class).getString("HINT_MainProjectScope"), Utilities.loadImage((String)"org/netbeans/modules/tasklist/projectint/main_project_scope.png"));
    }

    public Iterator<FileObject> iterator() {
        return new MainProjectIterator(this.editedFiles);
    }

    public boolean isInScope(FileObject fileObject) {
        if (null == fileObject || null == this.currentProject) {
            return false;
        }
        Project project = FileOwnerQuery.getOwner((FileObject)fileObject);
        if (null == project) {
            return false;
        }
        if (project.equals(this.currentProject)) {
            return true;
        }
        Project[] projectArray = OpenProjects.getDefault().getOpenProjects();
        for (int i = 0; i < projectArray.length; ++i) {
            SubprojectProvider subprojectProvider;
            if (projectArray[i].equals(this.currentProject) || null == (subprojectProvider = (SubprojectProvider)projectArray[i].getLookup().lookup(SubprojectProvider.class)) || !subprojectProvider.getSubprojects().contains(this.currentProject) || !projectArray[i].equals(project)) continue;
            return true;
        }
        return false;
    }

    public Lookup getLookup() {
        if (null == this.lookup) {
            this.lookup = new AbstractLookup((AbstractLookup.Content)this.lookupContent);
        }
        return this.lookup;
    }

    public void attach(TaskScanningScope.Callback callback) {
        if (null != callback && null == this.callback) {
            OpenProjects.getDefault().addPropertyChangeListener((PropertyChangeListener)this);
            TopComponent.getRegistry().addPropertyChangeListener((PropertyChangeListener)this);
            this.setLookupContent(OpenProjects.getDefault().getMainProject());
            if (SwingUtilities.isEventDispatchThread()) {
                this.run();
            } else {
                SwingUtilities.invokeLater(this);
            }
        } else if (null == callback && null != this.callback) {
            OpenProjects.getDefault().removePropertyChangeListener((PropertyChangeListener)this);
            TopComponent.getRegistry().removePropertyChangeListener((PropertyChangeListener)this);
            this.editedFiles = null;
            this.setLookupContent(null);
        }
        this.callback = callback;
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if ("MainProject".equals(propertyChangeEvent.getPropertyName())) {
            if (null != this.callback) {
                this.setLookupContent(OpenProjects.getDefault().getMainProject());
                this.callback.refresh();
            }
        } else if ("opened".equals(propertyChangeEvent.getPropertyName())) {
            this.run();
        }
    }

    @Override
    public void run() {
        this.editedFiles = Utils.collectEditedFiles();
    }

    private void setLookupContent(Project project) {
        if (null != this.currentProject) {
            this.lookupContent.remove((Object)this.currentProject);
        }
        if (null != project) {
            this.lookupContent.add((Object)project);
        }
        this.currentProject = project;
    }
}

