/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.api.model;

import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import org.netbeans.modules.vmd.api.model.Debug;
import org.netbeans.modules.vmd.api.model.GlobalDescriptorRegistry;
import org.netbeans.modules.vmd.api.model.PaletteDescriptor;
import org.netbeans.modules.vmd.api.model.PresenterSerializer;
import org.netbeans.modules.vmd.api.model.PropertyDescriptor;
import org.netbeans.modules.vmd.api.model.TypeDescriptor;
import org.netbeans.modules.vmd.api.model.TypeID;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.loaders.DataFolder;
import org.openide.xml.XMLUtil;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComponentSerializationSupport {
    public static void refreshDescriptorRegistry(String string) {
        GlobalDescriptorRegistry globalDescriptorRegistry = GlobalDescriptorRegistry.getGlobalDescriptorRegistry(string);
        DataFolder dataFolder = globalDescriptorRegistry.getRegistryFolder();
        dataFolder.getPrimaryFile().refresh(true);
        DataFolder dataFolder2 = globalDescriptorRegistry.getProducersFolder();
        dataFolder2.getPrimaryFile().refresh(true);
        globalDescriptorRegistry.reload();
    }

    public static void runUnderDescriptorRegistryReadAccess(String string, Runnable runnable) {
        GlobalDescriptorRegistry globalDescriptorRegistry = GlobalDescriptorRegistry.getGlobalDescriptorRegistry(string);
        globalDescriptorRegistry.readAccess(runnable);
    }

    public static void runUnderDescriptorRegistryWriteAccess(String string, Runnable runnable) {
        GlobalDescriptorRegistry globalDescriptorRegistry = GlobalDescriptorRegistry.getGlobalDescriptorRegistry(string);
        globalDescriptorRegistry.writeAccess(runnable);
    }

    public static void serialize(String string, TypeDescriptor typeDescriptor, PaletteDescriptor paletteDescriptor, List<PropertyDescriptor> list, List<PresenterSerializer> list2) {
        assert (string != null && typeDescriptor != null && list != null && list2 != null);
        ComponentSerializationSupport.serializeComponentDescriptor(string, typeDescriptor, null, list, list2);
        if (typeDescriptor.isCanInstantiate()) {
            ComponentSerializationSupport.serializeComponentProducer(string, typeDescriptor.getThisType(), paletteDescriptor);
        }
    }

    private static void serializeComponentDescriptor(String string, TypeDescriptor typeDescriptor, PaletteDescriptor paletteDescriptor, List<PropertyDescriptor> list, List<PresenterSerializer> list2) {
        List<Element> list3;
        Object object3;
        Document document = XMLUtil.createDocument((String)"ComponentDescriptor", null, null, null);
        Node node = document.getFirstChild();
        ComponentSerializationSupport.setAttribute(document, node, "version", "1");
        Element element = document.createElement("TypeDescriptor");
        if (typeDescriptor.getSuperType() != null) {
            ComponentSerializationSupport.setAttribute(document, element, "superTypeID", typeDescriptor.getSuperType().toString());
        }
        ComponentSerializationSupport.setAttribute(document, element, "thisTypeID", typeDescriptor.getThisType().toString());
        ComponentSerializationSupport.setAttribute(document, element, "canDerive", Boolean.toString(typeDescriptor.isCanDerive()));
        ComponentSerializationSupport.setAttribute(document, element, "canInstantiate", Boolean.toString(typeDescriptor.isCanInstantiate()));
        node.appendChild(element);
        if (paletteDescriptor != null) {
            object3 = document.createElement("PaletteDescriptor");
            ComponentSerializationSupport.setAttribute(document, (Node)object3, "displayName", paletteDescriptor.getDisplayName());
            if (paletteDescriptor.getToolTip() != null) {
                ComponentSerializationSupport.setAttribute(document, (Node)object3, "toolTip", paletteDescriptor.getToolTip());
            }
            if (paletteDescriptor.getCategoryID() != null) {
                ComponentSerializationSupport.setAttribute(document, (Node)object3, "preferredCategoryID", paletteDescriptor.getCategoryID());
            }
            if (paletteDescriptor.getSmallIcon() != null) {
                ComponentSerializationSupport.setAttribute(document, (Node)object3, "smallIcon", paletteDescriptor.getSmallIcon());
            }
            if (paletteDescriptor.getLargeIcon() != null) {
                ComponentSerializationSupport.setAttribute(document, (Node)object3, "largeIcon", paletteDescriptor.getLargeIcon());
            }
            node.appendChild((Node)object3);
        }
        for (PropertyDescriptor object22 : list) {
            assert (object22 != null);
            Element element2 = document.createElement("PropertyDescriptor");
            ComponentSerializationSupport.setAttribute(document, element2, "name", object22.getName());
            ComponentSerializationSupport.setAttribute(document, element2, "typeID", object22.getType().toString());
            list3 = object22.getDefaultValue().getUserCode();
            if (list3 != null) {
                ComponentSerializationSupport.setAttribute(document, element2, "defaultValue", (String)((Object)list3));
            }
            ComponentSerializationSupport.setAttribute(document, element2, "allowNull", Boolean.toString(object22.isAllowNull()));
            ComponentSerializationSupport.setAttribute(document, element2, "allowUserCode", Boolean.toString(object22.isAllowUserCode()));
            ComponentSerializationSupport.setAttribute(document, element2, "useForSerialization", Boolean.toString(object22.isUseForSerialization()));
            ComponentSerializationSupport.setAttribute(document, element2, "readOnly", Boolean.toString(object22.isReadOnly()));
            node.appendChild(element2);
        }
        object3 = document.createElement("Presenters");
        for (PresenterSerializer presenterSerializer : list2) {
            list3 = presenterSerializer.serialize(document);
            if (list3 == null) continue;
            for (Element element3 : list3) {
                if (element3 == null) continue;
                object3.appendChild(element3);
            }
        }
        node.appendChild((Node)object3);
        GlobalDescriptorRegistry globalDescriptorRegistry = GlobalDescriptorRegistry.getGlobalDescriptorRegistry(string);
        DataFolder dataFolder = globalDescriptorRegistry.getRegistryFolder();
        if (!ComponentSerializationSupport.writeDocument(dataFolder.getPrimaryFile(), typeDescriptor.getThisType().toString(), "xml", document)) {
            Debug.warning("Error while serializing a component descriptor", typeDescriptor.getThisType().toString());
        }
    }

    private static void serializeComponentProducer(String string, TypeID typeID, PaletteDescriptor paletteDescriptor) {
        GlobalDescriptorRegistry globalDescriptorRegistry;
        DataFolder dataFolder;
        Document document = XMLUtil.createDocument((String)"ComponentProducer", null, null, null);
        Node node = document.getFirstChild();
        ComponentSerializationSupport.setAttribute(document, node, "version", "1");
        ComponentSerializationSupport.setAttribute(document, node, "producerID", typeID.toString());
        ComponentSerializationSupport.setAttribute(document, node, "mainComponentTypeID", typeID.toString());
        ComponentSerializationSupport.setAttribute(document, node, "displayName", paletteDescriptor.getDisplayName());
        if (paletteDescriptor.getToolTip() != null) {
            ComponentSerializationSupport.setAttribute(document, node, "toolTip", paletteDescriptor.getToolTip());
        }
        if (paletteDescriptor.getCategoryID() != null) {
            ComponentSerializationSupport.setAttribute(document, node, "preferredCategoryID", paletteDescriptor.getCategoryID());
        }
        if (paletteDescriptor.getSmallIcon() != null) {
            ComponentSerializationSupport.setAttribute(document, node, "smallIcon", paletteDescriptor.getSmallIcon());
        }
        if (paletteDescriptor.getLargeIcon() != null) {
            ComponentSerializationSupport.setAttribute(document, node, "largeIcon", paletteDescriptor.getLargeIcon());
        }
        if (!ComponentSerializationSupport.writeDocument((dataFolder = (globalDescriptorRegistry = GlobalDescriptorRegistry.getGlobalDescriptorRegistry(string)).getProducersFolder()).getPrimaryFile(), typeID.toString(), "xml", document)) {
            Debug.warning("Error while serializing a component producer", typeID.toString());
        }
    }

    private static void setAttribute(Document document, Node node, String string, String string2) {
        NamedNodeMap namedNodeMap = node.getAttributes();
        Attr attr = document.createAttribute(string);
        attr.setValue(string2);
        namedNodeMap.setNamedItem(attr);
    }

    public static boolean writeDocument(final FileObject fileObject, final String string, final String string2, final Document document) {
        try {
            fileObject.getFileSystem().runAtomicAction(new FileSystem.AtomicAction(){

                public void run() throws IOException {
                    FileObject fileObject2 = fileObject.getFileObject(string, string2);
                    if (fileObject2 == null) {
                        fileObject2 = fileObject.createData(string, string2);
                    }
                    ComponentSerializationSupport.writeDocument(fileObject2, document);
                }
            });
            return true;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeDocument(FileObject fileObject, Document document) throws IOException {
        FileLock fileLock;
        block10: {
            if (fileObject == null) {
                throw new IOException("Null file to write document");
            }
            if (document == null) {
                throw new IOException("Empty document is about to save");
            }
            OutputStream outputStream = null;
            fileLock = null;
            try {
                fileLock = fileObject.lock();
                outputStream = fileObject.getOutputStream(fileLock);
                XMLUtil.write((Document)document, (OutputStream)outputStream, (String)"UTF-8");
                Object var5_4 = null;
                if (outputStream == null) break block10;
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                if (outputStream != null) {
                    try {
                        outputStream.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                if (fileLock != null) {
                    fileLock.releaseLock();
                }
                throw throwable;
            }
            try {
                outputStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (fileLock != null) {
            fileLock.releaseLock();
        }
    }
}

