/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.ui.debugging;

import java.beans.Customizer;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.netbeans.api.debugger.jpda.DeadlockDetector;
import org.netbeans.api.debugger.jpda.JPDADebugger;
import org.netbeans.api.debugger.jpda.JPDAThread;
import org.netbeans.modules.debugger.jpda.ui.debugging.DebuggingView;
import org.openide.util.Exceptions;
import org.openide.util.RequestProcessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ThreadsListener
implements PropertyChangeListener {
    private static ThreadsListener instance;
    private JPDADebugger debugger = null;
    private LinkedList<JPDAThread> currentThreadsHistory = new LinkedList();
    private Set<JPDAThread> threads = new HashSet<JPDAThread>();
    private BreakpointHits hits = new BreakpointHits();
    private DebuggingView debuggingView;

    private ThreadsListener() {
    }

    public static synchronized ThreadsListener getDefault() {
        if (instance == null) {
            instance = new ThreadsListener();
        }
        return instance;
    }

    public void setDebuggingView(DebuggingView debuggingView) {
        this.debuggingView = debuggingView;
    }

    public synchronized void changeDebugger(JPDADebugger jPDADebugger) {
        if (this.debugger == jPDADebugger || jPDADebugger == null) {
            return;
        }
        if (this.debugger != null) {
            this.unregisterListeners();
        }
        this.debugger = jPDADebugger;
        if (jPDADebugger != null) {
            jPDADebugger.addPropertyChangeListener((PropertyChangeListener)this);
            DeadlockDetector deadlockDetector = jPDADebugger.getThreadsCollector().getDeadlockDetector();
            deadlockDetector.addPropertyChangeListener((PropertyChangeListener)this);
            if (deadlockDetector.getDeadlocks() != null) {
                this.setShowDeadlock(true);
            }
            List list = jPDADebugger.getThreadsCollector().getAllThreads();
            for (JPDAThread jPDAThread : list) {
                this.threads.add(jPDAThread);
                ((Customizer)jPDAThread).addPropertyChangeListener(this);
            }
        }
    }

    @Override
    public synchronized void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        Object object = propertyChangeEvent.getSource();
        if (object instanceof JPDADebugger) {
            if ("threadStarted".equals(string)) {
                final JPDAThread jPDAThread = (JPDAThread)propertyChangeEvent.getNewValue();
                if (this.threads.add(jPDAThread)) {
                    ((Customizer)jPDAThread).addPropertyChangeListener(this);
                    RequestProcessor.Task task = RequestProcessor.getDefault().create(new Runnable(){

                        public void run() {
                            if (!ThreadsListener.this.isCurrent(jPDAThread) && ThreadsListener.this.isAtBreakpoint(jPDAThread)) {
                                ThreadsListener.this.addBreakpointHit(jPDAThread);
                            }
                        }
                    });
                    task.schedule(100);
                }
            } else if ("threadDied".equals(string)) {
                JPDAThread jPDAThread = (JPDAThread)propertyChangeEvent.getOldValue();
                if (this.threads.remove(jPDAThread)) {
                    this.currentThreadsHistory.remove(jPDAThread);
                    ((Customizer)jPDAThread).removePropertyChangeListener(this);
                }
            } else if ("currentThread".equals(string)) {
                JPDAThread jPDAThread = this.debugger.getCurrentThread();
                this.removeBreakpointHit(jPDAThread);
                this.currentThreadsHistory.remove(jPDAThread);
                this.currentThreadsHistory.addFirst(jPDAThread);
            } else if ("state".equals(string) && this.debugger.getState() == 4) {
                this.unregisterListeners();
            }
        } else if (object instanceof JPDAThread) {
            final JPDAThread jPDAThread = (JPDAThread)object;
            if ("suspended".equals(string)) {
                RequestProcessor.Task task = RequestProcessor.getDefault().create(new Runnable(){

                    public void run() {
                        if (!ThreadsListener.this.isCurrent(jPDAThread)) {
                            if (ThreadsListener.this.isAtBreakpoint(jPDAThread)) {
                                ThreadsListener.this.addBreakpointHit(jPDAThread);
                            } else {
                                ThreadsListener.this.removeBreakpointHit(jPDAThread);
                            }
                        } else {
                            ThreadsListener.this.removeBreakpointHit(jPDAThread);
                        }
                    }
                });
                task.schedule(100);
            } else if ("lockerThreads".equals(string)) {
                List list;
                try {
                    Method method = jPDAThread.getClass().getMethod("getLockerThreads", new Class[0]);
                    list = (List)method.invoke((Object)jPDAThread, new Object[0]);
                }
                catch (Exception exception) {
                    Exceptions.printStackTrace((Throwable)exception);
                    list = null;
                }
                this.setShowThreadLocks(jPDAThread, list);
            }
        } else if (object instanceof DeadlockDetector && "deadlock".equals(string)) {
            this.setShowDeadlock(true);
        }
    }

    public synchronized List<JPDAThread> getCurrentThreadsHistory() {
        if (this.debugger != null && this.debugger.getState() != 4) {
            ArrayList<JPDAThread> arrayList = new ArrayList<JPDAThread>(this.currentThreadsHistory.size());
            for (JPDAThread jPDAThread : this.currentThreadsHistory) {
                if (!jPDAThread.isSuspended()) continue;
                arrayList.add(jPDAThread);
            }
            return arrayList;
        }
        return Collections.EMPTY_LIST;
    }

    public synchronized List<JPDAThread> getThreads() {
        if (this.debugger != null && this.debugger.getState() != 4) {
            return this.debugger.getThreadsCollector().getAllThreads();
        }
        return Collections.EMPTY_LIST;
    }

    public synchronized int getHitsCount() {
        return this.hits.size();
    }

    public synchronized boolean isBreakpointHit(JPDAThread jPDAThread) {
        return this.hits.contains(jPDAThread);
    }

    public synchronized void goToHit() {
        this.hits.goToHit();
    }

    public JPDADebugger getDebugger() {
        return this.debugger;
    }

    private boolean isCurrent(JPDAThread jPDAThread) {
        return this.debugger.getCurrentThread() == jPDAThread;
    }

    private boolean isAtBreakpoint(JPDAThread jPDAThread) {
        return jPDAThread.getCurrentBreakpoint() != null;
    }

    private void addBreakpointHit(JPDAThread jPDAThread) {
        if (jPDAThread != null && !this.hits.contains(jPDAThread)) {
            this.hits.add(jPDAThread);
            this.debuggingView.getInfoPanel().addBreakpointHit(jPDAThread, this.hits.size());
        }
    }

    private void removeBreakpointHit(JPDAThread jPDAThread) {
        if (jPDAThread != null && this.hits.contains(jPDAThread)) {
            this.hits.remove(jPDAThread);
            this.debuggingView.getInfoPanel().removeBreakpointHit(jPDAThread, this.hits.size());
        }
    }

    private void clearAllHits() {
        this.hits.clear();
        this.debuggingView.getInfoPanel().clearBreakpointHits();
    }

    private void setShowDeadlock(boolean bl) {
        this.debuggingView.getInfoPanel().setShowDeadlock(bl);
    }

    private void setShowThreadLocks(JPDAThread jPDAThread, List<JPDAThread> list) {
        this.debuggingView.getInfoPanel().setShowThreadLocks(jPDAThread, list);
    }

    private synchronized void unregisterListeners() {
        for (JPDAThread jPDAThread : this.threads) {
            ((Customizer)jPDAThread).removePropertyChangeListener(this);
        }
        this.threads.clear();
        this.currentThreadsHistory.clear();
        this.clearAllHits();
        this.setShowDeadlock(false);
        this.debugger.removePropertyChangeListener((PropertyChangeListener)this);
        this.debugger.getThreadsCollector().getDeadlockDetector().removePropertyChangeListener((PropertyChangeListener)this);
    }

    class BreakpointHits {
        private Set<JPDAThread> stoppedThreadsSet = new HashSet<JPDAThread>();
        private LinkedList<JPDAThread> stoppedThreads = new LinkedList();

        BreakpointHits() {
        }

        public void goToHit() {
            JPDAThread jPDAThread = this.stoppedThreads.getLast();
            jPDAThread.makeCurrent();
        }

        public boolean contains(JPDAThread jPDAThread) {
            return this.stoppedThreadsSet.contains(jPDAThread);
        }

        public boolean add(JPDAThread jPDAThread) {
            if (this.stoppedThreadsSet.add(jPDAThread)) {
                this.stoppedThreads.addFirst(jPDAThread);
                return true;
            }
            return false;
        }

        public boolean remove(JPDAThread jPDAThread) {
            if (this.stoppedThreadsSet.remove(jPDAThread)) {
                this.stoppedThreads.remove(jPDAThread);
                return true;
            }
            return false;
        }

        public void clear() {
            this.stoppedThreadsSet.clear();
            this.stoppedThreads.clear();
        }

        public int size() {
            return this.stoppedThreads.size();
        }
    }
}

