/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.ui.debugging;

import java.awt.Container;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.prefs.Preferences;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JToggleButton;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;
import org.openide.util.Utilities;
import org.openide.util.actions.Presenter;

public final class FiltersDescriptor {
    public static final String SUSPEND_SORT = "suspend_sort";
    public static final String NATURAL_SORT = "natural_sort";
    public static final String ALPHABETIC_SORT = "alphabetic_sort";
    public static final String SHOW_QUALIFIED_NAMES = "show_fqn";
    public static final String SHOW_MONITORS = "show_monitors";
    public static final String SHOW_SYSTEM_THREADS = "show_system_threads";
    public static final String SHOW_SUSPEND_TABLE = "show_suspend_table";
    public static final String SHOW_THREAD_GROUPS = "thread_group";
    public static final String SHOW_SUSPENDED_THREADS_ONLY = "suspended_threads_only";
    private static FiltersDescriptor instance;
    private List<Item> filters = new ArrayList<Item>();
    private Action[] filterActions;

    private FiltersDescriptor() {
    }

    public static synchronized FiltersDescriptor getInstance() {
        if (instance == null) {
            instance = FiltersDescriptor.createDebuggingViewFilters();
        }
        return instance;
    }

    public synchronized Action[] getFilterActions() {
        if (this.filterActions == null) {
            ArrayList<SortAction> arrayList = new ArrayList<SortAction>();
            HashMap<Item, SortAction> hashMap = new HashMap<Item, SortAction>();
            for (Item item : this.filters) {
                if (item.getGroup() == null) continue;
                SortAction sortAction = new SortAction(item, hashMap);
                arrayList.add(sortAction);
                hashMap.put(item, sortAction);
            }
            int n = arrayList.size();
            this.filterActions = new Action[n + 2];
            for (int i = 0; i < n; ++i) {
                this.filterActions[i] = (Action)arrayList.get(i);
            }
            this.filterActions[n] = null;
            this.filterActions[n + 1] = new FilterSubmenuAction(this);
        }
        return this.filterActions;
    }

    public int getFilterCount() {
        return this.filters.size();
    }

    public String getName(int n) {
        return this.filters.get((int)n).name;
    }

    public String getDisplayName(int n) {
        return this.filters.get((int)n).displayName;
    }

    public String getTooltip(int n) {
        return this.filters.get((int)n).tooltip;
    }

    public Icon getSelectedIcon(int n) {
        return this.filters.get((int)n).selectedIcon;
    }

    public boolean isSelected(int n) {
        return this.filters.get(n).isSelected;
    }

    public void setSelected(int n, boolean bl) {
        this.filters.get(n).setSelected(bl);
    }

    public void setSelected(String string, boolean bl) {
        for (Item item : this.filters) {
            if (!item.getName().equals(string)) continue;
            item.setSelected(bl);
            break;
        }
    }

    public void connectToggleButton(int n, JToggleButton jToggleButton) {
        this.filters.get(n).setToggleButton(jToggleButton);
    }

    private static FiltersDescriptor createDebuggingViewFilters() {
        FiltersDescriptor filtersDescriptor = new FiltersDescriptor();
        filtersDescriptor.addItem(new Item(SHOW_THREAD_GROUPS, FiltersDescriptor.getString("LBL_THREAD_GROUPS"), FiltersDescriptor.getString("LBL_THREAD_GROUPS_TIP"), false, FiltersDescriptor.loadIcon("thread_group_mixed_16.png")));
        filtersDescriptor.addItem(new Item(SHOW_SUSPEND_TABLE, FiltersDescriptor.getString("LBL_SUSPEND_TABLE"), FiltersDescriptor.getString("LBL_SUSPEND_TABLE_TIP"), false, FiltersDescriptor.loadIcon("show_suspend_table_option_16.png")));
        filtersDescriptor.addItem(new Item(SHOW_SYSTEM_THREADS, FiltersDescriptor.getString("LBL_SYSTEM_THREADS"), FiltersDescriptor.getString("LBL_SYSTEM_THREADS_TIP"), false, FiltersDescriptor.loadIcon("show_system_threads_option_16.png")));
        filtersDescriptor.addItem(new Item(SHOW_SUSPENDED_THREADS_ONLY, FiltersDescriptor.getString("LBL_SUPSENDED_THREADS_ONLY"), FiltersDescriptor.getString("LBL_SUPSENDED_THREADS_ONLY_TIP"), false, FiltersDescriptor.loadIcon("show_suspended_threads_option_16.png")));
        filtersDescriptor.addItem(new Item(SHOW_MONITORS, FiltersDescriptor.getString("LBL_MONITORS"), FiltersDescriptor.getString("LBL_MONITORS_TIP"), false, FiltersDescriptor.loadIcon("monitor_acquired_16.png")));
        filtersDescriptor.addItem(new Item(SHOW_QUALIFIED_NAMES, FiltersDescriptor.getString("LBL_QUALIFIED_NAMES"), FiltersDescriptor.getString("LBL_QUALIFIED_NAMES_TIP"), false, FiltersDescriptor.loadIcon("show_fqn_option_16.png")));
        ArrayList<Item> arrayList = new ArrayList<Item>();
        Group group = new Group();
        Item item = new Item(SUSPEND_SORT, FiltersDescriptor.getString("LBL_SUSPEND_SORT"), FiltersDescriptor.getString("LBL_SUSPEND_SORT_TIP"), false, FiltersDescriptor.loadIcon("suspend_property_sort_order_16.png"));
        arrayList.add(item);
        filtersDescriptor.addItem(item);
        item.setGroup(group);
        item = new Item(ALPHABETIC_SORT, FiltersDescriptor.getString("LBL_ALPHABETIC_SORT"), FiltersDescriptor.getString("LBL_ALPHABETIC_SORT_TIP"), false, FiltersDescriptor.loadIcon("alphabetic_sort_order_16.png"));
        arrayList.add(item);
        filtersDescriptor.addItem(item);
        item.setGroup(group);
        item = new Item(NATURAL_SORT, FiltersDescriptor.getString("LBL_NATURAL_SORT"), FiltersDescriptor.getString("LBL_NATURAL_SORT_TIP"), true, FiltersDescriptor.loadIcon("natural_sort_order_16.png"));
        arrayList.add(item);
        filtersDescriptor.addItem(item);
        item.setGroup(group);
        group.setItems(arrayList);
        return filtersDescriptor;
    }

    private void addItem(Item item) {
        this.filters.add(item);
    }

    private static Icon loadIcon(String string) {
        return new ImageIcon(Utilities.loadImage((String)("org/netbeans/modules/debugger/jpda/resources/" + string)));
    }

    private static String getString(String string) {
        return NbBundle.getMessage(FiltersDescriptor.class, (String)string);
    }

    static final class FilterSubmenuAction
    extends AbstractAction
    implements Presenter.Popup {
        private static final String PROP_FILTER_NAME = "nbFilterName";
        private FiltersDescriptor filtersDesc;

        public FilterSubmenuAction(FiltersDescriptor filtersDescriptor) {
            this.filtersDesc = filtersDescriptor;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            if (object instanceof JCheckBoxMenuItem) {
                JCheckBoxMenuItem jCheckBoxMenuItem = (JCheckBoxMenuItem)object;
                String string = (String)jCheckBoxMenuItem.getClientProperty(PROP_FILTER_NAME);
                this.filtersDesc.setSelected(string, jCheckBoxMenuItem.isSelected());
            }
        }

        public final JMenuItem getPopupPresenter() {
            return this.createSubmenu();
        }

        private JMenuItem createSubmenu() {
            JMenu jMenu = new JMenu(NbBundle.getMessage(FiltersDescriptor.class, (String)"LBL_FilterSubmenu"));
            for (Item item : this.filtersDesc.filters) {
                if (item.getGroup() != null) continue;
                String string = item.getName();
                JCheckBoxMenuItem jCheckBoxMenuItem = new JCheckBoxMenuItem(item.getDisplayName(), item.isSelected());
                jCheckBoxMenuItem.addActionListener(this);
                jCheckBoxMenuItem.putClientProperty(PROP_FILTER_NAME, string);
                ((Container)jMenu).add(jCheckBoxMenuItem);
            }
            return jMenu;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class SortAction
    extends AbstractAction
    implements Presenter.Popup {
        private JRadioButtonMenuItem menuItem;
        private Item filterItem;
        private Map<Item, SortAction> itemToSortAction;

        SortAction(Item item, Map<Item, SortAction> map) {
            this.filterItem = item;
            this.itemToSortAction = map;
            this.putValue("Name", item.getDisplayName());
            this.putValue("SmallIcon", item.getIcon());
        }

        public final JMenuItem getPopupPresenter() {
            JRadioButtonMenuItem jRadioButtonMenuItem = this.obtainMenuItem();
            this.updateMenuItem();
            return jRadioButtonMenuItem;
        }

        protected final JRadioButtonMenuItem obtainMenuItem() {
            if (this.menuItem == null) {
                this.menuItem = new JRadioButtonMenuItem((String)this.getValue("Name"));
                this.menuItem.setAction(this);
            }
            return this.menuItem;
        }

        protected void updateMenuItem() {
            JRadioButtonMenuItem jRadioButtonMenuItem = this.obtainMenuItem();
            jRadioButtonMenuItem.setSelected(this.filterItem.isSelected());
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            for (Map.Entry<Item, SortAction> entry : this.itemToSortAction.entrySet()) {
                Item item = entry.getKey();
                SortAction sortAction = entry.getValue();
                item.setSelected(item == this.filterItem);
                sortAction.updateMenuItem();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class Group {
        List<Item> items = Collections.EMPTY_LIST;

        Group() {
        }

        public void setItems(List<Item> list) {
            this.items = list;
            for (Item item : list) {
                item.setGroup(this);
            }
        }

        public List<Item> getItems() {
            return this.items;
        }
    }

    static class Item {
        String name;
        String displayName;
        String tooltip;
        Icon selectedIcon;
        private boolean isSelected;
        private Group group;
        private JToggleButton toggleButton;

        Item(String string, String string2, String string3, boolean bl, Icon icon) {
            this.name = string;
            this.displayName = string2;
            this.tooltip = string3;
            this.selectedIcon = icon;
            this.isSelected = bl;
            this.readValue();
        }

        private Group getGroup() {
            return this.group;
        }

        public void setGroup(Group group) {
            this.group = group;
        }

        public String getName() {
            return this.name;
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public Icon getIcon() {
            return this.selectedIcon;
        }

        public boolean isSelected() {
            return this.isSelected;
        }

        public void setSelected(boolean bl) {
            if (this.isSelected == bl) {
                return;
            }
            this.isSelected = bl;
            this.toggleButton.setSelected(bl);
            if (bl && this.group != null) {
                for (Item item : this.group.getItems()) {
                    if (item == this || !item.isSelected()) continue;
                    JToggleButton jToggleButton = item.getToggleButton();
                    item.isSelected = false;
                    item.writeValue();
                    jToggleButton.setSelected(false);
                }
            }
            this.writeValue();
        }

        public JToggleButton getToggleButton() {
            return this.toggleButton;
        }

        public void setToggleButton(JToggleButton jToggleButton) {
            this.toggleButton = jToggleButton;
        }

        private void readValue() {
            Preferences preferences = NbPreferences.forModule(this.getClass()).node("debugging");
            this.isSelected = this.name.equals(FiltersDescriptor.SHOW_SYSTEM_THREADS) ? preferences.getBoolean("show.systemThreads", false) : (this.name.equals(FiltersDescriptor.SHOW_THREAD_GROUPS) ? preferences.getBoolean("show.threadGroups", false) : (this.name.equals(FiltersDescriptor.ALPHABETIC_SORT) ? preferences.getBoolean("sort.alphabet", true) : (this.name.equals(FiltersDescriptor.SUSPEND_SORT) ? preferences.getBoolean("sort.suspend", false) : (this.name.equals(FiltersDescriptor.SHOW_SUSPENDED_THREADS_ONLY) ? preferences.getBoolean("show.suspendedThreadsOnly", false) : (this.name.equals(FiltersDescriptor.NATURAL_SORT) ? !preferences.getBoolean("sort.alphabet", true) && !preferences.getBoolean("sort.suspend", false) : (this.name.equals(FiltersDescriptor.SHOW_MONITORS) ? preferences.getBoolean("show.monitors", false) : (this.name.equals(FiltersDescriptor.SHOW_QUALIFIED_NAMES) ? preferences.getBoolean("show.packageNames", false) : (this.name.equals(FiltersDescriptor.SHOW_SUSPEND_TABLE) ? preferences.getBoolean(FiltersDescriptor.SHOW_SUSPEND_TABLE, true) : false))))))));
        }

        private void writeValue() {
            String string = null;
            Preferences preferences = NbPreferences.forModule(this.getClass()).node("debugging");
            if (this.name.equals(FiltersDescriptor.SHOW_SYSTEM_THREADS)) {
                string = "show.systemThreads";
            } else if (this.name.equals(FiltersDescriptor.SHOW_THREAD_GROUPS)) {
                string = "show.threadGroups";
            } else if (this.name.equals(FiltersDescriptor.SHOW_SUSPENDED_THREADS_ONLY)) {
                string = "show.suspendedThreadsOnly";
            } else if (this.name.equals(FiltersDescriptor.ALPHABETIC_SORT)) {
                string = "sort.alphabet";
            } else if (this.name.equals(FiltersDescriptor.SUSPEND_SORT)) {
                string = "sort.suspend";
            } else if (this.name.equals(FiltersDescriptor.SHOW_MONITORS)) {
                string = "show.monitors";
            } else if (this.name.equals(FiltersDescriptor.SHOW_QUALIFIED_NAMES)) {
                string = "show.packageNames";
            } else if (this.name.equals(FiltersDescriptor.SHOW_SUSPEND_TABLE)) {
                string = FiltersDescriptor.SHOW_SUSPEND_TABLE;
            }
            if (string != null) {
                preferences.putBoolean(string, this.isSelected);
            }
        }
    }
}

