/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.ui.debugging;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.EventListener;
import java.util.HashSet;
import java.util.Set;
import java.util.prefs.PreferenceChangeEvent;
import java.util.prefs.PreferenceChangeListener;
import java.util.prefs.Preferences;
import javax.swing.Action;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.netbeans.api.debugger.DebuggerEngine;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.api.debugger.Session;
import org.netbeans.api.debugger.jpda.DeadlockDetector;
import org.netbeans.api.debugger.jpda.JPDADebugger;
import org.netbeans.api.debugger.jpda.JPDAThread;
import org.netbeans.api.debugger.jpda.JPDAThreadGroup;
import org.netbeans.modules.debugger.jpda.ui.debugging.ClickableIcon;
import org.netbeans.modules.debugger.jpda.ui.debugging.DebugTreeView;
import org.netbeans.modules.debugger.jpda.ui.debugging.FiltersDescriptor;
import org.netbeans.modules.debugger.jpda.ui.debugging.InfoPanel;
import org.netbeans.modules.debugger.jpda.ui.debugging.TapPanel;
import org.netbeans.modules.debugger.jpda.ui.debugging.ThreadsListener;
import org.netbeans.modules.debugger.jpda.ui.views.ViewModelListener;
import org.netbeans.spi.viewmodel.Models;
import org.netbeans.spi.viewmodel.TreeExpansionModel;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.ExplorerUtils;
import org.openide.explorer.view.TreeView;
import org.openide.explorer.view.Visualizer;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;
import org.openide.util.WeakListeners;
import org.openide.windows.Mode;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

public class DebuggingView
extends TopComponent
implements HelpCtx.Provider,
ExplorerManager.Provider,
PropertyChangeListener,
TreeExpansionListener,
TreeModelListener,
AdjustmentListener,
ChangeListener {
    private static final String ID = "debugging";
    public static final int BAR_WIDTH = 8;
    static final Color hitsColor = new Color(255, 255, 178);
    static final Color hitsBarColor = new Color(230, 230, 130);
    static final Color deadlockColor = UIManager.getDefaults().getColor("nb.errorForeground");
    static final Color greenBarColor = new Color(189, 230, 170);
    private transient Color treeBackgroundColor = UIManager.getDefaults().getColor("Tree.background");
    private transient RequestProcessor requestProcessor = new RequestProcessor("DebuggingView Refresh Scheduler", 1);
    private transient boolean refreshScheduled = false;
    private transient ExplorerManager manager = new ExplorerManager();
    private transient ViewModelListener viewModelListener;
    private Preferences preferences = NbPreferences.forModule(this.getClass()).node("debugging");
    private PreferenceChangeListener prefListener;
    private SessionsComboBoxListener sessionsComboListener;
    private transient ImageIcon resumeIcon;
    private transient ImageIcon focusedResumeIcon;
    private transient ImageIcon pressedResumeIcon;
    private transient ImageIcon suspendIcon;
    private transient ImageIcon focusedSuspendIcon;
    private transient ImageIcon pressedSuspendIcon;
    private DebugTreeView treeView;
    private TapPanel tapPanel;
    private InfoPanel infoPanel;
    private JPDADebugger debugger;
    private Session session;
    private JPDADebugger previousDebugger;
    private BarsPanel leftPanel;
    private IconsPanel rightPanel;
    private final ThreadsListener threadsListener;
    private transient Reference<TopComponent> lastSelectedTCRef;
    private transient Reference<TopComponent> componentToActivateAfterClose;
    private static Reference<DebuggingView> instance = null;
    private JPanel leftPanel1;
    private JPanel mainPanel;
    private JScrollPane mainScrollPane;
    private JPanel rightPanel1;
    private JPanel scrollBarPanel;
    private JComboBox sessionComboBox;
    private JScrollBar treeScrollBar;

    public DebuggingView() {
        this.setIcon(Utilities.loadImage((String)"org/netbeans/modules/debugger/jpda/resources/debugging.png"));
        this.putClientProperty("KeepNonPersistentTCInModelWhenClosed", Boolean.TRUE);
        this.initComponents();
        this.threadsListener = ThreadsListener.getDefault();
        this.threadsListener.setDebuggingView(this);
        this.resumeIcon = new ImageIcon(Utilities.loadImage((String)"org/netbeans/modules/debugger/jpda/resources/resume_button_16.png"));
        this.focusedResumeIcon = new ImageIcon(Utilities.loadImage((String)"org/netbeans/modules/debugger/jpda/resources/resume_button_focused_16.png"));
        this.pressedResumeIcon = new ImageIcon(Utilities.loadImage((String)"org/netbeans/modules/debugger/jpda/resources/resume_button_pressed_16.png"));
        this.suspendIcon = new ImageIcon(Utilities.loadImage((String)"org/netbeans/modules/debugger/jpda/resources/suspend_button_16.png"));
        this.focusedSuspendIcon = new ImageIcon(Utilities.loadImage((String)"org/netbeans/modules/debugger/jpda/resources/suspend_button_focused_16.png"));
        this.pressedSuspendIcon = new ImageIcon(Utilities.loadImage((String)"org/netbeans/modules/debugger/jpda/resources/suspend_button_pressed_16.png"));
        this.setBackground(this.treeBackgroundColor);
        this.treeView = new DebugTreeView();
        this.treeView.setRootVisible(false);
        this.treeView.setHorizontalScrollBarPolicy(31);
        this.treeView.setVerticalScrollBarPolicy(21);
        this.treeView.getAccessibleContext().setAccessibleName(NbBundle.getMessage(DebuggingView.class, (String)"DebuggingView.treeView.AccessibleContext.accessibleName"));
        this.treeView.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(DebuggingView.class, (String)"DebuggingView.treeView.AccessibleContext.accessibleDescription"));
        this.mainPanel.add((Component)((Object)this.treeView), "Center");
        this.leftPanel = new BarsPanel();
        this.rightPanel = new IconsPanel();
        this.mainPanel.add((Component)this.leftPanel, "West");
        this.mainPanel.add((Component)this.rightPanel, "East");
        this.tapPanel = new TapPanel();
        this.tapPanel.setOrientation(2);
        this.tapPanel.setExpanded(true);
        this.infoPanel = new InfoPanel(this.tapPanel);
        this.tapPanel.add(this.infoPanel);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        this.add(this.tapPanel, gridBagConstraints);
        this.manager.addPropertyChangeListener((PropertyChangeListener)this);
        this.treeView.addTreeExpansionListener(this);
        TreeModel treeModel = this.treeView.getTree().getModel();
        treeModel.addTreeModelListener(this);
        this.prefListener = new DebuggingPreferenceChangeListener();
        this.preferences.addPreferenceChangeListener((PreferenceChangeListener)WeakListeners.create(PreferenceChangeListener.class, (EventListener)this.prefListener, (Object)this.preferences));
        this.sessionsComboListener = new SessionsComboBoxListener();
        this.scrollBarPanel.setVisible(false);
        this.treeScrollBar.addAdjustmentListener(this);
        this.treeView.getViewport().addChangeListener(this);
        this.setSuspendTableVisible(this.preferences.getBoolean("show_suspend_table", true));
    }

    private void initComponents() {
        this.sessionComboBox = new JComboBox();
        this.mainScrollPane = new JScrollPane();
        this.mainPanel = new JPanel();
        this.scrollBarPanel = new JPanel();
        this.treeScrollBar = new JScrollBar();
        this.leftPanel1 = new JPanel();
        this.rightPanel1 = new JPanel();
        this.setLayout(new GridBagLayout());
        this.sessionComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"Java Project"}));
        this.sessionComboBox.setMaximumSize(new Dimension(Short.MAX_VALUE, 20));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        this.add(this.sessionComboBox, gridBagConstraints);
        this.sessionComboBox.getAccessibleContext().setAccessibleName(NbBundle.getMessage(DebuggingView.class, (String)"DebuggingView.sessionComboBox.AccessibleContext.accessibleName"));
        this.sessionComboBox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(DebuggingView.class, (String)"DebuggingView.sessionComboBox.AccessibleContext.accessibleDescription"));
        this.mainScrollPane.setBorder(null);
        this.mainScrollPane.setHorizontalScrollBarPolicy(31);
        this.mainScrollPane.setPreferredSize(new Dimension(32, 10));
        this.mainPanel.setLayout(new BorderLayout());
        this.mainScrollPane.setViewportView(this.mainPanel);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add(this.mainScrollPane, gridBagConstraints);
        this.scrollBarPanel.setMaximumSize(new Dimension(Integer.MAX_VALUE, 17));
        this.scrollBarPanel.setLayout(new BorderLayout());
        this.treeScrollBar.setOrientation(0);
        this.scrollBarPanel.add((Component)this.treeScrollBar, "Center");
        this.leftPanel1.setPreferredSize(new Dimension(8, 0));
        this.leftPanel1.setLayout(new FlowLayout(0, 0, 0));
        this.scrollBarPanel.add((Component)this.leftPanel1, "West");
        this.rightPanel1.setPreferredSize(new Dimension(24, 0));
        this.rightPanel1.setLayout(new FlowLayout(1, 0, 0));
        this.scrollBarPanel.add((Component)this.rightPanel1, "East");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        this.add(this.scrollBarPanel, gridBagConstraints);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRootContext(Models.CompoundModel compoundModel, DebuggerEngine debuggerEngine) {
        Object object = this.manager.getRootContext();
        if (object != null) {
            try {
                object.destroy();
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
            }
        }
        if (debuggerEngine != null) {
            object = (JPDADebugger)debuggerEngine.lookupFirst(null, JPDADebugger.class);
            DebuggingView debuggingView = this;
            synchronized (debuggingView) {
                if (this.previousDebugger != null) {
                    this.previousDebugger.removePropertyChangeListener((PropertyChangeListener)this);
                }
                this.previousDebugger = this.debugger;
                this.debugger = object;
                if (object != null) {
                    this.session = (Session)debuggerEngine.lookupFirst(null, Session.class);
                    object.addPropertyChangeListener((PropertyChangeListener)this);
                } else {
                    this.session = null;
                }
            }
            RequestProcessor.getDefault().post(new Runnable((JPDADebugger)object){
                final /* synthetic */ JPDADebugger val$deb;
                {
                    this.val$deb = jPDADebugger;
                }

                public void run() {
                    DebuggingView.this.threadsListener.changeDebugger(this.val$deb);
                }
            });
        } else {
            object = this;
            synchronized (object) {
                if (this.previousDebugger != null) {
                    this.previousDebugger.removePropertyChangeListener((PropertyChangeListener)this);
                }
                this.previousDebugger = null;
                this.debugger = null;
                this.session = null;
            }
            this.threadsListener.changeDebugger(null);
        }
        if (compoundModel == null) {
            object = Node.EMPTY;
        } else {
            object = Models.createNodes((Models.CompoundModel)compoundModel, (TreeView)this.treeView);
            this.treeView.setExpansionModel((TreeExpansionModel)compoundModel);
        }
        this.manager.setRootContext(object);
        this.refreshView();
        this.adjustTreeScrollBar();
    }

    public ExplorerManager getExplorerManager() {
        return this.manager;
    }

    public static DebuggingView getInstance() {
        DebuggingView debuggingView = (DebuggingView)WindowManager.getDefault().findTopComponent(ID);
        if (debuggingView == null) {
            debuggingView = DebuggingView.getDefault();
        }
        return debuggingView;
    }

    public Action[] getFilterActions() {
        return FiltersDescriptor.getInstance().getFilterActions();
    }

    public void setSuspendTableVisible(boolean bl) {
        this.rightPanel.setVisible(bl);
    }

    public static synchronized DebuggingView getDefault() {
        DebuggingView debuggingView;
        if (instance == null) {
            debuggingView = new DebuggingView();
            instance = new WeakReference<DebuggingView>(debuggingView);
        } else {
            debuggingView = instance.get();
            if (debuggingView == null) {
                debuggingView = new DebuggingView();
                instance = new WeakReference<DebuggingView>(debuggingView);
            }
        }
        return debuggingView;
    }

    protected String preferredID() {
        return this.getClass().getName();
    }

    protected void componentShowing() {
        super.componentShowing();
        if (this.viewModelListener != null) {
            this.viewModelListener.setUp();
            return;
        }
        if (this.viewModelListener != null) {
            throw new InternalError();
        }
        this.viewModelListener = new ViewModelListener("DebuggingView", (JComponent)((Object)this));
    }

    protected void componentHidden() {
        super.componentHidden();
        this.viewModelListener.destroy();
    }

    protected void componentActivated() {
        ExplorerUtils.activateActions((ExplorerManager)this.manager, (boolean)true);
    }

    protected void componentDeactivated() {
        ExplorerUtils.activateActions((ExplorerManager)this.manager, (boolean)false);
    }

    protected void componentOpened() {
        super.componentOpened();
        Mode mode = WindowManager.getDefault().findMode((TopComponent)this);
        this.lastSelectedTCRef = new WeakReference<TopComponent>(mode.getSelectedTopComponent());
        this.requestActive();
    }

    public boolean canClose() {
        Mode mode = WindowManager.getDefault().findMode((TopComponent)this);
        this.componentToActivateAfterClose = mode.getSelectedTopComponent() == this ? this.lastSelectedTCRef : null;
        return super.canClose();
    }

    protected void componentClosed() {
        TopComponent topComponent;
        TopComponent topComponent2 = topComponent = this.componentToActivateAfterClose != null ? this.componentToActivateAfterClose.get() : null;
        if (topComponent != null) {
            topComponent.requestActive();
        }
        super.componentClosed();
    }

    public int getPersistenceType() {
        return 0;
    }

    public boolean requestFocusInWindow() {
        return this.treeView.requestFocusInWindow();
    }

    public String getName() {
        return NbBundle.getMessage(DebuggingView.class, (String)"CTL_Debugging_view");
    }

    public String getToolTipText() {
        return NbBundle.getMessage(DebuggingView.class, (String)"CTL_Debugging_tooltip");
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        if ("rootContext".equals(string) || "nodeChange".equals(string)) {
            this.refreshView();
        } else if ("currentThread".equals(string)) {
            this.refreshView();
        } else if (string.equals("selectedNodes")) {
            this.setActivatedNodes((Node[])propertyChangeEvent.getNewValue());
        }
    }

    private static boolean isJPDASession(Session session) {
        DebuggerEngine debuggerEngine = session.getCurrentEngine();
        if (debuggerEngine == null) {
            return false;
        }
        return debuggerEngine.lookupFirst(null, JPDADebugger.class) != null;
    }

    private void updateSessionsComboBox() {
        this.sessionComboBox.removeActionListener(this.sessionsComboListener);
        ComboBoxModel comboBoxModel = this.sessionComboBox.getModel();
        this.sessionComboBox.removeAllItems();
        DebuggerManager debuggerManager = DebuggerManager.getDebuggerManager();
        Session[] sessionArray = debuggerManager.getSessions();
        for (int i = 0; i < sessionArray.length; ++i) {
            if (!DebuggingView.isJPDASession(sessionArray[i])) continue;
            this.sessionComboBox.addItem(new SessionItem(sessionArray[i]));
        }
        if (comboBoxModel.getSize() == 0) {
            this.sessionComboBox.addItem(new SessionItem(null));
        }
        this.sessionComboBox.setSelectedItem(new SessionItem(debuggerManager.getCurrentSession()));
        this.sessionComboBox.addActionListener(this.sessionsComboListener);
    }

    public void treeExpanded(TreeExpansionEvent treeExpansionEvent) {
        this.refreshView();
    }

    public void treeCollapsed(TreeExpansionEvent treeExpansionEvent) {
        this.refreshView();
    }

    public void treeNodesChanged(TreeModelEvent treeModelEvent) {
        this.refreshView();
    }

    public void treeNodesInserted(TreeModelEvent treeModelEvent) {
        this.refreshView();
    }

    public void treeNodesRemoved(TreeModelEvent treeModelEvent) {
        this.refreshView();
    }

    public void treeStructureChanged(TreeModelEvent treeModelEvent) {
        this.refreshView();
    }

    InfoPanel getInfoPanel() {
        return this.infoPanel;
    }

    void refreshView() {
        if (this.refreshScheduled) {
            return;
        }
        this.refreshScheduled = true;
        this.requestProcessor.post(new Runnable(){

            public void run() {
                SwingUtilities.invokeLater(new ViewRefresher());
            }
        }, 25);
    }

    private void adjustTreeScrollBar() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                JViewport jViewport = DebuggingView.this.treeView.getViewport();
                Point point = jViewport.getViewPosition();
                if (point.y < 0) {
                    jViewport.setViewPosition(new Point(point.x, 0));
                }
                Dimension dimension = jViewport.getExtentSize();
                Dimension dimension2 = jViewport.getViewSize();
                if (dimension2.width <= dimension.width) {
                    DebuggingView.this.scrollBarPanel.setVisible(false);
                } else {
                    DebuggingView.this.scrollBarPanel.setVisible(true);
                    DebuggingView.this.treeScrollBar.setMaximum(dimension2.width);
                    DebuggingView.this.treeScrollBar.setVisibleAmount(dimension.width);
                }
            }
        });
    }

    public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
        JViewport jViewport = this.treeView.getViewport();
        Point point = jViewport.getViewPosition();
        Dimension dimension = jViewport.getExtentSize();
        Rectangle rectangle = new Rectangle(adjustmentEvent.getValue(), point.y, dimension.width, dimension.height);
        ((JComponent)jViewport.getView()).scrollRectToVisible(rectangle);
    }

    public void stateChanged(ChangeEvent changeEvent) {
        this.adjustTreeScrollBar();
    }

    private class SessionItem {
        private Session session;

        SessionItem(Session session) {
            this.session = session;
        }

        public Session getSession() {
            return this.session;
        }

        public String toString() {
            if (this.session != null) {
                return this.session.getName();
            }
            return '<' + NbBundle.getMessage(DebuggingView.class, (String)"LBL_No_Session_Running") + '>';
        }

        public boolean equals(Object object) {
            if (!(object instanceof SessionItem)) {
                return false;
            }
            Session session = ((SessionItem)object).getSession();
            if (this.session == null) {
                return session == null;
            }
            return this.session.equals(session);
        }

        public int hashCode() {
            return 87 + (this.session != null ? this.session.hashCode() : 0);
        }
    }

    private class SessionsComboBoxListener
    implements ActionListener {
        private SessionsComboBoxListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            SessionItem sessionItem = (SessionItem)DebuggingView.this.sessionComboBox.getSelectedItem();
            if (sessionItem != null) {
                Session session = sessionItem.getSession();
                DebuggerManager debuggerManager = DebuggerManager.getDebuggerManager();
                if (session != null && session != debuggerManager.getCurrentSession()) {
                    debuggerManager.setCurrentSession(session);
                }
            }
        }
    }

    private class IconsPanel
    extends JPanel {
        private int endSY;
        private int counter;
        private ArrayList<IconItem> icons = new ArrayList();

        IconsPanel() {
            this.setBackground(DebuggingView.this.treeBackgroundColor);
            this.setPreferredSize(new Dimension(24, 0));
            this.setLayout(new FlowLayout(0, 0, 0));
        }

        public void startReset() {
            this.counter = 0;
            this.endSY = 0;
        }

        public void endReset() {
            int n = this.icons.size();
            for (int i = n - 1; i >= this.counter; --i) {
                this.remove(i);
                this.icons.remove(i);
            }
        }

        public void addIcon(int n, int n2, int n3, JPDAThread jPDAThread) {
            int n4 = n2 - this.endSY + n3;
            if (this.counter < this.icons.size()) {
                IconItem iconItem = this.icons.get(this.counter);
                iconItem.icon.changeThread(jPDAThread, (Container)((Object)DebuggingView.this), n, n2, 24, n4);
                iconItem.panel.setPreferredSize(new Dimension(24, n4));
                iconItem.height = n4;
            } else {
                JPanel jPanel = new JPanel(new GridBagLayout());
                jPanel.setBackground(DebuggingView.this.treeBackgroundColor);
                jPanel.setOpaque(false);
                jPanel.setPreferredSize(new Dimension(24, n4));
                ClickableIcon clickableIcon = new ClickableIcon(DebuggingView.this.resumeIcon, DebuggingView.this.focusedResumeIcon, DebuggingView.this.pressedResumeIcon, DebuggingView.this.suspendIcon, DebuggingView.this.focusedSuspendIcon, DebuggingView.this.pressedSuspendIcon, jPDAThread, DebuggingView.this.treeView);
                clickableIcon.setBackground(DebuggingView.this.treeBackgroundColor);
                GridBagConstraints gridBagConstraints = new GridBagConstraints();
                gridBagConstraints.gridx = 0;
                gridBagConstraints.gridy = 0;
                gridBagConstraints.anchor = 15;
                gridBagConstraints.weightx = 1.0;
                gridBagConstraints.weighty = 1.0;
                int n5 = n3 - 16;
                int n6 = n5 / 2;
                int n7 = n5 - n6;
                gridBagConstraints.insets = new Insets(n6, 0, n7, 0);
                jPanel.add((Component)clickableIcon, gridBagConstraints);
                clickableIcon.initializeState((Container)((Object)DebuggingView.this), n, n2, 24, n4);
                IconItem iconItem = new IconItem(n4, clickableIcon, jPanel);
                this.icons.add(iconItem);
                this.add(jPanel);
            }
            ++this.counter;
            this.endSY += n4;
        }

        protected void paintComponent(Graphics graphics) {
            super.paintComponent(graphics);
            DebuggingView.this.treeView.paintStripes(graphics, this);
        }

        private class IconItem {
            private int height;
            private ClickableIcon icon;
            private JPanel panel;

            IconItem(int n, ClickableIcon clickableIcon, JPanel jPanel) {
                this.height = n;
                this.icon = clickableIcon;
                this.panel = jPanel;
            }
        }
    }

    private class BarsPanel
    extends JPanel
    implements MouseMotionListener {
        private ArrayList<Bar> bars = new ArrayList();

        BarsPanel() {
            this.setBackground(DebuggingView.this.treeBackgroundColor);
            this.setPreferredSize(new Dimension(8, 0));
            this.setLayout(new FlowLayout(0, 0, 0));
            this.addMouseMotionListener(this);
        }

        public void clearBars() {
            this.bars.clear();
        }

        public void addBar(boolean bl, boolean bl2, boolean bl3, int n, int n2) {
            String string = null;
            Color color = null;
            Color color2 = null;
            if (bl3) {
                color = deadlockColor;
                string = NbBundle.getMessage(DebuggingView.class, (String)"LBL_DEADLOCKED_THREAD_TIP");
            } else if (bl) {
                color = greenBarColor;
                string = NbBundle.getMessage(DebuggingView.class, (String)"LBL_CURRENT_BAR_TIP");
            } else if (bl2) {
                color = hitsBarColor;
                string = NbBundle.getMessage(DebuggingView.class, (String)"LBL_BREAKPOINT_HIT_TIP");
            }
            if (bl && bl3) {
                color2 = greenBarColor;
                string = NbBundle.getMessage(DebuggingView.class, (String)"LBL_CURRENT_DEADLOCKED_TIP");
            }
            Bar bar = new Bar(n2, n, color, color2, string);
            this.bars.add(bar);
        }

        public void paintComponent(Graphics graphics) {
            super.paintComponent(graphics);
            Color color = graphics.getColor();
            Rectangle rectangle = graphics.getClipBounds();
            double d = rectangle.getY();
            double d2 = d + rectangle.getHeight() - 1.0;
            int n = (int)this.getBounds().getWidth();
            for (Bar bar : this.bars) {
                Rectangle rectangle2;
                if ((double)(bar.sy + bar.height - 1) < d) continue;
                if ((double)bar.sy > d2) break;
                if (bar.color != null) {
                    rectangle2 = new Rectangle(0, bar.sy + 1, n, bar.height - 1);
                    rectangle2 = rectangle2.intersection(rectangle);
                    graphics.setColor(bar.color);
                    graphics.fillRect(rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height);
                }
                if (bar.secondaryColor == null) continue;
                rectangle2 = new Rectangle(n / 2 - 1, bar.sy + 1, (n + 1) / 2 + 1, bar.height - 1);
                if ((rectangle2 = rectangle2.intersection(rectangle)).isEmpty()) continue;
                graphics.setColor(bar.secondaryColor);
                graphics.fillRect(rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height);
            }
            graphics.setColor(color);
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            this.computeToolTipText(mouseEvent);
        }

        public void mouseMoved(MouseEvent mouseEvent) {
            this.computeToolTipText(mouseEvent);
        }

        private void computeToolTipText(MouseEvent mouseEvent) {
            int n = mouseEvent.getY();
            try {
                for (Bar bar : this.bars) {
                    if (n < bar.sy || n >= bar.sy + bar.height) continue;
                    this.setToolTipText(bar.toolTipText);
                    return;
                }
            }
            catch (ConcurrentModificationException concurrentModificationException) {
                // empty catch block
            }
            this.setToolTipText(null);
        }

        private class Bar {
            private int sy;
            private int height;
            private Color color;
            private Color secondaryColor = null;
            private String toolTipText;

            Bar(int n, int n2, Color color, Color color2, String string) {
                this.sy = n;
                this.height = n2;
                this.color = color;
                this.secondaryColor = color2;
                this.toolTipText = string;
            }
        }
    }

    private final class ViewRefresher
    implements Runnable {
        private ViewRefresher() {
        }

        public void run() {
            Set set;
            DebuggingView.this.refreshScheduled = false;
            DebuggingView.this.leftPanel.clearBars();
            DebuggingView.this.rightPanel.startReset();
            int n = (DebuggingView.this.rightPanel.getWidth() - 24) / 2;
            int n2 = 0;
            JPDAThread jPDAThread = DebuggingView.this.debugger != null ? DebuggingView.this.debugger.getCurrentThread() : null;
            Set set2 = set = DebuggingView.this.debugger != null ? DebuggingView.this.debugger.getThreadsCollector().getDeadlockDetector().getDeadlocks() : Collections.EMPTY_SET;
            if (set == null) {
                set = Collections.EMPTY_SET;
            }
            HashSet hashSet = new HashSet();
            for (DeadlockDetector.Deadlock deadlock : set) {
                hashSet.addAll(deadlock.getThreads());
            }
            int n3 = 0;
            int n4 = 0;
            int n5 = 0;
            boolean bl = false;
            boolean bl2 = false;
            boolean bl3 = false;
            JPDAThread jPDAThread2 = null;
            int n6 = 0;
            int n7 = 0;
            for (TreePath treePath : DebuggingView.this.treeView.getVisiblePaths()) {
                Node node = Visualizer.findNode((Object)treePath.getLastPathComponent());
                JPDAThread jPDAThread3 = (JPDAThread)node.getLookup().lookup(JPDAThread.class);
                JPDAThreadGroup jPDAThreadGroup = (JPDAThreadGroup)node.getLookup().lookup(JPDAThreadGroup.class);
                JTree jTree = DebuggingView.this.treeView.getTree();
                Rectangle rectangle = jTree.getRowBounds(jTree.getRowForPath(treePath));
                int n8 = n7 = rectangle != null ? (int)Math.round(rectangle.getHeight()) : 0;
                if (jPDAThread3 != null || jPDAThreadGroup != null) {
                    if (jPDAThread2 != null) {
                        this.addPanels(jPDAThread2, bl, bl2, bl3, n5, n, n6, n7);
                    }
                    n5 = 0;
                    if (jPDAThread3 != null) {
                        bl = jPDAThread3 == jPDAThread && jPDAThread3.isSuspended();
                        bl2 = DebuggingView.this.threadsListener.isBreakpointHit(jPDAThread3);
                        bl3 = hashSet.contains(jPDAThread3);
                    } else {
                        bl = false;
                        bl2 = false;
                        bl3 = false;
                    }
                    jPDAThread2 = jPDAThread3 != null ? jPDAThread3 : jPDAThreadGroup;
                    n6 = n2;
                }
                n3 += n7;
                n4 = rectangle != null ? Math.max(n4, (int)Math.round(rectangle.getX() + rectangle.getWidth())) : n4;
                n5 += n7;
                n2 += n7;
            }
            if (jPDAThread2 != null) {
                this.addPanels(jPDAThread2, bl, bl2, bl3, n5, n, n6, n7);
            }
            DebuggingView.this.rightPanel.endReset();
            DebuggingView.this.leftPanel.repaint();
            DebuggingView.this.rightPanel.revalidate();
            DebuggingView.this.rightPanel.repaint();
            DebuggingView.this.treeView.getTree().setPreferredSize(new Dimension(n4, 0));
            DebuggingView.this.mainPanel.setPreferredSize(new Dimension(0, n3));
            DebuggingView.this.mainScrollPane.revalidate();
            DebuggingView.this.mainPanel.revalidate();
            DebuggingView.this.updateSessionsComboBox();
        }

        private void addPanels(Object object, boolean bl, boolean bl2, boolean bl3, int n, int n2, int n3, int n4) {
            if (bl || bl2 || bl3) {
                DebuggingView.this.leftPanel.addBar(bl, bl2, bl3, n, n3);
            }
            if (object instanceof JPDAThread) {
                DebuggingView.this.rightPanel.addIcon(n2, n3, n4, (JPDAThread)object);
            }
        }
    }

    private final class DebuggingPreferenceChangeListener
    implements PreferenceChangeListener {
        private DebuggingPreferenceChangeListener() {
        }

        public void preferenceChange(PreferenceChangeEvent preferenceChangeEvent) {
            String string = preferenceChangeEvent.getKey();
            if ("show_suspend_table".equals(string)) {
                DebuggingView.this.setSuspendTableVisible(preferenceChangeEvent.getNewValue().equals("true"));
            }
        }
    }
}

