/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.ui.actions;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.Set;
import org.netbeans.api.debugger.ActionsManager;
import org.netbeans.api.debugger.Breakpoint;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.api.debugger.jpda.JPDADebugger;
import org.netbeans.api.debugger.jpda.LineBreakpoint;
import org.netbeans.modules.debugger.jpda.ui.EditorContextBridge;
import org.netbeans.spi.debugger.ActionsProviderSupport;
import org.netbeans.spi.debugger.ContextProvider;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.URLMapper;
import org.openide.util.NbBundle;

public class ToggleBreakpointActionProvider
extends ActionsProviderSupport
implements PropertyChangeListener {
    private JPDADebugger debugger;

    public ToggleBreakpointActionProvider() {
        EditorContextBridge.getContext().addPropertyChangeListener((PropertyChangeListener)this);
    }

    public ToggleBreakpointActionProvider(ContextProvider contextProvider) {
        this.debugger = (JPDADebugger)contextProvider.lookupFirst(null, JPDADebugger.class);
        this.debugger.addPropertyChangeListener("state", (PropertyChangeListener)this);
        EditorContextBridge.getContext().addPropertyChangeListener((PropertyChangeListener)this);
    }

    private void destroy() {
        this.debugger.removePropertyChangeListener("state", (PropertyChangeListener)this);
        EditorContextBridge.getContext().removePropertyChangeListener((PropertyChangeListener)this);
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        FileObject fileObject;
        String string = EditorContextBridge.getContext().getCurrentURL();
        try {
            fileObject = URLMapper.findFileObject((URL)new URL(string));
        }
        catch (MalformedURLException malformedURLException) {
            fileObject = null;
        }
        this.setEnabled(ActionsManager.ACTION_TOGGLE_BREAKPOINT, EditorContextBridge.getContext().getCurrentLineNumber() >= 0 && fileObject != null && "text/x-java".equals(fileObject.getMIMEType()));
        if (this.debugger != null && this.debugger.getState() == 4) {
            this.destroy();
        }
    }

    public Set getActions() {
        return Collections.singleton(ActionsManager.ACTION_TOGGLE_BREAKPOINT);
    }

    public void doAction(Object object) {
        DebuggerManager debuggerManager = DebuggerManager.getDebuggerManager();
        int n = EditorContextBridge.getContext().getCurrentLineNumber();
        String string = EditorContextBridge.getContext().getCurrentURL();
        if ("".equals(string.trim())) {
            return;
        }
        LineBreakpoint lineBreakpoint = ToggleBreakpointActionProvider.findBreakpoint(string, n);
        if (lineBreakpoint != null) {
            debuggerManager.removeBreakpoint((Breakpoint)lineBreakpoint);
            return;
        }
        lineBreakpoint = LineBreakpoint.create((String)string, (int)n);
        lineBreakpoint.setPrintText(NbBundle.getBundle(ToggleBreakpointActionProvider.class).getString("CTL_Line_Breakpoint_Print_Text"));
        debuggerManager.addBreakpoint((Breakpoint)lineBreakpoint);
    }

    static LineBreakpoint findBreakpoint(String string, int n) {
        Breakpoint[] breakpointArray = DebuggerManager.getDebuggerManager().getBreakpoints();
        for (int i = 0; i < breakpointArray.length; ++i) {
            LineBreakpoint lineBreakpoint;
            if (!(breakpointArray[i] instanceof LineBreakpoint) || !(lineBreakpoint = (LineBreakpoint)breakpointArray[i]).getURL().equals(string) || lineBreakpoint.getLineNumber() != n) continue;
            return lineBreakpoint;
        }
        return null;
    }
}

