/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.ui;

import com.sun.jdi.AbsentInformationException;
import java.awt.IllegalComponentStateException;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.netbeans.api.debugger.Breakpoint;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.api.debugger.jpda.CallStackFrame;
import org.netbeans.api.debugger.jpda.FieldBreakpoint;
import org.netbeans.api.debugger.jpda.JPDABreakpoint;
import org.netbeans.api.debugger.jpda.JPDAThread;
import org.netbeans.api.debugger.jpda.LineBreakpoint;
import org.netbeans.api.debugger.jpda.MethodBreakpoint;
import org.netbeans.modules.debugger.jpda.ui.SourcePath;
import org.netbeans.spi.debugger.jpda.EditorContext;
import org.netbeans.spi.debugger.jpda.SourcePathProvider;
import org.openide.ErrorManager;

public class EditorContextBridge {
    public static final String FIELD = "field";
    public static final String METHOD = "method";
    public static final String CLASS = "class";
    public static final String LINE = "line";
    private static EditorContext context;

    public static EditorContext getContext() {
        if (context == null) {
            List list = DebuggerManager.getDebuggerManager().lookup(null, EditorContext.class);
            context = (EditorContext)list.get(0);
            int n = list.size();
            for (int i = 1; i < n; ++i) {
                context = new CompoundContextProvider((EditorContext)list.get(i), context);
            }
        }
        return context;
    }

    public static String getCurrentMethodSignature() {
        try {
            return (String)EditorContextBridge.getContext().getClass().getMethod("getCurrentMethodSignature", new Class[0]).invoke((Object)EditorContextBridge.getContext(), new Object[0]);
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getTargetException();
            if (throwable instanceof RuntimeException) {
                throw (RuntimeException)throwable;
            }
            ErrorManager.getDefault().notify(throwable);
            return "";
        }
        catch (Exception exception) {
            ErrorManager.getDefault().notify((Throwable)exception);
            return "";
        }
    }

    public static String getFileName(LineBreakpoint lineBreakpoint) {
        try {
            return new File(new URL(lineBreakpoint.getURL()).getFile()).getName();
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }

    public static String getDefaultType() {
        String string = EditorContextBridge.getContext().getSelectedIdentifier();
        try {
            if (string != null) {
                if (string.equals(EditorContextBridge.getContext().getCurrentMethodName())) {
                    return METHOD;
                }
                String string2 = EditorContextBridge.getContext().getCurrentClassName();
                int n = string2.lastIndexOf(46);
                if (n >= 0) {
                    string2 = string2.substring(n + 1);
                }
                if (string.equals(string2)) {
                    return CLASS;
                }
                return FIELD;
            }
            String string3 = EditorContextBridge.getContext().getCurrentFieldName();
            if (string3 != null && string3.length() > 0) {
                return FIELD;
            }
            string3 = EditorContextBridge.getContext().getCurrentMethodName();
            if (string3 != null && string3.length() > 0) {
                return METHOD;
            }
            if (string3 != null && string3.length() < 1 && (string3 = EditorContextBridge.getContext().getCurrentClassName()).length() > 0) {
                return CLASS;
            }
        }
        catch (IllegalComponentStateException illegalComponentStateException) {
            // empty catch block
        }
        return null;
    }

    public static Object annotate(LineBreakpoint lineBreakpoint) {
        String string;
        boolean bl;
        String string2 = lineBreakpoint.getURL();
        int n = lineBreakpoint.getLineNumber();
        if (n < 1) {
            return null;
        }
        String string3 = lineBreakpoint.getCondition();
        boolean bl2 = string3 != null && !"".equals(string3.trim());
        boolean bl3 = bl = lineBreakpoint.getValidity() == Breakpoint.VALIDITY.INVALID;
        String string4 = lineBreakpoint.isEnabled() ? (bl2 ? "CondBreakpoint" : "Breakpoint") : (string = bl2 ? "DisabledCondBreakpoint" : "DisabledBreakpoint");
        if (bl && lineBreakpoint.isEnabled()) {
            string = string + "_broken";
        }
        return EditorContextBridge.getContext().annotate(string2, n, string, (Object)lineBreakpoint);
    }

    public static Object[] annotate(JPDABreakpoint jPDABreakpoint) {
        Object object;
        Object object2;
        int n;
        String[] stringArray;
        String string;
        int[] nArray;
        String[] stringArray2;
        if (jPDABreakpoint instanceof LineBreakpoint) {
            stringArray2 = new String[]{((LineBreakpoint)jPDABreakpoint).getURL()};
            nArray = new int[]{((LineBreakpoint)jPDABreakpoint).getLineNumber()};
            string = ((LineBreakpoint)jPDABreakpoint).getCondition();
        } else if (jPDABreakpoint instanceof FieldBreakpoint) {
            stringArray = ((FieldBreakpoint)jPDABreakpoint).getClassName();
            stringArray2 = EditorContextBridge.getClassURLs(SourcePath.convertClassNameToRelativePath((String)stringArray));
            nArray = new int[stringArray2.length];
            for (n = 0; n < stringArray2.length; ++n) {
                nArray[n] = EditorContextBridge.getContext().getFieldLineNumber(stringArray2[n], (String)stringArray, ((FieldBreakpoint)jPDABreakpoint).getFieldName());
            }
            string = ((FieldBreakpoint)jPDABreakpoint).getCondition();
        } else if (jPDABreakpoint instanceof MethodBreakpoint) {
            stringArray = ((MethodBreakpoint)jPDABreakpoint).getClassFilters();
            String[] stringArray3 = new String[]{};
            object2 = new int[]{};
            for (int i = 0; i < stringArray.length; ++i) {
                if (stringArray[i].startsWith("*") || stringArray[i].endsWith("*")) continue;
                String[] stringArray4 = EditorContextBridge.getClassURLs(SourcePath.convertClassNameToRelativePath(stringArray[i]));
                object = new int[stringArray4.length];
                for (int j = 0; j < stringArray4.length; ++j) {
                    object[j] = EditorContextBridge.getContext().getMethodLineNumber(stringArray4[j], stringArray[i], ((MethodBreakpoint)jPDABreakpoint).getMethodName(), ((MethodBreakpoint)jPDABreakpoint).getMethodSignature());
                }
                if (stringArray3.length == 0) {
                    stringArray3 = stringArray4;
                    object2 = object;
                    continue;
                }
                String[] stringArray5 = new String[stringArray3.length + stringArray4.length];
                System.arraycopy(stringArray3, 0, stringArray5, 0, stringArray3.length);
                System.arraycopy(stringArray4, 0, stringArray5, stringArray3.length, stringArray4.length);
                stringArray3 = stringArray5;
                int[] nArray2 = new int[stringArray3.length + stringArray4.length];
                System.arraycopy(object2, 0, nArray2, 0, ((int[])object2).length);
                System.arraycopy(object, 0, nArray2, ((int[])object2).length, ((int[])object).length);
                object2 = nArray2;
            }
            stringArray2 = stringArray3;
            nArray = object2;
            string = ((MethodBreakpoint)jPDABreakpoint).getCondition();
        } else {
            return null;
        }
        boolean bl = string != null && !"".equals(string.trim());
        int n2 = n = jPDABreakpoint.getValidity() == Breakpoint.VALIDITY.INVALID ? 1 : 0;
        if (jPDABreakpoint instanceof LineBreakpoint) {
            object2 = jPDABreakpoint.isEnabled() ? (bl ? "CondBreakpoint" : "Breakpoint") : (bl ? "DisabledCondBreakpoint" : "DisabledBreakpoint");
        } else if (jPDABreakpoint instanceof FieldBreakpoint) {
            object2 = jPDABreakpoint.isEnabled() ? "FieldBreakpoint" : "DisabledFieldBreakpoint";
        } else if (jPDABreakpoint instanceof MethodBreakpoint) {
            object2 = jPDABreakpoint.isEnabled() ? "MethodBreakpoint" : "DisabledMethodBreakpoint";
        } else {
            return null;
        }
        if (n != 0 && jPDABreakpoint.isEnabled()) {
            object2 = (String)object2 + "_broken";
        }
        ArrayList<int[]> arrayList = new ArrayList<int[]>(stringArray2.length);
        for (int i = 0; i < stringArray2.length; ++i) {
            if (nArray[i] < 1 || (object = (Object)EditorContextBridge.getContext().annotate(stringArray2[i], nArray[i], (String)object2, (Object)jPDABreakpoint)) == null) continue;
            arrayList.add((int[])object);
        }
        if (arrayList.size() == 0) {
            return null;
        }
        return arrayList.toArray();
    }

    private static String[] getClassURLs(String string) {
        SourcePathProvider sourcePathProvider = SourcePath.getDefaultContext();
        try {
            return (String[])sourcePathProvider.getClass().getMethod("getAllURLs", String.class, Boolean.TYPE).invoke((Object)sourcePathProvider, string, Boolean.TRUE);
        }
        catch (Exception exception) {
            ErrorManager.getDefault().notify((Throwable)exception);
            return new String[0];
        }
    }

    public static String getRelativePath(JPDAThread jPDAThread, String string) {
        try {
            return EditorContextBridge.convertSlash(jPDAThread.getSourcePath(string));
        }
        catch (AbsentInformationException absentInformationException) {
            return EditorContextBridge.getRelativePath(jPDAThread.getClassName());
        }
    }

    public static String getRelativePath(CallStackFrame callStackFrame, String string) {
        try {
            return EditorContextBridge.convertSlash(callStackFrame.getSourcePath(string));
        }
        catch (AbsentInformationException absentInformationException) {
            return EditorContextBridge.getRelativePath(callStackFrame.getClassName());
        }
    }

    public static String getRelativePath(String string) {
        int n = string.indexOf(36);
        if (n > 0) {
            string = string.substring(0, n);
        }
        String string2 = string.replace('.', '/') + ".java";
        return string2;
    }

    private static String convertSlash(String string) {
        return string.replace(File.separatorChar, '/');
    }

    private static class CompoundAnnotation {
        Object annotation1;
        Object annotation2;

        private CompoundAnnotation() {
        }
    }

    private static class CompoundContextProvider
    extends EditorContext {
        private EditorContext cp1;
        private EditorContext cp2;

        CompoundContextProvider(EditorContext editorContext, EditorContext editorContext2) {
            this.cp1 = editorContext;
            this.cp2 = editorContext2;
        }

        public void createTimeStamp(Object object) {
            this.cp1.createTimeStamp(object);
            this.cp2.createTimeStamp(object);
        }

        public void disposeTimeStamp(Object object) {
            this.cp1.disposeTimeStamp(object);
            this.cp2.disposeTimeStamp(object);
        }

        public void updateTimeStamp(Object object, String string) {
            this.cp1.updateTimeStamp(object, string);
            this.cp2.updateTimeStamp(object, string);
        }

        public String getCurrentClassName() {
            String string = this.cp1.getCurrentClassName();
            if (string.trim().length() < 1) {
                return this.cp2.getCurrentClassName();
            }
            return string;
        }

        public String getCurrentURL() {
            String string = this.cp1.getCurrentURL();
            if (string.trim().length() < 1) {
                return this.cp2.getCurrentURL();
            }
            return string;
        }

        public String getCurrentFieldName() {
            String string = this.cp1.getCurrentFieldName();
            if (string == null || string.trim().length() < 1) {
                return this.cp2.getCurrentFieldName();
            }
            return string;
        }

        public int getCurrentLineNumber() {
            int n = this.cp1.getCurrentLineNumber();
            if (n < 1) {
                return this.cp2.getCurrentLineNumber();
            }
            return n;
        }

        public String getCurrentMethodName() {
            String string = this.cp1.getCurrentMethodName();
            if (string == null || string.trim().length() < 1) {
                return this.cp2.getCurrentMethodName();
            }
            return string;
        }

        public String getCurrentMethodSignature() {
            String string = null;
            try {
                string = (String)this.cp1.getClass().getMethod("getCurrentMethodSignature", new Class[0]).invoke((Object)EditorContextBridge.getContext(), new Object[0]);
            }
            catch (InvocationTargetException invocationTargetException) {
                Throwable throwable = invocationTargetException.getTargetException();
                if (throwable instanceof RuntimeException) {
                    throw (RuntimeException)throwable;
                }
                ErrorManager.getDefault().notify(throwable);
                return null;
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (string == null || string.trim().length() < 1) {
                try {
                    string = (String)this.cp2.getClass().getMethod("getCurrentMethodSignature", new Class[0]).invoke((Object)EditorContextBridge.getContext(), new Object[0]);
                }
                catch (InvocationTargetException invocationTargetException) {
                    Throwable throwable = invocationTargetException.getTargetException();
                    if (throwable instanceof RuntimeException) {
                        throw (RuntimeException)throwable;
                    }
                    ErrorManager.getDefault().notify(throwable);
                    return null;
                }
                catch (Exception exception) {
                    ErrorManager.getDefault().notify((Throwable)exception);
                    return null;
                }
            }
            return string;
        }

        public String getSelectedIdentifier() {
            String string = this.cp1.getSelectedIdentifier();
            if (string == null || string.trim().length() < 1) {
                return this.cp2.getSelectedIdentifier();
            }
            return string;
        }

        public String getSelectedMethodName() {
            String string = this.cp1.getSelectedMethodName();
            if (string == null || string.trim().length() < 1) {
                return this.cp2.getSelectedMethodName();
            }
            return string;
        }

        public void removeAnnotation(Object object) {
            if (object instanceof List) {
                for (CompoundAnnotation compoundAnnotation : (List)object) {
                    if (compoundAnnotation.annotation1 != null) {
                        this.cp1.removeAnnotation(compoundAnnotation.annotation1);
                    }
                    if (compoundAnnotation.annotation2 == null) continue;
                    this.cp2.removeAnnotation(compoundAnnotation.annotation2);
                }
                return;
            }
            CompoundAnnotation compoundAnnotation = (CompoundAnnotation)object;
            if (compoundAnnotation.annotation1 != null) {
                this.cp1.removeAnnotation(compoundAnnotation.annotation1);
            }
            if (compoundAnnotation.annotation2 != null) {
                this.cp2.removeAnnotation(compoundAnnotation.annotation2);
            }
        }

        public Object annotate(String string, int n, String string2, Object object) {
            CompoundAnnotation compoundAnnotation = new CompoundAnnotation();
            compoundAnnotation.annotation1 = this.cp1.annotate(string, n, string2, object);
            compoundAnnotation.annotation2 = this.cp2.annotate(string, n, string2, object);
            if (compoundAnnotation.annotation1 != null || compoundAnnotation.annotation2 != null) {
                return compoundAnnotation;
            }
            return null;
        }

        public Object annotate(String string, int n, String string2, Object object, JPDAThread jPDAThread) {
            CompoundAnnotation compoundAnnotation = new CompoundAnnotation();
            compoundAnnotation.annotation1 = this.cp1.annotate(string, n, string2, object, jPDAThread);
            compoundAnnotation.annotation2 = this.cp2.annotate(string, n, string2, object, jPDAThread);
            if (compoundAnnotation.annotation1 != null || compoundAnnotation.annotation2 != null) {
                return compoundAnnotation;
            }
            return null;
        }

        public Object annotate(String string, int n, int n2, String string2, Object object) {
            CompoundAnnotation compoundAnnotation = new CompoundAnnotation();
            compoundAnnotation.annotation1 = this.cp1.annotate(string, n, n2, string2, object);
            compoundAnnotation.annotation2 = this.cp2.annotate(string, n, n2, string2, object);
            if (compoundAnnotation.annotation1 != null || compoundAnnotation.annotation2 != null) {
                return compoundAnnotation;
            }
            return null;
        }

        public int getLineNumber(Object object, Object object2) {
            CompoundAnnotation compoundAnnotation = new CompoundAnnotation();
            int n = compoundAnnotation.annotation1 != null ? this.cp1.getLineNumber(compoundAnnotation.annotation1, object2) : -1;
            if (n >= 0) {
                return n;
            }
            if (compoundAnnotation.annotation2 != null) {
                return this.cp2.getLineNumber(compoundAnnotation.annotation2, object2);
            }
            return -1;
        }

        public boolean showSource(String string, int n, Object object) {
            return this.cp1.showSource(string, n, object) | this.cp2.showSource(string, n, object);
        }

        public int getFieldLineNumber(String string, String string2, String string3) {
            int n = this.cp1.getFieldLineNumber(string, string2, string3);
            if (n != -1) {
                return n;
            }
            return this.cp2.getFieldLineNumber(string, string2, string3);
        }

        public String getClassName(String string, int n) {
            String string2 = this.cp1.getClassName(string, n);
            if (string2 != null) {
                return string2;
            }
            return this.cp2.getClassName(string, n);
        }

        public String[] getImports(String string) {
            String[] stringArray = this.cp1.getImports(string);
            String[] stringArray2 = this.cp2.getImports(string);
            String[] stringArray3 = new String[stringArray.length + stringArray2.length];
            System.arraycopy(stringArray, 0, stringArray3, 0, stringArray.length);
            System.arraycopy(stringArray2, 0, stringArray3, stringArray.length, stringArray2.length);
            return stringArray3;
        }

        public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
            this.cp1.addPropertyChangeListener(propertyChangeListener);
            this.cp2.addPropertyChangeListener(propertyChangeListener);
        }

        public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
            this.cp1.removePropertyChangeListener(propertyChangeListener);
            this.cp2.removePropertyChangeListener(propertyChangeListener);
        }

        public void addPropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
            this.cp1.addPropertyChangeListener(string, propertyChangeListener);
            this.cp2.addPropertyChangeListener(string, propertyChangeListener);
        }

        public void removePropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
            this.cp1.removePropertyChangeListener(string, propertyChangeListener);
            this.cp2.removePropertyChangeListener(string, propertyChangeListener);
        }
    }
}

