/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.sql.project.anttasks;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.List;
import javax.wsdl.Definition;
import org.netbeans.modules.sql.project.anttasks.FileUtil;

public class SQLMapWriter {
    private Definition wsdlDefinition;
    private String sqlmapLocation;
    private List sqlFilesList;

    public SQLMapWriter(List sqlFilesList, Definition def, String canonicalPath) {
        this.sqlFilesList = sqlFilesList;
        this.wsdlDefinition = def;
        this.sqlmapLocation = canonicalPath;
    }

    public String writeMap() throws Exception {
        StringBuffer sb = new StringBuffer();
        sb.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
        sb.append("<sqlmap  xmlns:tns=\"http://com.sun.jbi/sqlse/sqlengine\" \n");
        sb.append("\t targetNamespace=\"http://com.sun.jbi/sqlse/sqlengine\" > \n");
        if (this.sqlFilesList != null) {
            Iterator iter = this.sqlFilesList.iterator();
            while (iter.hasNext()) {
                String sqlFilePath = ((File)iter.next()).getName();
                int beginIndex = sqlFilePath.lastIndexOf(File.separator);
                String sqlFileName = sqlFilePath.substring(beginIndex + 1, sqlFilePath.length());
                sb.append("\t <sql partnerLink=\"" + this.wsdlDefinition.getQName() + "_sqlsePartnerLink" + "\"\n");
                sb.append("\t \t partnerLinkType=\"" + this.wsdlDefinition.getQName() + "_sqlsePartnerLinkType" + "\"\n");
                sb.append("\t \t roleName=\"" + this.wsdlDefinition.getQName() + "_myrole" + "\"\n");
                sb.append("\t \t portType=\"" + this.wsdlDefinition.getQName() + "_sqlsePortType" + "\"\n");
                sb.append("\t \t operation= \"" + sqlFileName + "\" \n");
                sb.append("\t \t wsdlfile=\"" + this.wsdlDefinition.getQName().getLocalPart() + ".wsdl" + "\"\n");
                sb.append("\t \t sqlfile=\"" + sqlFilePath + "\"\n");
                sb.append("\t \t type= \"requestReplyService\" /> \n");
            }
        } else {
            throw new Exception("No SQL Files found to generate SQL Map");
        }
        sb.append("</sqlmap>");
        String content = sb.toString();
        try {
            FileOutputStream fos = new FileOutputStream(this.sqlmapLocation + "/sqlmap.xml");
            FileUtil.copy(content.getBytes("UTF-8"), (OutputStream)fos);
        }
        catch (Exception e) {
            throw new Exception("Unable to generate sqlmap file", e);
        }
        return content;
    }
}

