/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.sql.project.anttasks;

import java.io.File;
import java.io.FileFilter;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.wsdl.Definition;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.netbeans.api.db.explorer.ConnectionManager;
import org.netbeans.api.db.explorer.DatabaseConnection;
import org.netbeans.modules.sql.project.anttasks.ExtensionFilter;
import org.netbeans.modules.sql.project.anttasks.JBIFileWriter;
import org.netbeans.modules.sql.project.anttasks.SQLEngineFileGenerator;
import org.netbeans.modules.sql.project.anttasks.SQLMapWriter;
import org.netbeans.modules.sql.project.anttasks.WSDLGenerator;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class GenerateWSDL
extends Task {
    private String mSrcDirectoryLocation;
    private String mBuildDirectoryLocation;
    private String dbURL = "";
    private String jndi_name = "";
    private static final String CONNECTION_FILE = "connectivityInfo.xml";
    private String engineFileName = null;
    private JFrame frame;
    DatabaseConnection dbConn = null;
    Connection conn = null;

    public String getSrcDirectoryLocation() {
        return this.mSrcDirectoryLocation;
    }

    public void setSrcDirectoryLocation(String srcDirectoryLocation) {
        this.mSrcDirectoryLocation = srcDirectoryLocation;
    }

    public String getBuildDirectoryLocation() {
        return this.mBuildDirectoryLocation;
    }

    public void setBuildDirectoryLocation(String buildDirectoryLocation) {
        this.mBuildDirectoryLocation = buildDirectoryLocation;
        this.engineFileName = "sqlse_engine.xml";
    }

    public static List getFilesRecursively(File dir, FileFilter filter) {
        ArrayList<File> ret = new ArrayList<File>();
        if (!dir.isDirectory()) {
            return ret;
        }
        File[] fileNdirs = dir.listFiles(filter);
        int I = fileNdirs.length;
        for (int i = 0; i < I; ++i) {
            if (fileNdirs[i].isDirectory()) {
                ret.addAll(GenerateWSDL.getFilesRecursively(fileNdirs[i], filter));
                continue;
            }
            ret.add(fileNdirs[i]);
        }
        return ret;
    }

    public static List getFilesRecursively(File dir, String[] extensions) {
        ExtensionFilter filter = null;
        if (extensions[0].equals(".sql")) {
            filter = new ExtensionFilter(extensions);
        }
        return GenerateWSDL.getFilesRecursively(dir, filter);
    }

    public void execute() throws BuildException {
        File[] fileNdirs;
        ExtensionFilter filter;
        String[] extensions;
        File srcDir = new File(this.mSrcDirectoryLocation);
        File bldDir = new File(this.mBuildDirectoryLocation + "/META-INF");
        if (!srcDir.exists()) {
            throw new BuildException("Directory " + this.mSrcDirectoryLocation + " does not exit.");
        }
        if (!bldDir.exists()) {
            throw new BuildException("Directory " + this.mBuildDirectoryLocation + " does not exit. Please generate the WSDL");
        }
        String srcDirPath = srcDir.getAbsolutePath();
        String bldDirPath = bldDir.getAbsolutePath();
        if (srcDir.isDirectory()) {
            extensions = new String[]{".wsdl"};
            filter = new ExtensionFilter(extensions);
            fileNdirs = srcDir.listFiles(filter);
            if (fileNdirs.length <= 0) {
                JOptionPane.showMessageDialog(this.frame, "Please Generate the WSDL using \"Generate WSDL...\" option, before building the application.", "Warning", 2);
            }
        }
        if (bldDir.isDirectory()) {
            extensions = new String[]{".xml"};
            filter = new ExtensionFilter(extensions);
            fileNdirs = bldDir.listFiles(filter);
            if (fileNdirs.length <= 0) {
                JOptionPane.showMessageDialog(this.frame, "JBI.xml is not generated, please generate the WSDL.", "Warning", 2);
            }
        }
    }

    public void execute1() throws BuildException {
        HashMap wsdlMap = new HashMap();
        File srcDir = new File(this.mSrcDirectoryLocation);
        if (!srcDir.exists()) {
            throw new BuildException("Directory " + this.mSrcDirectoryLocation + " does not exit.");
        }
        try {
            String baseDir = this.getProject().getProperty("basedir");
            String projectName = baseDir.substring(baseDir.lastIndexOf(File.separator) + 1, baseDir.length());
            SQLEngineFileGenerator engineFileGen = new SQLEngineFileGenerator(this.mBuildDirectoryLocation + "/" + this.engineFileName, projectName);
            String srcDirPath = srcDir.getAbsolutePath();
            String[] ext = new String[]{".sql"};
            List sqlFiles = GenerateWSDL.getFilesRecursively(srcDir, ext);
            this.readConnectionInfo(CONNECTION_FILE);
            this.getDatabaseConnection();
            if (this.conn == null) {
                throw new BuildException("Unable to retrieve any database connections with the url " + this.dbURL + "\n Please associate a Connection for the sql file in netbeans runtime tab or if it exists, connect to the external");
            }
            int I = sqlFiles.size();
            for (int i = 0; i < I; ++i) {
                File f = (File)sqlFiles.get(i);
                if (f == null) continue;
                engineFileGen.addSQLDefinition(f.getName(), this.dbConn);
            }
            engineFileGen.persistEngineFile(this.jndi_name);
            WSDLGenerator wsdlgen = new WSDLGenerator(this.conn, sqlFiles, projectName, srcDirPath, this.engineFileName);
            wsdlgen.setDBConnection(this.dbConn);
            Definition def = wsdlgen.generateWSDL();
            SQLMapWriter sqlw = new SQLMapWriter(sqlFiles, def, new File(this.mBuildDirectoryLocation).getCanonicalPath());
            sqlw.writeMap();
            JBIFileWriter fw = new JBIFileWriter(this.mBuildDirectoryLocation + "/META-INF/jbi.xml", this.mBuildDirectoryLocation + "/sqlmap.xml", this.mBuildDirectoryLocation);
            fw.writeJBI();
        }
        catch (Exception e) {
            throw new BuildException(e.getMessage());
        }
    }

    private void readConnectionInfo(String fileName) throws FileNotFoundException {
        if (fileName.endsWith(".xml")) {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            try {
                Node n4;
                Node n;
                NodeList n3;
                Node n2;
                Node n5;
                Document doc = factory.newDocumentBuilder().parse(new File(this.mSrcDirectoryLocation, CONNECTION_FILE));
                NodeList nl = doc.getDocumentElement().getElementsByTagName("database-url");
                if (nl != null && (n5 = nl.item(0)) != null && (n2 = n5.getAttributes().getNamedItem("value")) != null) {
                    this.dbURL = n2.getNodeValue();
                    this.log("Using Database URL value: " + this.dbURL);
                }
                if ((n3 = doc.getDocumentElement().getElementsByTagName("jndi-name")) != null && (n = n3.item(0)) != null && (n4 = n.getAttributes().getNamedItem("value")) != null) {
                    this.jndi_name = n4.getNodeValue();
                    this.log("jndi value: " + this.jndi_name);
                }
            }
            catch (SAXException e) {
                this.log(e.getLocalizedMessage());
            }
            catch (IOException e) {
                this.log(e.getLocalizedMessage());
            }
            catch (ParserConfigurationException e) {
                this.log(e.getLocalizedMessage());
            }
        } else {
            throw new BuildException("No File with name connectivityInfo.xml was found in the src directory");
        }
    }

    private void getDatabaseConnection() {
        DatabaseConnection[] dbConnections = ConnectionManager.getDefault().getConnections();
        if (this.dbConn == null) {
            for (int j = 0; j < dbConnections.length; ++j) {
                if (!dbConnections[j].getDatabaseURL().equalsIgnoreCase(this.dbURL)) continue;
                this.dbConn = dbConnections[j];
                this.conn = this.dbConn.getJDBCConnection();
                break;
            }
        }
        if (this.dbConn != null && this.conn == null) {
            ConnectionManager.getDefault().showConnectionDialog(this.dbConn);
            this.conn = this.dbConn.getJDBCConnection();
        }
    }
}

