/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.saas.codegen.java;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.modules.websvc.saas.codegen.Constants;
import org.netbeans.modules.websvc.saas.codegen.SaasClientAuthenticationGenerator;
import org.netbeans.modules.websvc.saas.codegen.SaasClientCodeGenerator;
import org.netbeans.modules.websvc.saas.codegen.java.SaasClientJavaAuthenticationGenerator;
import org.netbeans.modules.websvc.saas.codegen.java.support.JavaSourceHelper;
import org.netbeans.modules.websvc.saas.codegen.java.support.JavaUtil;
import org.netbeans.modules.websvc.saas.codegen.java.support.SourceGroupSupport;
import org.netbeans.modules.websvc.saas.codegen.model.CustomClientSaasBean;
import org.netbeans.modules.websvc.saas.codegen.model.ParameterInfo;
import org.netbeans.modules.websvc.saas.codegen.model.SaasBean;
import org.netbeans.modules.websvc.saas.codegen.util.Util;
import org.netbeans.modules.websvc.saas.model.CustomSaasMethod;
import org.netbeans.modules.websvc.saas.model.SaasMethod;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CustomClientPojoCodeGenerator
extends SaasClientCodeGenerator {
    private JavaSource targetSource;
    private FileObject serviceFolder;
    private SaasClientJavaAuthenticationGenerator authGen;

    public CustomClientPojoCodeGenerator() {
        this.setDropFileType(Constants.DropFileType.JAVA_CLIENT);
    }

    public boolean canAccept(SaasMethod saasMethod, Document document) {
        return SaasBean.canAccept((SaasMethod)saasMethod, CustomSaasMethod.class, (Constants.DropFileType)this.getDropFileType()) && Util.isJava((Document)document);
    }

    public void init(SaasMethod saasMethod, Document document) throws IOException {
        this.init(saasMethod, new CustomClientSaasBean((CustomSaasMethod)saasMethod, false), document);
    }

    protected void preGenerate() throws IOException {
        JavaUtil.addJaxbLib(this.getProject());
        this.createRestConnectionFile(this.getProject());
        if (this.getBean().getMethod().getSaas().getLibraryJars().size() > 0) {
            JavaUtil.addClientJars((SaasBean)this.getBean(), this.getProject(), null);
        }
        this.getTargetFolder().getFileSystem().runAtomicAction(new FileSystem.AtomicAction(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() throws IOException {
                Map map = CustomClientPojoCodeGenerator.this.getBean().getArtifactTemplates(Constants.DropFileType.RESOURCE.prefix());
                for (Map.Entry entry : map.entrySet()) {
                    String string = (String)entry.getKey();
                    String string2 = (String)entry.getValue();
                    Util.createDataObjectFromTemplate((String)string2, (FileObject)CustomClientPojoCodeGenerator.this.getSaasServiceFolder(), (String)string);
                }
            }
        });
    }

    public void init(SaasMethod saasMethod, CustomClientSaasBean customClientSaasBean, Document document) throws IOException {
        super.init(saasMethod, document);
        this.setBean((SaasBean)customClientSaasBean);
        this.targetSource = JavaSource.forFileObject((FileObject)this.getTargetFile());
        String string = JavaSourceHelper.getPackageName(this.getTargetSource());
        this.getBean().setPackageName(string);
        this.serviceFolder = null;
        this.authGen = new SaasClientJavaAuthenticationGenerator((SaasBean)this.getBean(), this.getProject());
        this.authGen.setLoginArguments(this.getLoginArguments());
        this.authGen.setAuthenticatorMethodParameters(this.getAuthenticatorMethodParameters());
        this.authGen.setSaasServiceFolder(this.getSaasServiceFolder());
        this.getBean();
        this.authGen.setAuthenticationProfile(CustomClientSaasBean.getProfile((SaasMethod)saasMethod, (Constants.DropFileType)this.getDropFileType()));
        this.authGen.setDropFileType(this.getDropFileType());
    }

    public CustomClientSaasBean getBean() {
        return (CustomClientSaasBean)super.getBean();
    }

    public SaasClientAuthenticationGenerator getAuthenticationGenerator() {
        return this.authGen;
    }

    protected JavaSource getTargetSource() {
        return this.targetSource;
    }

    public FileObject getSaasServiceFolder() throws IOException {
        if (this.serviceFolder == null) {
            SourceGroup[] sourceGroupArray = SourceGroupSupport.getJavaSourceGroups(this.getProject());
            this.serviceFolder = SourceGroupSupport.getFolderForPackage(sourceGroupArray[0], this.getBean().getSaasServicePackageName(), true);
        }
        return this.serviceFolder;
    }

    public Set<FileObject> generate() throws IOException {
        this.preGenerate();
        this.getAuthenticationGenerator().createAuthenticatorClass();
        this.getAuthenticationGenerator().createAuthorizationClasses();
        this.getAuthenticationGenerator().modifyAuthenticationClass();
        this.setJaxbWrapper();
        this.insertSaasServiceAccessCode(this.isInBlock(this.getTargetDocument()));
        this.addImportsToTargetFile();
        this.finishProgressReporting();
        return new HashSet<FileObject>(Collections.EMPTY_LIST);
    }

    private void setJaxbWrapper() {
    }

    protected String getCustomMethodBody() throws IOException {
        String string = "";
        String string2 = "";
        String string3 = "        ";
        String string4 = "             ";
        List<ParameterInfo> list = this.getServiceMethodParameters();
        string = string + Util.getHeaderOrParameterUsage((List)this.getBean().getInputParameters());
        string2 = string2 + this.getHeaderOrParameterDeclaration(list, string4);
        String string5 = string3 + "try {\n";
        string5 = string5 + "             " + this.getAuthenticationGenerator().getPreAuthenticationCode() + "\n";
        string5 = string5 + string2 + "\n";
        string5 = string5 + string4 + "RestResponse" + " result = " + this.getBean().getSaasServiceName() + "." + this.getBean().getSaasServiceMethodName() + "(" + string + ");\n";
        string5 = string5 + Util.createPrintStatement((String)this.getBean().getOutputWrapperPackageName(), (String)this.getBean().getOutputWrapperName(), (Constants.DropFileType)this.getDropFileType(), (Constants.HttpMethodType)this.getBean().getHttpMethod(), (boolean)this.getBean().canGenerateJAXBUnmarshaller(), (String)string4);
        string5 = string5 + string3 + "} catch (Exception ex) {\n";
        string5 = string5 + string4 + "ex.printStackTrace();\n";
        string5 = string5 + string3 + "}\n";
        return string5;
    }

    protected void insertSaasServiceAccessCode(boolean bl) throws IOException {
        try {
            String string = "";
            if (bl) {
                string = this.getCustomMethodBody();
            } else {
                string = "\nprivate String call" + this.getBean().getName() + "Service() {\n";
                string = string + this.getCustomMethodBody() + "\n";
                string = string + "return result;\n";
                string = string + "}\n";
            }
            this.insert(string, true);
        }
        catch (BadLocationException badLocationException) {
            throw new IOException(badLocationException.getMessage());
        }
    }

    protected void addImportsToTargetFile() throws IOException {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(this.getBean().getSaasServicePackageName() + "." + this.getBean().getSaasServiceName());
        if (this.getBean().getAuthenticationType() != Constants.SaasAuthenticationType.PLAIN) {
            arrayList.add(this.getBean().getSaasServicePackageName() + "." + this.getBean().getAuthenticatorClassName());
        }
        arrayList.add("org.netbeans.saas.RestResponse");
        JavaUtil.addImportsToSource(this.getTargetSource(), arrayList);
    }

    protected List<ParameterInfo> getServiceMethodParameters() {
        List list = this.getBean().filterParametersByAuth(this.getBean().filterParameters(new ParameterInfo.ParamFilter[]{ParameterInfo.ParamFilter.FIXED}));
        Constants.HttpMethodType httpMethodType = this.getBean().getHttpMethod();
        if (httpMethodType == Constants.HttpMethodType.PUT || httpMethodType == Constants.HttpMethodType.POST) {
            ParameterInfo parameterInfo = Util.findParameter((List)this.getBean().getInputParameters(), (String)"Content-Type");
            Class clazz = InputStream.class;
            if (parameterInfo == null) {
                list.add(new ParameterInfo("Content-Type", String.class));
            } else if (!parameterInfo.isFixed() && !list.contains(parameterInfo)) {
                list.add(parameterInfo);
            } else {
                String string = Util.findParamValue((ParameterInfo)parameterInfo);
                if (string.equals("text/plain") || string.equals("application/xml") || string.equals("text/xml")) {
                    clazz = String.class;
                }
            }
            list.add(new ParameterInfo("content", clazz));
        }
        return list;
    }

    protected String getHeaderOrParameterDeclaration(List<ParameterInfo> list, String string) {
        if (string == null) {
            string = " ";
        }
        String string2 = "";
        for (ParameterInfo parameterInfo : list) {
            String string3 = this.getVariableName(parameterInfo.getName());
            String string4 = Util.findParamValue((ParameterInfo)parameterInfo);
            if (parameterInfo.getType() != String.class) {
                string2 = string2 + string + parameterInfo.getType().getName() + " " + string3 + " = " + string4 + ";\n";
                continue;
            }
            if (string4 != null) {
                string2 = string2 + string + "String " + string3 + " = \"" + string4 + "\";\n";
                continue;
            }
            string2 = string2 + string + "String " + string3 + " = null;\n";
        }
        return string2;
    }

    protected String getHeaderOrParameterDeclaration(List<ParameterInfo> list) {
        String string = "                 ";
        return this.getHeaderOrParameterDeclaration(list, string);
    }

    public static List<ParameterInfo> getAuthenticatorMethodParametersForWeb() {
        ArrayList<ParameterInfo> arrayList = new ArrayList<ParameterInfo>();
        arrayList.add(new ParameterInfo("request", Object.class, "HttpServletRequest"));
        arrayList.add(new ParameterInfo("response", Object.class, "HttpServletResponse"));
        return arrayList;
    }

    public static List<ParameterInfo> getServiceMethodParametersForWeb(CustomClientSaasBean customClientSaasBean) {
        ArrayList<ParameterInfo> arrayList = new ArrayList<ParameterInfo>();
        arrayList.addAll(CustomClientPojoCodeGenerator.getAuthenticatorMethodParametersForWeb());
        arrayList.addAll(customClientSaasBean.filterParametersByAuth(customClientSaasBean.filterParameters(new ParameterInfo.ParamFilter[]{ParameterInfo.ParamFilter.FIXED})));
        return arrayList;
    }

    protected List<ParameterInfo> getAuthenticatorMethodParameters() {
        return Collections.emptyList();
    }

    protected String getLoginArguments() {
        return "";
    }

    protected void createRestConnectionFile(Project project) throws IOException {
        SourceGroup[] sourceGroupArray = SourceGroupSupport.getJavaSourceGroups(project);
        String string = "org.netbeans.saas";
        FileObject fileObject = SourceGroupSupport.getFolderForPackage(sourceGroupArray[0], string, true);
        JavaSourceHelper.createJavaSource("Templates/SaaSServices/RestConnection.java", fileObject, string, "RestConnection");
        String string2 = "Templates/SaaSServices/RestResponse.java";
        JavaSource javaSource = JavaSourceHelper.createJavaSource(string2, fileObject, string, "RestResponse");
    }
}

