/*
 * Decompiled with CFR 0.152.
 */
package proguard.classfile.io;

import java.io.ByteArrayOutputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import proguard.classfile.Clazz;
import proguard.classfile.Field;
import proguard.classfile.LibraryClass;
import proguard.classfile.LibraryMember;
import proguard.classfile.Method;
import proguard.classfile.ProgramClass;
import proguard.classfile.ProgramField;
import proguard.classfile.ProgramMethod;
import proguard.classfile.attribute.Attribute;
import proguard.classfile.attribute.CodeAttribute;
import proguard.classfile.attribute.ConstantValueAttribute;
import proguard.classfile.attribute.DeprecatedAttribute;
import proguard.classfile.attribute.EnclosingMethodAttribute;
import proguard.classfile.attribute.ExceptionInfo;
import proguard.classfile.attribute.ExceptionsAttribute;
import proguard.classfile.attribute.InnerClassesAttribute;
import proguard.classfile.attribute.InnerClassesInfo;
import proguard.classfile.attribute.LineNumberInfo;
import proguard.classfile.attribute.LineNumberTableAttribute;
import proguard.classfile.attribute.LocalVariableInfo;
import proguard.classfile.attribute.LocalVariableTableAttribute;
import proguard.classfile.attribute.LocalVariableTypeInfo;
import proguard.classfile.attribute.LocalVariableTypeTableAttribute;
import proguard.classfile.attribute.SignatureAttribute;
import proguard.classfile.attribute.SourceDirAttribute;
import proguard.classfile.attribute.SourceFileAttribute;
import proguard.classfile.attribute.SyntheticAttribute;
import proguard.classfile.attribute.UnknownAttribute;
import proguard.classfile.attribute.annotation.Annotation;
import proguard.classfile.attribute.annotation.AnnotationDefaultAttribute;
import proguard.classfile.attribute.annotation.AnnotationElementValue;
import proguard.classfile.attribute.annotation.AnnotationsAttribute;
import proguard.classfile.attribute.annotation.ArrayElementValue;
import proguard.classfile.attribute.annotation.ClassElementValue;
import proguard.classfile.attribute.annotation.ConstantElementValue;
import proguard.classfile.attribute.annotation.ElementValue;
import proguard.classfile.attribute.annotation.EnumConstantElementValue;
import proguard.classfile.attribute.annotation.ParameterAnnotationsAttribute;
import proguard.classfile.attribute.annotation.visitor.AnnotationVisitor;
import proguard.classfile.attribute.annotation.visitor.ElementValueVisitor;
import proguard.classfile.attribute.preverification.FullFrame;
import proguard.classfile.attribute.preverification.LessZeroFrame;
import proguard.classfile.attribute.preverification.MoreZeroFrame;
import proguard.classfile.attribute.preverification.ObjectType;
import proguard.classfile.attribute.preverification.SameOneFrame;
import proguard.classfile.attribute.preverification.SameZeroFrame;
import proguard.classfile.attribute.preverification.StackMapAttribute;
import proguard.classfile.attribute.preverification.StackMapFrame;
import proguard.classfile.attribute.preverification.StackMapTableAttribute;
import proguard.classfile.attribute.preverification.UninitializedType;
import proguard.classfile.attribute.preverification.VerificationType;
import proguard.classfile.attribute.preverification.visitor.StackMapFrameVisitor;
import proguard.classfile.attribute.preverification.visitor.VerificationTypeVisitor;
import proguard.classfile.attribute.visitor.AttributeVisitor;
import proguard.classfile.attribute.visitor.ExceptionInfoVisitor;
import proguard.classfile.attribute.visitor.InnerClassesInfoVisitor;
import proguard.classfile.attribute.visitor.LineNumberInfoVisitor;
import proguard.classfile.attribute.visitor.LocalVariableInfoVisitor;
import proguard.classfile.attribute.visitor.LocalVariableTypeInfoVisitor;
import proguard.classfile.constant.ClassConstant;
import proguard.classfile.constant.Constant;
import proguard.classfile.constant.DoubleConstant;
import proguard.classfile.constant.FloatConstant;
import proguard.classfile.constant.IntegerConstant;
import proguard.classfile.constant.LongConstant;
import proguard.classfile.constant.NameAndTypeConstant;
import proguard.classfile.constant.RefConstant;
import proguard.classfile.constant.StringConstant;
import proguard.classfile.constant.Utf8Constant;
import proguard.classfile.constant.visitor.ConstantVisitor;
import proguard.classfile.io.RuntimeDataOutput;
import proguard.classfile.util.ClassUtil;
import proguard.classfile.util.SimplifiedVisitor;
import proguard.classfile.visitor.ClassVisitor;
import proguard.classfile.visitor.MemberVisitor;

public class ProgramClassWriter
extends SimplifiedVisitor
implements ClassVisitor,
MemberVisitor,
ConstantVisitor,
AttributeVisitor {
    private RuntimeDataOutput dataOutput;
    private final ConstantBodyWriter constantBodyWriter = new ConstantBodyWriter();
    private final AttributeBodyWriter attributeBodyWriter = new AttributeBodyWriter();
    private final StackMapFrameBodyWriter stackMapFrameBodyWriter = new StackMapFrameBodyWriter();
    private final VerificationTypeBodyWriter verificationTypeBodyWriter = new VerificationTypeBodyWriter();
    private final ElementValueBodyWriter elementValueBodyWriter = new ElementValueBodyWriter();

    public ProgramClassWriter(DataOutput dataOutput) {
        this.dataOutput = new RuntimeDataOutput(dataOutput);
    }

    public void visitProgramClass(ProgramClass programClass) {
        this.dataOutput.writeInt(programClass.u4magic);
        this.dataOutput.writeShort(ClassUtil.internalMinorClassVersion(programClass.u4version));
        this.dataOutput.writeShort(ClassUtil.internalMajorClassVersion(programClass.u4version));
        this.dataOutput.writeShort(programClass.u2constantPoolCount);
        programClass.constantPoolEntriesAccept(this);
        this.dataOutput.writeShort(programClass.u2accessFlags);
        this.dataOutput.writeShort(programClass.u2thisClass);
        this.dataOutput.writeShort(programClass.u2superClass);
        this.dataOutput.writeShort(programClass.u2interfacesCount);
        for (int i = 0; i < programClass.u2interfacesCount; ++i) {
            this.dataOutput.writeShort(programClass.u2interfaces[i]);
        }
        this.dataOutput.writeShort(programClass.u2fieldsCount);
        programClass.fieldsAccept(this);
        this.dataOutput.writeShort(programClass.u2methodsCount);
        programClass.methodsAccept(this);
        this.dataOutput.writeShort(programClass.u2attributesCount);
        programClass.attributesAccept(this);
    }

    public void visitLibraryClass(LibraryClass libraryClass) {
    }

    public void visitProgramField(ProgramClass programClass, ProgramField programField) {
        this.dataOutput.writeShort(programField.u2accessFlags);
        this.dataOutput.writeShort(programField.u2nameIndex);
        this.dataOutput.writeShort(programField.u2descriptorIndex);
        this.dataOutput.writeShort(programField.u2attributesCount);
        programField.attributesAccept(programClass, this);
    }

    public void visitProgramMethod(ProgramClass programClass, ProgramMethod programMethod) {
        this.dataOutput.writeShort(programMethod.u2accessFlags);
        this.dataOutput.writeShort(programMethod.u2nameIndex);
        this.dataOutput.writeShort(programMethod.u2descriptorIndex);
        this.dataOutput.writeShort(programMethod.u2attributesCount);
        programMethod.attributesAccept(programClass, this);
    }

    public void visitLibraryMember(LibraryClass libraryClass, LibraryMember libraryMember) {
    }

    public void visitAnyConstant(Clazz clazz, Constant constant) {
        this.dataOutput.writeByte(constant.getTag());
        constant.accept(clazz, this.constantBodyWriter);
    }

    public void visitAnyAttribute(Clazz clazz, Attribute attribute) {
        this.dataOutput.writeShort(attribute.u2attributeNameIndex);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        RuntimeDataOutput runtimeDataOutput = this.dataOutput;
        this.dataOutput = new RuntimeDataOutput(new DataOutputStream(byteArrayOutputStream));
        attribute.accept(clazz, null, null, this.attributeBodyWriter);
        this.dataOutput = runtimeDataOutput;
        byte[] byArray = byteArrayOutputStream.toByteArray();
        this.dataOutput.writeInt(byArray.length);
        this.dataOutput.write(byArray);
    }

    private class ElementValueBodyWriter
    extends SimplifiedVisitor
    implements ElementValueVisitor {
        private ElementValueBodyWriter() {
        }

        public void visitConstantElementValue(Clazz clazz, Annotation annotation, ConstantElementValue constantElementValue) {
            ProgramClassWriter.this.dataOutput.writeShort(constantElementValue.u2constantValueIndex);
        }

        public void visitEnumConstantElementValue(Clazz clazz, Annotation annotation, EnumConstantElementValue enumConstantElementValue) {
            ProgramClassWriter.this.dataOutput.writeShort(enumConstantElementValue.u2typeNameIndex);
            ProgramClassWriter.this.dataOutput.writeShort(enumConstantElementValue.u2constantNameIndex);
        }

        public void visitClassElementValue(Clazz clazz, Annotation annotation, ClassElementValue classElementValue) {
            ProgramClassWriter.this.dataOutput.writeShort(classElementValue.u2classInfoIndex);
        }

        public void visitAnnotationElementValue(Clazz clazz, Annotation annotation, AnnotationElementValue annotationElementValue) {
            ProgramClassWriter.this.attributeBodyWriter.visitAnnotation(clazz, annotationElementValue.annotationValue);
        }

        public void visitArrayElementValue(Clazz clazz, Annotation annotation, ArrayElementValue arrayElementValue) {
            ProgramClassWriter.this.dataOutput.writeShort(arrayElementValue.u2elementValuesCount);
            arrayElementValue.elementValuesAccept(clazz, annotation, ProgramClassWriter.this.attributeBodyWriter);
        }
    }

    private class VerificationTypeBodyWriter
    extends SimplifiedVisitor
    implements VerificationTypeVisitor {
        private VerificationTypeBodyWriter() {
        }

        public void visitAnyVerificationType(Clazz clazz, Method method, CodeAttribute codeAttribute, int n, VerificationType verificationType) {
        }

        public void visitObjectType(Clazz clazz, Method method, CodeAttribute codeAttribute, int n, ObjectType objectType) {
            ProgramClassWriter.this.dataOutput.writeShort(objectType.u2classIndex);
        }

        public void visitUninitializedType(Clazz clazz, Method method, CodeAttribute codeAttribute, int n, UninitializedType uninitializedType) {
            ProgramClassWriter.this.dataOutput.writeShort(uninitializedType.u2newInstructionOffset);
        }
    }

    private class StackMapFrameBodyWriter
    extends SimplifiedVisitor
    implements StackMapFrameVisitor,
    VerificationTypeVisitor {
        private StackMapFrameBodyWriter() {
        }

        public void visitSameZeroFrame(Clazz clazz, Method method, CodeAttribute codeAttribute, int n, SameZeroFrame sameZeroFrame) {
            if (sameZeroFrame.getTag() == 251) {
                ProgramClassWriter.this.dataOutput.writeShort(sameZeroFrame.u2offsetDelta);
            }
        }

        public void visitSameOneFrame(Clazz clazz, Method method, CodeAttribute codeAttribute, int n, SameOneFrame sameOneFrame) {
            if (sameOneFrame.getTag() == 247) {
                ProgramClassWriter.this.dataOutput.writeShort(sameOneFrame.u2offsetDelta);
            }
            sameOneFrame.stackItemAccept(clazz, method, codeAttribute, n, this);
        }

        public void visitLessZeroFrame(Clazz clazz, Method method, CodeAttribute codeAttribute, int n, LessZeroFrame lessZeroFrame) {
            ProgramClassWriter.this.dataOutput.writeShort(lessZeroFrame.u2offsetDelta);
        }

        public void visitMoreZeroFrame(Clazz clazz, Method method, CodeAttribute codeAttribute, int n, MoreZeroFrame moreZeroFrame) {
            ProgramClassWriter.this.dataOutput.writeShort(moreZeroFrame.u2offsetDelta);
            moreZeroFrame.additionalVariablesAccept(clazz, method, codeAttribute, n, this);
        }

        public void visitFullFrame(Clazz clazz, Method method, CodeAttribute codeAttribute, int n, FullFrame fullFrame) {
            ProgramClassWriter.this.dataOutput.writeShort(fullFrame.u2offsetDelta);
            ProgramClassWriter.this.dataOutput.writeShort(fullFrame.variablesCount);
            fullFrame.variablesAccept(clazz, method, codeAttribute, n, this);
            ProgramClassWriter.this.dataOutput.writeShort(fullFrame.stackCount);
            fullFrame.stackAccept(clazz, method, codeAttribute, n, this);
        }

        public void visitAnyVerificationType(Clazz clazz, Method method, CodeAttribute codeAttribute, int n, VerificationType verificationType) {
            ProgramClassWriter.this.dataOutput.writeByte(verificationType.getTag());
            verificationType.accept(clazz, method, codeAttribute, n, ProgramClassWriter.this.verificationTypeBodyWriter);
        }
    }

    private class AttributeBodyWriter
    extends SimplifiedVisitor
    implements AttributeVisitor,
    InnerClassesInfoVisitor,
    ExceptionInfoVisitor,
    StackMapFrameVisitor,
    VerificationTypeVisitor,
    LineNumberInfoVisitor,
    LocalVariableInfoVisitor,
    LocalVariableTypeInfoVisitor,
    AnnotationVisitor,
    ElementValueVisitor {
        private AttributeBodyWriter() {
        }

        public void visitUnknownAttribute(Clazz clazz, UnknownAttribute unknownAttribute) {
            byte[] byArray = new byte[unknownAttribute.u4attributeLength];
            ProgramClassWriter.this.dataOutput.write(byArray);
            unknownAttribute.info = byArray;
        }

        public void visitSourceFileAttribute(Clazz clazz, SourceFileAttribute sourceFileAttribute) {
            ProgramClassWriter.this.dataOutput.writeShort(sourceFileAttribute.u2sourceFileIndex);
        }

        public void visitSourceDirAttribute(Clazz clazz, SourceDirAttribute sourceDirAttribute) {
            ProgramClassWriter.this.dataOutput.writeShort(sourceDirAttribute.u2sourceDirIndex);
        }

        public void visitInnerClassesAttribute(Clazz clazz, InnerClassesAttribute innerClassesAttribute) {
            ProgramClassWriter.this.dataOutput.writeShort(innerClassesAttribute.u2classesCount);
            innerClassesAttribute.innerClassEntriesAccept(clazz, this);
        }

        public void visitEnclosingMethodAttribute(Clazz clazz, EnclosingMethodAttribute enclosingMethodAttribute) {
            ProgramClassWriter.this.dataOutput.writeShort(enclosingMethodAttribute.u2classIndex);
            ProgramClassWriter.this.dataOutput.writeShort(enclosingMethodAttribute.u2nameAndTypeIndex);
        }

        public void visitDeprecatedAttribute(Clazz clazz, DeprecatedAttribute deprecatedAttribute) {
        }

        public void visitSyntheticAttribute(Clazz clazz, SyntheticAttribute syntheticAttribute) {
        }

        public void visitSignatureAttribute(Clazz clazz, SignatureAttribute signatureAttribute) {
            ProgramClassWriter.this.dataOutput.writeShort(signatureAttribute.u2signatureIndex);
        }

        public void visitConstantValueAttribute(Clazz clazz, Field field, ConstantValueAttribute constantValueAttribute) {
            ProgramClassWriter.this.dataOutput.writeShort(constantValueAttribute.u2constantValueIndex);
        }

        public void visitExceptionsAttribute(Clazz clazz, Method method, ExceptionsAttribute exceptionsAttribute) {
            ProgramClassWriter.this.dataOutput.writeShort(exceptionsAttribute.u2exceptionIndexTableLength);
            for (int i = 0; i < exceptionsAttribute.u2exceptionIndexTableLength; ++i) {
                ProgramClassWriter.this.dataOutput.writeShort(exceptionsAttribute.u2exceptionIndexTable[i]);
            }
        }

        public void visitCodeAttribute(Clazz clazz, Method method, CodeAttribute codeAttribute) {
            ProgramClassWriter.this.dataOutput.writeShort(codeAttribute.u2maxStack);
            ProgramClassWriter.this.dataOutput.writeShort(codeAttribute.u2maxLocals);
            ProgramClassWriter.this.dataOutput.writeInt(codeAttribute.u4codeLength);
            ProgramClassWriter.this.dataOutput.write(codeAttribute.code, 0, codeAttribute.u4codeLength);
            ProgramClassWriter.this.dataOutput.writeShort(codeAttribute.u2exceptionTableLength);
            codeAttribute.exceptionsAccept(clazz, method, this);
            ProgramClassWriter.this.dataOutput.writeShort(codeAttribute.u2attributesCount);
            codeAttribute.attributesAccept(clazz, method, ProgramClassWriter.this);
        }

        public void visitStackMapAttribute(Clazz clazz, Method method, CodeAttribute codeAttribute, StackMapAttribute stackMapAttribute) {
            ProgramClassWriter.this.dataOutput.writeShort(stackMapAttribute.u2stackMapFramesCount);
            stackMapAttribute.stackMapFramesAccept(clazz, method, codeAttribute, ProgramClassWriter.this.stackMapFrameBodyWriter);
        }

        public void visitStackMapTableAttribute(Clazz clazz, Method method, CodeAttribute codeAttribute, StackMapTableAttribute stackMapTableAttribute) {
            ProgramClassWriter.this.dataOutput.writeShort(stackMapTableAttribute.u2stackMapFramesCount);
            stackMapTableAttribute.stackMapFramesAccept(clazz, method, codeAttribute, this);
        }

        public void visitLineNumberTableAttribute(Clazz clazz, Method method, CodeAttribute codeAttribute, LineNumberTableAttribute lineNumberTableAttribute) {
            ProgramClassWriter.this.dataOutput.writeShort(lineNumberTableAttribute.u2lineNumberTableLength);
            lineNumberTableAttribute.lineNumbersAccept(clazz, method, codeAttribute, this);
        }

        public void visitLocalVariableTableAttribute(Clazz clazz, Method method, CodeAttribute codeAttribute, LocalVariableTableAttribute localVariableTableAttribute) {
            ProgramClassWriter.this.dataOutput.writeShort(localVariableTableAttribute.u2localVariableTableLength);
            localVariableTableAttribute.localVariablesAccept(clazz, method, codeAttribute, this);
        }

        public void visitLocalVariableTypeTableAttribute(Clazz clazz, Method method, CodeAttribute codeAttribute, LocalVariableTypeTableAttribute localVariableTypeTableAttribute) {
            ProgramClassWriter.this.dataOutput.writeShort(localVariableTypeTableAttribute.u2localVariableTypeTableLength);
            localVariableTypeTableAttribute.localVariablesAccept(clazz, method, codeAttribute, this);
        }

        public void visitAnyAnnotationsAttribute(Clazz clazz, AnnotationsAttribute annotationsAttribute) {
            ProgramClassWriter.this.dataOutput.writeShort(annotationsAttribute.u2annotationsCount);
            annotationsAttribute.annotationsAccept(clazz, this);
        }

        public void visitAnyParameterAnnotationsAttribute(Clazz clazz, Method method, ParameterAnnotationsAttribute parameterAnnotationsAttribute) {
            ProgramClassWriter.this.dataOutput.writeByte(parameterAnnotationsAttribute.u2parametersCount);
            for (int i = 0; i < parameterAnnotationsAttribute.u2parametersCount; ++i) {
                int n = parameterAnnotationsAttribute.u2parameterAnnotationsCount[i];
                Annotation[] annotationArray = parameterAnnotationsAttribute.parameterAnnotations[i];
                ProgramClassWriter.this.dataOutput.writeShort(n);
                for (int j = 0; j < n; ++j) {
                    Annotation annotation = annotationArray[j];
                    this.visitAnnotation(clazz, annotation);
                }
            }
        }

        public void visitAnnotationDefaultAttribute(Clazz clazz, Method method, AnnotationDefaultAttribute annotationDefaultAttribute) {
            annotationDefaultAttribute.defaultValue.accept(clazz, null, this);
        }

        public void visitInnerClassesInfo(Clazz clazz, InnerClassesInfo innerClassesInfo) {
            ProgramClassWriter.this.dataOutput.writeShort(innerClassesInfo.u2innerClassIndex);
            ProgramClassWriter.this.dataOutput.writeShort(innerClassesInfo.u2outerClassIndex);
            ProgramClassWriter.this.dataOutput.writeShort(innerClassesInfo.u2innerNameIndex);
            ProgramClassWriter.this.dataOutput.writeShort(innerClassesInfo.u2innerClassAccessFlags);
        }

        public void visitExceptionInfo(Clazz clazz, Method method, CodeAttribute codeAttribute, ExceptionInfo exceptionInfo) {
            ProgramClassWriter.this.dataOutput.writeShort(exceptionInfo.u2startPC);
            ProgramClassWriter.this.dataOutput.writeShort(exceptionInfo.u2endPC);
            ProgramClassWriter.this.dataOutput.writeShort(exceptionInfo.u2handlerPC);
            ProgramClassWriter.this.dataOutput.writeShort(exceptionInfo.u2catchType);
        }

        public void visitAnyStackMapFrame(Clazz clazz, Method method, CodeAttribute codeAttribute, int n, StackMapFrame stackMapFrame) {
            ProgramClassWriter.this.dataOutput.writeByte(stackMapFrame.getTag());
            stackMapFrame.accept(clazz, method, codeAttribute, n, ProgramClassWriter.this.stackMapFrameBodyWriter);
        }

        public void visitLineNumberInfo(Clazz clazz, Method method, CodeAttribute codeAttribute, LineNumberInfo lineNumberInfo) {
            ProgramClassWriter.this.dataOutput.writeShort(lineNumberInfo.u2startPC);
            ProgramClassWriter.this.dataOutput.writeShort(lineNumberInfo.u2lineNumber);
        }

        public void visitLocalVariableInfo(Clazz clazz, Method method, CodeAttribute codeAttribute, LocalVariableInfo localVariableInfo) {
            ProgramClassWriter.this.dataOutput.writeShort(localVariableInfo.u2startPC);
            ProgramClassWriter.this.dataOutput.writeShort(localVariableInfo.u2length);
            ProgramClassWriter.this.dataOutput.writeShort(localVariableInfo.u2nameIndex);
            ProgramClassWriter.this.dataOutput.writeShort(localVariableInfo.u2descriptorIndex);
            ProgramClassWriter.this.dataOutput.writeShort(localVariableInfo.u2index);
        }

        public void visitLocalVariableTypeInfo(Clazz clazz, Method method, CodeAttribute codeAttribute, LocalVariableTypeInfo localVariableTypeInfo) {
            ProgramClassWriter.this.dataOutput.writeShort(localVariableTypeInfo.u2startPC);
            ProgramClassWriter.this.dataOutput.writeShort(localVariableTypeInfo.u2length);
            ProgramClassWriter.this.dataOutput.writeShort(localVariableTypeInfo.u2nameIndex);
            ProgramClassWriter.this.dataOutput.writeShort(localVariableTypeInfo.u2signatureIndex);
            ProgramClassWriter.this.dataOutput.writeShort(localVariableTypeInfo.u2index);
        }

        public void visitAnnotation(Clazz clazz, Annotation annotation) {
            ProgramClassWriter.this.dataOutput.writeShort(annotation.u2typeIndex);
            ProgramClassWriter.this.dataOutput.writeShort(annotation.u2elementValuesCount);
            annotation.elementValuesAccept(clazz, this);
        }

        public void visitAnyElementValue(Clazz clazz, Annotation annotation, ElementValue elementValue) {
            int n = elementValue.u2elementNameIndex;
            if (n != 0) {
                ProgramClassWriter.this.dataOutput.writeShort(n);
            }
            ProgramClassWriter.this.dataOutput.writeByte(elementValue.getTag());
            elementValue.accept(clazz, annotation, ProgramClassWriter.this.elementValueBodyWriter);
        }
    }

    private class ConstantBodyWriter
    extends SimplifiedVisitor
    implements ConstantVisitor {
        private ConstantBodyWriter() {
        }

        public void visitIntegerConstant(Clazz clazz, IntegerConstant integerConstant) {
            ProgramClassWriter.this.dataOutput.writeInt(integerConstant.u4value);
        }

        public void visitLongConstant(Clazz clazz, LongConstant longConstant) {
            ProgramClassWriter.this.dataOutput.writeLong(longConstant.u8value);
        }

        public void visitFloatConstant(Clazz clazz, FloatConstant floatConstant) {
            ProgramClassWriter.this.dataOutput.writeFloat(floatConstant.f4value);
        }

        public void visitDoubleConstant(Clazz clazz, DoubleConstant doubleConstant) {
            ProgramClassWriter.this.dataOutput.writeDouble(doubleConstant.f8value);
        }

        public void visitStringConstant(Clazz clazz, StringConstant stringConstant) {
            ProgramClassWriter.this.dataOutput.writeShort(stringConstant.u2stringIndex);
        }

        public void visitUtf8Constant(Clazz clazz, Utf8Constant utf8Constant) {
            byte[] byArray = utf8Constant.getBytes();
            ProgramClassWriter.this.dataOutput.writeShort(byArray.length);
            ProgramClassWriter.this.dataOutput.write(byArray);
        }

        public void visitAnyRefConstant(Clazz clazz, RefConstant refConstant) {
            ProgramClassWriter.this.dataOutput.writeShort(refConstant.u2classIndex);
            ProgramClassWriter.this.dataOutput.writeShort(refConstant.u2nameAndTypeIndex);
        }

        public void visitClassConstant(Clazz clazz, ClassConstant classConstant) {
            ProgramClassWriter.this.dataOutput.writeShort(classConstant.u2nameIndex);
        }

        public void visitNameAndTypeConstant(Clazz clazz, NameAndTypeConstant nameAndTypeConstant) {
            ProgramClassWriter.this.dataOutput.writeShort(nameAndTypeConstant.u2nameIndex);
            ProgramClassWriter.this.dataOutput.writeShort(nameAndTypeConstant.u2descriptorIndex);
        }
    }
}

