/*
 * Decompiled with CFR 0.152.
 */
package proguard.classfile;

import proguard.classfile.Clazz;
import proguard.classfile.Field;
import proguard.classfile.LibraryField;
import proguard.classfile.LibraryMethod;
import proguard.classfile.Method;
import proguard.classfile.attribute.visitor.AttributeVisitor;
import proguard.classfile.constant.visitor.ConstantVisitor;
import proguard.classfile.visitor.ClassVisitor;
import proguard.classfile.visitor.MemberVisitor;

public class LibraryClass
implements Clazz {
    public int u2accessFlags;
    public String thisClassName;
    public String superClassName;
    public String[] interfaceNames;
    public LibraryField[] fields;
    public LibraryMethod[] methods;
    public Clazz superClass;
    public Clazz[] interfaceClasses;
    public Clazz[] subClasses;
    public Object visitorInfo;

    boolean isVisible() {
        return (this.u2accessFlags & 1) != 0;
    }

    public int getAccessFlags() {
        return this.u2accessFlags;
    }

    public String getName() {
        return this.thisClassName;
    }

    public String getSuperName() {
        return this.superClassName;
    }

    public int getInterfaceCount() {
        return this.interfaceClasses.length;
    }

    public String getInterfaceName(int n) {
        return this.interfaceNames[n];
    }

    public int getTag(int n) {
        throw new UnsupportedOperationException("Library class [" + this.thisClassName + "] doesn't store constant pool");
    }

    public String getString(int n) {
        throw new UnsupportedOperationException("Library class [" + this.thisClassName + "] doesn't store constant pool");
    }

    public String getStringString(int n) {
        throw new UnsupportedOperationException("Library class [" + this.thisClassName + "] doesn't store constant pool");
    }

    public String getClassName(int n) {
        throw new UnsupportedOperationException("Library class [" + this.thisClassName + "] doesn't store constant pool");
    }

    public String getName(int n) {
        throw new UnsupportedOperationException("Library class [" + this.thisClassName + "] doesn't store constant pool");
    }

    public String getType(int n) {
        throw new UnsupportedOperationException("Library class [" + this.thisClassName + "] doesn't store constant pool");
    }

    public void addSubClass(Clazz clazz) {
        if (this.subClasses == null) {
            this.subClasses = new Clazz[1];
        } else {
            Clazz[] clazzArray = new Clazz[this.subClasses.length + 1];
            System.arraycopy(this.subClasses, 0, clazzArray, 0, this.subClasses.length);
            this.subClasses = clazzArray;
        }
        this.subClasses[this.subClasses.length - 1] = clazz;
    }

    public Clazz getSuperClass() {
        return this.superClass;
    }

    public Clazz getInterface(int n) {
        return this.interfaceClasses[n];
    }

    public boolean extends_(Clazz clazz) {
        if (this.equals(clazz)) {
            return true;
        }
        return this.superClass != null && this.superClass.extends_(clazz);
    }

    public boolean extendsOrImplements(Clazz clazz) {
        if (this.equals(clazz)) {
            return true;
        }
        if (this.superClass != null && this.superClass.extendsOrImplements(clazz)) {
            return true;
        }
        if (this.interfaceClasses != null) {
            for (int i = 0; i < this.interfaceClasses.length; ++i) {
                Clazz clazz2 = this.interfaceClasses[i];
                if (clazz2 == null || !clazz2.extendsOrImplements(clazz)) continue;
                return true;
            }
        }
        return false;
    }

    public Field findField(String string, String string2) {
        for (int i = 0; i < this.fields.length; ++i) {
            LibraryField libraryField = this.fields[i];
            if (libraryField == null || string != null && !libraryField.getName(this).equals(string) || string2 != null && !libraryField.getDescriptor(this).equals(string2)) continue;
            return libraryField;
        }
        return null;
    }

    public Method findMethod(String string, String string2) {
        for (int i = 0; i < this.methods.length; ++i) {
            LibraryMethod libraryMethod = this.methods[i];
            if (libraryMethod == null || string != null && !libraryMethod.getName(this).equals(string) || string2 != null && !libraryMethod.getDescriptor(this).equals(string2)) continue;
            return libraryMethod;
        }
        return null;
    }

    public void accept(ClassVisitor classVisitor) {
        classVisitor.visitLibraryClass(this);
    }

    public void hierarchyAccept(boolean bl, boolean bl2, boolean bl3, boolean bl4, ClassVisitor classVisitor) {
        int n;
        if (bl) {
            this.accept(classVisitor);
        }
        if (bl2 && this.superClass != null) {
            this.superClass.hierarchyAccept(true, true, bl3, false, classVisitor);
        }
        if (bl3 && this.interfaceClasses != null) {
            for (n = 0; n < this.interfaceClasses.length; ++n) {
                Clazz clazz = this.interfaceClasses[n];
                if (clazz == null) continue;
                clazz.hierarchyAccept(true, true, true, false, classVisitor);
            }
        }
        if (bl4 && this.subClasses != null) {
            for (n = 0; n < this.subClasses.length; ++n) {
                this.subClasses[n].hierarchyAccept(true, false, false, true, classVisitor);
            }
        }
    }

    public void constantPoolEntriesAccept(ConstantVisitor constantVisitor) {
    }

    public void constantPoolEntryAccept(int n, ConstantVisitor constantVisitor) {
    }

    public void fieldsAccept(MemberVisitor memberVisitor) {
        for (int i = 0; i < this.fields.length; ++i) {
            LibraryField libraryField = this.fields[i];
            if (libraryField == null) continue;
            libraryField.accept((Clazz)this, memberVisitor);
        }
    }

    public void fieldAccept(String string, String string2, MemberVisitor memberVisitor) {
        Field field = this.findField(string, string2);
        if (field != null) {
            field.accept(this, memberVisitor);
        }
    }

    public void methodsAccept(MemberVisitor memberVisitor) {
        for (int i = 0; i < this.methods.length; ++i) {
            LibraryMethod libraryMethod = this.methods[i];
            if (libraryMethod == null) continue;
            libraryMethod.accept((Clazz)this, memberVisitor);
        }
    }

    public void methodAccept(String string, String string2, MemberVisitor memberVisitor) {
        Method method = this.findMethod(string, string2);
        if (method != null) {
            method.accept(this, memberVisitor);
        }
    }

    public boolean mayHaveImplementations(Method method) {
        return (this.u2accessFlags & 0x10) == 0 && (method == null || (method.getAccessFlags() & 0x1A) == 0 && !method.getName(this).equals("<init>"));
    }

    private boolean isSpecial(Method method) {
        return (method.getAccessFlags() & 0xA) != 0 || method.getName(this).equals("<init>");
    }

    public void methodImplementationsAccept(Method method, boolean bl, MemberVisitor memberVisitor) {
        this.methodImplementationsAccept(method.getName(this), method.getDescriptor(this), method, bl, true, true, true, memberVisitor);
    }

    public void methodImplementationsAccept(String string, String string2, boolean bl, MemberVisitor memberVisitor) {
        this.methodImplementationsAccept(string, string2, bl, true, true, true, memberVisitor);
    }

    public void methodImplementationsAccept(String string, String string2, boolean bl, boolean bl2, boolean bl3, boolean bl4, MemberVisitor memberVisitor) {
        this.methodImplementationsAccept(string, string2, this.findMethod(string, string2), bl, bl2, bl3, bl4, memberVisitor);
    }

    public void methodImplementationsAccept(String string, String string2, Method method, boolean bl, boolean bl2, boolean bl3, boolean bl4, MemberVisitor memberVisitor) {
        if (method != null) {
            if (this.isSpecial(method)) {
                if (bl2) {
                    method.accept(this, memberVisitor);
                    return;
                }
            } else {
                if (bl) {
                    method.accept(this, memberVisitor);
                }
                if (!this.mayHaveImplementations(method)) {
                    bl4 = false;
                }
                if ((method.getAccessFlags() & 0x400) == 0) {
                    bl3 = false;
                }
            }
        }
        if (bl4) {
            if (this.subClasses != null) {
                for (int i = 0; i < this.subClasses.length; ++i) {
                    Clazz clazz = this.subClasses[i];
                    clazz.methodImplementationsAccept(string, string2, true, false, bl3, true, memberVisitor);
                }
            }
            if ((this.u2accessFlags & 0x600) != 0) {
                bl3 = false;
            }
        }
        if (bl3 && this.superClass != null) {
            this.superClass.methodImplementationsAccept(string, string2, true, false, true, false, memberVisitor);
        }
    }

    public void attributesAccept(AttributeVisitor attributeVisitor) {
        throw new UnsupportedOperationException("Library class [" + this.thisClassName + "] doesn't store attributes");
    }

    public Object getVisitorInfo() {
        return this.visitorInfo;
    }

    public void setVisitorInfo(Object object) {
        this.visitorInfo = object;
    }
}

