/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.tasklist.todo.settings;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.prefs.Preferences;
import org.openide.util.NbPreferences;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Settings {
    public static final String PROP_PATTERN_LIST = "patternList";
    public static final String PROP_SCAN_COMMENTS_ONLY = "scanCommentsOnly";
    private static Settings theInstance;
    private static final String PATTERN_DELIMITER = "|";
    private ArrayList<String> patterns = new ArrayList(10);
    private Map<String, CommentTags> ext2comments = new HashMap<String, CommentTags>(10);
    private Map<String, CommentTags> mime2comments = new HashMap<String, CommentTags>(10);
    private boolean scanCommentsOnly = true;
    private PropertyChangeSupport propertySupport;

    private Settings() {
        this.patterns.addAll(Settings.decodePatterns(this.getPreferences().get("patterns", "@todo|TODO|FIXME|XXX|PENDING|<<<<<<<")));
        this.scanCommentsOnly = this.getPreferences().getBoolean(PROP_SCAN_COMMENTS_ONLY, true);
        this.ext2comments.put("JAVA", new CommentTags("//", "/*", "*/"));
        this.ext2comments.put("JS", new CommentTags("//", "/*", "*/"));
        this.ext2comments.put("C", new CommentTags("//", "/*", "*/"));
        this.ext2comments.put("CPP", new CommentTags("//", "/*", "*/"));
        this.ext2comments.put("CXX", new CommentTags("//", "/*", "*/"));
        this.ext2comments.put("CC", new CommentTags("//", "/*", "*/"));
        this.ext2comments.put("H", new CommentTags("//", "/*", "*/"));
        this.ext2comments.put("HTML", new CommentTags("<!--", "-->"));
        this.ext2comments.put("HTM", new CommentTags("<!--", "-->"));
        this.ext2comments.put("XML", new CommentTags("<!--", "-->"));
        this.ext2comments.put("JSP", new CommentTags("<%--", "--%>"));
        this.ext2comments.put("CSS", new CommentTags("/*", "*/"));
        this.ext2comments.put("PROPERTIES", new CommentTags("#"));
        this.ext2comments.put("SH", new CommentTags("#"));
        this.ext2comments.put("RB", new CommentTags("#"));
        this.ext2comments.put("PHP", new CommentTags("//", "/*", "*/"));
        this.mime2comments.put("text/x-java", new CommentTags("//", "/*", "*/"));
        this.mime2comments.put("text/html", new CommentTags("<!--", "-->"));
        this.mime2comments.put("application/x-httpd-eruby", new CommentTags("<!--", "-->"));
        this.mime2comments.put("text/x-ruby", new CommentTags("#"));
    }

    public static final Settings getDefault() {
        if (null == theInstance) {
            theInstance = new Settings();
        }
        return theInstance;
    }

    public Collection<String> getPatterns() {
        return Collections.unmodifiableCollection(this.patterns);
    }

    public void setPatterns(Collection<String> collection) {
        this.patterns.clear();
        this.patterns.addAll(collection);
        this.getPreferences().put("patterns", Settings.encodePatterns(collection));
        if (null == this.propertySupport) {
            this.propertySupport = new PropertyChangeSupport(this);
        }
        this.propertySupport.firePropertyChange(PROP_PATTERN_LIST, null, this.getPatterns());
    }

    public boolean isExtensionSupported(String string) {
        return null != this.ext2comments.get(string.toUpperCase());
    }

    public boolean isMimeTypeSupported(String string) {
        return null != this.mime2comments.get(string);
    }

    public String getLineComment(String string, String string2) {
        CommentTags commentTags = this.ext2comments.get(string.toUpperCase());
        if (null == commentTags) {
            commentTags = this.mime2comments.get(string2);
        }
        return null == commentTags ? null : commentTags.lineComment;
    }

    public String getBlockCommentStart(String string, String string2) {
        CommentTags commentTags = this.ext2comments.get(string.toUpperCase());
        if (null == commentTags) {
            commentTags = this.mime2comments.get(string2);
        }
        return null == commentTags ? null : commentTags.blockCommentStart;
    }

    public String getBlockCommentEnd(String string, String string2) {
        CommentTags commentTags = this.ext2comments.get(string.toUpperCase());
        if (null == commentTags) {
            commentTags = this.mime2comments.get(string2);
        }
        return null == commentTags ? null : commentTags.blockCommentEnd;
    }

    public boolean isScanCommentsOnly() {
        return this.scanCommentsOnly;
    }

    public void setScanCommentsOnly(boolean bl) {
        boolean bl2 = this.scanCommentsOnly;
        this.scanCommentsOnly = bl;
        this.getPreferences().putBoolean(PROP_SCAN_COMMENTS_ONLY, bl);
        if (null == this.propertySupport) {
            this.propertySupport = new PropertyChangeSupport(this);
        }
        this.propertySupport.firePropertyChange(PROP_SCAN_COMMENTS_ONLY, bl2, bl);
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (null == this.propertySupport) {
            this.propertySupport = new PropertyChangeSupport(this);
        }
        this.propertySupport.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (null != this.propertySupport) {
            this.propertySupport.removePropertyChangeListener(propertyChangeListener);
        }
    }

    private Preferences getPreferences() {
        return NbPreferences.forModule(Settings.class);
    }

    private static Collection<String> decodePatterns(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, PATTERN_DELIMITER, false);
        ArrayList<String> arrayList = new ArrayList<String>();
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            arrayList.add(string2);
        }
        return arrayList;
    }

    private static String encodePatterns(Collection<String> collection) {
        StringBuffer stringBuffer = new StringBuffer();
        for (String string : collection) {
            stringBuffer.append(string);
            stringBuffer.append(PATTERN_DELIMITER);
        }
        return stringBuffer.toString();
    }

    private static class CommentTags {
        private String lineComment;
        private String blockCommentStart;
        private String blockCommentEnd;

        public CommentTags(String string, String string2, String string3) {
            this.lineComment = string;
            this.blockCommentStart = string2;
            this.blockCommentEnd = string3;
        }

        public CommentTags(String string, String string2) {
            this.blockCommentStart = string;
            this.blockCommentEnd = string2;
        }

        public CommentTags(String string) {
            this.lineComment = string;
        }
    }
}

