/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.tasklist.todo;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.netbeans.api.queries.FileEncodingQuery;
import org.netbeans.modules.tasklist.todo.SourceCodeCommentParser;
import org.netbeans.modules.tasklist.todo.settings.Settings;
import org.netbeans.spi.tasklist.FileTaskScanner;
import org.netbeans.spi.tasklist.Task;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TodoTaskScanner
extends FileTaskScanner
implements PropertyChangeListener {
    private static final String GROUP_NAME = "nb-tasklist-todo";
    private Pattern regexp = null;
    private FileTaskScanner.Callback callback;

    TodoTaskScanner(String string, String string2) {
        super(string, string2, "Advanced/ToDo");
    }

    public static TodoTaskScanner create() {
        return new TodoTaskScanner(NbBundle.getBundle(TodoTaskScanner.class).getString("LBL_todotask"), NbBundle.getBundle(TodoTaskScanner.class).getString("HINT_todotask"));
    }

    public List<? extends Task> scan(FileObject fileObject) {
        if (!this.isSupported(fileObject)) {
            return null;
        }
        if (Settings.getDefault().isScanCommentsOnly()) {
            return this.scanComments(fileObject);
        }
        return this.scanAll(fileObject);
    }

    private List<? extends Task> scanAll(FileObject fileObject) {
        List<? extends Task> list = null;
        try {
            String string = this.getContent(fileObject);
            int n = 0;
            int n2 = 1;
            int n3 = string.length();
            Matcher matcher = this.getScanRegexp().matcher(string);
            while (n < n3 && matcher.find(n)) {
                int n4;
                int n5 = matcher.end();
                int n6 = 97;
                int n7 = n4;
                for (n4 = matcher.start(); n4 >= n; --n4) {
                    char c = string.charAt(n4);
                    n6 = c;
                    if (c == '\n') break;
                    if (n6 == 32 || n6 == 9) continue;
                    n7 = n4;
                }
                n4 = n7;
                n7 = n5;
                while (n5 < n3 && (n6 = (int)string.charAt(n5)) != 10 && n6 != 13) {
                    if (n6 != 32 && n6 != 9) {
                        n7 = n5;
                    }
                    ++n5;
                }
                for (int i = n; i <= n4; ++i) {
                    if (string.charAt(i) != '\n') continue;
                    ++n2;
                }
                n = n5;
                String string2 = ((Object)string.subSequence(n4, n7 + 1)).toString();
                Task task = Task.create((FileObject)fileObject, (String)GROUP_NAME, (String)string2, (int)n2);
                if (null == list) {
                    list = new LinkedList<Task>();
                }
                list.add((Task)task);
            }
        }
        catch (IOException iOException) {
            Logger.getLogger(this.getClass().getName()).log(Level.INFO, null, iOException);
        }
        catch (OutOfMemoryError outOfMemoryError) {
            System.gc();
            Logger.getLogger(this.getClass().getName()).log(Level.INFO, null, outOfMemoryError);
        }
        return null == list ? this.getEmptyList() : list;
    }

    private List<? extends Task> scanComments(FileObject fileObject) {
        String string = fileObject.getExt().toLowerCase();
        String string2 = FileUtil.getMIMEType((FileObject)fileObject);
        String string3 = Settings.getDefault().getLineComment(string, string2);
        String string4 = Settings.getDefault().getBlockCommentStart(string, string2);
        String string5 = Settings.getDefault().getBlockCommentEnd(string, string2);
        SourceCodeCommentParser sourceCodeCommentParser = new SourceCodeCommentParser(string3, string4, string5);
        List<? extends Task> list = null;
        try {
            String string6 = this.getContent(fileObject);
            sourceCodeCommentParser.setText(string6);
            SourceCodeCommentParser.CommentRegion commentRegion = new SourceCodeCommentParser.CommentRegion();
            Matcher matcher = this.getScanRegexp().matcher(string6);
            int n = string6.length();
            int n2 = 1;
            int n3 = 0;
            int n4 = 0;
            if (!sourceCodeCommentParser.nextRegion(commentRegion)) {
                return this.getEmptyList();
            }
            while (n3 < n && matcher.find(n3)) {
                boolean bl;
                int n5 = matcher.start();
                int n6 = matcher.end();
                boolean bl2 = false;
                do {
                    bl = true;
                    if (n5 < commentRegion.start) {
                        bl2 = true;
                        continue;
                    }
                    if (n5 <= commentRegion.stop) continue;
                    bl = false;
                    if (sourceCodeCommentParser.nextRegion(commentRegion)) continue;
                    return null == list ? this.getEmptyList() : list;
                } while (!bl);
                if (bl2) {
                    n3 = n6;
                    continue;
                }
                int n7 = 97;
                int n8 = n5;
                while (n5 >= n3) {
                    char c = string6.charAt(n5);
                    n7 = c;
                    if (c == '\n') break;
                    if (n7 != 32 && n7 != 9) {
                        n8 = n5;
                    }
                    --n5;
                }
                n5 = n8;
                n8 = n6;
                while (n6 < n && (n7 = (int)string6.charAt(n6)) != 10 && n7 != 13) {
                    if (n7 != 32 && n7 != 9) {
                        n8 = n6;
                    }
                    ++n6;
                }
                while (n4 <= n5) {
                    if (string6.charAt(n4) == '\n') {
                        ++n2;
                    }
                    ++n4;
                }
                n3 = n6;
                String string7 = ((Object)string6.subSequence(n5, n8 + 1)).toString();
                Task task = Task.create((FileObject)fileObject, (String)GROUP_NAME, (String)string7, (int)n2);
                if (null == list) {
                    list = new LinkedList<Task>();
                }
                list.add((Task)task);
            }
        }
        catch (IOException iOException) {
            Logger.getLogger(this.getClass().getName()).log(Level.INFO, null, iOException);
        }
        catch (OutOfMemoryError outOfMemoryError) {
            System.gc();
            Logger.getLogger(this.getClass().getName()).log(Level.INFO, null, outOfMemoryError);
        }
        return null == list ? this.getEmptyList() : list;
    }

    private boolean isSupported(FileObject fileObject) {
        if (null == fileObject || fileObject.isFolder()) {
            return false;
        }
        return Settings.getDefault().isExtensionSupported(fileObject.getExt()) || Settings.getDefault().isMimeTypeSupported(FileUtil.getMIMEType((FileObject)fileObject));
    }

    Pattern getScanRegexp() {
        if (this.regexp == null) {
            StringBuffer stringBuffer = new StringBuffer(200);
            Collection<String> collection = Settings.getDefault().getPatterns();
            boolean bl = false;
            for (String string : collection) {
                if (bl) {
                    stringBuffer.append('|');
                }
                bl = true;
                int n = string.length();
                if (Character.isJavaIdentifierPart(string.charAt(0))) {
                    stringBuffer.append("\\W");
                }
                for (int i = 0; i < n; ++i) {
                    char c = string.charAt(i);
                    if (c == '(' || c == ')' || c == '{' || c == '}' || c == '[' || c == ']' || c == '?' || c == '*' || c == '+' || c == '!' || c == '|' || c == '\\' || c == '^' || c == '$') {
                        stringBuffer.append('\\');
                    }
                    stringBuffer.append(c);
                }
                if (!Character.isJavaIdentifierPart(string.charAt(n - 1))) continue;
                stringBuffer.append("\\b");
            }
            try {
                this.regexp = Pattern.compile(stringBuffer.toString());
            }
            catch (PatternSyntaxException patternSyntaxException) {
                Logger.getLogger(this.getClass().getName()).log(Level.INFO, null, patternSyntaxException);
                return null;
            }
        }
        return this.regexp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getContent(FileObject fileObject) throws IOException {
        char[] cArray = new char[65536];
        StringBuffer stringBuffer = new StringBuffer();
        Charset charset = FileEncodingQuery.getEncoding((FileObject)fileObject);
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(fileObject.getInputStream(), charset));
        try {
            int n;
            while ((n = bufferedReader.read(cArray)) != -1) {
                stringBuffer.append(cArray, 0, n);
            }
        }
        finally {
            ((Reader)bufferedReader).close();
        }
        return stringBuffer.toString();
    }

    private List<? extends Task> getEmptyList() {
        List list = Collections.emptyList();
        return list;
    }

    public void attach(FileTaskScanner.Callback callback) {
        if (null == callback && null != this.callback) {
            this.regexp = null;
            Settings.getDefault().removePropertyChangeListener(this);
        } else if (null != callback && null == this.callback) {
            Settings.getDefault().addPropertyChangeListener(this);
        }
        this.callback = callback;
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if ("patternList".equals(propertyChangeEvent.getPropertyName()) || "scanCommentsOnly".equals(propertyChangeEvent.getPropertyName())) {
            this.regexp = null;
            if (null != this.callback) {
                this.callback.refreshAll();
            }
        }
    }

    public void notifyPrepare() {
        this.getScanRegexp();
    }

    public void notifyFinish() {
        this.regexp = null;
    }
}

