/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.schema.abe;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.SpringLayout;
import javax.swing.SwingUtilities;
import org.netbeans.modules.xml.axi.AXIComponent;
import org.netbeans.modules.xml.schema.abe.ABEBaseDropPanel;
import org.netbeans.modules.xml.schema.abe.AutoSizingPanel;
import org.netbeans.modules.xml.schema.abe.ContainerPanel;
import org.netbeans.modules.xml.schema.abe.ExpandCollapseButton;
import org.netbeans.modules.xml.schema.abe.InstanceDesignConstants;
import org.netbeans.modules.xml.schema.abe.InstanceUIContext;
import org.netbeans.modules.xml.schema.abe.ModelEventMediator;
import org.netbeans.modules.xml.schema.abe.UIVisitor;
import org.openide.util.NbBundle;

public abstract class TitleWrapperPanel
extends ABEBaseDropPanel {
    private static final long serialVersionUID = 7526472295622776147L;
    ContainerPanel child;
    String titleString;
    AXIComponent countComponent;
    ExpandCollapseButton expandCollapseButton;
    JLabel countLabel;
    private boolean openByDefault;
    private static final String locItem = NbBundle.getMessage(TitleWrapperPanel.class, (String)"LBL_ITEM_STRING");
    private static final String locItems = NbBundle.getMessage(TitleWrapperPanel.class, (String)"LBL_ITEMS_STRING");
    private static final String locHidden = NbBundle.getMessage(TitleWrapperPanel.class, (String)"LBL_HIDDEN");
    public static final int TITLE_BEGIN_FUDGE = 14;

    public TitleWrapperPanel(ContainerPanel containerPanel, String string, AXIComponent aXIComponent, boolean bl, InstanceUIContext instanceUIContext) {
        super(instanceUIContext);
        this.child = containerPanel;
        this.titleString = string;
        this.countComponent = aXIComponent;
        this.openByDefault = bl;
        this.initialize();
        this.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                TitleWrapperPanel.this.child.dispatchEvent(mouseEvent);
            }

            public void mousePressed(MouseEvent mouseEvent) {
                TitleWrapperPanel.this.child.dispatchEvent(mouseEvent);
            }

            public void mouseReleased(MouseEvent mouseEvent) {
                TitleWrapperPanel.this.child.dispatchEvent(mouseEvent);
            }
        });
    }

    private void initialize() {
        this.setLayout(new BorderLayout());
        this.setOpaque(false);
        SpringLayout springLayout = new SpringLayout();
        AutoSizingPanel autoSizingPanel = new AutoSizingPanel(this.context);
        autoSizingPanel.setLayout(springLayout);
        autoSizingPanel.setHorizontalScaling(true);
        autoSizingPanel.setOpaque(false);
        this.expandCollapseButton = new ExpandCollapseButton("-");
        if (this.openByDefault) {
            this.expandCollapseButton.setText("-");
        } else {
            this.expandCollapseButton.setText("+");
        }
        this.expandCollapseButton.setWatchForComponent(this.child);
        autoSizingPanel.add(this.expandCollapseButton);
        springLayout.putConstraint("West", (Component)this.expandCollapseButton, 0, "West", (Component)autoSizingPanel);
        springLayout.putConstraint("North", (Component)this.expandCollapseButton, 3, "North", (Component)autoSizingPanel);
        this.expandCollapseButton.addActionListener(new ActionListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void actionPerformed(ActionEvent actionEvent) {
                String string = TitleWrapperPanel.this.expandCollapseButton.getText();
                TitleWrapperPanel.this.setCursor(new Cursor(3));
                try {
                    if (string.equals("-")) {
                        TitleWrapperPanel.this.child.setVisible(false);
                    } else {
                        TitleWrapperPanel.this.child.addAllChildren();
                        TitleWrapperPanel.this.child.setVisible(true);
                    }
                    TitleWrapperPanel.this.setCountString();
                }
                finally {
                    TitleWrapperPanel.this.setCursor(new Cursor(0));
                }
            }
        });
        JLabel jLabel = new JLabel(this.titleString);
        jLabel.setDropTarget(new DropTarget(jLabel, new DropTargetListener(){

            public void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
                TitleWrapperPanel.this.dragEnter(dropTargetDragEvent);
            }

            public void dragExit(DropTargetEvent dropTargetEvent) {
                TitleWrapperPanel.this.dragExit(dropTargetEvent);
            }

            public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
                TitleWrapperPanel.this.dragOver(dropTargetDragEvent);
            }

            public void drop(DropTargetDropEvent dropTargetDropEvent) {
                TitleWrapperPanel.this.drop(dropTargetDropEvent);
            }

            public void dropActionChanged(DropTargetDragEvent dropTargetDragEvent) {
                TitleWrapperPanel.this.dropActionChanged(dropTargetDragEvent);
            }
        }));
        Font font = jLabel.getFont();
        font = font.deriveFont(font.getStyle() | 1, font.getSize() + 2);
        jLabel.setFont(font);
        jLabel.setForeground(InstanceDesignConstants.TAG_NAME_COLOR);
        autoSizingPanel.add(jLabel);
        springLayout.putConstraint("West", (Component)jLabel, 2, "East", (Component)this.expandCollapseButton);
        springLayout.putConstraint("North", (Component)jLabel, 0, "North", (Component)autoSizingPanel);
        this.countLabel = this.getCountLabel();
        autoSizingPanel.add(this.countLabel);
        springLayout.putConstraint("West", (Component)this.countLabel, 5, "East", (Component)jLabel);
        springLayout.putConstraint("North", (Component)jLabel, 0, "North", (Component)autoSizingPanel);
        JSeparator jSeparator = new JSeparator();
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setOpaque(false);
        jPanel.add((Component)autoSizingPanel, "Center");
        jPanel.add((Component)jSeparator, "South");
        this.add((Component)jPanel, "North");
        this.add((Component)this.child, "Center");
        if (this.openByDefault) {
            this.child.setVisible(true);
        } else {
            this.child.setVisible(false);
        }
        this.setCountString();
        this.child.addComponentListener(new ComponentAdapter(){

            public void componentHidden(ComponentEvent componentEvent) {
                this.componentShown(componentEvent);
            }

            public void componentShown(ComponentEvent componentEvent) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        TitleWrapperPanel.this.setCountString();
                    }
                });
            }
        });
    }

    public JLabel getCountLabel() {
        int n = this.getChildrenItemsCount();
        this.countLabel = new JLabel(this.getCountString(n));
        this.countComponent.addPropertyChangeListener((PropertyChangeListener)new ModelEventMediator(this, this.countComponent){

            public void _propertyChange(PropertyChangeEvent propertyChangeEvent) {
                TitleWrapperPanel.this.setCountString();
            }
        });
        this.countLabel.setForeground(Color.GRAY);
        return this.countLabel;
    }

    public void setCountString() {
        this.countLabel.setText(this.getCountString(this.getChildrenItemsCount()));
    }

    public abstract int getChildrenItemsCount();

    public String getCountString(int n) {
        String string = this.child.isVisible() || n == 0 ? "" : " " + locHidden;
        String string2 = n == 1 ? "[" + n + " " + locItem + string + "]" : "[" + n + " " + locItems + string + "]";
        return string2;
    }

    public void drop(DropTargetDropEvent dropTargetDropEvent) {
        this.context.getNamespacePanel().drop(dropTargetDropEvent);
    }

    public void dragExit(DropTargetEvent dropTargetEvent) {
        this.context.getNamespacePanel().dragExit(dropTargetEvent);
    }

    public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
        this.context.getNamespacePanel().dragOver(dropTargetDragEvent);
    }

    public void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
        this.context.getNamespacePanel().dragEnter(dropTargetDragEvent);
    }

    public void accept(UIVisitor uIVisitor) {
    }
}

