/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.schema.abe;

import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import org.netbeans.modules.xml.schema.abe.ABEBaseDropPanel;
import org.netbeans.modules.xml.schema.abe.InstanceDesignConstants;
import org.netbeans.modules.xml.schema.abe.InstanceUIContext;

public abstract class GradientShadePanel
extends ABEBaseDropPanel {
    private static final long serialVersionUID = 7526472295622776147L;
    protected boolean draging = false;
    protected Color selectedTopGradientColor = Color.WHITE;
    protected Color selectedBottomGradientColor = InstanceDesignConstants.DARK_BLUE;
    protected Color dragTopGradientColor = Color.WHITE;
    protected Color dragBottomGradientColor = InstanceDesignConstants.XP_ORANGE;
    protected Color normalTopGradientColor = Color.WHITE;
    protected Color normalBottomGradientColor = Color.LIGHT_GRAY.brighter();

    public GradientShadePanel(InstanceUIContext instanceUIContext) {
        super(instanceUIContext);
    }

    public void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        Graphics2D graphics2D = (Graphics2D)graphics;
        Rectangle rectangle = graphics2D.getClipBounds();
        Color color = this.normalTopGradientColor;
        Color color2 = this.normalBottomGradientColor;
        if (this.draging) {
            color = this.dragTopGradientColor;
            color2 = this.dragBottomGradientColor;
        } else if (this.context.getComponentSelectionManager().isSelected(this)) {
            color = this.selectedTopGradientColor;
            color2 = this.selectedBottomGradientColor;
        }
        GradientPaint gradientPaint = new GradientPaint(rectangle.x, rectangle.y, color, rectangle.x, rectangle.height, color2);
        graphics2D.setPaint(gradientPaint);
        graphics2D.fill(rectangle);
    }

    public void dragExit(DropTargetEvent dropTargetEvent) {
        this.draging = false;
        this.repaint();
    }

    public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
        this.draging = true;
        this.repaint();
    }

    public void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
        this.draging = true;
        this.repaint();
    }

    public void drop(DropTargetDropEvent dropTargetDropEvent) {
        this.draging = false;
        this.repaint();
    }
}

