/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.groovy.editor.parser;

import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.ModuleNode;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.groovy.editor.AstPath;
import org.netbeans.modules.groovy.editor.AstUtilities;
import org.netbeans.modules.groovy.editor.VariableScopeVisitor;
import org.netbeans.modules.groovy.editor.lexer.LexUtilities;
import org.netbeans.modules.gsf.api.ColoringAttributes;
import org.netbeans.modules.gsf.api.CompilationInfo;
import org.netbeans.modules.gsf.api.OccurrencesFinder;
import org.netbeans.modules.gsf.api.OffsetRange;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GroovyOccurrencesFinder
implements OccurrencesFinder {
    private boolean cancelled;
    private int caretPosition;
    private Map<OffsetRange, ColoringAttributes> occurrences;
    private final Logger LOG = Logger.getLogger(GroovyOccurrencesFinder.class.getName());

    public Map<OffsetRange, ColoringAttributes> getOccurrences() {
        this.LOG.log(Level.FINEST, "getOccurrences()\n");
        return this.occurrences;
    }

    protected final synchronized boolean isCancelled() {
        return this.cancelled;
    }

    protected final synchronized void resume() {
        this.cancelled = false;
    }

    public final synchronized void cancel() {
        this.cancelled = true;
    }

    public void run(CompilationInfo compilationInfo) {
        this.LOG.log(Level.FINEST, "run()");
        this.resume();
        if (this.isCancelled()) {
            return;
        }
        ModuleNode moduleNode = AstUtilities.getRoot(compilationInfo);
        if (moduleNode == null) {
            return;
        }
        int n = AstUtilities.getAstOffset(compilationInfo, this.caretPosition);
        if (n == -1) {
            return;
        }
        BaseDocument baseDocument = (BaseDocument)compilationInfo.getDocument();
        if (baseDocument == null) {
            this.LOG.log(Level.FINEST, "Could not get BaseDocument. It's null");
            return;
        }
        AstPath astPath = new AstPath((ASTNode)moduleNode, n, baseDocument);
        ASTNode aSTNode = astPath.leaf();
        this.LOG.log(Level.FINEST, "path = {0}", astPath);
        this.LOG.log(Level.FINEST, "closest: {0}", aSTNode);
        if (aSTNode == null) {
            return;
        }
        HashMap<OffsetRange, Object> hashMap = new HashMap<OffsetRange, ColoringAttributes>(100);
        GroovyOccurrencesFinder.highlight(astPath, hashMap, baseDocument);
        if (this.isCancelled()) {
            return;
        }
        if (hashMap.size() > 0) {
            HashMap hashMap2 = new HashMap(2 * hashMap.size());
            for (Map.Entry entry : hashMap.entrySet()) {
                OffsetRange offsetRange = LexUtilities.getLexerOffsets(compilationInfo, (OffsetRange)entry.getKey());
                if (offsetRange == OffsetRange.NONE) continue;
                hashMap2.put(offsetRange, entry.getValue());
            }
            hashMap = hashMap2;
            this.occurrences = hashMap;
        } else {
            this.occurrences = null;
        }
    }

    public void setCaretPosition(int n) {
        this.caretPosition = n;
        this.LOG.log(Level.FINEST, "\n\nsetCaretPosition() = {0}\n", n);
    }

    private static void highlight(AstPath astPath, Map<OffsetRange, ColoringAttributes> map, BaseDocument baseDocument) {
        ASTNode aSTNode = astPath.root();
        assert (aSTNode instanceof ModuleNode);
        ModuleNode moduleNode = (ModuleNode)aSTNode;
        VariableScopeVisitor variableScopeVisitor = new VariableScopeVisitor(moduleNode.getContext(), astPath);
        variableScopeVisitor.collect();
        for (ASTNode aSTNode2 : variableScopeVisitor.getOccurrences()) {
            OffsetRange offsetRange = AstUtilities.getRange(aSTNode2, baseDocument);
            map.put(offsetRange, ColoringAttributes.MARK_OCCURRENCES);
        }
    }
}

