/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.groovy.editor.hints;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.text.BadLocationException;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Utilities;
import org.netbeans.modules.groovy.editor.GroovyCompilerErrorID;
import org.netbeans.modules.groovy.editor.actions.FixImportsHelper;
import org.netbeans.modules.groovy.editor.hints.infrastructure.GroovyErrorRule;
import org.netbeans.modules.groovy.editor.hints.infrastructure.GroovyRuleContext;
import org.netbeans.modules.groovy.editor.parser.GroovyError;
import org.netbeans.modules.gsf.api.Hint;
import org.netbeans.modules.gsf.api.HintFix;
import org.netbeans.modules.gsf.api.HintSeverity;
import org.netbeans.modules.gsf.api.OffsetRange;
import org.netbeans.modules.gsf.api.Rule;
import org.netbeans.modules.gsf.api.RuleContext;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassNotFoundRule
extends GroovyErrorRule {
    public static final Logger LOG = Logger.getLogger(ClassNotFoundRule.class.getName());
    private final String DESC = NbBundle.getMessage(ClassNotFoundRule.class, (String)"FixImportsHintDescription");
    private final FixImportsHelper helper = new FixImportsHelper();
    private final Map<String, Set<Integer>> notfoundMap = new HashMap<String, Set<Integer>>();
    private int lastCompilationRun = 0;

    public ClassNotFoundRule() {
        LOG.log(Level.FINEST, "Constructor");
    }

    @Override
    public Set<GroovyCompilerErrorID> getCodes() {
        LOG.log(Level.FINEST, "getCodes()");
        HashSet<GroovyCompilerErrorID> hashSet = new HashSet<GroovyCompilerErrorID>();
        hashSet.add(GroovyCompilerErrorID.CLASS_NOT_FOUND);
        return hashSet;
    }

    @Override
    public void run(GroovyRuleContext groovyRuleContext, GroovyError groovyError, List<Hint> list) {
        Integer n;
        FileObject fileObject;
        List<FixImportsHelper.ImportCandidate> list2;
        LOG.log(Level.FINEST, "run()");
        String string = groovyError.getDescription();
        if (string == null) {
            LOG.log(Level.FINEST, "desc == null");
            return;
        }
        LOG.log(Level.FINEST, "Processing : {0}", string);
        String string2 = FixImportsHelper.getMissingClassName(string);
        if (string2 == null) {
            return;
        }
        int n2 = groovyRuleContext.compilationInfo.hashCode();
        LOG.log(Level.FINEST, "context.compilationInfo = {0}", n2);
        if (n2 != this.lastCompilationRun) {
            this.notfoundMap.clear();
            this.lastCompilationRun = n2;
        }
        if ((list2 = this.helper.getImportCandidate(fileObject = groovyRuleContext.compilationInfo.getFileObject(), string2)).isEmpty()) {
            return;
        }
        int n3 = 292;
        int n4 = 0;
        int n5 = 0;
        try {
            n = Utilities.getLineOffset((BaseDocument)groovyRuleContext.doc, (int)groovyError.getStartPosition());
            if (this.hasBeenMarkedBefore(string2, n)) {
                return;
            }
            n4 = Utilities.getRowStart((BaseDocument)groovyRuleContext.doc, (int)groovyError.getStartPosition());
            n5 = Utilities.getRowEnd((BaseDocument)groovyRuleContext.doc, (int)groovyError.getEndPosition());
        }
        catch (BadLocationException badLocationException) {
            LOG.log(Level.FINEST, "Processing : {0}", badLocationException);
            return;
        }
        n = new OffsetRange(n4, n5);
        for (FixImportsHelper.ImportCandidate importCandidate : list2) {
            ArrayList<AddImportFix> arrayList = new ArrayList<AddImportFix>(1);
            String string3 = importCandidate.getFqnName();
            AddImportFix addImportFix = new AddImportFix(fileObject, string3);
            arrayList.add(addImportFix);
            Hint hint = new Hint((Rule)this, addImportFix.getDescription(), fileObject, (OffsetRange)n, arrayList, n3);
            list.add(hint);
        }
    }

    boolean hasBeenMarkedBefore(String string, Integer n) {
        Set<Integer> set;
        for (String string2 : this.notfoundMap.keySet()) {
            if (!string2.equals(string)) continue;
            Set<Integer> set2 = this.notfoundMap.get(string2);
            for (Integer n2 : set2) {
                if (!n2.equals(n)) continue;
                return true;
            }
        }
        if (this.notfoundMap.containsKey(string)) {
            set = this.notfoundMap.get(string);
            set.add(n);
        } else {
            set = new HashSet();
            set.add(n);
            this.notfoundMap.put(string, set);
        }
        return false;
    }

    public boolean appliesTo(RuleContext ruleContext) {
        return true;
    }

    public String getDisplayName() {
        return this.DESC;
    }

    public boolean showInTasklist() {
        return false;
    }

    public HintSeverity getDefaultSeverity() {
        return HintSeverity.ERROR;
    }

    private class AddImportFix
    implements HintFix {
        String HINT_PREFIX = NbBundle.getMessage(ClassNotFoundRule.class, (String)"ClassNotFoundRuleHintDescription");
        FileObject fo;
        String fqn;

        public AddImportFix(FileObject fileObject, String string) {
            this.fo = fileObject;
            this.fqn = string;
        }

        public String getDescription() {
            return this.HINT_PREFIX + " " + this.fqn;
        }

        public void implement() throws Exception {
            ClassNotFoundRule.this.helper.doImport(this.fo, this.fqn);
        }

        public boolean isSafe() {
            return true;
        }

        public boolean isInteractive() {
            return false;
        }
    }
}

