/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.groovy.editor.elements;

import java.io.IOException;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Set;
import javax.swing.text.Document;
import org.netbeans.modules.groovy.editor.AstUtilities;
import org.netbeans.modules.groovy.editor.GroovyIndex;
import org.netbeans.modules.groovy.editor.elements.GroovyElement;
import org.netbeans.modules.gsf.api.Modifier;
import org.netbeans.modules.gsf.api.ParserFile;
import org.netbeans.modules.gsf.spi.DefaultParserFile;
import org.openide.filesystems.FileObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class IndexedElement
extends GroovyElement {
    protected String fileUrl;
    protected final String clz;
    protected final String fqn;
    protected final GroovyIndex index;
    protected final String attributes;
    protected Set<Modifier> modifiers;
    protected int flags;
    protected int docLength = -1;
    private Document document;
    private FileObject fileObject;

    protected IndexedElement(GroovyIndex groovyIndex, String string, String string2, String string3, String string4, int n) {
        this.index = groovyIndex;
        this.fileUrl = string;
        this.fqn = string2;
        this.attributes = string4;
        this.clz = string3;
        this.flags = n;
    }

    public abstract String getSignature();

    public final String getFileUrl() {
        return this.fileUrl;
    }

    public final String getFqn() {
        return this.fqn;
    }

    public String toString() {
        return this.getSignature() + ":" + this.getFileUrl();
    }

    public final String getClz() {
        return this.clz;
    }

    public GroovyIndex getIndex() {
        return this.index;
    }

    @Override
    public String getIn() {
        return this.getClz();
    }

    public String getFilenameUrl() {
        return this.fileUrl;
    }

    public Document getDocument() throws IOException {
        if (this.document == null) {
            FileObject fileObject = this.getFileObject();
            if (fileObject == null) {
                return null;
            }
            this.document = AstUtilities.getBaseDocument(this.fileObject, true);
        }
        return this.document;
    }

    public ParserFile getFile() {
        boolean bl = false;
        return new DefaultParserFile(this.getFileObject(), null, bl);
    }

    @Override
    public FileObject getFileObject() {
        if (this.fileObject == null && this.fileUrl != null) {
            this.fileObject = GroovyIndex.getFileObject(this.fileUrl);
            if (this.fileObject == null) {
                this.fileUrl = null;
            }
        }
        return this.fileObject;
    }

    @Override
    public final Set<Modifier> getModifiers() {
        if (this.modifiers == null) {
            Modifier modifier = Modifier.PRIVATE;
            if (this.isPublic()) {
                modifier = Modifier.PUBLIC;
            } else if (this.isProtected()) {
                modifier = Modifier.PROTECTED;
            }
            boolean bl = this.isStatic();
            this.modifiers = modifier != Modifier.PRIVATE ? (bl ? EnumSet.of(modifier, Modifier.STATIC) : EnumSet.of(modifier)) : (bl ? EnumSet.of(Modifier.STATIC) : Collections.emptySet());
        }
        return this.modifiers;
    }

    public static char flagToFirstChar(int n) {
        char c = (char)(n >>= 4);
        if (c >= '\n') {
            return (char)(c - 10 + 97);
        }
        return (char)(c + 48);
    }

    public static char flagToSecondChar(int n) {
        char c = (char)(n & 0xF);
        if (c >= '\n') {
            return (char)(c - 10 + 97);
        }
        return (char)(c + 48);
    }

    public static String flagToString(int n) {
        return "" + IndexedElement.flagToFirstChar(n) + IndexedElement.flagToSecondChar(n);
    }

    public static int stringToFlag(String string, int n) {
        return IndexedElement.stringToFlag(string.charAt(n), string.charAt(n + 1));
    }

    public static int stringToFlag(char c, char c2) {
        int n = 0;
        int n2 = 0;
        n = c > '9' ? c - 97 + 10 : c - 48;
        n2 = c2 > '9' ? c2 - 97 + 10 : c2 - 48;
        return (n << 4) + n2;
    }

    public boolean isPublic() {
        return (this.flags & 1) != 0;
    }

    public boolean isPrivate() {
        return (this.flags & 1 & 4) == 0;
    }

    public boolean isProtected() {
        return (this.flags & 4) != 0;
    }

    public boolean isStatic() {
        return (this.flags & 8) != 0;
    }

    public static String decodeFlags(int n) {
        StringBuilder stringBuilder = new StringBuilder();
        if ((n & 1) != 0) {
            stringBuilder.append("|PUBLIC");
        }
        if ((n & 4) != 0) {
            stringBuilder.append("|PROTECTED");
        }
        if ((n & 8) != 0) {
            stringBuilder.append("|STATIC");
        }
        return stringBuilder.toString();
    }
}

