/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.groovy.editor;

import java.util.HashSet;
import java.util.Set;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.ClassCodeVisitorSupport;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.ConstructorNode;
import org.codehaus.groovy.ast.FieldNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.ModuleNode;
import org.codehaus.groovy.ast.Parameter;
import org.codehaus.groovy.ast.Variable;
import org.codehaus.groovy.ast.VariableScope;
import org.codehaus.groovy.ast.expr.ClassExpression;
import org.codehaus.groovy.ast.expr.ClosureExpression;
import org.codehaus.groovy.ast.expr.ClosureListExpression;
import org.codehaus.groovy.ast.expr.ConstantExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.MethodCallExpression;
import org.codehaus.groovy.ast.expr.PropertyExpression;
import org.codehaus.groovy.ast.expr.VariableExpression;
import org.codehaus.groovy.ast.stmt.BlockStatement;
import org.codehaus.groovy.ast.stmt.ForStatement;
import org.codehaus.groovy.control.SourceUnit;
import org.netbeans.modules.groovy.editor.AstPath;
import org.netbeans.modules.groovy.editor.Methods;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class VariableScopeVisitor
extends ClassCodeVisitorSupport {
    private final SourceUnit sourceUnit;
    private final AstPath path;
    private final ASTNode leaf;
    private final ASTNode leafParent;
    private final Set<ASTNode> occurrences = new HashSet<ASTNode>();

    public VariableScopeVisitor(SourceUnit sourceUnit, AstPath astPath) {
        this.sourceUnit = sourceUnit;
        this.path = astPath;
        this.leaf = astPath.leaf();
        this.leafParent = astPath.leafParent();
    }

    public Set<ASTNode> getOccurrences() {
        return this.occurrences;
    }

    public void collect() {
        Object object;
        if (this.leaf instanceof Variable) {
            object = (Variable)((Object)this.leaf);
            for (ASTNode aSTNode : this.path) {
                VariableScope variableScope;
                if (aSTNode instanceof ClosureExpression) {
                    variableScope = ((ClosureExpression)aSTNode).getVariableScope();
                    if (variableScope.getDeclaredVariable(object.getName()) == null) continue;
                    this.visitClosureExpression((ClosureExpression)aSTNode);
                    return;
                }
                if (aSTNode instanceof MethodNode) {
                    if (!this.collectMethodOrConstructor((MethodNode)aSTNode, (Variable)object)) continue;
                    return;
                }
                if (aSTNode instanceof ConstructorNode) {
                    if (!this.collectMethodOrConstructor((ConstructorNode)aSTNode, (Variable)object)) continue;
                    return;
                }
                if (aSTNode instanceof ForStatement) {
                    variableScope = ((ForStatement)aSTNode).getVariableScope();
                    if (variableScope.getDeclaredVariable(object.getName()) == null) continue;
                    this.visitForLoop((ForStatement)aSTNode);
                    return;
                }
                if (aSTNode instanceof BlockStatement) {
                    variableScope = ((BlockStatement)aSTNode).getVariableScope();
                    if (variableScope.getDeclaredVariable(object.getName()) == null) continue;
                    this.visitBlockStatement((BlockStatement)aSTNode);
                    return;
                }
                if (!(aSTNode instanceof ClosureListExpression) || (variableScope = ((ClosureListExpression)aSTNode).getVariableScope()).getDeclaredVariable(object.getName()) == null) continue;
                this.visitClosureListExpression((ClosureListExpression)aSTNode);
                return;
            }
        }
        object = (ModuleNode)this.path.root();
        for (ASTNode aSTNode : ((ModuleNode)object).getClasses()) {
            this.visitClass((ClassNode)aSTNode);
        }
        for (ASTNode aSTNode : ((ModuleNode)object).getMethods()) {
            this.visitMethod((MethodNode)aSTNode);
        }
        this.visitBlockStatement(((ModuleNode)object).getStatementBlock());
    }

    private boolean collectMethodOrConstructor(MethodNode methodNode, Variable variable) {
        VariableScope variableScope = methodNode.getVariableScope();
        if (variableScope.getDeclaredVariable(variable.getName()) != null) {
            for (Parameter parameter : methodNode.getParameters()) {
                if (!parameter.getName().equals(variable.getName())) continue;
                this.occurrences.add(parameter);
                break;
            }
            super.visitMethod(methodNode);
            return true;
        }
        return false;
    }

    @Override
    protected SourceUnit getSourceUnit() {
        return this.sourceUnit;
    }

    @Override
    public void visitVariableExpression(VariableExpression variableExpression) {
        if (this.leaf instanceof Variable && ((Variable)((Object)this.leaf)).getName().equals(variableExpression.getName())) {
            this.occurrences.add(variableExpression);
        } else if (this.leaf instanceof ConstantExpression && this.leafParent instanceof PropertyExpression) {
            PropertyExpression propertyExpression = (PropertyExpression)this.leafParent;
            if (variableExpression.getName().equals(propertyExpression.getPropertyAsString())) {
                this.occurrences.add(variableExpression);
                return;
            }
        }
        super.visitVariableExpression(variableExpression);
    }

    @Override
    public void visitField(FieldNode fieldNode) {
        if (this.leaf instanceof Variable && ((Variable)((Object)this.leaf)).getName().equals(fieldNode.getName())) {
            this.occurrences.add(fieldNode);
        } else if (this.leaf instanceof ConstantExpression && this.leafParent instanceof PropertyExpression) {
            PropertyExpression propertyExpression = (PropertyExpression)this.leafParent;
            if (fieldNode.getName().equals(propertyExpression.getPropertyAsString())) {
                this.occurrences.add(fieldNode);
                return;
            }
        }
        super.visitField(fieldNode);
    }

    @Override
    public void visitMethod(MethodNode methodNode) {
        VariableScope variableScope = methodNode.getVariableScope();
        if (this.leaf instanceof Variable) {
            String string = ((Variable)((Object)this.leaf)).getName();
            if (variableScope.getDeclaredVariable(string) != null) {
                return;
            }
        } else if (this.leaf instanceof ConstantExpression && this.leafParent instanceof PropertyExpression) {
            String string = ((ConstantExpression)this.leaf).getText();
            if (variableScope.getDeclaredVariable(string) != null) {
                return;
            }
        } else if (this.leaf instanceof ConstantExpression && this.leafParent instanceof MethodCallExpression) {
            MethodCallExpression methodCallExpression = (MethodCallExpression)this.leafParent;
            if (Methods.isSameMethod(methodNode, methodCallExpression)) {
                this.occurrences.add(methodNode);
            }
        } else if (this.leaf instanceof MethodNode && Methods.isSameMethod(methodNode, (MethodNode)this.leaf)) {
            this.occurrences.add(methodNode);
        }
        super.visitMethod(methodNode);
    }

    @Override
    public void visitMethodCallExpression(MethodCallExpression methodCallExpression) {
        if (this.leaf instanceof MethodNode) {
            MethodNode methodNode = (MethodNode)this.leaf;
            if (Methods.isSameMethod(methodNode, methodCallExpression)) {
                this.occurrences.add(methodCallExpression);
            }
        } else if (this.leaf instanceof ConstantExpression && this.leafParent instanceof MethodCallExpression && Methods.isSameMethod(methodCallExpression, (MethodCallExpression)this.leafParent)) {
            this.occurrences.add(methodCallExpression);
        }
        super.visitMethodCallExpression(methodCallExpression);
    }

    @Override
    public void visitClassExpression(ClassExpression classExpression) {
        if (this.leaf instanceof ClassNode) {
            ClassNode classNode = (ClassNode)this.leaf;
            if (classExpression.getText().equals(classNode.getName())) {
                this.occurrences.add(classExpression);
            }
        } else if (this.leaf instanceof ClassExpression && classExpression.getText().equals(((ClassExpression)this.leaf).getText())) {
            this.occurrences.add(classExpression);
        }
        super.visitClassExpression(classExpression);
    }

    @Override
    public void visitClass(ClassNode classNode) {
        if (this.leaf instanceof ClassExpression) {
            if (classNode.getName().equals(((ClassExpression)this.leaf).getText())) {
                this.occurrences.add(classNode);
            }
        } else if (this.leaf instanceof ClassNode && classNode.getName().equals(((ClassNode)this.leaf).getName())) {
            this.occurrences.add(classNode);
        }
        super.visitClass(classNode);
    }

    @Override
    public void visitPropertyExpression(PropertyExpression propertyExpression) {
        Expression expression = propertyExpression.getProperty();
        if (this.leaf instanceof Variable && ((Variable)((Object)this.leaf)).getName().equals(propertyExpression.getPropertyAsString())) {
            this.occurrences.add(expression);
        } else if (this.leaf instanceof ConstantExpression && this.leafParent instanceof PropertyExpression) {
            PropertyExpression propertyExpression2 = (PropertyExpression)this.leafParent;
            String string = propertyExpression.getPropertyAsString();
            if (string != null && string.equals(propertyExpression2.getPropertyAsString())) {
                this.occurrences.add(expression);
            }
        }
        super.visitPropertyExpression(propertyExpression);
    }
}

