/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.groovy.editor;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.ClassCodeVisitorSupport;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.ConstructorNode;
import org.codehaus.groovy.ast.FieldNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.Parameter;
import org.codehaus.groovy.ast.PropertyNode;
import org.codehaus.groovy.ast.expr.ArgumentListExpression;
import org.codehaus.groovy.ast.expr.ArrayExpression;
import org.codehaus.groovy.ast.expr.AttributeExpression;
import org.codehaus.groovy.ast.expr.BinaryExpression;
import org.codehaus.groovy.ast.expr.BitwiseNegationExpression;
import org.codehaus.groovy.ast.expr.BooleanExpression;
import org.codehaus.groovy.ast.expr.CastExpression;
import org.codehaus.groovy.ast.expr.ClassExpression;
import org.codehaus.groovy.ast.expr.ClosureExpression;
import org.codehaus.groovy.ast.expr.ClosureListExpression;
import org.codehaus.groovy.ast.expr.ConstantExpression;
import org.codehaus.groovy.ast.expr.ConstructorCallExpression;
import org.codehaus.groovy.ast.expr.DeclarationExpression;
import org.codehaus.groovy.ast.expr.ElvisOperatorExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.FieldExpression;
import org.codehaus.groovy.ast.expr.GStringExpression;
import org.codehaus.groovy.ast.expr.ListExpression;
import org.codehaus.groovy.ast.expr.MapEntryExpression;
import org.codehaus.groovy.ast.expr.MapExpression;
import org.codehaus.groovy.ast.expr.MethodCallExpression;
import org.codehaus.groovy.ast.expr.MethodPointerExpression;
import org.codehaus.groovy.ast.expr.NotExpression;
import org.codehaus.groovy.ast.expr.PostfixExpression;
import org.codehaus.groovy.ast.expr.PrefixExpression;
import org.codehaus.groovy.ast.expr.PropertyExpression;
import org.codehaus.groovy.ast.expr.RangeExpression;
import org.codehaus.groovy.ast.expr.RegexExpression;
import org.codehaus.groovy.ast.expr.SpreadExpression;
import org.codehaus.groovy.ast.expr.SpreadMapExpression;
import org.codehaus.groovy.ast.expr.StaticMethodCallExpression;
import org.codehaus.groovy.ast.expr.TernaryExpression;
import org.codehaus.groovy.ast.expr.TupleExpression;
import org.codehaus.groovy.ast.expr.UnaryMinusExpression;
import org.codehaus.groovy.ast.expr.UnaryPlusExpression;
import org.codehaus.groovy.ast.expr.VariableExpression;
import org.codehaus.groovy.ast.stmt.AssertStatement;
import org.codehaus.groovy.ast.stmt.BlockStatement;
import org.codehaus.groovy.ast.stmt.BreakStatement;
import org.codehaus.groovy.ast.stmt.CaseStatement;
import org.codehaus.groovy.ast.stmt.CatchStatement;
import org.codehaus.groovy.ast.stmt.ContinueStatement;
import org.codehaus.groovy.ast.stmt.DoWhileStatement;
import org.codehaus.groovy.ast.stmt.ExpressionStatement;
import org.codehaus.groovy.ast.stmt.ForStatement;
import org.codehaus.groovy.ast.stmt.IfStatement;
import org.codehaus.groovy.ast.stmt.ReturnStatement;
import org.codehaus.groovy.ast.stmt.Statement;
import org.codehaus.groovy.ast.stmt.SwitchStatement;
import org.codehaus.groovy.ast.stmt.SynchronizedStatement;
import org.codehaus.groovy.ast.stmt.ThrowStatement;
import org.codehaus.groovy.ast.stmt.TryCatchStatement;
import org.codehaus.groovy.ast.stmt.WhileStatement;
import org.codehaus.groovy.control.SourceUnit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PathFinderVisitor
extends ClassCodeVisitorSupport {
    private static final Logger LOG = Logger.getLogger(PathFinderVisitor.class.getName());
    private final SourceUnit sourceUnit;
    private final int line;
    private final int column;
    private final List<ASTNode> path;

    public PathFinderVisitor(SourceUnit sourceUnit, int n, int n2) {
        this.sourceUnit = sourceUnit;
        this.line = n;
        this.column = n2;
        this.path = new ArrayList<ASTNode>();
    }

    public List<ASTNode> getPath() {
        return this.path;
    }

    @Override
    protected SourceUnit getSourceUnit() {
        return this.sourceUnit;
    }

    @Override
    protected void visitConstructorOrMethod(MethodNode methodNode, boolean bl) {
        super.visitConstructorOrMethod(methodNode, bl);
        for (Parameter parameter : methodNode.getParameters()) {
            this.isInside(parameter, this.line, this.column);
        }
    }

    @Override
    protected void visitStatement(Statement statement) {
    }

    @Override
    public void visitBlockStatement(BlockStatement blockStatement) {
        if (this.isInside(blockStatement, this.line, this.column, false)) {
            this.path.add(blockStatement);
        } else {
            for (Object e : blockStatement.getStatements()) {
                if (!this.isInside((ASTNode)e, this.line, this.column, false)) continue;
                this.path.add(blockStatement);
                break;
            }
        }
        for (Object e : blockStatement.getStatements()) {
            Statement statement = (Statement)e;
            statement.visit(this);
        }
    }

    @Override
    public void visitForLoop(ForStatement forStatement) {
        if (this.isInside(forStatement, this.line, this.column)) {
            super.visitForLoop(forStatement);
        }
    }

    @Override
    public void visitWhileLoop(WhileStatement whileStatement) {
        if (this.isInside(whileStatement, this.line, this.column)) {
            super.visitWhileLoop(whileStatement);
        }
    }

    @Override
    public void visitDoWhileLoop(DoWhileStatement doWhileStatement) {
        if (this.isInside(doWhileStatement, this.line, this.column)) {
            super.visitDoWhileLoop(doWhileStatement);
        }
    }

    @Override
    public void visitIfElse(IfStatement ifStatement) {
        if (this.isInside(ifStatement, this.line, this.column)) {
            super.visitIfElse(ifStatement);
        }
    }

    @Override
    public void visitExpressionStatement(ExpressionStatement expressionStatement) {
        if (this.isInside(expressionStatement, this.line, this.column)) {
            super.visitExpressionStatement(expressionStatement);
        }
    }

    @Override
    public void visitReturnStatement(ReturnStatement returnStatement) {
        if (this.isInside(returnStatement, this.line, this.column)) {
            super.visitReturnStatement(returnStatement);
        }
    }

    @Override
    public void visitAssertStatement(AssertStatement assertStatement) {
        if (this.isInside(assertStatement, this.line, this.column)) {
            super.visitAssertStatement(assertStatement);
        }
    }

    @Override
    public void visitTryCatchFinally(TryCatchStatement tryCatchStatement) {
        if (this.isInside(tryCatchStatement, this.line, this.column)) {
            super.visitTryCatchFinally(tryCatchStatement);
        }
    }

    @Override
    public void visitSwitch(SwitchStatement switchStatement) {
        if (this.isInside(switchStatement, this.line, this.column)) {
            super.visitSwitch(switchStatement);
        }
    }

    @Override
    public void visitCaseStatement(CaseStatement caseStatement) {
        if (this.isInside(caseStatement, this.line, this.column)) {
            super.visitCaseStatement(caseStatement);
        }
    }

    @Override
    public void visitBreakStatement(BreakStatement breakStatement) {
        if (this.isInside(breakStatement, this.line, this.column)) {
            super.visitBreakStatement(breakStatement);
        }
    }

    @Override
    public void visitContinueStatement(ContinueStatement continueStatement) {
        if (this.isInside(continueStatement, this.line, this.column)) {
            super.visitContinueStatement(continueStatement);
        }
    }

    @Override
    public void visitThrowStatement(ThrowStatement throwStatement) {
        if (this.isInside(throwStatement, this.line, this.column)) {
            super.visitThrowStatement(throwStatement);
        }
    }

    @Override
    public void visitSynchronizedStatement(SynchronizedStatement synchronizedStatement) {
        if (this.isInside(synchronizedStatement, this.line, this.column)) {
            super.visitSynchronizedStatement(synchronizedStatement);
        }
    }

    @Override
    public void visitCatchStatement(CatchStatement catchStatement) {
        if (this.isInside(catchStatement, this.line, this.column)) {
            super.visitCatchStatement(catchStatement);
        }
    }

    @Override
    public void visitMethodCallExpression(MethodCallExpression methodCallExpression) {
        if (this.isInside(methodCallExpression, this.line, this.column)) {
            super.visitMethodCallExpression(methodCallExpression);
        }
    }

    @Override
    public void visitStaticMethodCallExpression(StaticMethodCallExpression staticMethodCallExpression) {
        if (this.isInside(staticMethodCallExpression, this.line, this.column)) {
            super.visitStaticMethodCallExpression(staticMethodCallExpression);
        }
    }

    @Override
    public void visitConstructorCallExpression(ConstructorCallExpression constructorCallExpression) {
        if (this.isInside(constructorCallExpression, this.line, this.column)) {
            super.visitConstructorCallExpression(constructorCallExpression);
        }
    }

    @Override
    public void visitTernaryExpression(TernaryExpression ternaryExpression) {
        if (this.isInside(ternaryExpression, this.line, this.column)) {
            super.visitTernaryExpression(ternaryExpression);
        }
    }

    @Override
    public void visitShortTernaryExpression(ElvisOperatorExpression elvisOperatorExpression) {
        if (this.isInside(elvisOperatorExpression, this.line, this.column)) {
            super.visitShortTernaryExpression(elvisOperatorExpression);
        }
    }

    @Override
    public void visitBinaryExpression(BinaryExpression binaryExpression) {
        if (this.isInside(binaryExpression, this.line, this.column)) {
            super.visitBinaryExpression(binaryExpression);
        }
    }

    @Override
    public void visitPrefixExpression(PrefixExpression prefixExpression) {
        if (this.isInside(prefixExpression, this.line, this.column)) {
            super.visitPrefixExpression(prefixExpression);
        }
    }

    @Override
    public void visitPostfixExpression(PostfixExpression postfixExpression) {
        if (this.isInside(postfixExpression, this.line, this.column)) {
            super.visitPostfixExpression(postfixExpression);
        }
    }

    @Override
    public void visitBooleanExpression(BooleanExpression booleanExpression) {
        if (this.isInside(booleanExpression, this.line, this.column)) {
            super.visitBooleanExpression(booleanExpression);
        }
    }

    @Override
    public void visitClosureExpression(ClosureExpression closureExpression) {
        if (this.isInside(closureExpression, this.line, this.column)) {
            super.visitClosureExpression(closureExpression);
        }
    }

    @Override
    public void visitTupleExpression(TupleExpression tupleExpression) {
        if (this.isInside(tupleExpression, this.line, this.column)) {
            super.visitTupleExpression(tupleExpression);
        }
    }

    @Override
    public void visitMapExpression(MapExpression mapExpression) {
        if (this.isInside(mapExpression, this.line, this.column)) {
            super.visitMapExpression(mapExpression);
        }
    }

    @Override
    public void visitMapEntryExpression(MapEntryExpression mapEntryExpression) {
        if (this.isInside(mapEntryExpression, this.line, this.column)) {
            super.visitMapEntryExpression(mapEntryExpression);
        }
    }

    @Override
    public void visitListExpression(ListExpression listExpression) {
        if (this.isInside(listExpression, this.line, this.column)) {
            super.visitListExpression(listExpression);
        }
    }

    @Override
    public void visitRangeExpression(RangeExpression rangeExpression) {
        if (this.isInside(rangeExpression, this.line, this.column)) {
            super.visitRangeExpression(rangeExpression);
        }
    }

    @Override
    public void visitPropertyExpression(PropertyExpression propertyExpression) {
        Expression expression = propertyExpression.getObjectExpression();
        Expression expression2 = propertyExpression.getProperty();
        if (this.isInside(propertyExpression, this.line, this.column, false)) {
            this.path.add(propertyExpression);
        } else {
            boolean bl = false;
            if (this.isInside(expression, this.line, this.column, false)) {
                this.path.add(propertyExpression);
                bl = true;
            }
            if (this.isInside(expression2, this.line, this.column, false) && !bl) {
                this.path.add(propertyExpression);
            }
        }
        expression.visit(this);
        expression2.visit(this);
    }

    @Override
    public void visitAttributeExpression(AttributeExpression attributeExpression) {
        if (this.isInside(attributeExpression, this.line, this.column)) {
            super.visitAttributeExpression(attributeExpression);
        }
    }

    @Override
    public void visitFieldExpression(FieldExpression fieldExpression) {
        if (this.isInside(fieldExpression, this.line, this.column)) {
            super.visitFieldExpression(fieldExpression);
        }
    }

    @Override
    public void visitMethodPointerExpression(MethodPointerExpression methodPointerExpression) {
        if (this.isInside(methodPointerExpression, this.line, this.column)) {
            super.visitMethodPointerExpression(methodPointerExpression);
        }
    }

    @Override
    public void visitConstantExpression(ConstantExpression constantExpression) {
        if (this.isInside(constantExpression, this.line, this.column)) {
            super.visitConstantExpression(constantExpression);
        }
    }

    @Override
    public void visitClassExpression(ClassExpression classExpression) {
        if (this.isInside(classExpression, this.line, this.column)) {
            super.visitClassExpression(classExpression);
        }
    }

    @Override
    public void visitVariableExpression(VariableExpression variableExpression) {
        if (this.isInside(variableExpression, this.line, this.column)) {
            super.visitVariableExpression(variableExpression);
        }
    }

    @Override
    public void visitDeclarationExpression(DeclarationExpression declarationExpression) {
        if (this.isInside(declarationExpression, this.line, this.column)) {
            super.visitDeclarationExpression(declarationExpression);
        }
    }

    @Override
    public void visitRegexExpression(RegexExpression regexExpression) {
        if (this.isInside(regexExpression, this.line, this.column)) {
            super.visitRegexExpression(regexExpression);
        }
    }

    @Override
    public void visitGStringExpression(GStringExpression gStringExpression) {
        if (this.isInside(gStringExpression, this.line, this.column)) {
            super.visitGStringExpression(gStringExpression);
        }
    }

    @Override
    public void visitArrayExpression(ArrayExpression arrayExpression) {
        if (this.isInside(arrayExpression, this.line, this.column)) {
            super.visitArrayExpression(arrayExpression);
        }
    }

    @Override
    public void visitSpreadExpression(SpreadExpression spreadExpression) {
        if (this.isInside(spreadExpression, this.line, this.column)) {
            super.visitSpreadExpression(spreadExpression);
        }
    }

    @Override
    public void visitSpreadMapExpression(SpreadMapExpression spreadMapExpression) {
        if (this.isInside(spreadMapExpression, this.line, this.column)) {
            super.visitSpreadMapExpression(spreadMapExpression);
        }
    }

    @Override
    public void visitNotExpression(NotExpression notExpression) {
        if (this.isInside(notExpression, this.line, this.column)) {
            super.visitNotExpression(notExpression);
        }
    }

    @Override
    public void visitUnaryMinusExpression(UnaryMinusExpression unaryMinusExpression) {
        if (this.isInside(unaryMinusExpression, this.line, this.column)) {
            super.visitUnaryMinusExpression(unaryMinusExpression);
        }
    }

    @Override
    public void visitUnaryPlusExpression(UnaryPlusExpression unaryPlusExpression) {
        if (this.isInside(unaryPlusExpression, this.line, this.column)) {
            super.visitUnaryPlusExpression(unaryPlusExpression);
        }
    }

    @Override
    public void visitBitwiseNegationExpression(BitwiseNegationExpression bitwiseNegationExpression) {
        if (this.isInside(bitwiseNegationExpression, this.line, this.column)) {
            super.visitBitwiseNegationExpression(bitwiseNegationExpression);
        }
    }

    @Override
    public void visitCastExpression(CastExpression castExpression) {
        if (this.isInside(castExpression, this.line, this.column)) {
            super.visitCastExpression(castExpression);
        }
    }

    @Override
    public void visitArgumentlistExpression(ArgumentListExpression argumentListExpression) {
        if (this.isInside(argumentListExpression, this.line, this.column)) {
            super.visitArgumentlistExpression(argumentListExpression);
        }
    }

    @Override
    public void visitClosureListExpression(ClosureListExpression closureListExpression) {
        if (this.isInside(closureListExpression, this.line, this.column)) {
            super.visitClosureListExpression(closureListExpression);
        }
    }

    @Override
    public void visitClass(ClassNode classNode) {
        if (this.isInside(classNode, this.line, this.column)) {
            super.visitClass(classNode);
        }
    }

    @Override
    public void visitConstructor(ConstructorNode constructorNode) {
        if (this.isInside(constructorNode, this.line, this.column)) {
            super.visitConstructor(constructorNode);
        }
    }

    @Override
    public void visitMethod(MethodNode methodNode) {
        if (this.isInside(methodNode, this.line, this.column)) {
            super.visitMethod(methodNode);
        }
    }

    @Override
    public void visitField(FieldNode fieldNode) {
        if (this.isInside(fieldNode, this.line, this.column)) {
            super.visitField(fieldNode);
        }
    }

    @Override
    public void visitProperty(PropertyNode propertyNode) {
        if (this.isInside(propertyNode, this.line, this.column)) {
            super.visitProperty(propertyNode);
        }
    }

    private boolean isInside(ASTNode aSTNode, int n, int n2) {
        return this.isInside(aSTNode, n, n2, true);
    }

    private boolean isInside(ASTNode aSTNode, int n, int n2, boolean bl) {
        int n3 = aSTNode.getLineNumber();
        int n4 = aSTNode.getColumnNumber();
        int n5 = aSTNode.getLastLineNumber();
        int n6 = aSTNode.getLastColumnNumber();
        LOG.finest("isInside: " + aSTNode + " - " + n3 + ", " + n4 + ", " + n5 + ", " + n6);
        if (n3 == -1 || n4 == -1 || n5 == -1 || n6 == -1) {
            return bl;
        }
        boolean bl2 = false;
        if (n3 == n5) {
            if (n == n3 && n2 >= n4 && n2 < n6) {
                bl2 = true;
            }
        } else if (n == n3) {
            if (n2 >= n4) {
                bl2 = true;
            }
        } else if (n == n5) {
            if (n2 < n6) {
                bl2 = true;
            }
        } else {
            bl2 = n3 < n && n < n5;
        }
        if (bl2 && bl) {
            this.path.add(aSTNode);
            LOG.finest("Path:" + this.path);
        }
        return bl ? true : bl2;
    }
}

