/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.groovy.editor;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Locale;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.swing.JEditorPane;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.StyledDocument;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.source.ClasspathInfo;
import org.openide.ErrorManager;
import org.openide.cookies.EditorCookie;
import org.openide.cookies.LineCookie;
import org.openide.cookies.OpenCookie;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.text.Line;
import org.openide.text.NbDocument;
import org.openide.util.Exceptions;
import org.openide.windows.TopComponent;

public class NbUtilities {
    private NbUtilities() {
    }

    public static JEditorPane getOpenPane() {
        JEditorPane[] jEditorPaneArray;
        EditorCookie editorCookie;
        Node[] nodeArray = TopComponent.getRegistry().getActivatedNodes();
        if (nodeArray.length > 0 && (editorCookie = (EditorCookie)nodeArray[0].getCookie(EditorCookie.class)) != null && (jEditorPaneArray = editorCookie.getOpenedPanes()) != null && jEditorPaneArray.length > 0) {
            return jEditorPaneArray[0];
        }
        return null;
    }

    public static FileObject findFileObject(JTextComponent jTextComponent) {
        Document document = jTextComponent.getDocument();
        DataObject dataObject = (DataObject)document.getProperty("stream");
        if (dataObject == null) {
            return null;
        }
        return dataObject.getPrimaryFile();
    }

    public static boolean open(final FileObject fileObject, final int n, final String string) {
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    NbUtilities.doOpen(fileObject, n, string);
                }
            });
            return true;
        }
        return NbUtilities.doOpen(fileObject, n, string);
    }

    private static boolean doOpen(FileObject fileObject, int n, String string) {
        try {
            Object object;
            DataObject dataObject = DataObject.find((FileObject)fileObject);
            EditorCookie editorCookie = (EditorCookie)dataObject.getCookie(EditorCookie.class);
            LineCookie lineCookie = (LineCookie)dataObject.getCookie(LineCookie.class);
            if (n == -1 && editorCookie.getDocument() != null && string == null) {
                editorCookie.open();
                return true;
            }
            if (editorCookie != null && string != null && n == -1) {
                object = editorCookie.openDocument();
                try {
                    String string2 = object.getText(0, object.getLength());
                    n = string2.indexOf(string);
                }
                catch (BadLocationException badLocationException) {
                    Exceptions.printStackTrace((Throwable)badLocationException);
                }
            }
            if (editorCookie != null && lineCookie != null && n != -1 && (object = editorCookie.openDocument()) != null) {
                Line line;
                int n2 = NbDocument.findLineNumber((StyledDocument)object, (int)n);
                int n3 = NbDocument.findLineOffset((StyledDocument)object, (int)n2);
                int n4 = n - n3;
                if (n2 != -1 && (line = lineCookie.getLineSet().getCurrent(n2)) != null) {
                    line.show(2, n4);
                    return true;
                }
            }
            if ((object = (OpenCookie)dataObject.getCookie(OpenCookie.class)) != null) {
                object.open();
                return true;
            }
        }
        catch (IOException iOException) {
            ErrorManager.getDefault().notify(1, (Throwable)iOException);
        }
        return false;
    }

    public static void extractZip(FileObject fileObject, FileObject fileObject2) throws IOException {
        File file = FileUtil.toFile((FileObject)fileObject);
        NbUtilities.extractZip(fileObject2, new BufferedInputStream(new FileInputStream(file)));
    }

    private static void extractZip(final FileObject fileObject, final InputStream inputStream) throws IOException {
        FileSystem fileSystem = fileObject.getFileSystem();
        fileSystem.runAtomicAction(new FileSystem.AtomicAction(){

            public void run() throws IOException {
                NbUtilities.extractZipImpl(fileObject, inputStream);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void extractZipImpl(FileObject fileObject, InputStream inputStream) throws IOException {
        ZipEntry zipEntry;
        ZipInputStream zipInputStream = new ZipInputStream(inputStream);
        while ((zipEntry = zipInputStream.getNextEntry()) != null) {
            String string = zipEntry.getName();
            if (string.toLowerCase(Locale.ENGLISH).startsWith("meta-inf/")) continue;
            if (zipEntry.isDirectory()) {
                FileUtil.createFolder((FileObject)fileObject, (String)string);
                continue;
            }
            FileObject fileObject2 = FileUtil.createData((FileObject)fileObject, (String)string);
            FileLock fileLock = fileObject2.lock();
            try {
                OutputStream outputStream = fileObject2.getOutputStream(fileLock);
                try {
                    FileUtil.copy((InputStream)zipInputStream, (OutputStream)outputStream);
                }
                finally {
                    outputStream.close();
                }
            }
            finally {
                fileLock.releaseLock();
            }
        }
    }

    public static boolean isCodeTemplateEditing(Document document) {
        String string = "processing-code-template";
        return document.getProperty(string) == Boolean.TRUE;
    }

    public static String stripPackage(String string) {
        if (string.contains(".")) {
            int n = string.lastIndexOf(".");
            string = string.substring(n + 1);
        }
        return string.replace(";", "");
    }

    public static ClasspathInfo getClasspathInfoForFileObject(FileObject fileObject) {
        ClassPath classPath = ClassPath.getClassPath((FileObject)fileObject, (String)"classpath/boot");
        ClassPath classPath2 = ClassPath.getClassPath((FileObject)fileObject, (String)"classpath/compile");
        ClassPath classPath3 = ClassPath.getClassPath((FileObject)fileObject, (String)"classpath/source");
        if (classPath == null || classPath2 == null || classPath3 == null) {
            return null;
        }
        return ClasspathInfo.create((ClassPath)classPath, (ClassPath)classPath2, (ClassPath)classPath3);
    }
}

