/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.groovy.editor;

import javax.lang.model.element.ExecutableElement;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.expr.ArgumentListExpression;
import org.codehaus.groovy.ast.expr.ConstantExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.MethodCallExpression;
import org.codehaus.groovy.ast.expr.NamedArgumentListExpression;

public class Methods {
    public static boolean isSameMethod(ExecutableElement executableElement, MethodCallExpression methodCallExpression) {
        ConstantExpression constantExpression = (ConstantExpression)methodCallExpression.getMethod();
        return executableElement.getSimpleName().contentEquals(constantExpression.getText()) && Methods.getParameterCount(methodCallExpression) == executableElement.getParameters().size();
    }

    public static boolean isSameMethod(MethodNode methodNode, MethodCallExpression methodCallExpression) {
        return methodNode.getName().equals(methodCallExpression.getMethodAsString()) && Methods.getParameterCount(methodCallExpression) == methodNode.getParameters().length;
    }

    public static boolean isSameMethod(MethodNode methodNode, MethodNode methodNode2) {
        return methodNode.getName().equals(methodNode2.getName()) && methodNode.getParameters().length == methodNode2.getParameters().length;
    }

    public static boolean isSameMethod(MethodCallExpression methodCallExpression, MethodCallExpression methodCallExpression2) {
        String string = methodCallExpression.getMethodAsString();
        if (string != null && string.equals(methodCallExpression2.getMethodAsString())) {
            int n = Methods.getParameterCount(methodCallExpression);
            int n2 = Methods.getParameterCount(methodCallExpression2);
            if (n >= 0 && n == n2) {
                return true;
            }
        }
        return false;
    }

    private static int getParameterCount(MethodCallExpression methodCallExpression) {
        Expression expression = methodCallExpression.getArguments();
        if (expression instanceof ArgumentListExpression) {
            return ((ArgumentListExpression)expression).getExpressions().size();
        }
        if (expression instanceof NamedArgumentListExpression) {
            return 1;
        }
        return -1;
    }
}

