/*
 * Decompiled with CFR 0.152.
 */
package com.sun.rave.designtime.impl;

import com.sun.rave.designtime.Customizer2;
import com.sun.rave.designtime.DesignBean;
import com.sun.rave.designtime.Result;
import java.awt.Component;
import java.awt.Image;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.Constructor;
import java.util.Vector;

public class BasicCustomizer2
implements Customizer2 {
    protected Class panelClass;
    protected DesignBean designBean;
    protected boolean applyCapable = true;
    protected boolean modified = false;
    protected String displayName;
    protected String description;
    protected Image largeIcon;
    protected Image smallIcon;
    protected String helpKey;
    protected Vector propertyChangeListeners;

    public BasicCustomizer2() {
    }

    public BasicCustomizer2(Class panelClass) {
        this(panelClass, "Customizer", null, null);
    }

    public BasicCustomizer2(Class panelClass, String displayName) {
        this(panelClass, displayName, null, null);
    }

    public BasicCustomizer2(Class panelClass, String displayName, String description) {
        this(panelClass, displayName, description, null);
    }

    public BasicCustomizer2(Class panelClass, String displayName, String description, String helpKey) {
        this.panelClass = panelClass;
        this.displayName = displayName;
        this.description = description;
        this.helpKey = helpKey;
    }

    public void setPanelClass(Class panelClass) {
        this.panelClass = panelClass;
    }

    public Class getPanelClass() {
        return this.panelClass;
    }

    protected Component createCustomizerPanel() {
        if (this.panelClass != null) {
            Object panel = null;
            try {
                Constructor con = this.panelClass.getConstructor(DesignBean.class);
                panel = con.newInstance(this.designBean);
            }
            catch (Exception x) {
                try {
                    panel = this.panelClass.newInstance();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (panel instanceof Component) {
                return panel;
            }
        }
        return null;
    }

    public Component getCustomizerPanel(DesignBean designBean) {
        this.designBean = designBean;
        return this.createCustomizerPanel();
    }

    public DesignBean getDesignBean() {
        return this.designBean;
    }

    public void setApplyCapable(boolean applyCapable) {
        this.applyCapable = applyCapable;
    }

    public boolean isApplyCapable() {
        return this.applyCapable;
    }

    public void setModified(boolean modified) {
        this.modified = modified;
        this.firePropertyChange();
    }

    public boolean isModified() {
        return this.modified;
    }

    public Result applyChanges() {
        this.modified = false;
        this.firePropertyChange();
        return Result.SUCCESS;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public void setLargeIcon(Image largeIcon) {
        this.largeIcon = largeIcon;
    }

    public Image getLargeIcon() {
        return this.largeIcon;
    }

    public void setSmallIcon(Image smallIcon) {
        this.smallIcon = smallIcon;
    }

    public Image getSmallIcon() {
        return this.smallIcon;
    }

    public void setHelpKey(String helpKey) {
        this.helpKey = helpKey;
    }

    public String getHelpKey() {
        return this.helpKey;
    }

    public synchronized void addPropertyChangeListener(PropertyChangeListener l) {
        Vector v;
        Vector vector = v = this.propertyChangeListeners == null ? new Vector(2) : (Vector)this.propertyChangeListeners.clone();
        if (!v.contains(l)) {
            v.addElement(l);
            this.propertyChangeListeners = v;
        }
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener l) {
        if (this.propertyChangeListeners != null && this.propertyChangeListeners.contains(l)) {
            Vector v = (Vector)this.propertyChangeListeners.clone();
            v.removeElement(l);
            this.propertyChangeListeners = v;
        }
    }

    public PropertyChangeListener[] getPropertyChangeListeners() {
        Vector v = this.propertyChangeListeners == null ? new Vector(2) : (Vector)this.propertyChangeListeners.clone();
        return v.toArray(new PropertyChangeListener[v.size()]);
    }

    public void firePropertyChange() {
        if (this.designBean != null) {
            PropertyChangeEvent e = new PropertyChangeEvent(this.designBean.getInstance(), null, null, null);
            this.firePropertyChange(e);
        }
    }

    public void firePropertyChange(String propName) {
        if (this.designBean != null) {
            PropertyChangeEvent e = new PropertyChangeEvent(this.designBean.getInstance(), propName, null, null);
            this.firePropertyChange(e);
        }
    }

    public void firePropertyChange(String propName, Object oldValue, Object newValue) {
        if (this.designBean != null) {
            PropertyChangeEvent e = new PropertyChangeEvent(this.designBean.getInstance(), propName, oldValue, newValue);
            this.firePropertyChange(e);
        }
    }

    public void firePropertyChange(PropertyChangeEvent e) {
        if (this.propertyChangeListeners != null) {
            Vector listeners = this.propertyChangeListeners;
            int count = listeners.size();
            for (int i = 0; i < count; ++i) {
                ((PropertyChangeListener)listeners.elementAt(i)).propertyChange(e);
            }
        }
    }
}

